// Code generated by protoc-gen-go. DO NOT EDIT.
// source: gossip/message.proto

package gossip

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	peer "github.com/hyperledger/fabric-protos-go/peer"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type PullMsgType int32

const (
	PullMsgType_UNDEFINED    PullMsgType = 0
	PullMsgType_BLOCK_MSG    PullMsgType = 1
	PullMsgType_IDENTITY_MSG PullMsgType = 2
)

var PullMsgType_name = map[int32]string{
	0: "UNDEFINED",
	1: "BLOCK_MSG",
	2: "IDENTITY_MSG",
}

var PullMsgType_value = map[string]int32{
	"UNDEFINED":    0,
	"BLOCK_MSG":    1,
	"IDENTITY_MSG": 2,
}

func (x PullMsgType) String() string {
	return proto.EnumName(PullMsgType_name, int32(x))
}

func (PullMsgType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{0}
}

type GossipMessage_Tag int32

const (
	GossipMessage_UNDEFINED    GossipMessage_Tag = 0
	GossipMessage_EMPTY        GossipMessage_Tag = 1
	GossipMessage_ORG_ONLY     GossipMessage_Tag = 2
	GossipMessage_CHAN_ONLY    GossipMessage_Tag = 3
	GossipMessage_CHAN_AND_ORG GossipMessage_Tag = 4
	GossipMessage_CHAN_OR_ORG  GossipMessage_Tag = 5
)

var GossipMessage_Tag_name = map[int32]string{
	0: "UNDEFINED",
	1: "EMPTY",
	2: "ORG_ONLY",
	3: "CHAN_ONLY",
	4: "CHAN_AND_ORG",
	5: "CHAN_OR_ORG",
}

var GossipMessage_Tag_value = map[string]int32{
	"UNDEFINED":    0,
	"EMPTY":        1,
	"ORG_ONLY":     2,
	"CHAN_ONLY":    3,
	"CHAN_AND_ORG": 4,
	"CHAN_OR_ORG":  5,
}

func (x GossipMessage_Tag) String() string {
	return proto.EnumName(GossipMessage_Tag_name, int32(x))
}

func (GossipMessage_Tag) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{3, 0}
}

// Envelope contains a marshalled
// GossipMessage and a signature over it.
// It may also contain a SecretEnvelope
// which is a marshalled Secret
type Envelope struct {
	Payload              []byte          `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	Signature            []byte          `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	SecretEnvelope       *SecretEnvelope `protobuf:"bytes,3,opt,name=secret_envelope,json=secretEnvelope,proto3" json:"secret_envelope,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Envelope) Reset()         { *m = Envelope{} }
func (m *Envelope) String() string { return proto.CompactTextString(m) }
func (*Envelope) ProtoMessage()    {}
func (*Envelope) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{0}
}

func (m *Envelope) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Envelope.Unmarshal(m, b)
}
func (m *Envelope) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Envelope.Marshal(b, m, deterministic)
}
func (m *Envelope) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Envelope.Merge(m, src)
}
func (m *Envelope) XXX_Size() int {
	return xxx_messageInfo_Envelope.Size(m)
}
func (m *Envelope) XXX_DiscardUnknown() {
	xxx_messageInfo_Envelope.DiscardUnknown(m)
}

var xxx_messageInfo_Envelope proto.InternalMessageInfo

func (m *Envelope) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *Envelope) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

func (m *Envelope) GetSecretEnvelope() *SecretEnvelope {
	if m != nil {
		return m.SecretEnvelope
	}
	return nil
}

// SecretEnvelope is a marshalled Secret
// and a signature over it.
// The signature should be validated by the peer
// that signed the Envelope the SecretEnvelope
// came with
type SecretEnvelope struct {
	Payload              []byte   `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	Signature            []byte   `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SecretEnvelope) Reset()         { *m = SecretEnvelope{} }
func (m *SecretEnvelope) String() string { return proto.CompactTextString(m) }
func (*SecretEnvelope) ProtoMessage()    {}
func (*SecretEnvelope) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{1}
}

func (m *SecretEnvelope) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecretEnvelope.Unmarshal(m, b)
}
func (m *SecretEnvelope) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecretEnvelope.Marshal(b, m, deterministic)
}
func (m *SecretEnvelope) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretEnvelope.Merge(m, src)
}
func (m *SecretEnvelope) XXX_Size() int {
	return xxx_messageInfo_SecretEnvelope.Size(m)
}
func (m *SecretEnvelope) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretEnvelope.DiscardUnknown(m)
}

var xxx_messageInfo_SecretEnvelope proto.InternalMessageInfo

func (m *SecretEnvelope) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *SecretEnvelope) GetSignature() []byte {
	if m != nil {
		return m.Signature
	}
	return nil
}

// Secret is an entity that might be omitted
// from an Envelope when the remote peer that is receiving
// the Envelope shouldn't know the secret's content.
type Secret struct {
	// Types that are valid to be assigned to Content:
	//	*Secret_InternalEndpoint
	Content              isSecret_Content `protobuf_oneof:"content"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Secret) Reset()         { *m = Secret{} }
func (m *Secret) String() string { return proto.CompactTextString(m) }
func (*Secret) ProtoMessage()    {}
func (*Secret) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{2}
}

func (m *Secret) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Secret.Unmarshal(m, b)
}
func (m *Secret) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Secret.Marshal(b, m, deterministic)
}
func (m *Secret) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Secret.Merge(m, src)
}
func (m *Secret) XXX_Size() int {
	return xxx_messageInfo_Secret.Size(m)
}
func (m *Secret) XXX_DiscardUnknown() {
	xxx_messageInfo_Secret.DiscardUnknown(m)
}

var xxx_messageInfo_Secret proto.InternalMessageInfo

type isSecret_Content interface {
	isSecret_Content()
}

type Secret_InternalEndpoint struct {
	InternalEndpoint string `protobuf:"bytes,1,opt,name=internalEndpoint,proto3,oneof"`
}

func (*Secret_InternalEndpoint) isSecret_Content() {}

func (m *Secret) GetContent() isSecret_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *Secret) GetInternalEndpoint() string {
	if x, ok := m.GetContent().(*Secret_InternalEndpoint); ok {
		return x.InternalEndpoint
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Secret) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Secret_InternalEndpoint)(nil),
	}
}

// GossipMessage defines the message sent in a gossip network
type GossipMessage struct {
	// used mainly for testing, but will might be used in the future
	// for ensuring message delivery by acking
	Nonce uint64 `protobuf:"varint,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	// The channel of the message.
	// Some GossipMessages may set this to nil, because
	// they are cross-channels but some may not
	Channel []byte `protobuf:"bytes,2,opt,name=channel,proto3" json:"channel,omitempty"`
	// determines to which peers it is allowed
	// to forward the message
	Tag GossipMessage_Tag `protobuf:"varint,3,opt,name=tag,proto3,enum=gossip.GossipMessage_Tag" json:"tag,omitempty"`
	// Types that are valid to be assigned to Content:
	//	*GossipMessage_AliveMsg
	//	*GossipMessage_MemReq
	//	*GossipMessage_MemRes
	//	*GossipMessage_DataMsg
	//	*GossipMessage_Hello
	//	*GossipMessage_DataDig
	//	*GossipMessage_DataReq
	//	*GossipMessage_DataUpdate
	//	*GossipMessage_Empty
	//	*GossipMessage_Conn
	//	*GossipMessage_StateInfo
	//	*GossipMessage_StateSnapshot
	//	*GossipMessage_StateInfoPullReq
	//	*GossipMessage_StateRequest
	//	*GossipMessage_StateResponse
	//	*GossipMessage_LeadershipMsg
	//	*GossipMessage_PeerIdentity
	//	*GossipMessage_Ack
	//	*GossipMessage_PrivateReq
	//	*GossipMessage_PrivateRes
	//	*GossipMessage_PrivateData
	Content              isGossipMessage_Content `protobuf_oneof:"content"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *GossipMessage) Reset()         { *m = GossipMessage{} }
func (m *GossipMessage) String() string { return proto.CompactTextString(m) }
func (*GossipMessage) ProtoMessage()    {}
func (*GossipMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{3}
}

func (m *GossipMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GossipMessage.Unmarshal(m, b)
}
func (m *GossipMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GossipMessage.Marshal(b, m, deterministic)
}
func (m *GossipMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GossipMessage.Merge(m, src)
}
func (m *GossipMessage) XXX_Size() int {
	return xxx_messageInfo_GossipMessage.Size(m)
}
func (m *GossipMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_GossipMessage.DiscardUnknown(m)
}

var xxx_messageInfo_GossipMessage proto.InternalMessageInfo

func (m *GossipMessage) GetNonce() uint64 {
	if m != nil {
		return m.Nonce
	}
	return 0
}

func (m *GossipMessage) GetChannel() []byte {
	if m != nil {
		return m.Channel
	}
	return nil
}

func (m *GossipMessage) GetTag() GossipMessage_Tag {
	if m != nil {
		return m.Tag
	}
	return GossipMessage_UNDEFINED
}

type isGossipMessage_Content interface {
	isGossipMessage_Content()
}

type GossipMessage_AliveMsg struct {
	AliveMsg *AliveMessage `protobuf:"bytes,5,opt,name=alive_msg,json=aliveMsg,proto3,oneof"`
}

type GossipMessage_MemReq struct {
	MemReq *MembershipRequest `protobuf:"bytes,6,opt,name=mem_req,json=memReq,proto3,oneof"`
}

type GossipMessage_MemRes struct {
	MemRes *MembershipResponse `protobuf:"bytes,7,opt,name=mem_res,json=memRes,proto3,oneof"`
}

type GossipMessage_DataMsg struct {
	DataMsg *DataMessage `protobuf:"bytes,8,opt,name=data_msg,json=dataMsg,proto3,oneof"`
}

type GossipMessage_Hello struct {
	Hello *GossipHello `protobuf:"bytes,9,opt,name=hello,proto3,oneof"`
}

type GossipMessage_DataDig struct {
	DataDig *DataDigest `protobuf:"bytes,10,opt,name=data_dig,json=dataDig,proto3,oneof"`
}

type GossipMessage_DataReq struct {
	DataReq *DataRequest `protobuf:"bytes,11,opt,name=data_req,json=dataReq,proto3,oneof"`
}

type GossipMessage_DataUpdate struct {
	DataUpdate *DataUpdate `protobuf:"bytes,12,opt,name=data_update,json=dataUpdate,proto3,oneof"`
}

type GossipMessage_Empty struct {
	Empty *Empty `protobuf:"bytes,13,opt,name=empty,proto3,oneof"`
}

type GossipMessage_Conn struct {
	Conn *ConnEstablish `protobuf:"bytes,14,opt,name=conn,proto3,oneof"`
}

type GossipMessage_StateInfo struct {
	StateInfo *StateInfo `protobuf:"bytes,15,opt,name=state_info,json=stateInfo,proto3,oneof"`
}

type GossipMessage_StateSnapshot struct {
	StateSnapshot *StateInfoSnapshot `protobuf:"bytes,16,opt,name=state_snapshot,json=stateSnapshot,proto3,oneof"`
}

type GossipMessage_StateInfoPullReq struct {
	StateInfoPullReq *StateInfoPullRequest `protobuf:"bytes,17,opt,name=state_info_pull_req,json=stateInfoPullReq,proto3,oneof"`
}

type GossipMessage_StateRequest struct {
	StateRequest *RemoteStateRequest `protobuf:"bytes,18,opt,name=state_request,json=stateRequest,proto3,oneof"`
}

type GossipMessage_StateResponse struct {
	StateResponse *RemoteStateResponse `protobuf:"bytes,19,opt,name=state_response,json=stateResponse,proto3,oneof"`
}

type GossipMessage_LeadershipMsg struct {
	LeadershipMsg *LeadershipMessage `protobuf:"bytes,20,opt,name=leadership_msg,json=leadershipMsg,proto3,oneof"`
}

type GossipMessage_PeerIdentity struct {
	PeerIdentity *PeerIdentity `protobuf:"bytes,21,opt,name=peer_identity,json=peerIdentity,proto3,oneof"`
}

type GossipMessage_Ack struct {
	Ack *Acknowledgement `protobuf:"bytes,22,opt,name=ack,proto3,oneof"`
}

type GossipMessage_PrivateReq struct {
	PrivateReq *RemotePvtDataRequest `protobuf:"bytes,23,opt,name=privateReq,proto3,oneof"`
}

type GossipMessage_PrivateRes struct {
	PrivateRes *RemotePvtDataResponse `protobuf:"bytes,24,opt,name=privateRes,proto3,oneof"`
}

type GossipMessage_PrivateData struct {
	PrivateData *PrivateDataMessage `protobuf:"bytes,25,opt,name=private_data,json=privateData,proto3,oneof"`
}

func (*GossipMessage_AliveMsg) isGossipMessage_Content() {}

func (*GossipMessage_MemReq) isGossipMessage_Content() {}

func (*GossipMessage_MemRes) isGossipMessage_Content() {}

func (*GossipMessage_DataMsg) isGossipMessage_Content() {}

func (*GossipMessage_Hello) isGossipMessage_Content() {}

func (*GossipMessage_DataDig) isGossipMessage_Content() {}

func (*GossipMessage_DataReq) isGossipMessage_Content() {}

func (*GossipMessage_DataUpdate) isGossipMessage_Content() {}

func (*GossipMessage_Empty) isGossipMessage_Content() {}

func (*GossipMessage_Conn) isGossipMessage_Content() {}

func (*GossipMessage_StateInfo) isGossipMessage_Content() {}

func (*GossipMessage_StateSnapshot) isGossipMessage_Content() {}

func (*GossipMessage_StateInfoPullReq) isGossipMessage_Content() {}

func (*GossipMessage_StateRequest) isGossipMessage_Content() {}

func (*GossipMessage_StateResponse) isGossipMessage_Content() {}

func (*GossipMessage_LeadershipMsg) isGossipMessage_Content() {}

func (*GossipMessage_PeerIdentity) isGossipMessage_Content() {}

func (*GossipMessage_Ack) isGossipMessage_Content() {}

func (*GossipMessage_PrivateReq) isGossipMessage_Content() {}

func (*GossipMessage_PrivateRes) isGossipMessage_Content() {}

func (*GossipMessage_PrivateData) isGossipMessage_Content() {}

func (m *GossipMessage) GetContent() isGossipMessage_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *GossipMessage) GetAliveMsg() *AliveMessage {
	if x, ok := m.GetContent().(*GossipMessage_AliveMsg); ok {
		return x.AliveMsg
	}
	return nil
}

func (m *GossipMessage) GetMemReq() *MembershipRequest {
	if x, ok := m.GetContent().(*GossipMessage_MemReq); ok {
		return x.MemReq
	}
	return nil
}

func (m *GossipMessage) GetMemRes() *MembershipResponse {
	if x, ok := m.GetContent().(*GossipMessage_MemRes); ok {
		return x.MemRes
	}
	return nil
}

func (m *GossipMessage) GetDataMsg() *DataMessage {
	if x, ok := m.GetContent().(*GossipMessage_DataMsg); ok {
		return x.DataMsg
	}
	return nil
}

func (m *GossipMessage) GetHello() *GossipHello {
	if x, ok := m.GetContent().(*GossipMessage_Hello); ok {
		return x.Hello
	}
	return nil
}

func (m *GossipMessage) GetDataDig() *DataDigest {
	if x, ok := m.GetContent().(*GossipMessage_DataDig); ok {
		return x.DataDig
	}
	return nil
}

func (m *GossipMessage) GetDataReq() *DataRequest {
	if x, ok := m.GetContent().(*GossipMessage_DataReq); ok {
		return x.DataReq
	}
	return nil
}

func (m *GossipMessage) GetDataUpdate() *DataUpdate {
	if x, ok := m.GetContent().(*GossipMessage_DataUpdate); ok {
		return x.DataUpdate
	}
	return nil
}

func (m *GossipMessage) GetEmpty() *Empty {
	if x, ok := m.GetContent().(*GossipMessage_Empty); ok {
		return x.Empty
	}
	return nil
}

func (m *GossipMessage) GetConn() *ConnEstablish {
	if x, ok := m.GetContent().(*GossipMessage_Conn); ok {
		return x.Conn
	}
	return nil
}

func (m *GossipMessage) GetStateInfo() *StateInfo {
	if x, ok := m.GetContent().(*GossipMessage_StateInfo); ok {
		return x.StateInfo
	}
	return nil
}

func (m *GossipMessage) GetStateSnapshot() *StateInfoSnapshot {
	if x, ok := m.GetContent().(*GossipMessage_StateSnapshot); ok {
		return x.StateSnapshot
	}
	return nil
}

func (m *GossipMessage) GetStateInfoPullReq() *StateInfoPullRequest {
	if x, ok := m.GetContent().(*GossipMessage_StateInfoPullReq); ok {
		return x.StateInfoPullReq
	}
	return nil
}

func (m *GossipMessage) GetStateRequest() *RemoteStateRequest {
	if x, ok := m.GetContent().(*GossipMessage_StateRequest); ok {
		return x.StateRequest
	}
	return nil
}

func (m *GossipMessage) GetStateResponse() *RemoteStateResponse {
	if x, ok := m.GetContent().(*GossipMessage_StateResponse); ok {
		return x.StateResponse
	}
	return nil
}

func (m *GossipMessage) GetLeadershipMsg() *LeadershipMessage {
	if x, ok := m.GetContent().(*GossipMessage_LeadershipMsg); ok {
		return x.LeadershipMsg
	}
	return nil
}

func (m *GossipMessage) GetPeerIdentity() *PeerIdentity {
	if x, ok := m.GetContent().(*GossipMessage_PeerIdentity); ok {
		return x.PeerIdentity
	}
	return nil
}

func (m *GossipMessage) GetAck() *Acknowledgement {
	if x, ok := m.GetContent().(*GossipMessage_Ack); ok {
		return x.Ack
	}
	return nil
}

func (m *GossipMessage) GetPrivateReq() *RemotePvtDataRequest {
	if x, ok := m.GetContent().(*GossipMessage_PrivateReq); ok {
		return x.PrivateReq
	}
	return nil
}

func (m *GossipMessage) GetPrivateRes() *RemotePvtDataResponse {
	if x, ok := m.GetContent().(*GossipMessage_PrivateRes); ok {
		return x.PrivateRes
	}
	return nil
}

func (m *GossipMessage) GetPrivateData() *PrivateDataMessage {
	if x, ok := m.GetContent().(*GossipMessage_PrivateData); ok {
		return x.PrivateData
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GossipMessage) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GossipMessage_AliveMsg)(nil),
		(*GossipMessage_MemReq)(nil),
		(*GossipMessage_MemRes)(nil),
		(*GossipMessage_DataMsg)(nil),
		(*GossipMessage_Hello)(nil),
		(*GossipMessage_DataDig)(nil),
		(*GossipMessage_DataReq)(nil),
		(*GossipMessage_DataUpdate)(nil),
		(*GossipMessage_Empty)(nil),
		(*GossipMessage_Conn)(nil),
		(*GossipMessage_StateInfo)(nil),
		(*GossipMessage_StateSnapshot)(nil),
		(*GossipMessage_StateInfoPullReq)(nil),
		(*GossipMessage_StateRequest)(nil),
		(*GossipMessage_StateResponse)(nil),
		(*GossipMessage_LeadershipMsg)(nil),
		(*GossipMessage_PeerIdentity)(nil),
		(*GossipMessage_Ack)(nil),
		(*GossipMessage_PrivateReq)(nil),
		(*GossipMessage_PrivateRes)(nil),
		(*GossipMessage_PrivateData)(nil),
	}
}

// StateInfo is used for a peer to relay its state information
// to other peers
type StateInfo struct {
	Timestamp *PeerTime `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	PkiId     []byte    `protobuf:"bytes,3,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
	// channel_MAC is an authentication code that proves
	// that the peer that sent this message knows
	// the name of the channel.
	Channel_MAC          []byte      `protobuf:"bytes,4,opt,name=channel_MAC,json=channelMAC,proto3" json:"channel_MAC,omitempty"`
	Properties           *Properties `protobuf:"bytes,5,opt,name=properties,proto3" json:"properties,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *StateInfo) Reset()         { *m = StateInfo{} }
func (m *StateInfo) String() string { return proto.CompactTextString(m) }
func (*StateInfo) ProtoMessage()    {}
func (*StateInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{4}
}

func (m *StateInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateInfo.Unmarshal(m, b)
}
func (m *StateInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateInfo.Marshal(b, m, deterministic)
}
func (m *StateInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateInfo.Merge(m, src)
}
func (m *StateInfo) XXX_Size() int {
	return xxx_messageInfo_StateInfo.Size(m)
}
func (m *StateInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_StateInfo.DiscardUnknown(m)
}

var xxx_messageInfo_StateInfo proto.InternalMessageInfo

func (m *StateInfo) GetTimestamp() *PeerTime {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *StateInfo) GetPkiId() []byte {
	if m != nil {
		return m.PkiId
	}
	return nil
}

func (m *StateInfo) GetChannel_MAC() []byte {
	if m != nil {
		return m.Channel_MAC
	}
	return nil
}

func (m *StateInfo) GetProperties() *Properties {
	if m != nil {
		return m.Properties
	}
	return nil
}

type Properties struct {
	LedgerHeight         uint64       `protobuf:"varint,1,opt,name=ledger_height,json=ledgerHeight,proto3" json:"ledger_height,omitempty"`
	LeftChannel          bool         `protobuf:"varint,2,opt,name=left_channel,json=leftChannel,proto3" json:"left_channel,omitempty"`
	Chaincodes           []*Chaincode `protobuf:"bytes,3,rep,name=chaincodes,proto3" json:"chaincodes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Properties) Reset()         { *m = Properties{} }
func (m *Properties) String() string { return proto.CompactTextString(m) }
func (*Properties) ProtoMessage()    {}
func (*Properties) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{5}
}

func (m *Properties) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Properties.Unmarshal(m, b)
}
func (m *Properties) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Properties.Marshal(b, m, deterministic)
}
func (m *Properties) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Properties.Merge(m, src)
}
func (m *Properties) XXX_Size() int {
	return xxx_messageInfo_Properties.Size(m)
}
func (m *Properties) XXX_DiscardUnknown() {
	xxx_messageInfo_Properties.DiscardUnknown(m)
}

var xxx_messageInfo_Properties proto.InternalMessageInfo

func (m *Properties) GetLedgerHeight() uint64 {
	if m != nil {
		return m.LedgerHeight
	}
	return 0
}

func (m *Properties) GetLeftChannel() bool {
	if m != nil {
		return m.LeftChannel
	}
	return false
}

func (m *Properties) GetChaincodes() []*Chaincode {
	if m != nil {
		return m.Chaincodes
	}
	return nil
}

// StateInfoSnapshot is an aggregation of StateInfo messages
type StateInfoSnapshot struct {
	Elements             []*Envelope `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *StateInfoSnapshot) Reset()         { *m = StateInfoSnapshot{} }
func (m *StateInfoSnapshot) String() string { return proto.CompactTextString(m) }
func (*StateInfoSnapshot) ProtoMessage()    {}
func (*StateInfoSnapshot) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{6}
}

func (m *StateInfoSnapshot) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateInfoSnapshot.Unmarshal(m, b)
}
func (m *StateInfoSnapshot) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateInfoSnapshot.Marshal(b, m, deterministic)
}
func (m *StateInfoSnapshot) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateInfoSnapshot.Merge(m, src)
}
func (m *StateInfoSnapshot) XXX_Size() int {
	return xxx_messageInfo_StateInfoSnapshot.Size(m)
}
func (m *StateInfoSnapshot) XXX_DiscardUnknown() {
	xxx_messageInfo_StateInfoSnapshot.DiscardUnknown(m)
}

var xxx_messageInfo_StateInfoSnapshot proto.InternalMessageInfo

func (m *StateInfoSnapshot) GetElements() []*Envelope {
	if m != nil {
		return m.Elements
	}
	return nil
}

// StateInfoPullRequest is used to fetch a StateInfoSnapshot
// from a remote peer
type StateInfoPullRequest struct {
	// channel_MAC is an authentication code that proves
	// that the peer that sent this message knows
	// the name of the channel.
	Channel_MAC          []byte   `protobuf:"bytes,1,opt,name=channel_MAC,json=channelMAC,proto3" json:"channel_MAC,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateInfoPullRequest) Reset()         { *m = StateInfoPullRequest{} }
func (m *StateInfoPullRequest) String() string { return proto.CompactTextString(m) }
func (*StateInfoPullRequest) ProtoMessage()    {}
func (*StateInfoPullRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{7}
}

func (m *StateInfoPullRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateInfoPullRequest.Unmarshal(m, b)
}
func (m *StateInfoPullRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateInfoPullRequest.Marshal(b, m, deterministic)
}
func (m *StateInfoPullRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateInfoPullRequest.Merge(m, src)
}
func (m *StateInfoPullRequest) XXX_Size() int {
	return xxx_messageInfo_StateInfoPullRequest.Size(m)
}
func (m *StateInfoPullRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StateInfoPullRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StateInfoPullRequest proto.InternalMessageInfo

func (m *StateInfoPullRequest) GetChannel_MAC() []byte {
	if m != nil {
		return m.Channel_MAC
	}
	return nil
}

// ConnEstablish is the message used for the gossip handshake
// Whenever a peer connects to another peer, it handshakes
// with it by sending this message that proves its identity
type ConnEstablish struct {
	PkiId                []byte   `protobuf:"bytes,1,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
	Identity             []byte   `protobuf:"bytes,2,opt,name=identity,proto3" json:"identity,omitempty"`
	TlsCertHash          []byte   `protobuf:"bytes,3,opt,name=tls_cert_hash,json=tlsCertHash,proto3" json:"tls_cert_hash,omitempty"`
	Probe                bool     `protobuf:"varint,4,opt,name=probe,proto3" json:"probe,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConnEstablish) Reset()         { *m = ConnEstablish{} }
func (m *ConnEstablish) String() string { return proto.CompactTextString(m) }
func (*ConnEstablish) ProtoMessage()    {}
func (*ConnEstablish) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{8}
}

func (m *ConnEstablish) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConnEstablish.Unmarshal(m, b)
}
func (m *ConnEstablish) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConnEstablish.Marshal(b, m, deterministic)
}
func (m *ConnEstablish) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConnEstablish.Merge(m, src)
}
func (m *ConnEstablish) XXX_Size() int {
	return xxx_messageInfo_ConnEstablish.Size(m)
}
func (m *ConnEstablish) XXX_DiscardUnknown() {
	xxx_messageInfo_ConnEstablish.DiscardUnknown(m)
}

var xxx_messageInfo_ConnEstablish proto.InternalMessageInfo

func (m *ConnEstablish) GetPkiId() []byte {
	if m != nil {
		return m.PkiId
	}
	return nil
}

func (m *ConnEstablish) GetIdentity() []byte {
	if m != nil {
		return m.Identity
	}
	return nil
}

func (m *ConnEstablish) GetTlsCertHash() []byte {
	if m != nil {
		return m.TlsCertHash
	}
	return nil
}

func (m *ConnEstablish) GetProbe() bool {
	if m != nil {
		return m.Probe
	}
	return false
}

// PeerIdentity defines the identity of the peer
// Used to make other peers learn of the identity
// of a certain peer
type PeerIdentity struct {
	PkiId                []byte   `protobuf:"bytes,1,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
	Cert                 []byte   `protobuf:"bytes,2,opt,name=cert,proto3" json:"cert,omitempty"`
	Metadata             []byte   `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PeerIdentity) Reset()         { *m = PeerIdentity{} }
func (m *PeerIdentity) String() string { return proto.CompactTextString(m) }
func (*PeerIdentity) ProtoMessage()    {}
func (*PeerIdentity) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{9}
}

func (m *PeerIdentity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PeerIdentity.Unmarshal(m, b)
}
func (m *PeerIdentity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PeerIdentity.Marshal(b, m, deterministic)
}
func (m *PeerIdentity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PeerIdentity.Merge(m, src)
}
func (m *PeerIdentity) XXX_Size() int {
	return xxx_messageInfo_PeerIdentity.Size(m)
}
func (m *PeerIdentity) XXX_DiscardUnknown() {
	xxx_messageInfo_PeerIdentity.DiscardUnknown(m)
}

var xxx_messageInfo_PeerIdentity proto.InternalMessageInfo

func (m *PeerIdentity) GetPkiId() []byte {
	if m != nil {
		return m.PkiId
	}
	return nil
}

func (m *PeerIdentity) GetCert() []byte {
	if m != nil {
		return m.Cert
	}
	return nil
}

func (m *PeerIdentity) GetMetadata() []byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// DataRequest is a message used for a peer to request
// certain data blocks from a remote peer
type DataRequest struct {
	Nonce                uint64      `protobuf:"varint,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	Digests              [][]byte    `protobuf:"bytes,2,rep,name=digests,proto3" json:"digests,omitempty"`
	MsgType              PullMsgType `protobuf:"varint,3,opt,name=msg_type,json=msgType,proto3,enum=gossip.PullMsgType" json:"msg_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *DataRequest) Reset()         { *m = DataRequest{} }
func (m *DataRequest) String() string { return proto.CompactTextString(m) }
func (*DataRequest) ProtoMessage()    {}
func (*DataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{10}
}

func (m *DataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DataRequest.Unmarshal(m, b)
}
func (m *DataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DataRequest.Marshal(b, m, deterministic)
}
func (m *DataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataRequest.Merge(m, src)
}
func (m *DataRequest) XXX_Size() int {
	return xxx_messageInfo_DataRequest.Size(m)
}
func (m *DataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DataRequest proto.InternalMessageInfo

func (m *DataRequest) GetNonce() uint64 {
	if m != nil {
		return m.Nonce
	}
	return 0
}

func (m *DataRequest) GetDigests() [][]byte {
	if m != nil {
		return m.Digests
	}
	return nil
}

func (m *DataRequest) GetMsgType() PullMsgType {
	if m != nil {
		return m.MsgType
	}
	return PullMsgType_UNDEFINED
}

// GossipHello is the message that is used for the peer to initiate
// a pull round with another peer
type GossipHello struct {
	Nonce                uint64      `protobuf:"varint,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	Metadata             []byte      `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	MsgType              PullMsgType `protobuf:"varint,3,opt,name=msg_type,json=msgType,proto3,enum=gossip.PullMsgType" json:"msg_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *GossipHello) Reset()         { *m = GossipHello{} }
func (m *GossipHello) String() string { return proto.CompactTextString(m) }
func (*GossipHello) ProtoMessage()    {}
func (*GossipHello) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{11}
}

func (m *GossipHello) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GossipHello.Unmarshal(m, b)
}
func (m *GossipHello) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GossipHello.Marshal(b, m, deterministic)
}
func (m *GossipHello) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GossipHello.Merge(m, src)
}
func (m *GossipHello) XXX_Size() int {
	return xxx_messageInfo_GossipHello.Size(m)
}
func (m *GossipHello) XXX_DiscardUnknown() {
	xxx_messageInfo_GossipHello.DiscardUnknown(m)
}

var xxx_messageInfo_GossipHello proto.InternalMessageInfo

func (m *GossipHello) GetNonce() uint64 {
	if m != nil {
		return m.Nonce
	}
	return 0
}

func (m *GossipHello) GetMetadata() []byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *GossipHello) GetMsgType() PullMsgType {
	if m != nil {
		return m.MsgType
	}
	return PullMsgType_UNDEFINED
}

// DataUpdate is the final message in the pull phase
// sent from the receiver to the initiator
type DataUpdate struct {
	Nonce                uint64      `protobuf:"varint,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	Data                 []*Envelope `protobuf:"bytes,2,rep,name=data,proto3" json:"data,omitempty"`
	MsgType              PullMsgType `protobuf:"varint,3,opt,name=msg_type,json=msgType,proto3,enum=gossip.PullMsgType" json:"msg_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *DataUpdate) Reset()         { *m = DataUpdate{} }
func (m *DataUpdate) String() string { return proto.CompactTextString(m) }
func (*DataUpdate) ProtoMessage()    {}
func (*DataUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{12}
}

func (m *DataUpdate) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DataUpdate.Unmarshal(m, b)
}
func (m *DataUpdate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DataUpdate.Marshal(b, m, deterministic)
}
func (m *DataUpdate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataUpdate.Merge(m, src)
}
func (m *DataUpdate) XXX_Size() int {
	return xxx_messageInfo_DataUpdate.Size(m)
}
func (m *DataUpdate) XXX_DiscardUnknown() {
	xxx_messageInfo_DataUpdate.DiscardUnknown(m)
}

var xxx_messageInfo_DataUpdate proto.InternalMessageInfo

func (m *DataUpdate) GetNonce() uint64 {
	if m != nil {
		return m.Nonce
	}
	return 0
}

func (m *DataUpdate) GetData() []*Envelope {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *DataUpdate) GetMsgType() PullMsgType {
	if m != nil {
		return m.MsgType
	}
	return PullMsgType_UNDEFINED
}

// DataDigest is the message sent from the receiver peer
// to the initator peer and contains the data items it has
type DataDigest struct {
	Nonce                uint64      `protobuf:"varint,1,opt,name=nonce,proto3" json:"nonce,omitempty"`
	Digests              [][]byte    `protobuf:"bytes,2,rep,name=digests,proto3" json:"digests,omitempty"`
	MsgType              PullMsgType `protobuf:"varint,3,opt,name=msg_type,json=msgType,proto3,enum=gossip.PullMsgType" json:"msg_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *DataDigest) Reset()         { *m = DataDigest{} }
func (m *DataDigest) String() string { return proto.CompactTextString(m) }
func (*DataDigest) ProtoMessage()    {}
func (*DataDigest) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{13}
}

func (m *DataDigest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DataDigest.Unmarshal(m, b)
}
func (m *DataDigest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DataDigest.Marshal(b, m, deterministic)
}
func (m *DataDigest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataDigest.Merge(m, src)
}
func (m *DataDigest) XXX_Size() int {
	return xxx_messageInfo_DataDigest.Size(m)
}
func (m *DataDigest) XXX_DiscardUnknown() {
	xxx_messageInfo_DataDigest.DiscardUnknown(m)
}

var xxx_messageInfo_DataDigest proto.InternalMessageInfo

func (m *DataDigest) GetNonce() uint64 {
	if m != nil {
		return m.Nonce
	}
	return 0
}

func (m *DataDigest) GetDigests() [][]byte {
	if m != nil {
		return m.Digests
	}
	return nil
}

func (m *DataDigest) GetMsgType() PullMsgType {
	if m != nil {
		return m.MsgType
	}
	return PullMsgType_UNDEFINED
}

// DataMessage is the message that contains a block
type DataMessage struct {
	Payload              *Payload `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DataMessage) Reset()         { *m = DataMessage{} }
func (m *DataMessage) String() string { return proto.CompactTextString(m) }
func (*DataMessage) ProtoMessage()    {}
func (*DataMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{14}
}

func (m *DataMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DataMessage.Unmarshal(m, b)
}
func (m *DataMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DataMessage.Marshal(b, m, deterministic)
}
func (m *DataMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataMessage.Merge(m, src)
}
func (m *DataMessage) XXX_Size() int {
	return xxx_messageInfo_DataMessage.Size(m)
}
func (m *DataMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_DataMessage.DiscardUnknown(m)
}

var xxx_messageInfo_DataMessage proto.InternalMessageInfo

func (m *DataMessage) GetPayload() *Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

// PrivateDataMessage message which includes private
// data information to distributed once transaction
// has been endorsed
type PrivateDataMessage struct {
	Payload              *PrivatePayload `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *PrivateDataMessage) Reset()         { *m = PrivateDataMessage{} }
func (m *PrivateDataMessage) String() string { return proto.CompactTextString(m) }
func (*PrivateDataMessage) ProtoMessage()    {}
func (*PrivateDataMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{15}
}

func (m *PrivateDataMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrivateDataMessage.Unmarshal(m, b)
}
func (m *PrivateDataMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrivateDataMessage.Marshal(b, m, deterministic)
}
func (m *PrivateDataMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrivateDataMessage.Merge(m, src)
}
func (m *PrivateDataMessage) XXX_Size() int {
	return xxx_messageInfo_PrivateDataMessage.Size(m)
}
func (m *PrivateDataMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_PrivateDataMessage.DiscardUnknown(m)
}

var xxx_messageInfo_PrivateDataMessage proto.InternalMessageInfo

func (m *PrivateDataMessage) GetPayload() *PrivatePayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Payload contains a block
type Payload struct {
	SeqNum               uint64   `protobuf:"varint,1,opt,name=seq_num,json=seqNum,proto3" json:"seq_num,omitempty"`
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	PrivateData          [][]byte `protobuf:"bytes,3,rep,name=private_data,json=privateData,proto3" json:"private_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Payload) Reset()         { *m = Payload{} }
func (m *Payload) String() string { return proto.CompactTextString(m) }
func (*Payload) ProtoMessage()    {}
func (*Payload) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{16}
}

func (m *Payload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Payload.Unmarshal(m, b)
}
func (m *Payload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Payload.Marshal(b, m, deterministic)
}
func (m *Payload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Payload.Merge(m, src)
}
func (m *Payload) XXX_Size() int {
	return xxx_messageInfo_Payload.Size(m)
}
func (m *Payload) XXX_DiscardUnknown() {
	xxx_messageInfo_Payload.DiscardUnknown(m)
}

var xxx_messageInfo_Payload proto.InternalMessageInfo

func (m *Payload) GetSeqNum() uint64 {
	if m != nil {
		return m.SeqNum
	}
	return 0
}

func (m *Payload) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Payload) GetPrivateData() [][]byte {
	if m != nil {
		return m.PrivateData
	}
	return nil
}

// PrivatePayload payload to encapsulate private
// data with collection name to enable routing
// based on collection partitioning
type PrivatePayload struct {
	CollectionName       string                        `protobuf:"bytes,1,opt,name=collection_name,json=collectionName,proto3" json:"collection_name,omitempty"`
	Namespace            string                        `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	TxId                 string                        `protobuf:"bytes,3,opt,name=tx_id,json=txId,proto3" json:"tx_id,omitempty"`
	PrivateRwset         []byte                        `protobuf:"bytes,4,opt,name=private_rwset,json=privateRwset,proto3" json:"private_rwset,omitempty"`
	PrivateSimHeight     uint64                        `protobuf:"varint,5,opt,name=private_sim_height,json=privateSimHeight,proto3" json:"private_sim_height,omitempty"`
	CollectionConfigs    *peer.CollectionConfigPackage `protobuf:"bytes,6,opt,name=collection_configs,json=collectionConfigs,proto3" json:"collection_configs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *PrivatePayload) Reset()         { *m = PrivatePayload{} }
func (m *PrivatePayload) String() string { return proto.CompactTextString(m) }
func (*PrivatePayload) ProtoMessage()    {}
func (*PrivatePayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{17}
}

func (m *PrivatePayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrivatePayload.Unmarshal(m, b)
}
func (m *PrivatePayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrivatePayload.Marshal(b, m, deterministic)
}
func (m *PrivatePayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrivatePayload.Merge(m, src)
}
func (m *PrivatePayload) XXX_Size() int {
	return xxx_messageInfo_PrivatePayload.Size(m)
}
func (m *PrivatePayload) XXX_DiscardUnknown() {
	xxx_messageInfo_PrivatePayload.DiscardUnknown(m)
}

var xxx_messageInfo_PrivatePayload proto.InternalMessageInfo

func (m *PrivatePayload) GetCollectionName() string {
	if m != nil {
		return m.CollectionName
	}
	return ""
}

func (m *PrivatePayload) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *PrivatePayload) GetTxId() string {
	if m != nil {
		return m.TxId
	}
	return ""
}

func (m *PrivatePayload) GetPrivateRwset() []byte {
	if m != nil {
		return m.PrivateRwset
	}
	return nil
}

func (m *PrivatePayload) GetPrivateSimHeight() uint64 {
	if m != nil {
		return m.PrivateSimHeight
	}
	return 0
}

func (m *PrivatePayload) GetCollectionConfigs() *peer.CollectionConfigPackage {
	if m != nil {
		return m.CollectionConfigs
	}
	return nil
}

// AliveMessage is sent to inform remote peers
// of a peer's existence and activity
type AliveMessage struct {
	Membership           *Member   `protobuf:"bytes,1,opt,name=membership,proto3" json:"membership,omitempty"`
	Timestamp            *PeerTime `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Identity             []byte    `protobuf:"bytes,4,opt,name=identity,proto3" json:"identity,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *AliveMessage) Reset()         { *m = AliveMessage{} }
func (m *AliveMessage) String() string { return proto.CompactTextString(m) }
func (*AliveMessage) ProtoMessage()    {}
func (*AliveMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{18}
}

func (m *AliveMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AliveMessage.Unmarshal(m, b)
}
func (m *AliveMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AliveMessage.Marshal(b, m, deterministic)
}
func (m *AliveMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AliveMessage.Merge(m, src)
}
func (m *AliveMessage) XXX_Size() int {
	return xxx_messageInfo_AliveMessage.Size(m)
}
func (m *AliveMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_AliveMessage.DiscardUnknown(m)
}

var xxx_messageInfo_AliveMessage proto.InternalMessageInfo

func (m *AliveMessage) GetMembership() *Member {
	if m != nil {
		return m.Membership
	}
	return nil
}

func (m *AliveMessage) GetTimestamp() *PeerTime {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *AliveMessage) GetIdentity() []byte {
	if m != nil {
		return m.Identity
	}
	return nil
}

// Leadership Message is sent during leader election to inform
// remote peers about intent of peer to proclaim itself as leader
type LeadershipMessage struct {
	PkiId                []byte    `protobuf:"bytes,1,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
	Timestamp            *PeerTime `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	IsDeclaration        bool      `protobuf:"varint,3,opt,name=is_declaration,json=isDeclaration,proto3" json:"is_declaration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *LeadershipMessage) Reset()         { *m = LeadershipMessage{} }
func (m *LeadershipMessage) String() string { return proto.CompactTextString(m) }
func (*LeadershipMessage) ProtoMessage()    {}
func (*LeadershipMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{19}
}

func (m *LeadershipMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LeadershipMessage.Unmarshal(m, b)
}
func (m *LeadershipMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LeadershipMessage.Marshal(b, m, deterministic)
}
func (m *LeadershipMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LeadershipMessage.Merge(m, src)
}
func (m *LeadershipMessage) XXX_Size() int {
	return xxx_messageInfo_LeadershipMessage.Size(m)
}
func (m *LeadershipMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_LeadershipMessage.DiscardUnknown(m)
}

var xxx_messageInfo_LeadershipMessage proto.InternalMessageInfo

func (m *LeadershipMessage) GetPkiId() []byte {
	if m != nil {
		return m.PkiId
	}
	return nil
}

func (m *LeadershipMessage) GetTimestamp() *PeerTime {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *LeadershipMessage) GetIsDeclaration() bool {
	if m != nil {
		return m.IsDeclaration
	}
	return false
}

// PeerTime defines the logical time of a peer's life
type PeerTime struct {
	IncNum               uint64   `protobuf:"varint,1,opt,name=inc_num,json=incNum,proto3" json:"inc_num,omitempty"`
	SeqNum               uint64   `protobuf:"varint,2,opt,name=seq_num,json=seqNum,proto3" json:"seq_num,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PeerTime) Reset()         { *m = PeerTime{} }
func (m *PeerTime) String() string { return proto.CompactTextString(m) }
func (*PeerTime) ProtoMessage()    {}
func (*PeerTime) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{20}
}

func (m *PeerTime) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PeerTime.Unmarshal(m, b)
}
func (m *PeerTime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PeerTime.Marshal(b, m, deterministic)
}
func (m *PeerTime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PeerTime.Merge(m, src)
}
func (m *PeerTime) XXX_Size() int {
	return xxx_messageInfo_PeerTime.Size(m)
}
func (m *PeerTime) XXX_DiscardUnknown() {
	xxx_messageInfo_PeerTime.DiscardUnknown(m)
}

var xxx_messageInfo_PeerTime proto.InternalMessageInfo

func (m *PeerTime) GetIncNum() uint64 {
	if m != nil {
		return m.IncNum
	}
	return 0
}

func (m *PeerTime) GetSeqNum() uint64 {
	if m != nil {
		return m.SeqNum
	}
	return 0
}

// MembershipRequest is used to ask membership information
// from a remote peer
type MembershipRequest struct {
	SelfInformation      *Envelope `protobuf:"bytes,1,opt,name=self_information,json=selfInformation,proto3" json:"self_information,omitempty"`
	Known                [][]byte  `protobuf:"bytes,2,rep,name=known,proto3" json:"known,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *MembershipRequest) Reset()         { *m = MembershipRequest{} }
func (m *MembershipRequest) String() string { return proto.CompactTextString(m) }
func (*MembershipRequest) ProtoMessage()    {}
func (*MembershipRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{21}
}

func (m *MembershipRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MembershipRequest.Unmarshal(m, b)
}
func (m *MembershipRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MembershipRequest.Marshal(b, m, deterministic)
}
func (m *MembershipRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MembershipRequest.Merge(m, src)
}
func (m *MembershipRequest) XXX_Size() int {
	return xxx_messageInfo_MembershipRequest.Size(m)
}
func (m *MembershipRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MembershipRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MembershipRequest proto.InternalMessageInfo

func (m *MembershipRequest) GetSelfInformation() *Envelope {
	if m != nil {
		return m.SelfInformation
	}
	return nil
}

func (m *MembershipRequest) GetKnown() [][]byte {
	if m != nil {
		return m.Known
	}
	return nil
}

// MembershipResponse is used for replying to MembershipRequests
type MembershipResponse struct {
	Alive                []*Envelope `protobuf:"bytes,1,rep,name=alive,proto3" json:"alive,omitempty"`
	Dead                 []*Envelope `protobuf:"bytes,2,rep,name=dead,proto3" json:"dead,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *MembershipResponse) Reset()         { *m = MembershipResponse{} }
func (m *MembershipResponse) String() string { return proto.CompactTextString(m) }
func (*MembershipResponse) ProtoMessage()    {}
func (*MembershipResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{22}
}

func (m *MembershipResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MembershipResponse.Unmarshal(m, b)
}
func (m *MembershipResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MembershipResponse.Marshal(b, m, deterministic)
}
func (m *MembershipResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MembershipResponse.Merge(m, src)
}
func (m *MembershipResponse) XXX_Size() int {
	return xxx_messageInfo_MembershipResponse.Size(m)
}
func (m *MembershipResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MembershipResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MembershipResponse proto.InternalMessageInfo

func (m *MembershipResponse) GetAlive() []*Envelope {
	if m != nil {
		return m.Alive
	}
	return nil
}

func (m *MembershipResponse) GetDead() []*Envelope {
	if m != nil {
		return m.Dead
	}
	return nil
}

// Member holds membership-related information
// about a peer
type Member struct {
	Endpoint             string   `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	Metadata             []byte   `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	PkiId                []byte   `protobuf:"bytes,3,opt,name=pki_id,json=pkiId,proto3" json:"pki_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Member) Reset()         { *m = Member{} }
func (m *Member) String() string { return proto.CompactTextString(m) }
func (*Member) ProtoMessage()    {}
func (*Member) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{23}
}

func (m *Member) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Member.Unmarshal(m, b)
}
func (m *Member) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Member.Marshal(b, m, deterministic)
}
func (m *Member) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Member.Merge(m, src)
}
func (m *Member) XXX_Size() int {
	return xxx_messageInfo_Member.Size(m)
}
func (m *Member) XXX_DiscardUnknown() {
	xxx_messageInfo_Member.DiscardUnknown(m)
}

var xxx_messageInfo_Member proto.InternalMessageInfo

func (m *Member) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func (m *Member) GetMetadata() []byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Member) GetPkiId() []byte {
	if m != nil {
		return m.PkiId
	}
	return nil
}

// Empty is used for pinging and in tests
type Empty struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Empty) Reset()         { *m = Empty{} }
func (m *Empty) String() string { return proto.CompactTextString(m) }
func (*Empty) ProtoMessage()    {}
func (*Empty) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{24}
}

func (m *Empty) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Empty.Unmarshal(m, b)
}
func (m *Empty) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Empty.Marshal(b, m, deterministic)
}
func (m *Empty) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Empty.Merge(m, src)
}
func (m *Empty) XXX_Size() int {
	return xxx_messageInfo_Empty.Size(m)
}
func (m *Empty) XXX_DiscardUnknown() {
	xxx_messageInfo_Empty.DiscardUnknown(m)
}

var xxx_messageInfo_Empty proto.InternalMessageInfo

// RemoteStateRequest is used to ask a set of blocks
// from a remote peer
type RemoteStateRequest struct {
	StartSeqNum          uint64   `protobuf:"varint,1,opt,name=start_seq_num,json=startSeqNum,proto3" json:"start_seq_num,omitempty"`
	EndSeqNum            uint64   `protobuf:"varint,2,opt,name=end_seq_num,json=endSeqNum,proto3" json:"end_seq_num,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RemoteStateRequest) Reset()         { *m = RemoteStateRequest{} }
func (m *RemoteStateRequest) String() string { return proto.CompactTextString(m) }
func (*RemoteStateRequest) ProtoMessage()    {}
func (*RemoteStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{25}
}

func (m *RemoteStateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoteStateRequest.Unmarshal(m, b)
}
func (m *RemoteStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoteStateRequest.Marshal(b, m, deterministic)
}
func (m *RemoteStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteStateRequest.Merge(m, src)
}
func (m *RemoteStateRequest) XXX_Size() int {
	return xxx_messageInfo_RemoteStateRequest.Size(m)
}
func (m *RemoteStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteStateRequest proto.InternalMessageInfo

func (m *RemoteStateRequest) GetStartSeqNum() uint64 {
	if m != nil {
		return m.StartSeqNum
	}
	return 0
}

func (m *RemoteStateRequest) GetEndSeqNum() uint64 {
	if m != nil {
		return m.EndSeqNum
	}
	return 0
}

// RemoteStateResponse is used to send a set of blocks
// to a remote peer
type RemoteStateResponse struct {
	Payloads             []*Payload `protobuf:"bytes,1,rep,name=payloads,proto3" json:"payloads,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *RemoteStateResponse) Reset()         { *m = RemoteStateResponse{} }
func (m *RemoteStateResponse) String() string { return proto.CompactTextString(m) }
func (*RemoteStateResponse) ProtoMessage()    {}
func (*RemoteStateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{26}
}

func (m *RemoteStateResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemoteStateResponse.Unmarshal(m, b)
}
func (m *RemoteStateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemoteStateResponse.Marshal(b, m, deterministic)
}
func (m *RemoteStateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemoteStateResponse.Merge(m, src)
}
func (m *RemoteStateResponse) XXX_Size() int {
	return xxx_messageInfo_RemoteStateResponse.Size(m)
}
func (m *RemoteStateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemoteStateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemoteStateResponse proto.InternalMessageInfo

func (m *RemoteStateResponse) GetPayloads() []*Payload {
	if m != nil {
		return m.Payloads
	}
	return nil
}

// RemotePrivateDataRequest message used to request
// missing private rwset
type RemotePvtDataRequest struct {
	Digests              []*PvtDataDigest `protobuf:"bytes,1,rep,name=digests,proto3" json:"digests,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *RemotePvtDataRequest) Reset()         { *m = RemotePvtDataRequest{} }
func (m *RemotePvtDataRequest) String() string { return proto.CompactTextString(m) }
func (*RemotePvtDataRequest) ProtoMessage()    {}
func (*RemotePvtDataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{27}
}

func (m *RemotePvtDataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemotePvtDataRequest.Unmarshal(m, b)
}
func (m *RemotePvtDataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemotePvtDataRequest.Marshal(b, m, deterministic)
}
func (m *RemotePvtDataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemotePvtDataRequest.Merge(m, src)
}
func (m *RemotePvtDataRequest) XXX_Size() int {
	return xxx_messageInfo_RemotePvtDataRequest.Size(m)
}
func (m *RemotePvtDataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RemotePvtDataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RemotePvtDataRequest proto.InternalMessageInfo

func (m *RemotePvtDataRequest) GetDigests() []*PvtDataDigest {
	if m != nil {
		return m.Digests
	}
	return nil
}

// PvtDataDigest defines a digest of private data
type PvtDataDigest struct {
	TxId                 string   `protobuf:"bytes,1,opt,name=tx_id,json=txId,proto3" json:"tx_id,omitempty"`
	Namespace            string   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Collection           string   `protobuf:"bytes,3,opt,name=collection,proto3" json:"collection,omitempty"`
	BlockSeq             uint64   `protobuf:"varint,4,opt,name=block_seq,json=blockSeq,proto3" json:"block_seq,omitempty"`
	SeqInBlock           uint64   `protobuf:"varint,5,opt,name=seq_in_block,json=seqInBlock,proto3" json:"seq_in_block,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PvtDataDigest) Reset()         { *m = PvtDataDigest{} }
func (m *PvtDataDigest) String() string { return proto.CompactTextString(m) }
func (*PvtDataDigest) ProtoMessage()    {}
func (*PvtDataDigest) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{28}
}

func (m *PvtDataDigest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PvtDataDigest.Unmarshal(m, b)
}
func (m *PvtDataDigest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PvtDataDigest.Marshal(b, m, deterministic)
}
func (m *PvtDataDigest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PvtDataDigest.Merge(m, src)
}
func (m *PvtDataDigest) XXX_Size() int {
	return xxx_messageInfo_PvtDataDigest.Size(m)
}
func (m *PvtDataDigest) XXX_DiscardUnknown() {
	xxx_messageInfo_PvtDataDigest.DiscardUnknown(m)
}

var xxx_messageInfo_PvtDataDigest proto.InternalMessageInfo

func (m *PvtDataDigest) GetTxId() string {
	if m != nil {
		return m.TxId
	}
	return ""
}

func (m *PvtDataDigest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *PvtDataDigest) GetCollection() string {
	if m != nil {
		return m.Collection
	}
	return ""
}

func (m *PvtDataDigest) GetBlockSeq() uint64 {
	if m != nil {
		return m.BlockSeq
	}
	return 0
}

func (m *PvtDataDigest) GetSeqInBlock() uint64 {
	if m != nil {
		return m.SeqInBlock
	}
	return 0
}

// RemotePrivateData message to response on private
// data replication request
type RemotePvtDataResponse struct {
	Elements             []*PvtDataElement `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *RemotePvtDataResponse) Reset()         { *m = RemotePvtDataResponse{} }
func (m *RemotePvtDataResponse) String() string { return proto.CompactTextString(m) }
func (*RemotePvtDataResponse) ProtoMessage()    {}
func (*RemotePvtDataResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{29}
}

func (m *RemotePvtDataResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RemotePvtDataResponse.Unmarshal(m, b)
}
func (m *RemotePvtDataResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RemotePvtDataResponse.Marshal(b, m, deterministic)
}
func (m *RemotePvtDataResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RemotePvtDataResponse.Merge(m, src)
}
func (m *RemotePvtDataResponse) XXX_Size() int {
	return xxx_messageInfo_RemotePvtDataResponse.Size(m)
}
func (m *RemotePvtDataResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RemotePvtDataResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RemotePvtDataResponse proto.InternalMessageInfo

func (m *RemotePvtDataResponse) GetElements() []*PvtDataElement {
	if m != nil {
		return m.Elements
	}
	return nil
}

type PvtDataElement struct {
	Digest *PvtDataDigest `protobuf:"bytes,1,opt,name=digest,proto3" json:"digest,omitempty"`
	// the payload is a marshaled kvrwset.KVRWSet
	Payload              [][]byte `protobuf:"bytes,2,rep,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PvtDataElement) Reset()         { *m = PvtDataElement{} }
func (m *PvtDataElement) String() string { return proto.CompactTextString(m) }
func (*PvtDataElement) ProtoMessage()    {}
func (*PvtDataElement) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{30}
}

func (m *PvtDataElement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PvtDataElement.Unmarshal(m, b)
}
func (m *PvtDataElement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PvtDataElement.Marshal(b, m, deterministic)
}
func (m *PvtDataElement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PvtDataElement.Merge(m, src)
}
func (m *PvtDataElement) XXX_Size() int {
	return xxx_messageInfo_PvtDataElement.Size(m)
}
func (m *PvtDataElement) XXX_DiscardUnknown() {
	xxx_messageInfo_PvtDataElement.DiscardUnknown(m)
}

var xxx_messageInfo_PvtDataElement proto.InternalMessageInfo

func (m *PvtDataElement) GetDigest() *PvtDataDigest {
	if m != nil {
		return m.Digest
	}
	return nil
}

func (m *PvtDataElement) GetPayload() [][]byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

// PvtPayload augments private rwset data and tx index
// inside the block
type PvtDataPayload struct {
	TxSeqInBlock uint64 `protobuf:"varint,1,opt,name=tx_seq_in_block,json=txSeqInBlock,proto3" json:"tx_seq_in_block,omitempty"`
	// Encodes marhslaed bytes of rwset.TxPvtReadWriteSet
	// defined in rwset.proto
	Payload              []byte   `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PvtDataPayload) Reset()         { *m = PvtDataPayload{} }
func (m *PvtDataPayload) String() string { return proto.CompactTextString(m) }
func (*PvtDataPayload) ProtoMessage()    {}
func (*PvtDataPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{31}
}

func (m *PvtDataPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PvtDataPayload.Unmarshal(m, b)
}
func (m *PvtDataPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PvtDataPayload.Marshal(b, m, deterministic)
}
func (m *PvtDataPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PvtDataPayload.Merge(m, src)
}
func (m *PvtDataPayload) XXX_Size() int {
	return xxx_messageInfo_PvtDataPayload.Size(m)
}
func (m *PvtDataPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_PvtDataPayload.DiscardUnknown(m)
}

var xxx_messageInfo_PvtDataPayload proto.InternalMessageInfo

func (m *PvtDataPayload) GetTxSeqInBlock() uint64 {
	if m != nil {
		return m.TxSeqInBlock
	}
	return 0
}

func (m *PvtDataPayload) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

type Acknowledgement struct {
	Error                string   `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Acknowledgement) Reset()         { *m = Acknowledgement{} }
func (m *Acknowledgement) String() string { return proto.CompactTextString(m) }
func (*Acknowledgement) ProtoMessage()    {}
func (*Acknowledgement) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{32}
}

func (m *Acknowledgement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Acknowledgement.Unmarshal(m, b)
}
func (m *Acknowledgement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Acknowledgement.Marshal(b, m, deterministic)
}
func (m *Acknowledgement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Acknowledgement.Merge(m, src)
}
func (m *Acknowledgement) XXX_Size() int {
	return xxx_messageInfo_Acknowledgement.Size(m)
}
func (m *Acknowledgement) XXX_DiscardUnknown() {
	xxx_messageInfo_Acknowledgement.DiscardUnknown(m)
}

var xxx_messageInfo_Acknowledgement proto.InternalMessageInfo

func (m *Acknowledgement) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// Chaincode represents a Chaincode that is installed
// on a peer
type Chaincode struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version              string   `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Metadata             []byte   `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Chaincode) Reset()         { *m = Chaincode{} }
func (m *Chaincode) String() string { return proto.CompactTextString(m) }
func (*Chaincode) ProtoMessage()    {}
func (*Chaincode) Descriptor() ([]byte, []int) {
	return fileDescriptor_24518b295636120e, []int{33}
}

func (m *Chaincode) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Chaincode.Unmarshal(m, b)
}
func (m *Chaincode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Chaincode.Marshal(b, m, deterministic)
}
func (m *Chaincode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Chaincode.Merge(m, src)
}
func (m *Chaincode) XXX_Size() int {
	return xxx_messageInfo_Chaincode.Size(m)
}
func (m *Chaincode) XXX_DiscardUnknown() {
	xxx_messageInfo_Chaincode.DiscardUnknown(m)
}

var xxx_messageInfo_Chaincode proto.InternalMessageInfo

func (m *Chaincode) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Chaincode) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Chaincode) GetMetadata() []byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func init() {
	proto.RegisterEnum("gossip.PullMsgType", PullMsgType_name, PullMsgType_value)
	proto.RegisterEnum("gossip.GossipMessage_Tag", GossipMessage_Tag_name, GossipMessage_Tag_value)
	proto.RegisterType((*Envelope)(nil), "gossip.Envelope")
	proto.RegisterType((*SecretEnvelope)(nil), "gossip.SecretEnvelope")
	proto.RegisterType((*Secret)(nil), "gossip.Secret")
	proto.RegisterType((*GossipMessage)(nil), "gossip.GossipMessage")
	proto.RegisterType((*StateInfo)(nil), "gossip.StateInfo")
	proto.RegisterType((*Properties)(nil), "gossip.Properties")
	proto.RegisterType((*StateInfoSnapshot)(nil), "gossip.StateInfoSnapshot")
	proto.RegisterType((*StateInfoPullRequest)(nil), "gossip.StateInfoPullRequest")
	proto.RegisterType((*ConnEstablish)(nil), "gossip.ConnEstablish")
	proto.RegisterType((*PeerIdentity)(nil), "gossip.PeerIdentity")
	proto.RegisterType((*DataRequest)(nil), "gossip.DataRequest")
	proto.RegisterType((*GossipHello)(nil), "gossip.GossipHello")
	proto.RegisterType((*DataUpdate)(nil), "gossip.DataUpdate")
	proto.RegisterType((*DataDigest)(nil), "gossip.DataDigest")
	proto.RegisterType((*DataMessage)(nil), "gossip.DataMessage")
	proto.RegisterType((*PrivateDataMessage)(nil), "gossip.PrivateDataMessage")
	proto.RegisterType((*Payload)(nil), "gossip.Payload")
	proto.RegisterType((*PrivatePayload)(nil), "gossip.PrivatePayload")
	proto.RegisterType((*AliveMessage)(nil), "gossip.AliveMessage")
	proto.RegisterType((*LeadershipMessage)(nil), "gossip.LeadershipMessage")
	proto.RegisterType((*PeerTime)(nil), "gossip.PeerTime")
	proto.RegisterType((*MembershipRequest)(nil), "gossip.MembershipRequest")
	proto.RegisterType((*MembershipResponse)(nil), "gossip.MembershipResponse")
	proto.RegisterType((*Member)(nil), "gossip.Member")
	proto.RegisterType((*Empty)(nil), "gossip.Empty")
	proto.RegisterType((*RemoteStateRequest)(nil), "gossip.RemoteStateRequest")
	proto.RegisterType((*RemoteStateResponse)(nil), "gossip.RemoteStateResponse")
	proto.RegisterType((*RemotePvtDataRequest)(nil), "gossip.RemotePvtDataRequest")
	proto.RegisterType((*PvtDataDigest)(nil), "gossip.PvtDataDigest")
	proto.RegisterType((*RemotePvtDataResponse)(nil), "gossip.RemotePvtDataResponse")
	proto.RegisterType((*PvtDataElement)(nil), "gossip.PvtDataElement")
	proto.RegisterType((*PvtDataPayload)(nil), "gossip.PvtDataPayload")
	proto.RegisterType((*Acknowledgement)(nil), "gossip.Acknowledgement")
	proto.RegisterType((*Chaincode)(nil), "gossip.Chaincode")
}

func init() { proto.RegisterFile("gossip/message.proto", fileDescriptor_24518b295636120e) }

var fileDescriptor_24518b295636120e = []byte{
	// 1895 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0x5b, 0x53, 0xe3, 0xc8,
	0x15, 0x46, 0xe0, 0xeb, 0xf1, 0x05, 0xd3, 0xc0, 0x8c, 0x96, 0xdd, 0xec, 0xb2, 0xca, 0x4e, 0x76,
	0x92, 0x99, 0x31, 0x13, 0x36, 0xb7, 0xaa, 0x4d, 0x32, 0x05, 0xb6, 0x17, 0xbb, 0x76, 0xec, 0x21,
	0x82, 0x49, 0x42, 0x5e, 0x54, 0x8d, 0xd4, 0xc8, 0x2a, 0xa4, 0x96, 0x50, 0x37, 0x2c, 0x54, 0xe5,
	0x25, 0x95, 0x87, 0xad, 0xca, 0x4b, 0x7e, 0x43, 0x9e, 0xf2, 0x37, 0x53, 0xdd, 0xad, 0xab, 0x0d,
	0x54, 0xcd, 0x54, 0xe5, 0xcd, 0xe7, 0xde, 0x7d, 0xfa, 0x9c, 0xef, 0x1c, 0x19, 0xb6, 0xdc, 0x90,
	0x31, 0x2f, 0xda, 0x0b, 0x08, 0x63, 0xd8, 0x25, 0xfd, 0x28, 0x0e, 0x79, 0x88, 0x6a, 0x8a, 0xbb,
	0xb3, 0x1d, 0x11, 0x12, 0xef, 0xd9, 0xa1, 0xef, 0x13, 0x9b, 0x7b, 0x21, 0x55, 0x62, 0xe3, 0x9f,
	0x1a, 0x34, 0x46, 0xf4, 0x86, 0xf8, 0x61, 0x44, 0x90, 0x0e, 0xf5, 0x08, 0xdf, 0xf9, 0x21, 0x76,
	0x74, 0x6d, 0x57, 0x7b, 0xde, 0x36, 0x53, 0x12, 0x7d, 0x06, 0x4d, 0xe6, 0xb9, 0x14, 0xf3, 0xeb,
	0x98, 0xe8, 0xab, 0x52, 0x96, 0x33, 0xd0, 0x1b, 0x58, 0x67, 0xc4, 0x8e, 0x09, 0xb7, 0x48, 0xe2,
	0x4a, 0x5f, 0xdb, 0xd5, 0x9e, 0xb7, 0xf6, 0x9f, 0xf4, 0x55, 0xf4, 0xfe, 0x89, 0x14, 0xa7, 0x81,
	0xcc, 0x2e, 0x2b, 0xd1, 0xc6, 0x18, 0xba, 0x65, 0x8d, 0x8f, 0x3d, 0x8a, 0x71, 0x00, 0x35, 0xe5,
	0x09, 0xbd, 0x84, 0x9e, 0x47, 0x39, 0x89, 0x29, 0xf6, 0x47, 0xd4, 0x89, 0x42, 0x8f, 0x72, 0xe9,
	0xaa, 0x39, 0x5e, 0x31, 0x97, 0x24, 0x87, 0x4d, 0xa8, 0xdb, 0x21, 0xe5, 0x84, 0x72, 0xe3, 0xc7,
	0x16, 0x74, 0x8e, 0xe4, 0xb1, 0xa7, 0x2a, 0x93, 0x68, 0x0b, 0xaa, 0x34, 0xa4, 0x36, 0x91, 0xf6,
	0x15, 0x53, 0x11, 0xe2, 0x88, 0xf6, 0x1c, 0x53, 0x4a, 0xfc, 0xe4, 0x18, 0x29, 0x89, 0x5e, 0xc0,
	0x1a, 0xc7, 0xae, 0xcc, 0x41, 0x77, 0xff, 0x93, 0x34, 0x07, 0x25, 0x9f, 0xfd, 0x53, 0xec, 0x9a,
	0x42, 0x0b, 0x7d, 0x03, 0x4d, 0xec, 0x7b, 0x37, 0xc4, 0x0a, 0x98, 0xab, 0x57, 0x65, 0xda, 0xb6,
	0x52, 0x93, 0x03, 0x21, 0x48, 0x2c, 0xc6, 0x2b, 0x66, 0x43, 0x2a, 0x4e, 0x99, 0x8b, 0x7e, 0x05,
	0xf5, 0x80, 0x04, 0x56, 0x4c, 0xae, 0xf4, 0x9a, 0x34, 0xc9, 0xa2, 0x4c, 0x49, 0x70, 0x4e, 0x62,
	0x36, 0xf7, 0x22, 0x93, 0x5c, 0x5d, 0x13, 0xc6, 0xc7, 0x2b, 0x66, 0x2d, 0x20, 0x81, 0x49, 0xae,
	0xd0, 0xaf, 0x53, 0x2b, 0xa6, 0xd7, 0xa5, 0xd5, 0xce, 0x7d, 0x56, 0x2c, 0x0a, 0x29, 0x23, 0x99,
	0x19, 0x43, 0xaf, 0xa1, 0xe1, 0x60, 0x8e, 0xe5, 0x01, 0x1b, 0xd2, 0x6e, 0x33, 0xb5, 0x1b, 0x62,
	0x8e, 0xf3, 0xf3, 0xd5, 0x85, 0x9a, 0x38, 0xde, 0x0b, 0xa8, 0xce, 0x89, 0xef, 0x87, 0x7a, 0xb3,
	0xac, 0xae, 0x52, 0x30, 0x16, 0xa2, 0xf1, 0x8a, 0xa9, 0x74, 0xd0, 0x5e, 0xe2, 0xde, 0xf1, 0x5c,
	0x1d, 0xa4, 0x3e, 0x2a, 0xba, 0x1f, 0x7a, 0xae, 0xba, 0x85, 0xf4, 0x3e, 0xf4, 0xdc, 0xec, 0x3c,
	0xe2, 0xf6, 0xad, 0xe5, 0xf3, 0xe4, 0xf7, 0x96, 0x16, 0xea, 0xe2, 0x2d, 0x69, 0x71, 0x1d, 0x39,
	0x98, 0x13, 0xbd, 0xbd, 0x1c, 0xe5, 0xbd, 0x94, 0x8c, 0x57, 0x4c, 0x70, 0x32, 0x0a, 0x3d, 0x83,
	0x2a, 0x09, 0x22, 0x7e, 0xa7, 0x77, 0xa4, 0x41, 0x27, 0x35, 0x18, 0x09, 0xa6, 0xb8, 0x80, 0x94,
	0xa2, 0x17, 0x50, 0xb1, 0x43, 0x4a, 0xf5, 0xae, 0xd4, 0xda, 0x4e, 0xb5, 0x06, 0x21, 0xa5, 0x23,
	0xc6, 0xf1, 0xb9, 0xef, 0xb1, 0xf9, 0x78, 0xc5, 0x94, 0x4a, 0x68, 0x1f, 0x80, 0x71, 0xcc, 0x89,
	0xe5, 0xd1, 0x8b, 0x50, 0x5f, 0x97, 0x26, 0x1b, 0x59, 0x9b, 0x08, 0xc9, 0x84, 0x5e, 0x88, 0xec,
	0x34, 0x59, 0x4a, 0xa0, 0x43, 0xe8, 0x2a, 0x1b, 0x46, 0x71, 0xc4, 0xe6, 0x21, 0xd7, 0x7b, 0xe5,
	0x47, 0xcf, 0xec, 0x4e, 0x12, 0x85, 0xf1, 0x8a, 0xd9, 0x91, 0x26, 0x29, 0x03, 0x4d, 0x61, 0x33,
	0x8f, 0x6b, 0x45, 0xd7, 0xbe, 0x2f, 0xf3, 0xb7, 0x21, 0x1d, 0x7d, 0xb6, 0xe4, 0xe8, 0xf8, 0xda,
	0xf7, 0xf3, 0x44, 0xf6, 0xd8, 0x02, 0x1f, 0x1d, 0x80, 0xf2, 0x2f, 0x9c, 0x08, 0x25, 0x1d, 0x95,
	0x0b, 0xca, 0x24, 0x41, 0xc8, 0x89, 0x74, 0x97, 0xbb, 0x69, 0xb3, 0x02, 0x8d, 0x86, 0xe9, 0xad,
	0xe2, 0xa4, 0xe4, 0xf4, 0x4d, 0xe9, 0xe3, 0xd3, 0x7b, 0x7d, 0x64, 0x55, 0xd9, 0x61, 0x45, 0x86,
	0xc8, 0x8d, 0x4f, 0xb0, 0xa3, 0x8a, 0x57, 0x96, 0xe8, 0x56, 0x39, 0x37, 0x6f, 0x33, 0x69, 0x5e,
	0xa8, 0x9d, 0xdc, 0x44, 0x94, 0xeb, 0xb7, 0xd0, 0x11, 0xe8, 0x68, 0x79, 0x0e, 0xa1, 0xdc, 0xe3,
	0x77, 0xfa, 0x76, 0xb9, 0x0d, 0x8f, 0x09, 0x89, 0x27, 0x89, 0x4c, 0x5c, 0x23, 0x2a, 0xd0, 0xa2,
	0xd9, 0xb1, 0x7d, 0xa9, 0x3f, 0x91, 0x26, 0x4f, 0xb3, 0xce, 0xb5, 0x2f, 0x69, 0xf8, 0x83, 0x4f,
	0x1c, 0x97, 0x04, 0x84, 0x8a, 0xcb, 0x0b, 0x2d, 0xf4, 0x47, 0x80, 0x28, 0xf6, 0x6e, 0x54, 0x16,
	0xf4, 0xa7, 0xe5, 0xe4, 0xab, 0xfb, 0x1e, 0xdf, 0xf0, 0x72, 0x15, 0x17, 0x2c, 0xd0, 0x9b, 0x82,
	0x3d, 0xd3, 0x75, 0x69, 0xff, 0x93, 0x07, 0xec, 0xb3, 0x8c, 0x15, 0x4c, 0xd0, 0x1b, 0x68, 0x27,
	0x94, 0x25, 0x0a, 0x5d, 0xff, 0xa4, 0xfc, 0x6c, 0xc7, 0x4a, 0x56, 0x6e, 0xeb, 0x56, 0x94, 0x73,
	0x0d, 0x0b, 0xd6, 0x4e, 0xb1, 0x8b, 0x3a, 0xd0, 0x7c, 0x3f, 0x1b, 0x8e, 0xbe, 0x9b, 0xcc, 0x46,
	0xc3, 0xde, 0x0a, 0x6a, 0x42, 0x75, 0x34, 0x3d, 0x3e, 0x3d, 0xeb, 0x69, 0xa8, 0x0d, 0x8d, 0x77,
	0xe6, 0x91, 0xf5, 0x6e, 0xf6, 0xf6, 0xac, 0xb7, 0x2a, 0xf4, 0x06, 0xe3, 0x83, 0x99, 0x22, 0xd7,
	0x50, 0x0f, 0xda, 0x92, 0x3c, 0x98, 0x0d, 0xad, 0x77, 0xe6, 0x51, 0xaf, 0x82, 0xd6, 0xa1, 0xa5,
	0x14, 0x4c, 0xc9, 0xa8, 0x16, 0x91, 0xf8, 0xbf, 0x1a, 0x34, 0xb3, 0x8a, 0x44, 0x7d, 0x68, 0x72,
	0x2f, 0x20, 0x8c, 0xe3, 0x20, 0x92, 0x88, 0xdb, 0xda, 0xef, 0x15, 0x5f, 0xe8, 0xd4, 0x0b, 0x88,
	0x99, 0xab, 0xa0, 0x6d, 0xa8, 0x45, 0x97, 0x9e, 0xe5, 0x39, 0x12, 0x88, 0xdb, 0x66, 0x35, 0xba,
	0xf4, 0x26, 0x0e, 0xfa, 0x02, 0x5a, 0x09, 0x4e, 0x5b, 0xd3, 0x83, 0x81, 0x5e, 0x91, 0x32, 0x48,
	0x58, 0xd3, 0x83, 0x81, 0xe8, 0xd0, 0x28, 0x0e, 0x23, 0x12, 0x73, 0x8f, 0xb0, 0x04, 0x91, 0x51,
	0x9e, 0xa0, 0x54, 0x62, 0x16, 0xb4, 0x8c, 0x1f, 0x35, 0x80, 0x5c, 0x84, 0x7e, 0x0a, 0x1d, 0xf9,
	0xf4, 0xb1, 0x35, 0x27, 0x9e, 0x3b, 0xe7, 0xc9, 0xe0, 0x68, 0x2b, 0xe6, 0x58, 0xf2, 0xd0, 0x97,
	0xd0, 0xf6, 0xc9, 0x05, 0xb7, 0x8a, 0x43, 0xa4, 0x61, 0xb6, 0x04, 0x6f, 0x90, 0x0c, 0x92, 0x5f,
	0x82, 0x38, 0x98, 0x47, 0xed, 0xd0, 0x21, 0x4c, 0x5f, 0xdb, 0x5d, 0x2b, 0x82, 0xc5, 0x20, 0x95,
	0x98, 0x05, 0x25, 0xe3, 0x00, 0x36, 0x96, 0xd0, 0x00, 0xbd, 0x84, 0x06, 0xf1, 0x65, 0x21, 0x32,
	0x5d, 0x93, 0x5e, 0xb2, 0xcc, 0x65, 0x33, 0x39, 0xd3, 0x30, 0x7e, 0x0b, 0x5b, 0xf7, 0xe1, 0xc0,
	0x62, 0xe6, 0xb4, 0xc5, 0xcc, 0x19, 0x7f, 0x87, 0x4e, 0x09, 0xf4, 0x0a, 0x4f, 0xa0, 0x15, 0x9f,
	0x60, 0x07, 0x1a, 0x59, 0xab, 0xa9, 0xd1, 0x99, 0xd1, 0xc8, 0x80, 0x0e, 0xf7, 0x99, 0x65, 0x93,
	0x98, 0x5b, 0x73, 0xcc, 0xe6, 0xc9, 0xe3, 0xb5, 0xb8, 0xcf, 0x06, 0x24, 0xe6, 0x63, 0xcc, 0xe6,
	0x62, 0x1e, 0x47, 0x71, 0x78, 0x4e, 0xe4, 0xe3, 0x35, 0x4c, 0x45, 0x18, 0xef, 0xa1, 0x5d, 0x6c,
	0xd4, 0x87, 0x82, 0x23, 0xa8, 0x08, 0xe7, 0x49, 0x60, 0xf9, 0x5b, 0x1c, 0x28, 0x20, 0x1c, 0xcb,
	0x8e, 0x50, 0xf1, 0x32, 0xda, 0x08, 0xa0, 0x55, 0xe8, 0xc7, 0x87, 0x77, 0x01, 0x47, 0xce, 0x29,
	0xa6, 0xaf, 0xee, 0xae, 0x89, 0x5d, 0x20, 0x21, 0x51, 0x1f, 0x1a, 0x01, 0x73, 0x2d, 0x7e, 0x97,
	0x2c, 0x45, 0xdd, 0x7c, 0x58, 0x89, 0xdc, 0x4e, 0x99, 0x7b, 0x7a, 0x17, 0x11, 0xb3, 0x1e, 0xa8,
	0x1f, 0x46, 0x08, 0xad, 0xc2, 0x94, 0x7c, 0x20, 0x5c, 0xf1, 0xbc, 0xab, 0xe5, 0xf3, 0x7e, 0x70,
	0xc0, 0x5b, 0x80, 0x7c, 0x00, 0x3e, 0x10, 0xef, 0x2b, 0xa8, 0x24, 0xb1, 0xee, 0xaf, 0x9d, 0xca,
	0x47, 0x45, 0xf6, 0x55, 0x64, 0x35, 0xe0, 0xff, 0xef, 0x89, 0xfd, 0x9d, 0x7a, 0xc7, 0x74, 0xa7,
	0xfb, 0x79, 0x79, 0xc1, 0x6c, 0xed, 0xaf, 0x67, 0xd6, 0x8a, 0x9d, 0x6d, 0x9c, 0xc6, 0x77, 0x80,
	0x96, 0x71, 0x11, 0xbd, 0x5e, 0x74, 0xf0, 0x64, 0x01, 0x44, 0x97, 0xfc, 0x9c, 0x41, 0x3d, 0xe1,
	0xa1, 0xa7, 0x50, 0x67, 0xe4, 0xca, 0xa2, 0xd7, 0x41, 0x72, 0xdd, 0x1a, 0x23, 0x57, 0xb3, 0xeb,
	0x40, 0x54, 0x67, 0xe1, 0x55, 0x55, 0x5e, 0xbf, 0x5c, 0xc0, 0xec, 0x35, 0x99, 0x88, 0x12, 0x2a,
	0xff, 0x7b, 0x15, 0xba, 0xe5, 0xb0, 0xe8, 0x6b, 0x58, 0xcf, 0xb7, 0x7d, 0x8b, 0xe2, 0x40, 0x65,
	0xb6, 0x69, 0x76, 0x73, 0xf6, 0x0c, 0x07, 0x44, 0x2c, 0xd4, 0x42, 0xca, 0x22, 0x6c, 0xab, 0x85,
	0xba, 0x69, 0xe6, 0x0c, 0xb4, 0x09, 0x55, 0x7e, 0x9b, 0x82, 0x68, 0xd3, 0xac, 0xf0, 0xdb, 0x89,
	0x23, 0xf0, 0x2d, 0x3d, 0x51, 0xfc, 0x03, 0x23, 0x3c, 0x41, 0xd1, 0xf4, 0x98, 0xa6, 0xe0, 0xa1,
	0x97, 0x80, 0x52, 0x25, 0xe6, 0x05, 0x29, 0x12, 0x56, 0xe5, 0x75, 0x7b, 0x89, 0xe4, 0xc4, 0x0b,
	0x12, 0x34, 0x9c, 0x01, 0x2a, 0x1c, 0xd7, 0x0e, 0xe9, 0x85, 0xe7, 0xb2, 0x64, 0xb9, 0xfd, 0x42,
	0x7d, 0xac, 0xb0, 0xfe, 0x20, 0xd3, 0x18, 0x48, 0x85, 0x63, 0x6c, 0x5f, 0x62, 0x97, 0x98, 0x1b,
	0xf6, 0x82, 0x80, 0x19, 0xff, 0xd2, 0xa0, 0x5d, 0x5c, 0x9f, 0x51, 0x1f, 0x20, 0xc8, 0xb6, 0xdc,
	0xe4, 0xc9, 0xba, 0xe5, 0xfd, 0xd7, 0x2c, 0x68, 0x7c, 0xf0, 0xb8, 0x29, 0x82, 0x5a, 0xa5, 0x0c,
	0x6a, 0xc6, 0x3f, 0x34, 0xd8, 0x58, 0xda, 0x43, 0x1e, 0x02, 0xa8, 0x0f, 0x0d, 0xfc, 0x0c, 0xba,
	0x1e, 0xb3, 0x1c, 0x62, 0xfb, 0x38, 0xc6, 0x22, 0x05, 0xf2, 0xa9, 0x1a, 0x66, 0xc7, 0x63, 0xc3,
	0x9c, 0x69, 0xfc, 0x1e, 0x1a, 0xa9, 0xb5, 0x28, 0x3f, 0x8f, 0xda, 0xc5, 0xf2, 0xf3, 0xa8, 0x2d,
	0xca, 0xaf, 0x50, 0x97, 0xab, 0xc5, 0xba, 0x34, 0x2e, 0x60, 0x63, 0xe9, 0xcb, 0x02, 0x7d, 0x0b,
	0x3d, 0x46, 0xfc, 0x0b, 0xb9, 0x52, 0xc6, 0x81, 0x8a, 0xad, 0x95, 0x0f, 0x9c, 0x41, 0xc4, 0xba,
	0xd0, 0x9c, 0xe4, 0x8a, 0xa2, 0xdf, 0xc5, 0x8a, 0x44, 0x93, 0xbe, 0x56, 0x84, 0x71, 0x0e, 0x68,
	0xf9, 0x5b, 0x04, 0xfd, 0x0c, 0xaa, 0xf2, 0xd3, 0xe7, 0xc1, 0xe1, 0xa5, 0xc4, 0x12, 0xa7, 0x08,
	0x76, 0x1e, 0xc1, 0x29, 0x82, 0x1d, 0xe3, 0x2f, 0x50, 0x53, 0x31, 0xc4, 0x9b, 0x91, 0xd2, 0xb7,
	0xa1, 0x99, 0xd1, 0x8f, 0x62, 0xec, 0xfd, 0xab, 0x85, 0x51, 0x87, 0xaa, 0xfc, 0x34, 0x30, 0xfe,
	0x0a, 0x68, 0x79, 0x01, 0x16, 0xa3, 0x8d, 0x71, 0x1c, 0x73, 0xab, 0xdc, 0xfa, 0x2d, 0xc9, 0x3c,
	0x51, 0xfd, 0xff, 0x39, 0xb4, 0x08, 0x75, 0xac, 0xf2, 0x23, 0x34, 0x09, 0x75, 0x94, 0xdc, 0x38,
	0x84, 0xcd, 0x7b, 0xd6, 0x62, 0xf4, 0x02, 0x1a, 0x09, 0xca, 0xa4, 0x03, 0x7e, 0x09, 0xce, 0x32,
	0x05, 0xe3, 0x08, 0xb6, 0xee, 0x5b, 0x35, 0xd1, 0x5e, 0x8e, 0xb5, 0xca, 0x47, 0xf6, 0x29, 0x93,
	0x28, 0x2a, 0xa4, 0xce, 0x20, 0xd8, 0xf8, 0x8f, 0x06, 0x9d, 0x92, 0x28, 0x47, 0x0b, 0xad, 0x80,
	0x16, 0x8f, 0x03, 0xcc, 0xe7, 0x00, 0x79, 0xf7, 0x26, 0x28, 0x53, 0xe0, 0xa0, 0x4f, 0xa1, 0x79,
	0xee, 0x87, 0xf6, 0xa5, 0xc8, 0x89, 0x6c, 0xac, 0x8a, 0xd9, 0x90, 0x8c, 0x13, 0x72, 0x85, 0x76,
	0xa1, 0x2d, 0x52, 0xe5, 0x51, 0x4b, 0xb2, 0x12, 0x74, 0x01, 0x46, 0xae, 0x26, 0xf4, 0x50, 0x70,
	0x8c, 0xef, 0x61, 0xfb, 0xde, 0xbd, 0x18, 0xed, 0x2f, 0xed, 0x44, 0x4f, 0x16, 0xae, 0x3b, 0x52,
	0xe2, 0xc2, 0x66, 0x74, 0x06, 0xdd, 0xb2, 0x0c, 0xbd, 0x82, 0x9a, 0xca, 0x46, 0x52, 0xf8, 0x0f,
	0xa4, 0x2c, 0x51, 0x2a, 0xfe, 0xad, 0x91, 0x8c, 0xb3, 0x74, 0x38, 0xfc, 0x29, 0x73, 0x9d, 0x02,
	0xf8, 0x33, 0x58, 0xe7, 0xb7, 0x56, 0xe9, 0x7a, 0xc9, 0x1a, 0xc9, 0x6f, 0x4f, 0xb2, 0x0b, 0x96,
	0x5d, 0x16, 0xff, 0x29, 0x31, 0xbe, 0x86, 0xf5, 0x85, 0xcf, 0x10, 0xd1, 0x74, 0x24, 0x8e, 0xc3,
	0x38, 0x79, 0x1f, 0x45, 0x18, 0xef, 0xa1, 0x99, 0x2d, 0x93, 0x62, 0x02, 0x15, 0x86, 0x85, 0xfc,
	0x2d, 0x62, 0xdc, 0x90, 0x98, 0x89, 0x07, 0x52, 0xef, 0x97, 0x92, 0x8f, 0x6d, 0x4e, 0xbf, 0xf8,
	0x03, 0xb4, 0x0a, 0x93, 0x78, 0xf1, 0x93, 0xa1, 0x03, 0xcd, 0xc3, 0xb7, 0xef, 0x06, 0xdf, 0x5b,
	0xd3, 0x93, 0xa3, 0x9e, 0x26, 0xbe, 0x0c, 0x26, 0xc3, 0xd1, 0xec, 0x74, 0x72, 0x7a, 0x26, 0x39,
	0xab, 0xfb, 0x17, 0x50, 0x53, 0x9b, 0x10, 0xfa, 0x0d, 0xb4, 0xd5, 0xaf, 0x13, 0x1e, 0x13, 0x1c,
	0xa0, 0xa5, 0xc6, 0xde, 0x59, 0xe2, 0x3c, 0xd7, 0x5e, 0x6b, 0x02, 0x0e, 0x8e, 0x3d, 0xea, 0xa2,
	0xf2, 0x87, 0xfb, 0x4e, 0x99, 0x3c, 0xfc, 0x33, 0x7c, 0x15, 0xc6, 0x6e, 0x7f, 0x7e, 0x17, 0x91,
	0x58, 0x2d, 0xe8, 0xfd, 0x0b, 0x7c, 0x1e, 0x7b, 0x76, 0x3a, 0x75, 0x94, 0xf6, 0xdf, 0xfa, 0xae,
	0xc7, 0xe7, 0xd7, 0xe7, 0x7d, 0x3b, 0x0c, 0xf6, 0x0a, 0xca, 0x7b, 0x4a, 0xf9, 0x95, 0x52, 0x7e,
	0xe5, 0x86, 0x7b, 0x4a, 0xff, 0xbc, 0x26, 0x39, 0xdf, 0xfc, 0x2f, 0x00, 0x00, 0xff, 0xff, 0xa6,
	0xdd, 0x37, 0x76, 0x98, 0x13, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// GossipClient is the client API for Gossip service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GossipClient interface {
	// GossipStream is the gRPC stream used for sending and receiving messages
	GossipStream(ctx context.Context, opts ...grpc.CallOption) (Gossip_GossipStreamClient, error)
	// Ping is used to probe a remote peer's aliveness
	Ping(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error)
}

type gossipClient struct {
	cc *grpc.ClientConn
}

func NewGossipClient(cc *grpc.ClientConn) GossipClient {
	return &gossipClient{cc}
}

func (c *gossipClient) GossipStream(ctx context.Context, opts ...grpc.CallOption) (Gossip_GossipStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Gossip_serviceDesc.Streams[0], "/gossip.Gossip/GossipStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &gossipGossipStreamClient{stream}
	return x, nil
}

type Gossip_GossipStreamClient interface {
	Send(*Envelope) error
	Recv() (*Envelope, error)
	grpc.ClientStream
}

type gossipGossipStreamClient struct {
	grpc.ClientStream
}

func (x *gossipGossipStreamClient) Send(m *Envelope) error {
	return x.ClientStream.SendMsg(m)
}

func (x *gossipGossipStreamClient) Recv() (*Envelope, error) {
	m := new(Envelope)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *gossipClient) Ping(ctx context.Context, in *Empty, opts ...grpc.CallOption) (*Empty, error) {
	out := new(Empty)
	err := c.cc.Invoke(ctx, "/gossip.Gossip/Ping", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GossipServer is the server API for Gossip service.
type GossipServer interface {
	// GossipStream is the gRPC stream used for sending and receiving messages
	GossipStream(Gossip_GossipStreamServer) error
	// Ping is used to probe a remote peer's aliveness
	Ping(context.Context, *Empty) (*Empty, error)
}

// UnimplementedGossipServer can be embedded to have forward compatible implementations.
type UnimplementedGossipServer struct {
}

func (*UnimplementedGossipServer) GossipStream(srv Gossip_GossipStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method GossipStream not implemented")
}
func (*UnimplementedGossipServer) Ping(ctx context.Context, req *Empty) (*Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Ping not implemented")
}

func RegisterGossipServer(s *grpc.Server, srv GossipServer) {
	s.RegisterService(&_Gossip_serviceDesc, srv)
}

func _Gossip_GossipStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(GossipServer).GossipStream(&gossipGossipStreamServer{stream})
}

type Gossip_GossipStreamServer interface {
	Send(*Envelope) error
	Recv() (*Envelope, error)
	grpc.ServerStream
}

type gossipGossipStreamServer struct {
	grpc.ServerStream
}

func (x *gossipGossipStreamServer) Send(m *Envelope) error {
	return x.ServerStream.SendMsg(m)
}

func (x *gossipGossipStreamServer) Recv() (*Envelope, error) {
	m := new(Envelope)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Gossip_Ping_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GossipServer).Ping(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/gossip.Gossip/Ping",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GossipServer).Ping(ctx, req.(*Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _Gossip_serviceDesc = grpc.ServiceDesc{
	ServiceName: "gossip.Gossip",
	HandlerType: (*GossipServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Ping",
			Handler:    _Gossip_Ping_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GossipStream",
			Handler:       _Gossip_GossipStream_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "gossip/message.proto",
}
