// Code generated by protoc-gen-go. DO NOT EDIT.
// source: peer/chaincode_shim.proto

package peer

import (
	context "context"
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type ChaincodeMessage_Type int32

const (
	ChaincodeMessage_UNDEFINED             ChaincodeMessage_Type = 0
	ChaincodeMessage_REGISTER              ChaincodeMessage_Type = 1
	ChaincodeMessage_REGISTERED            ChaincodeMessage_Type = 2
	ChaincodeMessage_INIT                  ChaincodeMessage_Type = 3
	ChaincodeMessage_READY                 ChaincodeMessage_Type = 4
	ChaincodeMessage_TRANSACTION           ChaincodeMessage_Type = 5
	ChaincodeMessage_COMPLETED             ChaincodeMessage_Type = 6
	ChaincodeMessage_ERROR                 ChaincodeMessage_Type = 7
	ChaincodeMessage_GET_STATE             ChaincodeMessage_Type = 8
	ChaincodeMessage_PUT_STATE             ChaincodeMessage_Type = 9
	ChaincodeMessage_DEL_STATE             ChaincodeMessage_Type = 10
	ChaincodeMessage_INVOKE_CHAINCODE      ChaincodeMessage_Type = 11
	ChaincodeMessage_RESPONSE              ChaincodeMessage_Type = 13
	ChaincodeMessage_GET_STATE_BY_RANGE    ChaincodeMessage_Type = 14
	ChaincodeMessage_GET_QUERY_RESULT      ChaincodeMessage_Type = 15
	ChaincodeMessage_QUERY_STATE_NEXT      ChaincodeMessage_Type = 16
	ChaincodeMessage_QUERY_STATE_CLOSE     ChaincodeMessage_Type = 17
	ChaincodeMessage_KEEPALIVE             ChaincodeMessage_Type = 18
	ChaincodeMessage_GET_HISTORY_FOR_KEY   ChaincodeMessage_Type = 19
	ChaincodeMessage_GET_STATE_METADATA    ChaincodeMessage_Type = 20
	ChaincodeMessage_PUT_STATE_METADATA    ChaincodeMessage_Type = 21
	ChaincodeMessage_GET_PRIVATE_DATA_HASH ChaincodeMessage_Type = 22
)

var ChaincodeMessage_Type_name = map[int32]string{
	0:  "UNDEFINED",
	1:  "REGISTER",
	2:  "REGISTERED",
	3:  "INIT",
	4:  "READY",
	5:  "TRANSACTION",
	6:  "COMPLETED",
	7:  "ERROR",
	8:  "GET_STATE",
	9:  "PUT_STATE",
	10: "DEL_STATE",
	11: "INVOKE_CHAINCODE",
	13: "RESPONSE",
	14: "GET_STATE_BY_RANGE",
	15: "GET_QUERY_RESULT",
	16: "QUERY_STATE_NEXT",
	17: "QUERY_STATE_CLOSE",
	18: "KEEPALIVE",
	19: "GET_HISTORY_FOR_KEY",
	20: "GET_STATE_METADATA",
	21: "PUT_STATE_METADATA",
	22: "GET_PRIVATE_DATA_HASH",
}

var ChaincodeMessage_Type_value = map[string]int32{
	"UNDEFINED":             0,
	"REGISTER":              1,
	"REGISTERED":            2,
	"INIT":                  3,
	"READY":                 4,
	"TRANSACTION":           5,
	"COMPLETED":             6,
	"ERROR":                 7,
	"GET_STATE":             8,
	"PUT_STATE":             9,
	"DEL_STATE":             10,
	"INVOKE_CHAINCODE":      11,
	"RESPONSE":              13,
	"GET_STATE_BY_RANGE":    14,
	"GET_QUERY_RESULT":      15,
	"QUERY_STATE_NEXT":      16,
	"QUERY_STATE_CLOSE":     17,
	"KEEPALIVE":             18,
	"GET_HISTORY_FOR_KEY":   19,
	"GET_STATE_METADATA":    20,
	"PUT_STATE_METADATA":    21,
	"GET_PRIVATE_DATA_HASH": 22,
}

func (x ChaincodeMessage_Type) String() string {
	return proto.EnumName(ChaincodeMessage_Type_name, int32(x))
}

func (ChaincodeMessage_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{0, 0}
}

type ChaincodeMessage struct {
	Type      ChaincodeMessage_Type `protobuf:"varint,1,opt,name=type,proto3,enum=protos.ChaincodeMessage_Type" json:"type,omitempty"`
	Timestamp *timestamp.Timestamp  `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Payload   []byte                `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	Txid      string                `protobuf:"bytes,4,opt,name=txid,proto3" json:"txid,omitempty"`
	Proposal  *SignedProposal       `protobuf:"bytes,5,opt,name=proposal,proto3" json:"proposal,omitempty"`
	//event emitted by chaincode. Used only with Init or Invoke.
	// This event is then stored (currently)
	//with Block.NonHashData.TransactionResult
	ChaincodeEvent *ChaincodeEvent `protobuf:"bytes,6,opt,name=chaincode_event,json=chaincodeEvent,proto3" json:"chaincode_event,omitempty"`
	//channel id
	ChannelId            string   `protobuf:"bytes,7,opt,name=channel_id,json=channelId,proto3" json:"channel_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ChaincodeMessage) Reset()         { *m = ChaincodeMessage{} }
func (m *ChaincodeMessage) String() string { return proto.CompactTextString(m) }
func (*ChaincodeMessage) ProtoMessage()    {}
func (*ChaincodeMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{0}
}

func (m *ChaincodeMessage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ChaincodeMessage.Unmarshal(m, b)
}
func (m *ChaincodeMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ChaincodeMessage.Marshal(b, m, deterministic)
}
func (m *ChaincodeMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ChaincodeMessage.Merge(m, src)
}
func (m *ChaincodeMessage) XXX_Size() int {
	return xxx_messageInfo_ChaincodeMessage.Size(m)
}
func (m *ChaincodeMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_ChaincodeMessage.DiscardUnknown(m)
}

var xxx_messageInfo_ChaincodeMessage proto.InternalMessageInfo

func (m *ChaincodeMessage) GetType() ChaincodeMessage_Type {
	if m != nil {
		return m.Type
	}
	return ChaincodeMessage_UNDEFINED
}

func (m *ChaincodeMessage) GetTimestamp() *timestamp.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *ChaincodeMessage) GetPayload() []byte {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *ChaincodeMessage) GetTxid() string {
	if m != nil {
		return m.Txid
	}
	return ""
}

func (m *ChaincodeMessage) GetProposal() *SignedProposal {
	if m != nil {
		return m.Proposal
	}
	return nil
}

func (m *ChaincodeMessage) GetChaincodeEvent() *ChaincodeEvent {
	if m != nil {
		return m.ChaincodeEvent
	}
	return nil
}

func (m *ChaincodeMessage) GetChannelId() string {
	if m != nil {
		return m.ChannelId
	}
	return ""
}

// GetState is the payload of a ChaincodeMessage. It contains a key which
// is to be fetched from the ledger. If the collection is specified, the key
// would be fetched from the collection (i.e., private state)
type GetState struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Collection           string   `protobuf:"bytes,2,opt,name=collection,proto3" json:"collection,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetState) Reset()         { *m = GetState{} }
func (m *GetState) String() string { return proto.CompactTextString(m) }
func (*GetState) ProtoMessage()    {}
func (*GetState) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{1}
}

func (m *GetState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetState.Unmarshal(m, b)
}
func (m *GetState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetState.Marshal(b, m, deterministic)
}
func (m *GetState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetState.Merge(m, src)
}
func (m *GetState) XXX_Size() int {
	return xxx_messageInfo_GetState.Size(m)
}
func (m *GetState) XXX_DiscardUnknown() {
	xxx_messageInfo_GetState.DiscardUnknown(m)
}

var xxx_messageInfo_GetState proto.InternalMessageInfo

func (m *GetState) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *GetState) GetCollection() string {
	if m != nil {
		return m.Collection
	}
	return ""
}

type GetStateMetadata struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Collection           string   `protobuf:"bytes,2,opt,name=collection,proto3" json:"collection,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetStateMetadata) Reset()         { *m = GetStateMetadata{} }
func (m *GetStateMetadata) String() string { return proto.CompactTextString(m) }
func (*GetStateMetadata) ProtoMessage()    {}
func (*GetStateMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{2}
}

func (m *GetStateMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetStateMetadata.Unmarshal(m, b)
}
func (m *GetStateMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetStateMetadata.Marshal(b, m, deterministic)
}
func (m *GetStateMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetStateMetadata.Merge(m, src)
}
func (m *GetStateMetadata) XXX_Size() int {
	return xxx_messageInfo_GetStateMetadata.Size(m)
}
func (m *GetStateMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_GetStateMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_GetStateMetadata proto.InternalMessageInfo

func (m *GetStateMetadata) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *GetStateMetadata) GetCollection() string {
	if m != nil {
		return m.Collection
	}
	return ""
}

// PutState is the payload of a ChaincodeMessage. It contains a key and value
// which needs to be written to the transaction's write set. If the collection is
// specified, the key and value would be written to the transaction's private
// write set.
type PutState struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value                []byte   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	Collection           string   `protobuf:"bytes,3,opt,name=collection,proto3" json:"collection,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PutState) Reset()         { *m = PutState{} }
func (m *PutState) String() string { return proto.CompactTextString(m) }
func (*PutState) ProtoMessage()    {}
func (*PutState) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{3}
}

func (m *PutState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PutState.Unmarshal(m, b)
}
func (m *PutState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PutState.Marshal(b, m, deterministic)
}
func (m *PutState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PutState.Merge(m, src)
}
func (m *PutState) XXX_Size() int {
	return xxx_messageInfo_PutState.Size(m)
}
func (m *PutState) XXX_DiscardUnknown() {
	xxx_messageInfo_PutState.DiscardUnknown(m)
}

var xxx_messageInfo_PutState proto.InternalMessageInfo

func (m *PutState) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *PutState) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *PutState) GetCollection() string {
	if m != nil {
		return m.Collection
	}
	return ""
}

type PutStateMetadata struct {
	Key                  string         `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Collection           string         `protobuf:"bytes,3,opt,name=collection,proto3" json:"collection,omitempty"`
	Metadata             *StateMetadata `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *PutStateMetadata) Reset()         { *m = PutStateMetadata{} }
func (m *PutStateMetadata) String() string { return proto.CompactTextString(m) }
func (*PutStateMetadata) ProtoMessage()    {}
func (*PutStateMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{4}
}

func (m *PutStateMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PutStateMetadata.Unmarshal(m, b)
}
func (m *PutStateMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PutStateMetadata.Marshal(b, m, deterministic)
}
func (m *PutStateMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PutStateMetadata.Merge(m, src)
}
func (m *PutStateMetadata) XXX_Size() int {
	return xxx_messageInfo_PutStateMetadata.Size(m)
}
func (m *PutStateMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_PutStateMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_PutStateMetadata proto.InternalMessageInfo

func (m *PutStateMetadata) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *PutStateMetadata) GetCollection() string {
	if m != nil {
		return m.Collection
	}
	return ""
}

func (m *PutStateMetadata) GetMetadata() *StateMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// DelState is the payload of a ChaincodeMessage. It contains a key which
// needs to be recorded in the transaction's write set as a delete operation.
// If the collection is specified, the key needs to be recorded in the
// transaction's private write set as a delete operation.
type DelState struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Collection           string   `protobuf:"bytes,2,opt,name=collection,proto3" json:"collection,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DelState) Reset()         { *m = DelState{} }
func (m *DelState) String() string { return proto.CompactTextString(m) }
func (*DelState) ProtoMessage()    {}
func (*DelState) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{5}
}

func (m *DelState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DelState.Unmarshal(m, b)
}
func (m *DelState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DelState.Marshal(b, m, deterministic)
}
func (m *DelState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DelState.Merge(m, src)
}
func (m *DelState) XXX_Size() int {
	return xxx_messageInfo_DelState.Size(m)
}
func (m *DelState) XXX_DiscardUnknown() {
	xxx_messageInfo_DelState.DiscardUnknown(m)
}

var xxx_messageInfo_DelState proto.InternalMessageInfo

func (m *DelState) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *DelState) GetCollection() string {
	if m != nil {
		return m.Collection
	}
	return ""
}

// GetStateByRange is the payload of a ChaincodeMessage. It contains a start key and
// a end key required to execute range query. If the collection is specified,
// the range query needs to be executed on the private data. The metadata hold
// the byte representation of QueryMetadata.
type GetStateByRange struct {
	StartKey             string   `protobuf:"bytes,1,opt,name=startKey,proto3" json:"startKey,omitempty"`
	EndKey               string   `protobuf:"bytes,2,opt,name=endKey,proto3" json:"endKey,omitempty"`
	Collection           string   `protobuf:"bytes,3,opt,name=collection,proto3" json:"collection,omitempty"`
	Metadata             []byte   `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetStateByRange) Reset()         { *m = GetStateByRange{} }
func (m *GetStateByRange) String() string { return proto.CompactTextString(m) }
func (*GetStateByRange) ProtoMessage()    {}
func (*GetStateByRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{6}
}

func (m *GetStateByRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetStateByRange.Unmarshal(m, b)
}
func (m *GetStateByRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetStateByRange.Marshal(b, m, deterministic)
}
func (m *GetStateByRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetStateByRange.Merge(m, src)
}
func (m *GetStateByRange) XXX_Size() int {
	return xxx_messageInfo_GetStateByRange.Size(m)
}
func (m *GetStateByRange) XXX_DiscardUnknown() {
	xxx_messageInfo_GetStateByRange.DiscardUnknown(m)
}

var xxx_messageInfo_GetStateByRange proto.InternalMessageInfo

func (m *GetStateByRange) GetStartKey() string {
	if m != nil {
		return m.StartKey
	}
	return ""
}

func (m *GetStateByRange) GetEndKey() string {
	if m != nil {
		return m.EndKey
	}
	return ""
}

func (m *GetStateByRange) GetCollection() string {
	if m != nil {
		return m.Collection
	}
	return ""
}

func (m *GetStateByRange) GetMetadata() []byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// GetQueryResult is the payload of a ChaincodeMessage. It contains a query
// string in the form that is supported by the underlying state database.
// If the collection is specified, the query needs to be executed on the
// private data.  The metadata hold the byte representation of QueryMetadata.
type GetQueryResult struct {
	Query                string   `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	Collection           string   `protobuf:"bytes,2,opt,name=collection,proto3" json:"collection,omitempty"`
	Metadata             []byte   `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetQueryResult) Reset()         { *m = GetQueryResult{} }
func (m *GetQueryResult) String() string { return proto.CompactTextString(m) }
func (*GetQueryResult) ProtoMessage()    {}
func (*GetQueryResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{7}
}

func (m *GetQueryResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetQueryResult.Unmarshal(m, b)
}
func (m *GetQueryResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetQueryResult.Marshal(b, m, deterministic)
}
func (m *GetQueryResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetQueryResult.Merge(m, src)
}
func (m *GetQueryResult) XXX_Size() int {
	return xxx_messageInfo_GetQueryResult.Size(m)
}
func (m *GetQueryResult) XXX_DiscardUnknown() {
	xxx_messageInfo_GetQueryResult.DiscardUnknown(m)
}

var xxx_messageInfo_GetQueryResult proto.InternalMessageInfo

func (m *GetQueryResult) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *GetQueryResult) GetCollection() string {
	if m != nil {
		return m.Collection
	}
	return ""
}

func (m *GetQueryResult) GetMetadata() []byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// QueryMetadata is the metadata of a GetStateByRange and GetQueryResult.
// It contains a pageSize which denotes the number of records to be fetched
// and a bookmark.
type QueryMetadata struct {
	PageSize             int32    `protobuf:"varint,1,opt,name=pageSize,proto3" json:"pageSize,omitempty"`
	Bookmark             string   `protobuf:"bytes,2,opt,name=bookmark,proto3" json:"bookmark,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryMetadata) Reset()         { *m = QueryMetadata{} }
func (m *QueryMetadata) String() string { return proto.CompactTextString(m) }
func (*QueryMetadata) ProtoMessage()    {}
func (*QueryMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{8}
}

func (m *QueryMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryMetadata.Unmarshal(m, b)
}
func (m *QueryMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryMetadata.Marshal(b, m, deterministic)
}
func (m *QueryMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryMetadata.Merge(m, src)
}
func (m *QueryMetadata) XXX_Size() int {
	return xxx_messageInfo_QueryMetadata.Size(m)
}
func (m *QueryMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_QueryMetadata proto.InternalMessageInfo

func (m *QueryMetadata) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *QueryMetadata) GetBookmark() string {
	if m != nil {
		return m.Bookmark
	}
	return ""
}

// GetHistoryForKey is the payload of a ChaincodeMessage. It contains a key
// for which the historical values need to be retrieved.
type GetHistoryForKey struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetHistoryForKey) Reset()         { *m = GetHistoryForKey{} }
func (m *GetHistoryForKey) String() string { return proto.CompactTextString(m) }
func (*GetHistoryForKey) ProtoMessage()    {}
func (*GetHistoryForKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{9}
}

func (m *GetHistoryForKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetHistoryForKey.Unmarshal(m, b)
}
func (m *GetHistoryForKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetHistoryForKey.Marshal(b, m, deterministic)
}
func (m *GetHistoryForKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetHistoryForKey.Merge(m, src)
}
func (m *GetHistoryForKey) XXX_Size() int {
	return xxx_messageInfo_GetHistoryForKey.Size(m)
}
func (m *GetHistoryForKey) XXX_DiscardUnknown() {
	xxx_messageInfo_GetHistoryForKey.DiscardUnknown(m)
}

var xxx_messageInfo_GetHistoryForKey proto.InternalMessageInfo

func (m *GetHistoryForKey) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

type QueryStateNext struct {
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryStateNext) Reset()         { *m = QueryStateNext{} }
func (m *QueryStateNext) String() string { return proto.CompactTextString(m) }
func (*QueryStateNext) ProtoMessage()    {}
func (*QueryStateNext) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{10}
}

func (m *QueryStateNext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryStateNext.Unmarshal(m, b)
}
func (m *QueryStateNext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryStateNext.Marshal(b, m, deterministic)
}
func (m *QueryStateNext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryStateNext.Merge(m, src)
}
func (m *QueryStateNext) XXX_Size() int {
	return xxx_messageInfo_QueryStateNext.Size(m)
}
func (m *QueryStateNext) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryStateNext.DiscardUnknown(m)
}

var xxx_messageInfo_QueryStateNext proto.InternalMessageInfo

func (m *QueryStateNext) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type QueryStateClose struct {
	Id                   string   `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryStateClose) Reset()         { *m = QueryStateClose{} }
func (m *QueryStateClose) String() string { return proto.CompactTextString(m) }
func (*QueryStateClose) ProtoMessage()    {}
func (*QueryStateClose) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{11}
}

func (m *QueryStateClose) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryStateClose.Unmarshal(m, b)
}
func (m *QueryStateClose) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryStateClose.Marshal(b, m, deterministic)
}
func (m *QueryStateClose) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryStateClose.Merge(m, src)
}
func (m *QueryStateClose) XXX_Size() int {
	return xxx_messageInfo_QueryStateClose.Size(m)
}
func (m *QueryStateClose) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryStateClose.DiscardUnknown(m)
}

var xxx_messageInfo_QueryStateClose proto.InternalMessageInfo

func (m *QueryStateClose) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// QueryResultBytes hold the byte representation of a record returned by the peer.
type QueryResultBytes struct {
	ResultBytes          []byte   `protobuf:"bytes,1,opt,name=resultBytes,proto3" json:"resultBytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryResultBytes) Reset()         { *m = QueryResultBytes{} }
func (m *QueryResultBytes) String() string { return proto.CompactTextString(m) }
func (*QueryResultBytes) ProtoMessage()    {}
func (*QueryResultBytes) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{12}
}

func (m *QueryResultBytes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryResultBytes.Unmarshal(m, b)
}
func (m *QueryResultBytes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryResultBytes.Marshal(b, m, deterministic)
}
func (m *QueryResultBytes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResultBytes.Merge(m, src)
}
func (m *QueryResultBytes) XXX_Size() int {
	return xxx_messageInfo_QueryResultBytes.Size(m)
}
func (m *QueryResultBytes) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResultBytes.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResultBytes proto.InternalMessageInfo

func (m *QueryResultBytes) GetResultBytes() []byte {
	if m != nil {
		return m.ResultBytes
	}
	return nil
}

// QueryResponse is returned by the peer as a result of a GetStateByRange,
// GetQueryResult, and GetHistoryForKey. It holds a bunch of records in
// results field, a flag to denote whether more results need to be fetched from
// the peer in has_more field, transaction id in id field, and a QueryResponseMetadata
// in metadata field.
type QueryResponse struct {
	Results              []*QueryResultBytes `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	HasMore              bool                `protobuf:"varint,2,opt,name=has_more,json=hasMore,proto3" json:"has_more,omitempty"`
	Id                   string              `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
	Metadata             []byte              `protobuf:"bytes,4,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *QueryResponse) Reset()         { *m = QueryResponse{} }
func (m *QueryResponse) String() string { return proto.CompactTextString(m) }
func (*QueryResponse) ProtoMessage()    {}
func (*QueryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{13}
}

func (m *QueryResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryResponse.Unmarshal(m, b)
}
func (m *QueryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryResponse.Marshal(b, m, deterministic)
}
func (m *QueryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResponse.Merge(m, src)
}
func (m *QueryResponse) XXX_Size() int {
	return xxx_messageInfo_QueryResponse.Size(m)
}
func (m *QueryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResponse proto.InternalMessageInfo

func (m *QueryResponse) GetResults() []*QueryResultBytes {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *QueryResponse) GetHasMore() bool {
	if m != nil {
		return m.HasMore
	}
	return false
}

func (m *QueryResponse) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *QueryResponse) GetMetadata() []byte {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// QueryResponseMetadata is the metadata of a QueryResponse. It contains a count
// which denotes the number of records fetched from the ledger and a bookmark.
type QueryResponseMetadata struct {
	FetchedRecordsCount  int32    `protobuf:"varint,1,opt,name=fetched_records_count,json=fetchedRecordsCount,proto3" json:"fetched_records_count,omitempty"`
	Bookmark             string   `protobuf:"bytes,2,opt,name=bookmark,proto3" json:"bookmark,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryResponseMetadata) Reset()         { *m = QueryResponseMetadata{} }
func (m *QueryResponseMetadata) String() string { return proto.CompactTextString(m) }
func (*QueryResponseMetadata) ProtoMessage()    {}
func (*QueryResponseMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{14}
}

func (m *QueryResponseMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryResponseMetadata.Unmarshal(m, b)
}
func (m *QueryResponseMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryResponseMetadata.Marshal(b, m, deterministic)
}
func (m *QueryResponseMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResponseMetadata.Merge(m, src)
}
func (m *QueryResponseMetadata) XXX_Size() int {
	return xxx_messageInfo_QueryResponseMetadata.Size(m)
}
func (m *QueryResponseMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResponseMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResponseMetadata proto.InternalMessageInfo

func (m *QueryResponseMetadata) GetFetchedRecordsCount() int32 {
	if m != nil {
		return m.FetchedRecordsCount
	}
	return 0
}

func (m *QueryResponseMetadata) GetBookmark() string {
	if m != nil {
		return m.Bookmark
	}
	return ""
}

type StateMetadata struct {
	Metakey              string   `protobuf:"bytes,1,opt,name=metakey,proto3" json:"metakey,omitempty"`
	Value                []byte   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StateMetadata) Reset()         { *m = StateMetadata{} }
func (m *StateMetadata) String() string { return proto.CompactTextString(m) }
func (*StateMetadata) ProtoMessage()    {}
func (*StateMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{15}
}

func (m *StateMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateMetadata.Unmarshal(m, b)
}
func (m *StateMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateMetadata.Marshal(b, m, deterministic)
}
func (m *StateMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateMetadata.Merge(m, src)
}
func (m *StateMetadata) XXX_Size() int {
	return xxx_messageInfo_StateMetadata.Size(m)
}
func (m *StateMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_StateMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_StateMetadata proto.InternalMessageInfo

func (m *StateMetadata) GetMetakey() string {
	if m != nil {
		return m.Metakey
	}
	return ""
}

func (m *StateMetadata) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

type StateMetadataResult struct {
	Entries              []*StateMetadata `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *StateMetadataResult) Reset()         { *m = StateMetadataResult{} }
func (m *StateMetadataResult) String() string { return proto.CompactTextString(m) }
func (*StateMetadataResult) ProtoMessage()    {}
func (*StateMetadataResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_e5819fec16c96da2, []int{16}
}

func (m *StateMetadataResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StateMetadataResult.Unmarshal(m, b)
}
func (m *StateMetadataResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StateMetadataResult.Marshal(b, m, deterministic)
}
func (m *StateMetadataResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StateMetadataResult.Merge(m, src)
}
func (m *StateMetadataResult) XXX_Size() int {
	return xxx_messageInfo_StateMetadataResult.Size(m)
}
func (m *StateMetadataResult) XXX_DiscardUnknown() {
	xxx_messageInfo_StateMetadataResult.DiscardUnknown(m)
}

var xxx_messageInfo_StateMetadataResult proto.InternalMessageInfo

func (m *StateMetadataResult) GetEntries() []*StateMetadata {
	if m != nil {
		return m.Entries
	}
	return nil
}

func init() {
	proto.RegisterEnum("protos.ChaincodeMessage_Type", ChaincodeMessage_Type_name, ChaincodeMessage_Type_value)
	proto.RegisterType((*ChaincodeMessage)(nil), "protos.ChaincodeMessage")
	proto.RegisterType((*GetState)(nil), "protos.GetState")
	proto.RegisterType((*GetStateMetadata)(nil), "protos.GetStateMetadata")
	proto.RegisterType((*PutState)(nil), "protos.PutState")
	proto.RegisterType((*PutStateMetadata)(nil), "protos.PutStateMetadata")
	proto.RegisterType((*DelState)(nil), "protos.DelState")
	proto.RegisterType((*GetStateByRange)(nil), "protos.GetStateByRange")
	proto.RegisterType((*GetQueryResult)(nil), "protos.GetQueryResult")
	proto.RegisterType((*QueryMetadata)(nil), "protos.QueryMetadata")
	proto.RegisterType((*GetHistoryForKey)(nil), "protos.GetHistoryForKey")
	proto.RegisterType((*QueryStateNext)(nil), "protos.QueryStateNext")
	proto.RegisterType((*QueryStateClose)(nil), "protos.QueryStateClose")
	proto.RegisterType((*QueryResultBytes)(nil), "protos.QueryResultBytes")
	proto.RegisterType((*QueryResponse)(nil), "protos.QueryResponse")
	proto.RegisterType((*QueryResponseMetadata)(nil), "protos.QueryResponseMetadata")
	proto.RegisterType((*StateMetadata)(nil), "protos.StateMetadata")
	proto.RegisterType((*StateMetadataResult)(nil), "protos.StateMetadataResult")
}

func init() { proto.RegisterFile("peer/chaincode_shim.proto", fileDescriptor_e5819fec16c96da2) }

var fileDescriptor_e5819fec16c96da2 = []byte{
	// 1042 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xcf, 0x73, 0xda, 0x46,
	0x14, 0x2e, 0xc6, 0x18, 0xf1, 0xb0, 0xf1, 0x66, 0x1d, 0x5c, 0xc2, 0x4c, 0x5a, 0xca, 0xf4, 0xc0,
	0xa1, 0x81, 0x86, 0xf6, 0xd0, 0x43, 0x67, 0x32, 0x32, 0xac, 0x31, 0x63, 0x5b, 0x90, 0x95, 0xec,
	0xa9, 0x7b, 0xd1, 0x08, 0x69, 0x23, 0x34, 0x01, 0xad, 0x2a, 0x2d, 0x69, 0xe8, 0xad, 0xd7, 0x1e,
	0xfb, 0xc7, 0xf5, 0xef, 0xe9, 0xac, 0x7e, 0x19, 0x70, 0x9d, 0x74, 0x7c, 0x42, 0xdf, 0x7b, 0xdf,
	0x7e, 0xef, 0xd7, 0x3e, 0x24, 0x78, 0x11, 0x30, 0x16, 0xf6, 0xec, 0xb9, 0xe5, 0xf9, 0x36, 0x77,
	0x98, 0x19, 0xcd, 0xbd, 0x65, 0x37, 0x08, 0xb9, 0xe0, 0xf8, 0x20, 0xfe, 0x89, 0x9a, 0xcd, 0x1d,
	0x0a, 0xfb, 0xc0, 0x7c, 0x91, 0x70, 0x9a, 0x27, 0xb1, 0x2f, 0x08, 0x79, 0xc0, 0x23, 0x6b, 0x91,
	0x1a, 0xbf, 0x76, 0x39, 0x77, 0x17, 0xac, 0x17, 0xa3, 0xd9, 0xea, 0x5d, 0x4f, 0x78, 0x4b, 0x16,
	0x09, 0x6b, 0x19, 0x24, 0x84, 0xf6, 0x3f, 0x25, 0x40, 0x83, 0x4c, 0xef, 0x9a, 0x45, 0x91, 0xe5,
	0x32, 0xfc, 0x1a, 0xf6, 0xc5, 0x3a, 0x60, 0x8d, 0x42, 0xab, 0xd0, 0xa9, 0xf5, 0x5f, 0x26, 0xd4,
	0xa8, 0xbb, 0xcb, 0xeb, 0x1a, 0xeb, 0x80, 0xd1, 0x98, 0x8a, 0x7f, 0x82, 0x4a, 0x2e, 0xdd, 0xd8,
	0x6b, 0x15, 0x3a, 0xd5, 0x7e, 0xb3, 0x9b, 0x04, 0xef, 0x66, 0xc1, 0xbb, 0x46, 0xc6, 0xa0, 0xf7,
	0x64, 0xdc, 0x80, 0x72, 0x60, 0xad, 0x17, 0xdc, 0x72, 0x1a, 0xc5, 0x56, 0xa1, 0x73, 0x48, 0x33,
	0x88, 0x31, 0xec, 0x8b, 0x8f, 0x9e, 0xd3, 0xd8, 0x6f, 0x15, 0x3a, 0x15, 0x1a, 0x3f, 0xe3, 0x3e,
	0x28, 0x59, 0x89, 0x8d, 0x52, 0x1c, 0xe6, 0x34, 0x4b, 0x4f, 0xf7, 0x5c, 0x9f, 0x39, 0xd3, 0xd4,
	0x4b, 0x73, 0x1e, 0x7e, 0x03, 0xc7, 0x3b, 0x2d, 0x6b, 0x1c, 0x6c, 0x1f, 0xcd, 0x2b, 0x23, 0xd2,
	0x4b, 0x6b, 0xf6, 0x16, 0xc6, 0x2f, 0x01, 0xec, 0xb9, 0xe5, 0xfb, 0x6c, 0x61, 0x7a, 0x4e, 0xa3,
	0x1c, 0xa7, 0x53, 0x49, 0x2d, 0x63, 0xa7, 0xfd, 0x77, 0x11, 0xf6, 0x65, 0x2b, 0xf0, 0x11, 0x54,
	0x6e, 0xb4, 0x21, 0x39, 0x1f, 0x6b, 0x64, 0x88, 0xbe, 0xc0, 0x87, 0xa0, 0x50, 0x32, 0x1a, 0xeb,
	0x06, 0xa1, 0xa8, 0x80, 0x6b, 0x00, 0x19, 0x22, 0x43, 0xb4, 0x87, 0x15, 0xd8, 0x1f, 0x6b, 0x63,
	0x03, 0x15, 0x71, 0x05, 0x4a, 0x94, 0xa8, 0xc3, 0x3b, 0xb4, 0x8f, 0x8f, 0xa1, 0x6a, 0x50, 0x55,
	0xd3, 0xd5, 0x81, 0x31, 0x9e, 0x68, 0xa8, 0x24, 0x25, 0x07, 0x93, 0xeb, 0xe9, 0x15, 0x31, 0xc8,
	0x10, 0x1d, 0x48, 0x2a, 0xa1, 0x74, 0x42, 0x51, 0x59, 0x7a, 0x46, 0xc4, 0x30, 0x75, 0x43, 0x35,
	0x08, 0x52, 0x24, 0x9c, 0xde, 0x64, 0xb0, 0x22, 0xe1, 0x90, 0x5c, 0xa5, 0x10, 0xf0, 0x73, 0x40,
	0x63, 0xed, 0x76, 0x72, 0x49, 0xcc, 0xc1, 0x85, 0x3a, 0xd6, 0x06, 0x93, 0x21, 0x41, 0xd5, 0x24,
	0x41, 0x7d, 0x3a, 0xd1, 0x74, 0x82, 0x8e, 0xf0, 0x29, 0xe0, 0x5c, 0xd0, 0x3c, 0xbb, 0x33, 0xa9,
	0xaa, 0x8d, 0x08, 0xaa, 0xc9, 0xb3, 0xd2, 0xfe, 0xf6, 0x86, 0xd0, 0x3b, 0x93, 0x12, 0xfd, 0xe6,
	0xca, 0x40, 0xc7, 0xd2, 0x9a, 0x58, 0x12, 0xbe, 0x46, 0x7e, 0x31, 0x10, 0xc2, 0x75, 0x78, 0xb6,
	0x69, 0x1d, 0x5c, 0x4d, 0x74, 0x82, 0x9e, 0xc9, 0x6c, 0x2e, 0x09, 0x99, 0xaa, 0x57, 0xe3, 0x5b,
	0x82, 0x30, 0xfe, 0x12, 0x4e, 0xa4, 0xe2, 0xc5, 0x58, 0x37, 0x26, 0xf4, 0xce, 0x3c, 0x9f, 0x50,
	0xf3, 0x92, 0xdc, 0xa1, 0x93, 0xed, 0x14, 0xae, 0x89, 0xa1, 0x0e, 0x55, 0x43, 0x45, 0xcf, 0xa5,
	0x3d, 0x2f, 0xee, 0xde, 0x5e, 0xc7, 0x2f, 0xa0, 0x2e, 0xf9, 0x53, 0x3a, 0xbe, 0x95, 0x1e, 0x69,
	0x35, 0x2f, 0x54, 0xfd, 0x02, 0x9d, 0xb6, 0x7f, 0x06, 0x65, 0xc4, 0x84, 0x2e, 0x2c, 0xc1, 0x30,
	0x82, 0xe2, 0x7b, 0xb6, 0x8e, 0xaf, 0x73, 0x85, 0xca, 0x47, 0xfc, 0x15, 0x80, 0xcd, 0x17, 0x0b,
	0x66, 0x0b, 0x8f, 0xfb, 0xf1, 0x7d, 0xad, 0xd0, 0x0d, 0x4b, 0x7b, 0x08, 0x28, 0x3b, 0x7d, 0xcd,
	0x84, 0xe5, 0x58, 0xc2, 0x7a, 0x82, 0x0a, 0x05, 0x65, 0xba, 0x7a, 0x34, 0x87, 0xe7, 0x50, 0xfa,
	0x60, 0x2d, 0x56, 0x2c, 0x3e, 0x78, 0x48, 0x13, 0xb0, 0xa3, 0x59, 0x7c, 0xa0, 0xf9, 0x3b, 0xa0,
	0x4c, 0xf3, 0x7f, 0x67, 0xf6, 0x40, 0x05, 0xbf, 0x06, 0x65, 0x99, 0x9e, 0x8e, 0xd7, 0xab, 0xda,
	0xaf, 0xe7, 0x6b, 0xb4, 0x29, 0x4d, 0x73, 0x9a, 0x6c, 0xe8, 0x90, 0x2d, 0x9e, 0xda, 0xd0, 0x3f,
	0x0b, 0x70, 0x9c, 0x75, 0xf4, 0x6c, 0x4d, 0x2d, 0xdf, 0x65, 0xb8, 0x09, 0x4a, 0x24, 0xac, 0x50,
	0x5c, 0xe6, 0x52, 0x39, 0xc6, 0xa7, 0x70, 0xc0, 0x7c, 0x47, 0x7a, 0x12, 0xad, 0x14, 0x7d, 0xb6,
	0xb0, 0xe6, 0x4e, 0x61, 0x87, 0x1b, 0x15, 0xcc, 0xa0, 0x36, 0x62, 0xe2, 0xed, 0x8a, 0x85, 0x6b,
	0xca, 0xa2, 0xd5, 0x42, 0xc8, 0x11, 0xfc, 0x26, 0x61, 0x1a, 0x3e, 0x01, 0x9f, 0xab, 0x65, 0x2b,
	0x46, 0x71, 0x27, 0xc6, 0x08, 0x8e, 0xe2, 0x00, 0xf9, 0x6c, 0x9a, 0xa0, 0x04, 0x96, 0xcb, 0x74,
	0xef, 0x8f, 0xe4, 0xff, 0xb4, 0x44, 0x73, 0x2c, 0x7d, 0x33, 0xce, 0xdf, 0x2f, 0xad, 0xf0, 0x7d,
	0x1a, 0x26, 0xc7, 0xed, 0x6f, 0xe3, 0x1b, 0x78, 0xe1, 0x45, 0x82, 0x87, 0xeb, 0x73, 0x1e, 0xca,
	0xe2, 0x1f, 0xb4, 0xbd, 0xdd, 0x82, 0x5a, 0x1c, 0x2e, 0xee, 0xab, 0xc6, 0x3e, 0x0a, 0x5c, 0x83,
	0x3d, 0xcf, 0x49, 0x29, 0x7b, 0x9e, 0xd3, 0xfe, 0x06, 0x8e, 0xef, 0x19, 0x83, 0x05, 0x8f, 0xd8,
	0x03, 0xca, 0x8f, 0x80, 0x36, 0x9a, 0x72, 0xb6, 0x16, 0x2c, 0xc2, 0x2d, 0xa8, 0x86, 0xf7, 0x30,
	0x26, 0x1f, 0xd2, 0x4d, 0x53, 0xfb, 0xaf, 0x42, 0x5a, 0x2a, 0x65, 0x51, 0xc0, 0xfd, 0x88, 0xe1,
	0x3e, 0x94, 0x13, 0x82, 0xe4, 0x17, 0x3b, 0xd5, 0x7e, 0x23, 0xbb, 0x53, 0xbb, 0xf2, 0x34, 0x23,
	0xe2, 0x17, 0xa0, 0xcc, 0xad, 0xc8, 0x5c, 0xf2, 0x30, 0xd9, 0x03, 0x85, 0x96, 0xe7, 0x56, 0x74,
	0xcd, 0xc3, 0x2c, 0xcd, 0x62, 0x96, 0xe6, 0x27, 0x47, 0xeb, 0x42, 0x7d, 0x2b, 0x97, 0xbc, 0xfd,
	0x7d, 0xa8, 0xbf, 0x63, 0xc2, 0x9e, 0x33, 0xc7, 0x0c, 0x99, 0xcd, 0x43, 0x27, 0x32, 0x6d, 0xbe,
	0xf2, 0x45, 0x3a, 0x8b, 0x93, 0xd4, 0x49, 0x13, 0xdf, 0x40, 0xba, 0x3e, 0x39, 0x96, 0x37, 0x70,
	0xb4, 0xbd, 0x7b, 0x0d, 0x28, 0xcb, 0x2c, 0xee, 0xe7, 0x92, 0xc1, 0xff, 0xde, 0xef, 0xf6, 0x39,
	0x9c, 0x6c, 0x6f, 0x58, 0x72, 0x13, 0x7b, 0x50, 0x66, 0xbe, 0x08, 0x3d, 0x96, 0xf5, 0xee, 0x91,
	0x7d, 0xcc, 0x58, 0xfd, 0xdb, 0x8d, 0xf7, 0xb6, 0xbe, 0x0a, 0x02, 0x1e, 0x0a, 0x7c, 0x06, 0x0a,
	0x65, 0xae, 0x17, 0x09, 0x16, 0xe2, 0xc6, 0x63, 0x6f, 0xed, 0xe6, 0xa3, 0x9e, 0x4e, 0xe1, 0xfb,
	0x42, 0x5f, 0x83, 0x4a, 0x6e, 0xc7, 0x2a, 0x94, 0x07, 0xdc, 0xf7, 0x99, 0x2d, 0x9e, 0xaa, 0x77,
	0x46, 0xa1, 0xcd, 0x43, 0xb7, 0x3b, 0x5f, 0x07, 0x2c, 0x5c, 0x30, 0xc7, 0x65, 0x61, 0xf7, 0x9d,
	0x35, 0x0b, 0x3d, 0x3b, 0x3b, 0x25, 0x3f, 0x5b, 0x7e, 0xfd, 0xce, 0xf5, 0xc4, 0x7c, 0x35, 0xeb,
	0xda, 0x7c, 0xd9, 0xdb, 0xa0, 0xf6, 0x12, 0xea, 0xab, 0x84, 0xfa, 0xca, 0xe5, 0x3d, 0xc9, 0x9e,
	0x25, 0x9f, 0x43, 0x3f, 0xfc, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x77, 0x8a, 0x54, 0x7a, 0x32, 0x09,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ChaincodeSupportClient is the client API for ChaincodeSupport service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ChaincodeSupportClient interface {
	Register(ctx context.Context, opts ...grpc.CallOption) (ChaincodeSupport_RegisterClient, error)
}

type chaincodeSupportClient struct {
	cc *grpc.ClientConn
}

func NewChaincodeSupportClient(cc *grpc.ClientConn) ChaincodeSupportClient {
	return &chaincodeSupportClient{cc}
}

func (c *chaincodeSupportClient) Register(ctx context.Context, opts ...grpc.CallOption) (ChaincodeSupport_RegisterClient, error) {
	stream, err := c.cc.NewStream(ctx, &_ChaincodeSupport_serviceDesc.Streams[0], "/protos.ChaincodeSupport/Register", opts...)
	if err != nil {
		return nil, err
	}
	x := &chaincodeSupportRegisterClient{stream}
	return x, nil
}

type ChaincodeSupport_RegisterClient interface {
	Send(*ChaincodeMessage) error
	Recv() (*ChaincodeMessage, error)
	grpc.ClientStream
}

type chaincodeSupportRegisterClient struct {
	grpc.ClientStream
}

func (x *chaincodeSupportRegisterClient) Send(m *ChaincodeMessage) error {
	return x.ClientStream.SendMsg(m)
}

func (x *chaincodeSupportRegisterClient) Recv() (*ChaincodeMessage, error) {
	m := new(ChaincodeMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ChaincodeSupportServer is the server API for ChaincodeSupport service.
type ChaincodeSupportServer interface {
	Register(ChaincodeSupport_RegisterServer) error
}

// UnimplementedChaincodeSupportServer can be embedded to have forward compatible implementations.
type UnimplementedChaincodeSupportServer struct {
}

func (*UnimplementedChaincodeSupportServer) Register(srv ChaincodeSupport_RegisterServer) error {
	return status.Errorf(codes.Unimplemented, "method Register not implemented")
}

func RegisterChaincodeSupportServer(s *grpc.Server, srv ChaincodeSupportServer) {
	s.RegisterService(&_ChaincodeSupport_serviceDesc, srv)
}

func _ChaincodeSupport_Register_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ChaincodeSupportServer).Register(&chaincodeSupportRegisterServer{stream})
}

type ChaincodeSupport_RegisterServer interface {
	Send(*ChaincodeMessage) error
	Recv() (*ChaincodeMessage, error)
	grpc.ServerStream
}

type chaincodeSupportRegisterServer struct {
	grpc.ServerStream
}

func (x *chaincodeSupportRegisterServer) Send(m *ChaincodeMessage) error {
	return x.ServerStream.SendMsg(m)
}

func (x *chaincodeSupportRegisterServer) Recv() (*ChaincodeMessage, error) {
	m := new(ChaincodeMessage)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _ChaincodeSupport_serviceDesc = grpc.ServiceDesc{
	ServiceName: "protos.ChaincodeSupport",
	HandlerType: (*ChaincodeSupportServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Register",
			Handler:       _ChaincodeSupport_Register_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "peer/chaincode_shim.proto",
}

// ChaincodeClient is the client API for Chaincode service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ChaincodeClient interface {
	Connect(ctx context.Context, opts ...grpc.CallOption) (Chaincode_ConnectClient, error)
}

type chaincodeClient struct {
	cc *grpc.ClientConn
}

func NewChaincodeClient(cc *grpc.ClientConn) ChaincodeClient {
	return &chaincodeClient{cc}
}

func (c *chaincodeClient) Connect(ctx context.Context, opts ...grpc.CallOption) (Chaincode_ConnectClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Chaincode_serviceDesc.Streams[0], "/protos.Chaincode/Connect", opts...)
	if err != nil {
		return nil, err
	}
	x := &chaincodeConnectClient{stream}
	return x, nil
}

type Chaincode_ConnectClient interface {
	Send(*ChaincodeMessage) error
	Recv() (*ChaincodeMessage, error)
	grpc.ClientStream
}

type chaincodeConnectClient struct {
	grpc.ClientStream
}

func (x *chaincodeConnectClient) Send(m *ChaincodeMessage) error {
	return x.ClientStream.SendMsg(m)
}

func (x *chaincodeConnectClient) Recv() (*ChaincodeMessage, error) {
	m := new(ChaincodeMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// ChaincodeServer is the server API for Chaincode service.
type ChaincodeServer interface {
	Connect(Chaincode_ConnectServer) error
}

// UnimplementedChaincodeServer can be embedded to have forward compatible implementations.
type UnimplementedChaincodeServer struct {
}

func (*UnimplementedChaincodeServer) Connect(srv Chaincode_ConnectServer) error {
	return status.Errorf(codes.Unimplemented, "method Connect not implemented")
}

func RegisterChaincodeServer(s *grpc.Server, srv ChaincodeServer) {
	s.RegisterService(&_Chaincode_serviceDesc, srv)
}

func _Chaincode_Connect_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ChaincodeServer).Connect(&chaincodeConnectServer{stream})
}

type Chaincode_ConnectServer interface {
	Send(*ChaincodeMessage) error
	Recv() (*ChaincodeMessage, error)
	grpc.ServerStream
}

type chaincodeConnectServer struct {
	grpc.ServerStream
}

func (x *chaincodeConnectServer) Send(m *ChaincodeMessage) error {
	return x.ServerStream.SendMsg(m)
}

func (x *chaincodeConnectServer) Recv() (*ChaincodeMessage, error) {
	m := new(ChaincodeMessage)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Chaincode_serviceDesc = grpc.ServiceDesc{
	ServiceName: "protos.Chaincode",
	HandlerType: (*ChaincodeServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Connect",
			Handler:       _Chaincode_Connect_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "peer/chaincode_shim.proto",
}
