/*
Copyright Beijing Sansec Technology Development Co., Ltd. 2017 All Rights Reserved.
Copyright IBM Corp. 2016 All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

		 http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package sw

import (
	"github.com/hyperledger/fabric-sdk-go/internal/github.com/hyperledger/fabric/bccsp"
	cspx509 "github.com/hyperledger/fabric-sdk-go/internal/github.com/hyperledger/fabric/bccsp/x509"
	sm2 "github.com/hyperledger/fabric-sdk-go/internal/github.com/hyperledger/fabric/bctls/tencentsm2"
)

/*
var (
	// curveHalfOrders contains the precomputed curve group orders halved.
	// It is used to ensure that signature' S value is lower or equal to the
	// curve group order halved. We accept only low-S signatures.
	// They are precomputed for efficiency reasons.
	curveHalfOrders map[elliptic.Curve]*big.Int = map[elliptic.Curve]*big.Int{
		elliptic.P256(): new(big.Int).Rsh(elliptic.P256().Params().N, 1),
	}
)
*/

func signSM2(k *sm2.PrivateKey, digest []byte, opts bccsp.SignerOpts) ([]byte, error) {
	if opts != nil && opts.HashFunc() == cspx509.SM3 {
		//采用ZA方式，digest表示原数据，不是hash
		//r, s, err := sm2.Sm2Sign( /*rand.Reader,*/ k, digest, []byte(cspx509.DEFAULT_USER_ID))

		/*
			s, _, err = SM2ToLowS(&k.PublicKey, s)
			if err != nil {
				return nil, err
			}
		*/

		return sm2.SignWithSM3(k, digest, cspx509.DEFAULT_USER_ID)
	} else {
		//r, s, err := sm2.Sign( /*rand.Reader,*/ k, digest)

		/*
			s, _, err = SM2ToLowS(&k.PublicKey, s)
			if err != nil {
				return nil, err
			}
		*/

		return sm2.Sign(k, digest)
	}

}

func verifySM2(k *sm2.PublicKey, signature, digest []byte, opts bccsp.SignerOpts) (bool, error) {
	//r, s, err := utils.UnmarshalSM2Signature(signature)

	/*
		lowS, err := SM2IsLowS(k, s)
		if err != nil {
			return false, err
		}

		if !lowS {
			return false, fmt.Errorf("Invalid S. Must be smaller than half the order [%s][%s].", s, curveHalfOrders[k.Curve])
		}
	*/

	if opts != nil && opts.HashFunc() == cspx509.SM3 {
		return sm2.VerifyWithSM3(k, digest, signature, cspx509.DEFAULT_USER_ID), nil
	} else {
		return sm2.Verify(k, digest, signature), nil
	}
}

type sm2Signer struct{}

func (s *sm2Signer) Sign(k bccsp.Key, digest []byte, opts bccsp.SignerOpts) (signature []byte, err error) {
	return signSM2(k.(*sm2PrivateKey).privKey, digest, opts)
}

type sm2PrivateKeyVerifier struct{}

func (v *sm2PrivateKeyVerifier) Verify(k bccsp.Key, signature, digest []byte, opts bccsp.SignerOpts) (bool, error) {
	return verifySM2(&(k.(*sm2PrivateKey).privKey.PublicKey), signature, digest, opts)
}

type sm2PublicKeyKeyVerifier struct{}

func (v *sm2PublicKeyKeyVerifier) Verify(k bccsp.Key, signature, digest []byte, opts bccsp.SignerOpts) (bool, error) {
	return verifySM2(k.(*sm2PublicKey).pubKey, signature, digest, opts)
}
