/*
Copyright SecureKey Technologies Inc. All Rights Reserved.

SPDX-License-Identifier: Apache-2.0
*/

// Package metadata contains variables used by tests
package metadata

// ChannelConfigPath is the relative path to the generated channel artifacts directory
var ChannelConfigPath = "test/fixtures/fabric/v2.2/channel"

// CryptoConfigPath is the relative path to the generated crypto config directory
var CryptoConfigPath = "test/fixtures/fabric/v1/crypto-config"

// SDKConfigPath is the relative path to the SDK configuration test fixtures directory
var SDKConfigPath = "test/fixtures/config"

// Project is the Go project name relative to the Go Path
var Project = "github.com/hyperledger/fabric-sdk-go"

// ProjectPath is the path to the source of fabric-sdk-go
var ProjectPath = ""

// TestRunID is an identifier for the current run of tests
var TestRunID = ""

// CCMode is an identifier for the cc mode: lifecycle or lscc
var CCMode = "lifecycle"
