/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.hyperledger.fabric.gateway.ContractException;
import org.hyperledger.fabric.gateway.spi.Query;
import org.hyperledger.fabric.gateway.spi.QueryHandler;
import org.hyperledger.fabric.sdk.ChaincodeResponse;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.ProposalResponse;

public final class RoundRobinQueryHandler
implements QueryHandler {
    private final List<Peer> peers;
    private final AtomicInteger currentPeerIndex = new AtomicInteger(0);

    public RoundRobinQueryHandler(Collection<Peer> peers) {
        if (peers.size() < 1) {
            throw new IllegalArgumentException("No peers provided");
        }
        this.peers = new ArrayList<Peer>(peers);
    }

    @Override
    public ProposalResponse evaluate(Query query) throws ContractException {
        int startPeerIndex = this.currentPeerIndex.getAndUpdate(i -> (i + 1) % this.peers.size());
        ArrayList<ProposalResponse> failResponses = new ArrayList<ProposalResponse>();
        for (int i2 = 0; i2 < this.peers.size(); ++i2) {
            int peerIndex = (startPeerIndex + i2) % this.peers.size();
            Peer peer = this.peers.get(peerIndex);
            ProposalResponse response = query.evaluate(peer);
            if (response.getStatus().equals((Object)ChaincodeResponse.Status.SUCCESS)) {
                return response;
            }
            if (response.getProposalResponse() != null) {
                throw new ContractException(response.getMessage(), Collections.singletonList(response));
            }
            failResponses.add(response);
        }
        String message = "No responses received. Errors: " + failResponses.stream().map(ChaincodeResponse::getMessage).collect(Collectors.joining("; "));
        throw new ContractException(message, failResponses);
    }
}

