/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.util.io.pem.PemGenerationException;
import org.bouncycastle.util.io.pem.PemObject;
import org.hyperledger.fabric.gateway.X509Identity;
import org.hyperledger.fabric.gateway.impl.identity.X509IdentityImpl;
import org.hyperledger.fabric.sdk.Enrollment;
import sun.security.util.CurveDB;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public final class Identities {
    private static void enableGM() throws IllegalAccessException, InvocationTargetException, NoSuchFieldException, NoSuchMethodException, IOException, ClassNotFoundException {
        Method[] methods = CurveDB.class.getDeclaredMethods();
        Method method = null;
        Pattern var0 = Pattern.compile(",|\\[|\\]");
        for (Method m : methods) {
            if (!"add".equals(m.getName())) continue;
            method = m;
        }
        method.setAccessible(true);
        method.invoke(CurveDB.class, "sm2p256v1", "1.2.156.10197.1.301", 1, "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 1, var0);
        Field specCollection = CurveDB.class.getDeclaredField("specCollection");
        Field oidMap = CurveDB.class.getDeclaredField("oidMap");
        oidMap.setAccessible(true);
        specCollection.setAccessible(true);
        specCollection.set(CurveDB.class, Collections.unmodifiableCollection(((Map)oidMap.get(CurveDB.class)).values()));
        Field nameTable = AlgorithmId.class.getDeclaredField("nameTable");
        nameTable.setAccessible(true);
        HashMap map = (HashMap)nameTable.get(AlgorithmId.class);
        ObjectIdentifier objectIdentifier = ObjectIdentifier.newInternal((int[])new int[]{1, 2, 156, 10197, 1, 501});
        map.put(objectIdentifier, "SM3withSM2");
        Class<?> clazz = Class.forName("io.grpc.netty.shaded.io.netty.handler.ssl.ExtendedOpenSslSession");
        Field algorithmsField = clazz.getDeclaredField("LOCAL_SUPPORTED_SIGNATURE_ALGORITHMS");
        algorithmsField.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(algorithmsField, algorithmsField.getModifiers() & 0xFFFFFFEF);
        String[] algorithms = (String[])algorithmsField.get(null);
        String[] newAlgorithms = new String[algorithms.length + 1];
        System.arraycopy(algorithms, 0, newAlgorithms, 0, algorithms.length);
        newAlgorithms[algorithms.length] = "SM3withSM2";
        algorithmsField.set(null, newAlgorithms);
        String os = System.getProperty("os.name");
        if (os.toLowerCase().startsWith("win")) {
            Identities.loadLib("libcrypto-1_1-x64");
            Identities.loadLib("libssl-1_1-x64");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLib(String libName) throws IOException {
        String libExtension = ".dll";
        String libFullName = libName + libExtension;
        String nativeTempDir = System.getProperty("java.io.tmpdir");
        InputStream in = null;
        BufferedInputStream reader = null;
        FileOutputStream writer = null;
        File extractedLibFile = new File(nativeTempDir + File.separator + libFullName);
        if (!extractedLibFile.exists()) {
            try {
                in = Identities.class.getResourceAsStream("/win32-x86-64/" + libFullName);
                if (in == null) {
                    in = Identities.class.getResourceAsStream(libFullName);
                }
                Identities.class.getResource(libFullName);
                reader = new BufferedInputStream(in);
                writer = new FileOutputStream(extractedLibFile);
                byte[] buffer = new byte[1024];
                while (reader.read(buffer) > 0) {
                    writer.write(buffer);
                    buffer = new byte[1024];
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
        }
        System.load(extractedLibFile.toString());
    }

    public static X509Identity newX509Identity(String mspId, X509Certificate certificate, PrivateKey privateKey) {
        return new X509IdentityImpl(mspId, certificate, privateKey);
    }

    public static X509Identity newX509Identity(String mspId, Enrollment enrollment) throws CertificateException {
        return Identities.newX509Identity(mspId, Identities.readX509Certificate(enrollment.getCert()), enrollment.getKey());
    }

    public static X509Certificate readX509Certificate(String pem) throws CertificateException {
        try {
            return Identities.readX509Certificate(new StringReader(pem));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static X509Certificate readX509Certificate(Reader pemReader) throws IOException, CertificateException {
        try {
            Object pemObject = Identities.readPemObject(pemReader);
            X509CertificateHolder certificateHolder = Identities.asX509CertificateHolder(pemObject);
            return new JcaX509CertificateConverter().getCertificate(certificateHolder);
        }
        catch (PEMException e) {
            throw new CertificateException(e);
        }
    }

    private static Object readPemObject(Reader reader) throws IOException {
        try (PEMParser parser = new PEMParser(reader);){
            Object result = parser.readObject();
            if (result == null) {
                throw new PEMException("Invalid PEM content");
            }
            Object object = result;
            return object;
        }
    }

    private static X509CertificateHolder asX509CertificateHolder(Object pemObject) throws CertificateException {
        if (pemObject instanceof X509CertificateHolder) {
            return (X509CertificateHolder)pemObject;
        }
        throw new CertificateException("Unexpected PEM content type: " + pemObject.getClass().getSimpleName());
    }

    public static PrivateKey readPrivateKey(String pem) throws InvalidKeyException {
        try {
            return Identities.readPrivateKey(new StringReader(pem));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static PrivateKey readPrivateKey(Reader pemReader) throws IOException, InvalidKeyException {
        try {
            Object pemObject = Identities.readPemObject(pemReader);
            PrivateKeyInfo privateKeyInfo = Identities.asPrivateKeyInfo(pemObject);
            return new JcaPEMKeyConverter().getPrivateKey(privateKeyInfo);
        }
        catch (PEMException e) {
            throw new InvalidKeyException(e);
        }
    }

    private static PrivateKeyInfo asPrivateKeyInfo(Object pemObject) throws InvalidKeyException {
        PrivateKeyInfo privateKeyInfo;
        if (pemObject instanceof PEMKeyPair) {
            privateKeyInfo = ((PEMKeyPair)pemObject).getPrivateKeyInfo();
        } else if (pemObject instanceof PrivateKeyInfo) {
            privateKeyInfo = (PrivateKeyInfo)pemObject;
        } else {
            throw new InvalidKeyException("Unexpected PEM content type: " + pemObject.getClass().getSimpleName());
        }
        return privateKeyInfo;
    }

    public static String toPemString(Certificate certificate) {
        return Identities.asPemString(certificate);
    }

    private static String asPemString(Object obj) {
        StringWriter stringWriter = new StringWriter();
        try (JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)stringWriter);){
            pemWriter.writeObject(obj);
            pemWriter.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return stringWriter.toString();
    }

    public static String toPemString(PrivateKey privateKey) {
        try {
            PemObject pkcs8PrivateKey = new JcaPKCS8Generator(privateKey, null).generate();
            return Identities.asPemString(pkcs8PrivateKey);
        }
        catch (PemGenerationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Identities() {
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            Identities.enableGM();
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Fail to enable GM, please check exception detail", e);
        }
    }
}

