/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.gateway.impl.identity;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonObject;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.hyperledger.fabric.gateway.GatewayRuntimeException;
import org.hyperledger.fabric.gateway.Identities;
import org.hyperledger.fabric.gateway.Identity;
import org.hyperledger.fabric.gateway.X509Identity;
import org.hyperledger.fabric.gateway.impl.identity.GatewayUser;
import org.hyperledger.fabric.gateway.impl.identity.IdentityProvider;
import org.hyperledger.fabric.sdk.Enrollment;
import org.hyperledger.fabric.sdk.HFClient;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.exception.CryptoException;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.identity.X509Enrollment;
import org.hyperledger.fabric.sdk.security.CryptoSuite;
import org.hyperledger.fabric.sdk.security.CryptoSuiteFactory;

public enum X509IdentityProvider implements IdentityProvider<X509Identity>
{
    INSTANCE;

    private static final String TYPE_ID = "X.509";
    private static final String JSON_CREDENTIALS = "credentials";
    private static final String JSON_CERTIFICATE = "certificate";
    private static final String JSON_PRIVATE_KEY = "privateKey";
    private static final String SM3WITHSM2 = "SM3WITHSM2";
    private static final String GMCURVE = "SM2P256V1";

    @Override
    public Class<X509Identity> getType() {
        return X509Identity.class;
    }

    @Override
    public String getTypeId() {
        return TYPE_ID;
    }

    @Override
    public JsonObject toJson(Identity identity) {
        X509Identity x509identity = (X509Identity)identity;
        String certificatePem = Identities.toPemString(x509identity.getCertificate());
        String privateKeyPem = Identities.toPemString(x509identity.getPrivateKey());
        return Json.createObjectBuilder().add("version", 1).add("mspId", x509identity.getMspId()).add("type", TYPE_ID).add(JSON_CREDENTIALS, Json.createObjectBuilder().add(JSON_CERTIFICATE, certificatePem).add(JSON_PRIVATE_KEY, privateKeyPem)).build();
    }

    @Override
    public X509Identity fromJson(JsonObject identityData) throws CertificateException, InvalidKeyException, IOException {
        try {
            return this.deserializeIdentity(identityData);
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    private X509Identity deserializeIdentity(JsonObject identityData) throws IOException, CertificateException, InvalidKeyException {
        String type = identityData.getString("type");
        if (!TYPE_ID.equals(type)) {
            throw new IOException("Bad type for provider: " + type);
        }
        int version = identityData.getInt("version");
        switch (version) {
            case 1: {
                return this.newIdentity(identityData);
            }
        }
        throw new IOException("Unsupported identity data version: " + version);
    }

    private X509Identity newIdentity(JsonObject identityData) throws CertificateException, InvalidKeyException {
        String mspId = identityData.getString("mspId");
        JsonObject credentials = identityData.getJsonObject(JSON_CREDENTIALS);
        String certificatePem = credentials.getString(JSON_CERTIFICATE);
        String privateKeyPem = credentials.getString(JSON_PRIVATE_KEY);
        X509Certificate certificate = Identities.readX509Certificate(certificatePem);
        PrivateKey privateKey = Identities.readPrivateKey(privateKeyPem);
        return Identities.newX509Identity(mspId, certificate, privateKey);
    }

    @Override
    public void setUserContext(HFClient client, Identity identity, String name) {
        X509Identity x509Identity = (X509Identity)identity;
        String certificatePem = Identities.toPemString(x509Identity.getCertificate());
        X509Enrollment enrollment = new X509Enrollment(x509Identity.getPrivateKey(), certificatePem);
        GatewayUser user = new GatewayUser(name, x509Identity.getMspId(), (Enrollment)enrollment);
        X509Certificate x509Certificate = x509Identity.getCertificate();
        String sigAlgName = x509Certificate.getSigAlgName();
        String curveName = "";
        PrivateKey key = x509Identity.getPrivateKey();
        if (key instanceof ECPrivateKey) {
            ECPrivateKey k = (ECPrivateKey)key;
            curveName = ((ECNamedCurveParameterSpec)k.getParameters()).getName();
        }
        try {
            if (sigAlgName.toUpperCase().equals(SM3WITHSM2) && curveName.toUpperCase().equals(GMCURVE)) {
                Properties properties = new Properties();
                properties.setProperty("org.hyperledger.fabric.sdk.crypto.default_signature_algorithm", sigAlgName);
                properties.setProperty("org.hyperledger.fabric.sdk.security_curve_mapping", "256=" + curveName);
                CryptoSuite cryptoSuite = CryptoSuiteFactory.getDefault().getCryptoSuite(properties);
                client.setCryptoSuite(cryptoSuite);
            } else {
                CryptoSuite cryptoSuite = CryptoSuiteFactory.getDefault().getCryptoSuite();
                client.setCryptoSuite(cryptoSuite);
            }
            client.setUserContext((User)user);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | CryptoException | InvalidArgumentException e) {
            throw new GatewayRuntimeException("Failed to configure user context", e);
        }
    }
}

