/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.sdk.EnvelopeDeserializer;

class BlockDeserializer {
    private final Common.Block block;
    private final Map<Integer, WeakReference<EnvelopeDeserializer>> envelopes = Collections.synchronizedMap(new WeakHashMap());

    public Common.Block getBlock() {
        return this.block;
    }

    BlockDeserializer(Common.Block block) {
        this.block = block;
    }

    ByteString getPreviousHash() {
        this.block.getHeader().getDataHash();
        return this.block.getHeader().getPreviousHash();
    }

    ByteString getDataHash() {
        return this.block.getHeader().getDataHash();
    }

    public long getNumber() {
        return this.block.getHeader().getNumber();
    }

    Common.BlockData getData() {
        return this.block.getData();
    }

    EnvelopeDeserializer getData(int index) throws InvalidProtocolBufferException {
        EnvelopeDeserializer ret;
        if (index >= this.getData().getDataCount()) {
            return null;
        }
        WeakReference<EnvelopeDeserializer> envelopeWeakReference = this.envelopes.get(index);
        if (null != envelopeWeakReference && null != (ret = (EnvelopeDeserializer)envelopeWeakReference.get())) {
            return ret;
        }
        EnvelopeDeserializer envelopeDeserializer = EnvelopeDeserializer.newInstance(this.getData().getData(index), this.getTransActionsMetaData()[index]);
        this.envelopes.put(index, new WeakReference<EnvelopeDeserializer>(envelopeDeserializer));
        return envelopeDeserializer;
    }

    byte[] getTransActionsMetaData() {
        return this.block.getMetadata().getMetadata(2).toByteArray();
    }
}

