/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hyperledger.fabric.protos.peer.EventsPackage;
import org.hyperledger.fabric.sdk.BlockInfo;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.exception.InvalidProtocolBufferRuntimeException;

public class BlockEvent
extends BlockInfo {
    private final Peer peer;

    BlockEvent(Peer peer, EventsPackage.DeliverResponse resp) {
        super(resp);
        this.peer = peer;
    }

    public Peer getPeer() {
        return this.peer;
    }

    TransactionEvent getTransactionEvent(int index) throws InvalidProtocolBufferException {
        TransactionEvent ret = null;
        BlockInfo.EnvelopeInfo envelopeInfo = this.getEnvelopeInfo(index);
        if (envelopeInfo.getType() == BlockInfo.EnvelopeType.TRANSACTION_ENVELOPE) {
            ret = this.isFiltered() ? new TransactionEvent(this.getEnvelopeInfo((int)index).filteredTx) : new TransactionEvent((BlockInfo.TransactionEnvelopeInfo)this.getEnvelopeInfo(index));
        }
        return ret;
    }

    List<TransactionEvent> getTransactionEventsList() {
        ArrayList<TransactionEvent> ret = new ArrayList<TransactionEvent>(this.getTransactionCount());
        for (TransactionEvent transactionEvent : this.getTransactionEvents()) {
            ret.add(transactionEvent);
        }
        return ret;
    }

    public Iterable<TransactionEvent> getTransactionEvents() {
        return new TransactionEventIterable();
    }

    class TransactionEventIterable
    implements Iterable<TransactionEvent> {
        TransactionEventIterable() {
        }

        @Override
        public Iterator<TransactionEvent> iterator() {
            return new TransactionEventIterator();
        }
    }

    class TransactionEventIterator
    implements Iterator<TransactionEvent> {
        final int max;
        int ci = 0;
        int returned = 0;

        TransactionEventIterator() {
            this.max = BlockEvent.this.getTransactionCount();
        }

        @Override
        public boolean hasNext() {
            return this.returned < this.max;
        }

        @Override
        public TransactionEvent next() {
            TransactionEvent ret = null;
            try {
                while ((ret = BlockEvent.this.getTransactionEvent(this.ci++)) == null) {
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
            ++this.returned;
            return ret;
        }
    }

    public class TransactionEvent
    extends BlockInfo.TransactionEnvelopeInfo {
        TransactionEvent(BlockInfo.TransactionEnvelopeInfo transactionEnvelopeInfo) {
            super((BlockInfo)BlockEvent.this, transactionEnvelopeInfo.getTransactionDeserializer());
        }

        TransactionEvent(EventsPackage.FilteredTransaction filteredTransaction) {
            super((BlockInfo)BlockEvent.this, filteredTransaction);
        }

        public BlockEvent getBlockEvent() {
            return BlockEvent.this;
        }

        public Peer getPeer() {
            return BlockEvent.this.getPeer();
        }
    }
}

