/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.ledger.rwset.Rwset;
import org.hyperledger.fabric.protos.msp.Identities;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.protos.peer.EventsPackage;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.sdk.BlockDeserializer;
import org.hyperledger.fabric.sdk.ChaincodeEvent;
import org.hyperledger.fabric.sdk.EndorserTransactionEnvDeserializer;
import org.hyperledger.fabric.sdk.EnvelopeDeserializer;
import org.hyperledger.fabric.sdk.HeaderDeserializer;
import org.hyperledger.fabric.sdk.TransactionActionDeserializer;
import org.hyperledger.fabric.sdk.TxReadWriteSetInfo;
import org.hyperledger.fabric.sdk.exception.InvalidProtocolBufferRuntimeException;
import org.hyperledger.fabric.sdk.transaction.ProtoUtils;

public class BlockInfo {
    private final BlockDeserializer block;
    private final EventsPackage.FilteredBlock filteredBlock;
    private int transactionCount = -1;

    BlockInfo(Common.Block block) {
        this.filteredBlock = null;
        this.block = new BlockDeserializer(block);
    }

    BlockInfo(EventsPackage.DeliverResponse resp) {
        EventsPackage.DeliverResponse.TypeCase type = resp.getTypeCase();
        if (type == EventsPackage.DeliverResponse.TypeCase.BLOCK) {
            Common.Block respBlock = resp.getBlock();
            this.filteredBlock = null;
            if (respBlock == null) {
                throw new AssertionError((Object)"DeliverResponse type block but block is null");
            }
            this.block = new BlockDeserializer(respBlock);
        } else if (type == EventsPackage.DeliverResponse.TypeCase.FILTERED_BLOCK) {
            this.filteredBlock = resp.getFilteredBlock();
            this.block = null;
            if (this.filteredBlock == null) {
                throw new AssertionError((Object)"DeliverResponse type filter block but filter block is null");
            }
        } else {
            throw new AssertionError((Object)String.format("DeliverResponse type has unexpected type: %s, %d", type.name(), type.getNumber()));
        }
    }

    public boolean isFiltered() {
        if (this.filteredBlock == null && this.block == null) {
            throw new AssertionError((Object)"Both block and filter is null.");
        }
        if (this.filteredBlock != null && this.block != null) {
            throw new AssertionError((Object)"Both block and filter are set.");
        }
        return this.filteredBlock != null;
    }

    public String getChannelId() throws InvalidProtocolBufferException {
        return this.isFiltered() ? this.filteredBlock.getChannelId() : this.getEnvelopeInfo(0).getChannelId();
    }

    public Common.Block getBlock() {
        return this.isFiltered() ? null : this.block.getBlock();
    }

    public EventsPackage.FilteredBlock getFilteredBlock() {
        return !this.isFiltered() ? null : this.filteredBlock;
    }

    public byte[] getPreviousHash() {
        return this.isFiltered() ? null : this.block.getPreviousHash().toByteArray();
    }

    public byte[] getDataHash() {
        return this.isFiltered() ? null : this.block.getDataHash().toByteArray();
    }

    public byte[] getTransActionsMetaData() {
        return this.isFiltered() ? null : this.block.getTransActionsMetaData();
    }

    public long getBlockNumber() {
        return this.isFiltered() ? this.filteredBlock.getNumber() : this.block.getNumber();
    }

    public int getEnvelopeCount() {
        return this.isFiltered() ? this.filteredBlock.getFilteredTransactionsCount() : this.block.getData().getDataCount();
    }

    public int getTransactionCount() {
        if (this.isFiltered()) {
            int ltransactionCount = this.transactionCount;
            if (ltransactionCount < 0) {
                ltransactionCount = 0;
                for (int i = this.filteredBlock.getFilteredTransactionsCount() - 1; i >= 0; --i) {
                    EventsPackage.FilteredTransaction filteredTransactions = this.filteredBlock.getFilteredTransactions(i);
                    Common.HeaderType type = filteredTransactions.getType();
                    if (type != Common.HeaderType.ENDORSER_TRANSACTION) continue;
                    ++ltransactionCount;
                }
                this.transactionCount = ltransactionCount;
            }
            return this.transactionCount;
        }
        int ltransactionCount = this.transactionCount;
        if (ltransactionCount < 0) {
            ltransactionCount = 0;
            for (int i = this.getEnvelopeCount() - 1; i >= 0; --i) {
                try {
                    EnvelopeInfo envelopeInfo = this.getEnvelopeInfo(i);
                    if (envelopeInfo.getType() != EnvelopeType.TRANSACTION_ENVELOPE) continue;
                    ++ltransactionCount;
                    continue;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new InvalidProtocolBufferRuntimeException(e);
                }
            }
            this.transactionCount = ltransactionCount;
        }
        return this.transactionCount;
    }

    public EnvelopeInfo getEnvelopeInfo(int envelopeIndex) throws InvalidProtocolBufferException {
        try {
            EnvelopeInfo ret;
            if (this.isFiltered()) {
                switch (this.filteredBlock.getFilteredTransactions(envelopeIndex).getType().getNumber()) {
                    case 3: {
                        ret = new TransactionEnvelopeInfo(this.filteredBlock.getFilteredTransactions(envelopeIndex));
                        break;
                    }
                    default: {
                        ret = new EnvelopeInfo(this.filteredBlock.getFilteredTransactions(envelopeIndex));
                        break;
                    }
                }
            } else {
                EnvelopeDeserializer ed = EnvelopeDeserializer.newInstance(this.block.getBlock().getData().getData(envelopeIndex), this.block.getTransActionsMetaData()[envelopeIndex]);
                switch (ed.getType()) {
                    case 3: {
                        ret = new TransactionEnvelopeInfo((EndorserTransactionEnvDeserializer)ed);
                        break;
                    }
                    default: {
                        ret = new EnvelopeInfo(ed);
                    }
                }
            }
            return ret;
        }
        catch (InvalidProtocolBufferRuntimeException e) {
            throw e.getCause();
        }
    }

    public Iterable<EnvelopeInfo> getEnvelopeInfos() {
        return new EnvelopeInfoIterable();
    }

    public static enum EnvelopeType {
        TRANSACTION_ENVELOPE,
        ENVELOPE;

    }

    public static class EndorserInfo {
        private final ProposalResponsePackage.Endorsement endorsement;

        EndorserInfo(ProposalResponsePackage.Endorsement endorsement) {
            this.endorsement = endorsement;
        }

        public byte[] getSignature() {
            return this.endorsement.getSignature().toByteArray();
        }

        @Deprecated
        public byte[] getEndorser() {
            return this.endorsement.getEndorser().toByteArray();
        }

        public String getId() {
            try {
                return Identities.SerializedIdentity.parseFrom(this.endorsement.getEndorser()).getIdBytes().toStringUtf8();
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
        }

        public String getMspid() {
            try {
                return Identities.SerializedIdentity.parseFrom(this.endorsement.getEndorser()).getMspid();
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
        }
    }

    class EnvelopeInfoIterable
    implements Iterable<EnvelopeInfo> {
        EnvelopeInfoIterable() {
        }

        @Override
        public Iterator<EnvelopeInfo> iterator() {
            return new EnvelopeInfoIterator();
        }
    }

    class EnvelopeInfoIterator
    implements Iterator<EnvelopeInfo> {
        int ci = 0;
        final int max;

        EnvelopeInfoIterator() {
            this.max = BlockInfo.this.isFiltered() ? BlockInfo.this.filteredBlock.getFilteredTransactionsCount() : BlockInfo.this.block.getData().getDataCount();
        }

        @Override
        public boolean hasNext() {
            return this.ci < this.max;
        }

        @Override
        public EnvelopeInfo next() {
            if (this.ci >= this.max) {
                throw new ArrayIndexOutOfBoundsException(String.format("Current index: %d. Max index: %d", this.ci, this.max));
            }
            try {
                return BlockInfo.this.getEnvelopeInfo(this.ci++);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
        }
    }

    public class TransactionEnvelopeInfo
    extends EnvelopeInfo {
        protected final EndorserTransactionEnvDeserializer transactionDeserializer;

        TransactionEnvelopeInfo(EventsPackage.FilteredTransaction filteredTx) {
            super(filteredTx);
            this.transactionDeserializer = null;
        }

        public byte[] getSignature() {
            return this.transactionDeserializer.getSignature();
        }

        TransactionEnvelopeInfo(EndorserTransactionEnvDeserializer transactionDeserializer) {
            super(transactionDeserializer);
            this.transactionDeserializer = transactionDeserializer;
        }

        EndorserTransactionEnvDeserializer getTransactionDeserializer() {
            return this.transactionDeserializer;
        }

        public int getTransactionActionInfoCount() {
            return BlockInfo.this.isFiltered() ? this.filteredTx.getTransactionActions().getChaincodeActionsCount() : this.transactionDeserializer.getPayload().getTransaction().getActionsCount();
        }

        public Iterable<TransactionActionInfo> getTransactionActionInfos() {
            return new TransactionActionIterable();
        }

        public TransactionActionInfo getTransactionActionInfo(int index) {
            return BlockInfo.this.isFiltered() ? new TransactionActionInfo(this.filteredTx.getTransactionActions().getChaincodeActionsList().get(index)) : new TransactionActionInfo(this.transactionDeserializer.getPayload().getTransaction().getTransactionAction(index));
        }

        public class TransactionActionIterable
        implements Iterable<TransactionActionInfo> {
            @Override
            public Iterator<TransactionActionInfo> iterator() {
                return new TransactionActionInfoIterator();
            }
        }

        public class TransactionActionInfoIterator
        implements Iterator<TransactionActionInfo> {
            int ci = 0;
            final int max;

            TransactionActionInfoIterator() {
                this.max = TransactionEnvelopeInfo.this.getTransactionActionInfoCount();
            }

            @Override
            public boolean hasNext() {
                return this.ci < this.max;
            }

            @Override
            public TransactionActionInfo next() {
                TransactionActionInfo transactionActionInfo;
                if (this.ci >= this.max) {
                    throw new ArrayIndexOutOfBoundsException(String.format("Current index: %d. Max index: %d", this.ci, this.max));
                }
                if (BlockInfo.this.isFiltered()) {
                    int n = this.ci++;
                    transactionActionInfo = new TransactionActionInfo(TransactionEnvelopeInfo.this.filteredTx.getTransactionActions().getChaincodeActions(n));
                } else {
                    transactionActionInfo = TransactionEnvelopeInfo.this.getTransactionActionInfo(this.ci++);
                }
                return transactionActionInfo;
            }
        }

        public class TransactionActionInfo {
            private final TransactionActionDeserializer transactionAction;
            private final EventsPackage.FilteredChaincodeAction filteredAction;
            List<EndorserInfo> endorserInfos = null;
            int getChaincodeInputArgsCount = -1;
            int getEndorsementsCount = -1;

            private boolean isFiltered() {
                return this.filteredAction != null;
            }

            TransactionActionInfo(TransactionActionDeserializer transactionAction) {
                this.transactionAction = transactionAction;
                this.filteredAction = null;
            }

            TransactionActionInfo(EventsPackage.FilteredChaincodeAction filteredAction) {
                this.filteredAction = filteredAction;
                this.transactionAction = null;
            }

            public byte[] getResponseMessageBytes() {
                return this.isFiltered() ? null : this.transactionAction.getPayload().getAction().getProposalResponsePayload().getExtension().getResponseMessageBytes();
            }

            public String getResponseMessage() {
                return this.isFiltered() ? null : this.transactionAction.getPayload().getAction().getProposalResponsePayload().getExtension().getResponseMessage();
            }

            public int getResponseStatus() {
                return this.isFiltered() ? -1 : this.transactionAction.getPayload().getAction().getProposalResponsePayload().getExtension().getResponseStatus();
            }

            public int getChaincodeInputArgsCount() {
                if (this.isFiltered()) {
                    return 0;
                }
                if (this.getChaincodeInputArgsCount < 0) {
                    this.getChaincodeInputArgsCount = this.transactionAction.getPayload().getChaincodeProposalPayload().getChaincodeInvocationSpec().getChaincodeInput().getChaincodeInput().getArgsCount();
                }
                return this.getChaincodeInputArgsCount;
            }

            public byte[] getChaincodeInputArgs(int index) {
                if (this.isFiltered()) {
                    return null;
                }
                Chaincode.ChaincodeInput input = this.transactionAction.getPayload().getChaincodeProposalPayload().getChaincodeInvocationSpec().getChaincodeInput().getChaincodeInput();
                return input.getArgs(index).toByteArray();
            }

            public boolean getChaincodeInputIsInit() {
                if (this.isFiltered()) {
                    return false;
                }
                Chaincode.ChaincodeInput input = this.transactionAction.getPayload().getChaincodeProposalPayload().getChaincodeInvocationSpec().getChaincodeInput().getChaincodeInput();
                return input.getIsInit();
            }

            public int getEndorsementsCount() {
                if (this.isFiltered()) {
                    return 0;
                }
                if (this.getEndorsementsCount < 0) {
                    this.getEndorsementsCount = this.transactionAction.getPayload().getAction().getEndorsementsCount();
                }
                return this.getEndorsementsCount;
            }

            public EndorserInfo getEndorsementInfo(int index) {
                if (this.isFiltered()) {
                    return null;
                }
                if (null == this.endorserInfos) {
                    this.endorserInfos = new ArrayList<EndorserInfo>();
                    for (ProposalResponsePackage.Endorsement endorsement : this.transactionAction.getPayload().getAction().getChaincodeEndorsedAction().getEndorsementsList()) {
                        this.endorserInfos.add(new EndorserInfo(endorsement));
                    }
                }
                return this.endorserInfos.get(index);
            }

            public byte[] getProposalResponseMessageBytes() {
                if (this.isFiltered()) {
                    return null;
                }
                return this.transactionAction.getPayload().getAction().getProposalResponsePayload().getExtension().getResponseMessageBytes();
            }

            public byte[] getProposalResponsePayload() {
                if (this.isFiltered()) {
                    return null;
                }
                ByteString retByteString = this.transactionAction.getPayload().getAction().getProposalResponsePayload().getExtension().getResponsePayload();
                return null != retByteString ? retByteString.toByteArray() : null;
            }

            public int getProposalResponseStatus() {
                if (this.isFiltered()) {
                    return -1;
                }
                return this.transactionAction.getPayload().getAction().getProposalResponsePayload().getExtension().getResponseStatus();
            }

            public String getChaincodeIDName() {
                if (this.isFiltered()) {
                    return null;
                }
                Chaincode.ChaincodeID ccid = this.transactionAction.getPayload().getAction().getProposalResponsePayload().getExtension().getChaincodeID();
                return ccid != null ? ccid.getName() : null;
            }

            public String getChaincodeIDVersion() {
                if (this.isFiltered()) {
                    return null;
                }
                Chaincode.ChaincodeID ccid = this.transactionAction.getPayload().getAction().getProposalResponsePayload().getExtension().getChaincodeID();
                return ccid != null ? ccid.getVersion() : null;
            }

            public TxReadWriteSetInfo getTxReadWriteSet() {
                if (BlockInfo.this.isFiltered()) {
                    return null;
                }
                Rwset.TxReadWriteSet txReadWriteSet = this.transactionAction.getPayload().getAction().getProposalResponsePayload().getExtension().getResults();
                return txReadWriteSet != null ? new TxReadWriteSetInfo(txReadWriteSet) : null;
            }

            public ChaincodeEvent getEvent() {
                if (this.isFiltered()) {
                    EventsPackage.FilteredChaincodeAction chaincodeActions = this.filteredAction;
                    return new ChaincodeEvent(chaincodeActions.getChaincodeEvent().toByteString());
                }
                return this.transactionAction.getPayload().getAction().getProposalResponsePayload().getExtension().getEvent();
            }
        }
    }

    public class EnvelopeInfo {
        private final EnvelopeDeserializer envelopeDeserializer;
        private final HeaderDeserializer headerDeserializer;
        protected final EventsPackage.FilteredTransaction filteredTx;

        boolean isFiltered() {
            return this.filteredTx != null;
        }

        EnvelopeInfo(EnvelopeDeserializer envelopeDeserializer) {
            this.envelopeDeserializer = envelopeDeserializer;
            this.headerDeserializer = envelopeDeserializer.getPayload().getHeader();
            this.filteredTx = null;
        }

        EnvelopeInfo(EventsPackage.FilteredTransaction filteredTx) {
            this.filteredTx = filteredTx;
            this.envelopeDeserializer = null;
            this.headerDeserializer = null;
        }

        public String getChannelId() {
            return BlockInfo.this.isFiltered() ? BlockInfo.this.filteredBlock.getChannelId() : this.headerDeserializer.getChannelHeader().getChannelId();
        }

        public IdentitiesInfo getCreator() {
            return this.isFiltered() ? null : new IdentitiesInfo(this.headerDeserializer.getCreator());
        }

        public byte[] getNonce() {
            return this.isFiltered() ? null : this.headerDeserializer.getNonce();
        }

        public String getTransactionID() {
            return BlockInfo.this.isFiltered() ? this.filteredTx.getTxid() : this.headerDeserializer.getChannelHeader().getTxId();
        }

        @Deprecated
        public long getEpoch() {
            return BlockInfo.this.isFiltered() ? -1L : this.headerDeserializer.getChannelHeader().getEpoch();
        }

        public Date getTimestamp() {
            return BlockInfo.this.isFiltered() ? null : ProtoUtils.getDateFromTimestamp(this.headerDeserializer.getChannelHeader().getTimestamp());
        }

        public boolean isValid() {
            return BlockInfo.this.isFiltered() ? this.filteredTx.getTxValidationCode().getNumber() == 0 : this.envelopeDeserializer.isValid();
        }

        public byte getValidationCode() {
            if (BlockInfo.this.isFiltered()) {
                return (byte)this.filteredTx.getTxValidationCode().getNumber();
            }
            return this.envelopeDeserializer.validationCode();
        }

        public EnvelopeType getType() {
            int type = BlockInfo.this.isFiltered() ? this.filteredTx.getTypeValue() : this.headerDeserializer.getChannelHeader().getType();
            switch (type) {
                case 3: {
                    return EnvelopeType.TRANSACTION_ENVELOPE;
                }
            }
            return EnvelopeType.ENVELOPE;
        }

        public class IdentitiesInfo {
            final String mspid;
            final String id;

            public String getId() {
                return this.id;
            }

            public String getMspid() {
                return this.mspid;
            }

            IdentitiesInfo(Identities.SerializedIdentity identity) {
                this.mspid = identity.getMspid();
                this.id = identity.getIdBytes().toStringUtf8();
            }
        }
    }
}

