/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.ref.WeakReference;
import org.hyperledger.fabric.protos.ledger.rwset.Rwset;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.sdk.ChaincodeEvent;
import org.hyperledger.fabric.sdk.exception.InvalidProtocolBufferRuntimeException;

class ChaincodeActionDeserializer {
    private final ByteString byteString;
    private WeakReference<ProposalPackage.ChaincodeAction> chaincodeAction;

    ChaincodeActionDeserializer(ByteString byteString) {
        this.byteString = byteString;
    }

    ProposalPackage.ChaincodeAction getChaincodeAction() {
        ProposalPackage.ChaincodeAction ret;
        ProposalPackage.ChaincodeAction chaincodeAction = ret = this.chaincodeAction != null ? (ProposalPackage.ChaincodeAction)this.chaincodeAction.get() : null;
        if (null == ret) {
            try {
                ret = ProposalPackage.ChaincodeAction.parseFrom(this.byteString);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
            this.chaincodeAction = new WeakReference<ProposalPackage.ChaincodeAction>(ret);
        }
        return ret;
    }

    Chaincode.ChaincodeID getChaincodeID() {
        ProposalPackage.ChaincodeAction chaincodeAction = this.getChaincodeAction();
        return chaincodeAction.hasChaincodeId() ? chaincodeAction.getChaincodeId() : null;
    }

    ChaincodeEvent getEvent() {
        ProposalPackage.ChaincodeAction ca = this.getChaincodeAction();
        ByteString eventsBytes = ca.getEvents();
        if (eventsBytes == null || eventsBytes.isEmpty()) {
            return null;
        }
        return new ChaincodeEvent(eventsBytes);
    }

    Rwset.TxReadWriteSet getResults() {
        try {
            return Rwset.TxReadWriteSet.parseFrom(this.getChaincodeAction().getResults());
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidProtocolBufferRuntimeException(e);
        }
    }

    String getResponseMessage() {
        return this.getChaincodeAction().getResponse().getMessage();
    }

    byte[] getResponseMessageBytes() {
        return this.getChaincodeAction().getResponse().getMessageBytes().toByteArray();
    }

    int getResponseStatus() {
        return this.getChaincodeAction().getResponse().getStatus();
    }

    ByteString getResponsePayload() {
        return this.getChaincodeAction().getResponse().getPayload();
    }
}

