/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.common.MspPrincipal;
import org.hyperledger.fabric.protos.common.Policies;
import org.hyperledger.fabric.protos.peer.Collection;
import org.hyperledger.fabric.sdk.exception.ChaincodeCollectionConfigurationException;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ChaincodeCollectionConfiguration {
    private static final Log logger = LogFactory.getLog(ChaincodeCollectionConfiguration.class);
    private static final Pattern noofPattern = Pattern.compile("^(\\d+)-of$");
    private final Collection.CollectionConfigPackage collectionConfigPackage;

    Collection.CollectionConfigPackage getCollectionConfigPackage() {
        return this.collectionConfigPackage;
    }

    ChaincodeCollectionConfiguration(JsonArray jsonConfig) throws ChaincodeCollectionConfigurationException {
        this.collectionConfigPackage = this.parse(jsonConfig);
        if (this.collectionConfigPackage == null) {
            throw new ChaincodeCollectionConfigurationException("Parsing collection configuration produce null configuration.");
        }
    }

    ChaincodeCollectionConfiguration(Collection.CollectionConfigPackage collectionConfigPackage) {
        this.collectionConfigPackage = collectionConfigPackage;
    }

    public byte[] getAsBytes() throws ChaincodeCollectionConfigurationException {
        if (this.collectionConfigPackage == null) {
            throw new ChaincodeCollectionConfigurationException("Collection configuration was null.");
        }
        return this.collectionConfigPackage.toByteArray();
    }

    public static ChaincodeCollectionConfiguration fromYamlFile(File configFile) throws InvalidArgumentException, IOException, ChaincodeCollectionConfigurationException {
        return ChaincodeCollectionConfiguration.fromFile(configFile, false);
    }

    public static ChaincodeCollectionConfiguration fromJsonFile(File configFile) throws InvalidArgumentException, IOException, ChaincodeCollectionConfigurationException {
        return ChaincodeCollectionConfiguration.fromFile(configFile, true);
    }

    public static ChaincodeCollectionConfiguration fromYamlStream(InputStream configStream) throws InvalidArgumentException, ChaincodeCollectionConfigurationException {
        logger.trace((Object)"ChaincodeCollectionConfiguration.fromYamlStream...");
        if (configStream == null) {
            throw new InvalidArgumentException("ConfigStream must be specified");
        }
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        List map = (List)yaml.load(configStream);
        JsonArrayBuilder builder = Json.createArrayBuilder((Collection)map);
        JsonArray jsonConfig = builder.build();
        return ChaincodeCollectionConfiguration.fromJsonObject(jsonConfig);
    }

    public static ChaincodeCollectionConfiguration fromJsonStream(InputStream configStream) throws InvalidArgumentException, ChaincodeCollectionConfigurationException {
        logger.trace((Object)"ChaincodeCollectionConfiguration.fromJsonStream...");
        if (configStream == null) {
            throw new InvalidArgumentException("configStream must be specified");
        }
        try (JsonReader reader = Json.createReader((InputStream)configStream);){
            ChaincodeCollectionConfiguration chaincodeCollectionConfiguration = ChaincodeCollectionConfiguration.fromJsonObject((JsonArray)reader.read());
            return chaincodeCollectionConfiguration;
        }
    }

    public static ChaincodeCollectionConfiguration fromJsonObject(JsonArray jsonConfig) throws InvalidArgumentException, ChaincodeCollectionConfigurationException {
        if (jsonConfig == null) {
            throw new InvalidArgumentException("jsonConfig must be specified");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("ChaincodeCollectionConfiguration.fromJsonObject: %s", jsonConfig.toString()));
        }
        return ChaincodeCollectionConfiguration.load(jsonConfig);
    }

    public static ChaincodeCollectionConfiguration fromCollectionConfigPackage(Collection.CollectionConfigPackage collectionConfigPackage) throws InvalidArgumentException {
        if (collectionConfigPackage == null) {
            throw new InvalidArgumentException("collectionConfigPackage must be specified");
        }
        return new ChaincodeCollectionConfiguration(collectionConfigPackage);
    }

    private static ChaincodeCollectionConfiguration fromFile(File configFile, boolean isJson) throws InvalidArgumentException, IOException, ChaincodeCollectionConfigurationException {
        if (configFile == null) {
            throw new InvalidArgumentException("configFile must be specified");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("ChaincodeCollectionConfiguration.fromFile: %s  isJson = %b", configFile.getAbsolutePath(), isJson));
        }
        try (FileInputStream stream = new FileInputStream(configFile);){
            ChaincodeCollectionConfiguration chaincodeCollectionConfiguration = isJson ? ChaincodeCollectionConfiguration.fromJsonStream(stream) : ChaincodeCollectionConfiguration.fromYamlStream(stream);
            return chaincodeCollectionConfiguration;
        }
    }

    private static ChaincodeCollectionConfiguration load(JsonArray jsonConfig) throws InvalidArgumentException, ChaincodeCollectionConfigurationException {
        if (jsonConfig == null) {
            throw new InvalidArgumentException("jsonConfig must be specified");
        }
        return new ChaincodeCollectionConfiguration(jsonConfig);
    }

    Collection.CollectionConfigPackage parse(JsonArray jsonConfig) throws ChaincodeCollectionConfigurationException {
        Collection.CollectionConfigPackage.Builder colcofbuilder = Collection.CollectionConfigPackage.newBuilder();
        for (int i = jsonConfig.size() - 1; i > -1; --i) {
            Collection.StaticCollectionConfig.Builder ssc = Collection.StaticCollectionConfig.newBuilder();
            JsonValue j = (JsonValue)jsonConfig.get(i);
            if (j.getValueType() != JsonValue.ValueType.OBJECT) {
                throw new ChaincodeCollectionConfigurationException(String.format("Expected StaticCollectionConfig to be Object type but got: %s", j.getValueType().name()));
            }
            JsonObject jsonObject = j.asJsonObject();
            JsonObject scf = ChaincodeCollectionConfiguration.getJsonObject(jsonObject, "StaticCollectionConfig");
            ssc.setName(ChaincodeCollectionConfiguration.getJsonString(scf, "name")).setBlockToLive(ChaincodeCollectionConfiguration.getJsonLong(scf, "blockToLive")).setMaximumPeerCount(ChaincodeCollectionConfiguration.getJsonInt(scf, "maximumPeerCount")).setMemberOrgsPolicy(Collection.CollectionPolicyConfig.newBuilder().setSignaturePolicy(this.parseSignaturePolicyEnvelope(scf)).build()).setRequiredPeerCount(ChaincodeCollectionConfiguration.getJsonInt(scf, "requiredPeerCount"));
            colcofbuilder.addConfig(Collection.CollectionConfig.newBuilder().setStaticCollectionConfig(ssc).build());
        }
        return colcofbuilder.build();
    }

    private Policies.SignaturePolicyEnvelope parseSignaturePolicyEnvelope(JsonObject scf) throws ChaincodeCollectionConfigurationException {
        JsonObject signaturePolicyEnvelope = ChaincodeCollectionConfiguration.getJsonObject(scf, "SignaturePolicyEnvelope");
        IndexedHashMap<String, MspPrincipal.MSPPrincipal> identities = this.parseIdentities(ChaincodeCollectionConfiguration.getJsonArray(signaturePolicyEnvelope, "identities"));
        Policies.SignaturePolicy sp = this.parsePolicy(identities, ChaincodeCollectionConfiguration.getJsonObject(signaturePolicyEnvelope, "policy"));
        return Policies.SignaturePolicyEnvelope.newBuilder().addAllIdentities(identities.values()).setRule(sp).build();
    }

    private Policies.SignaturePolicy parsePolicy(IndexedHashMap<String, MspPrincipal.MSPPrincipal> identities, JsonObject policy) throws ChaincodeCollectionConfigurationException {
        if (policy.size() != 1) {
            throw new ChaincodeCollectionConfigurationException(String.format("Expected policy size of 1 but got %d", policy.size()));
        }
        String key = (String)((Map.Entry)policy.entrySet().iterator().next()).getKey();
        if ("signed-by".equals(key)) {
            String vo = ChaincodeCollectionConfiguration.getJsonString(policy, key);
            MspPrincipal.MSPPrincipal mspPrincipal = (MspPrincipal.MSPPrincipal)identities.get(vo);
            if (null == mspPrincipal) {
                throw new ChaincodeCollectionConfigurationException(String.format("No identity found by name %s in signed-by.", vo));
            }
            return Policies.SignaturePolicy.newBuilder().setSignedBy(identities.getKeysIndex(vo)).build();
        }
        Matcher match = noofPattern.matcher(key);
        JsonArray vo = ChaincodeCollectionConfiguration.getJsonArray(policy, key);
        if (match.matches() && match.groupCount() == 1) {
            String matchStingNo = match.group(1).trim();
            int matchNo = Integer.parseInt(matchStingNo);
            if (vo.size() < matchNo) {
                throw new ChaincodeCollectionConfigurationException(String.format("%s expected to have at least %d items to match but only found %d.", key, matchNo, vo.size()));
            }
            Policies.SignaturePolicy.NOutOf.Builder spBuilder = Policies.SignaturePolicy.NOutOf.newBuilder().setN(matchNo);
            for (int i = vo.size() - 1; i >= 0; --i) {
                JsonValue jsonValue = (JsonValue)vo.get(i);
                if (jsonValue.getValueType() != JsonValue.ValueType.OBJECT) {
                    throw new ChaincodeCollectionConfigurationException(String.format("Expected object type in Nof but got %s", jsonValue.getValueType().name()));
                }
                Policies.SignaturePolicy sp = this.parsePolicy(identities, jsonValue.asJsonObject());
                spBuilder.addRules(sp);
            }
            return Policies.SignaturePolicy.newBuilder().setNOutOf(spBuilder.build()).build();
        }
        throw new ChaincodeCollectionConfigurationException(String.format("Unsupported policy type %s", key));
    }

    private IndexedHashMap<String, MspPrincipal.MSPPrincipal> parseIdentities(JsonArray identities) throws ChaincodeCollectionConfigurationException {
        IndexedHashMap<String, MspPrincipal.MSPPrincipal> ret = new IndexedHashMap<String, MspPrincipal.MSPPrincipal>();
        for (JsonValue jsonValue : identities) {
            MspPrincipal.MSPRole.MSPRoleType mspRoleType;
            if (jsonValue.getValueType() != JsonValue.ValueType.OBJECT) {
                throw new ChaincodeCollectionConfigurationException(String.format("Expected in identies user to be Object type but got: %s", jsonValue.getValueType().name()));
            }
            JsonObject user = jsonValue.asJsonObject();
            if (user.entrySet().size() != 1) {
                throw new ChaincodeCollectionConfigurationException("Only expected on property for user entry in identies.");
            }
            Map.Entry next = (Map.Entry)user.entrySet().iterator().next();
            String name = (String)next.getKey();
            jsonValue = (JsonValue)next.getValue();
            if (jsonValue.getValueType() != JsonValue.ValueType.OBJECT) {
                throw new ChaincodeCollectionConfigurationException(String.format("Expected in identies role to be Object type but got: %s", jsonValue.getValueType().name()));
            }
            JsonObject role = jsonValue.asJsonObject();
            JsonObject roleObj = ChaincodeCollectionConfiguration.getJsonObject(role, "role");
            String roleName = ChaincodeCollectionConfiguration.getJsonString(roleObj, "name");
            String mspId = ChaincodeCollectionConfiguration.getJsonString(roleObj, "mspId");
            switch (roleName.intern()) {
                case "member": {
                    mspRoleType = MspPrincipal.MSPRole.MSPRoleType.MEMBER;
                    break;
                }
                case "admin": {
                    mspRoleType = MspPrincipal.MSPRole.MSPRoleType.ADMIN;
                    break;
                }
                case "client": {
                    mspRoleType = MspPrincipal.MSPRole.MSPRoleType.CLIENT;
                    break;
                }
                case "peer": {
                    mspRoleType = MspPrincipal.MSPRole.MSPRoleType.PEER;
                    break;
                }
                default: {
                    throw new ChaincodeCollectionConfigurationException(String.format("In identities with key %s name expected member, admin, client, or peer in role got %s ", name, roleName));
                }
            }
            MspPrincipal.MSPRole mspRole = MspPrincipal.MSPRole.newBuilder().setRole(mspRoleType).setMspIdentifier(mspId).build();
            MspPrincipal.MSPPrincipal principal = MspPrincipal.MSPPrincipal.newBuilder().setPrincipalClassification(MspPrincipal.MSPPrincipal.Classification.ROLE).setPrincipal(mspRole.toByteString()).build();
            ret.put(name, principal);
        }
        return ret;
    }

    private static JsonObject getJsonObject(JsonObject obj, String prop) throws ChaincodeCollectionConfigurationException {
        JsonValue ret = (JsonValue)obj.get((Object)prop);
        if (ret == null) {
            throw new ChaincodeCollectionConfigurationException(String.format("property %s missing", prop));
        }
        if (ret.getValueType() != JsonValue.ValueType.OBJECT) {
            throw new ChaincodeCollectionConfigurationException(String.format("property %s wrong type expected object got %s", prop, ret.getValueType().name()));
        }
        return ret.asJsonObject();
    }

    private static JsonArray getJsonArray(JsonObject obj, String prop) throws ChaincodeCollectionConfigurationException {
        JsonValue ret = (JsonValue)obj.get((Object)prop);
        if (ret == null) {
            throw new ChaincodeCollectionConfigurationException(String.format("property %s missing", prop));
        }
        if (ret.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new ChaincodeCollectionConfigurationException(String.format("property %s wrong type expected array got %s", prop, ret.getValueType().name()));
        }
        return ret.asJsonArray();
    }

    private static String getJsonString(JsonObject obj, String prop) throws ChaincodeCollectionConfigurationException {
        JsonValue ret = (JsonValue)obj.get((Object)prop);
        if (ret == null) {
            throw new ChaincodeCollectionConfigurationException(String.format("property %s missing", prop));
        }
        if (ret.getValueType() != JsonValue.ValueType.STRING) {
            throw new ChaincodeCollectionConfigurationException(String.format("property %s wrong type expected string got %s", prop, ret.getValueType().name()));
        }
        return obj.getString(prop);
    }

    private static long getJsonLong(JsonObject obj, String prop) throws ChaincodeCollectionConfigurationException {
        JsonValue ret = (JsonValue)obj.get((Object)prop);
        if (ret == null) {
            throw new ChaincodeCollectionConfigurationException(String.format("property %s missing", prop));
        }
        if (ret.getValueType() != JsonValue.ValueType.NUMBER) {
            throw new ChaincodeCollectionConfigurationException(String.format("property %s wrong type expected number got %s", prop, ret.getValueType().name()));
        }
        return Long.parseLong(ret.toString());
    }

    private static int getJsonInt(JsonObject obj, String prop) throws ChaincodeCollectionConfigurationException {
        JsonValue ret = (JsonValue)obj.get((Object)prop);
        if (ret == null) {
            throw new ChaincodeCollectionConfigurationException(String.format("property %s missing", prop));
        }
        if (ret.getValueType() != JsonValue.ValueType.NUMBER) {
            throw new ChaincodeCollectionConfigurationException(String.format("property %s wrong type expected number got %s", prop, ret.getValueType().name()));
        }
        return Integer.parseInt(ret.toString());
    }

    private static class IndexedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        final HashMap<K, Integer> kmap = new HashMap();

        private IndexedHashMap() {
        }

        @Override
        public V put(K key, V value) {
            this.kmap.put(key, this.size());
            return super.put(key, value);
        }

        Integer getKeysIndex(String n) {
            return this.kmap.get(n);
        }
    }
}

