/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.ref.WeakReference;
import java.util.List;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.protos.peer.TransactionPackage;
import org.hyperledger.fabric.sdk.ProposalResponsePayloadDeserializer;
import org.hyperledger.fabric.sdk.exception.InvalidProtocolBufferRuntimeException;

class ChaincodeEndorsedActionDeserializer {
    private final ByteString byteString;
    private WeakReference<TransactionPackage.ChaincodeEndorsedAction> chaincodeEndorsedAction;
    private WeakReference<ProposalResponsePayloadDeserializer> proposalResponsePayload;

    ChaincodeEndorsedActionDeserializer(TransactionPackage.ChaincodeEndorsedAction action) {
        this.byteString = action.toByteString();
        this.chaincodeEndorsedAction = new WeakReference<TransactionPackage.ChaincodeEndorsedAction>(action);
    }

    TransactionPackage.ChaincodeEndorsedAction getChaincodeEndorsedAction() {
        TransactionPackage.ChaincodeEndorsedAction ret;
        TransactionPackage.ChaincodeEndorsedAction chaincodeEndorsedAction = ret = this.chaincodeEndorsedAction != null ? (TransactionPackage.ChaincodeEndorsedAction)this.chaincodeEndorsedAction.get() : null;
        if (null == ret) {
            try {
                ret = TransactionPackage.ChaincodeEndorsedAction.parseFrom(this.byteString);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
            this.chaincodeEndorsedAction = new WeakReference<TransactionPackage.ChaincodeEndorsedAction>(ret);
        }
        return ret;
    }

    int getEndorsementsCount() {
        return this.getChaincodeEndorsedAction().getEndorsementsCount();
    }

    List<ProposalResponsePackage.Endorsement> getEndorsements() {
        return this.getChaincodeEndorsedAction().getEndorsementsList();
    }

    byte[] getEndorsementSignature(int index) {
        return this.getChaincodeEndorsedAction().getEndorsements(index).getSignature().toByteArray();
    }

    ProposalResponsePayloadDeserializer getProposalResponsePayload() {
        ProposalResponsePayloadDeserializer ret;
        ProposalResponsePayloadDeserializer proposalResponsePayloadDeserializer = ret = this.proposalResponsePayload != null ? (ProposalResponsePayloadDeserializer)this.proposalResponsePayload.get() : null;
        if (null == ret) {
            ret = new ProposalResponsePayloadDeserializer(this.getChaincodeEndorsedAction().getProposalResponsePayload());
            this.proposalResponsePayload = new WeakReference<ProposalResponsePayloadDeserializer>(ret);
        }
        return ret;
    }
}

