/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.ref.WeakReference;
import org.hyperledger.fabric.protos.peer.ChaincodeEventPackage;
import org.hyperledger.fabric.sdk.exception.InvalidProtocolBufferRuntimeException;

public class ChaincodeEvent {
    private final ByteString byteString;
    private WeakReference<ChaincodeEventPackage.ChaincodeEvent> chaincodeEvent;

    ChaincodeEvent(ByteString byteString) {
        this.byteString = byteString;
    }

    ChaincodeEventPackage.ChaincodeEvent getChaincodeEvent() {
        ChaincodeEventPackage.ChaincodeEvent ret;
        ChaincodeEventPackage.ChaincodeEvent chaincodeEvent = ret = this.chaincodeEvent != null ? (ChaincodeEventPackage.ChaincodeEvent)this.chaincodeEvent.get() : null;
        if (null == ret) {
            try {
                ret = ChaincodeEventPackage.ChaincodeEvent.parseFrom(this.byteString);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
            this.chaincodeEvent = new WeakReference<ChaincodeEventPackage.ChaincodeEvent>(ret);
        }
        return ret;
    }

    public String getEventName() {
        return this.getChaincodeEvent().getEventName();
    }

    public String getChaincodeId() {
        return this.getChaincodeEvent().getChaincodeId();
    }

    public String getTxId() {
        return this.getChaincodeEvent().getTxId();
    }

    public byte[] getPayload() {
        ByteString ret = this.getChaincodeEvent().getPayload();
        if (null == ret) {
            return null;
        }
        return ret.toByteArray();
    }
}

