/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.ref.WeakReference;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.sdk.exception.InvalidProtocolBufferRuntimeException;

class ChaincodeInputDeserializer {
    private final ByteString byteString;
    private WeakReference<Chaincode.ChaincodeInput> chaincodeInput;

    ChaincodeInputDeserializer(Chaincode.ChaincodeInput chaincodeInput) {
        this.byteString = chaincodeInput.toByteString();
        this.chaincodeInput = new WeakReference<Chaincode.ChaincodeInput>(chaincodeInput);
    }

    Chaincode.ChaincodeInput getChaincodeInput() {
        Chaincode.ChaincodeInput ret = null;
        if (this.chaincodeInput != null) {
            ret = (Chaincode.ChaincodeInput)this.chaincodeInput.get();
        }
        if (ret == null) {
            try {
                ret = Chaincode.ChaincodeInput.parseFrom(this.byteString);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
            this.chaincodeInput = new WeakReference<Chaincode.ChaincodeInput>(ret);
        }
        return ret;
    }
}

