/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.ref.WeakReference;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.sdk.ChaincodeInputDeserializer;
import org.hyperledger.fabric.sdk.exception.InvalidProtocolBufferRuntimeException;

class ChaincodeInvocationSpecDeserializer {
    private final ByteString byteString;
    private WeakReference<Chaincode.ChaincodeInvocationSpec> invocationSpec;
    private WeakReference<ChaincodeInputDeserializer> chaincodeInputDeserializer;

    ChaincodeInvocationSpecDeserializer(ByteString byteString) {
        this.byteString = byteString;
    }

    Chaincode.ChaincodeInvocationSpec getChaincodeInvocationSpec() {
        Chaincode.ChaincodeInvocationSpec ret = null;
        if (this.invocationSpec != null) {
            ret = (Chaincode.ChaincodeInvocationSpec)this.invocationSpec.get();
        }
        if (ret == null) {
            try {
                ret = Chaincode.ChaincodeInvocationSpec.parseFrom(this.byteString);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
            this.invocationSpec = new WeakReference<Chaincode.ChaincodeInvocationSpec>(ret);
        }
        return ret;
    }

    ChaincodeInputDeserializer getChaincodeInput() {
        ChaincodeInputDeserializer ret = null;
        if (this.chaincodeInputDeserializer != null) {
            ret = (ChaincodeInputDeserializer)this.chaincodeInputDeserializer.get();
        }
        if (ret == null) {
            ret = new ChaincodeInputDeserializer(this.getChaincodeInvocationSpec().getChaincodeSpec().getInput());
            this.chaincodeInputDeserializer = new WeakReference<ChaincodeInputDeserializer>(ret);
        }
        return ret;
    }
}

