/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.StatusRuntimeException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.common.Configtx;
import org.hyperledger.fabric.protos.common.Ledger;
import org.hyperledger.fabric.protos.discovery.Protocol;
import org.hyperledger.fabric.protos.msp.MspConfigPackage;
import org.hyperledger.fabric.protos.orderer.Ab;
import org.hyperledger.fabric.protos.peer.Collection;
import org.hyperledger.fabric.protos.peer.Configuration;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.protos.peer.Query;
import org.hyperledger.fabric.protos.peer.TransactionPackage;
import org.hyperledger.fabric.sdk.BlockEvent;
import org.hyperledger.fabric.sdk.BlockInfo;
import org.hyperledger.fabric.sdk.BlockListener;
import org.hyperledger.fabric.sdk.BlockchainInfo;
import org.hyperledger.fabric.sdk.ChaincodeCollectionConfiguration;
import org.hyperledger.fabric.sdk.ChaincodeEvent;
import org.hyperledger.fabric.sdk.ChaincodeEventListener;
import org.hyperledger.fabric.sdk.ChaincodeResponse;
import org.hyperledger.fabric.sdk.ChannelConfiguration;
import org.hyperledger.fabric.sdk.CollectionConfigPackage;
import org.hyperledger.fabric.sdk.Enrollment;
import org.hyperledger.fabric.sdk.HFClient;
import org.hyperledger.fabric.sdk.InstallProposalRequest;
import org.hyperledger.fabric.sdk.InstantiateProposalRequest;
import org.hyperledger.fabric.sdk.LifecycleApproveChaincodeDefinitionForMyOrgProposalResponse;
import org.hyperledger.fabric.sdk.LifecycleApproveChaincodeDefinitionForMyOrgRequest;
import org.hyperledger.fabric.sdk.LifecycleChaincodePackage;
import org.hyperledger.fabric.sdk.LifecycleCheckCommitReadinessProposalResponse;
import org.hyperledger.fabric.sdk.LifecycleCheckCommitReadinessRequest;
import org.hyperledger.fabric.sdk.LifecycleCommitChaincodeDefinitionProposalResponse;
import org.hyperledger.fabric.sdk.LifecycleCommitChaincodeDefinitionRequest;
import org.hyperledger.fabric.sdk.LifecycleInstallChaincodeProposalResponse;
import org.hyperledger.fabric.sdk.LifecycleInstallChaincodeRequest;
import org.hyperledger.fabric.sdk.LifecycleQueryChaincodeDefinitionProposalResponse;
import org.hyperledger.fabric.sdk.LifecycleQueryChaincodeDefinitionsProposalResponse;
import org.hyperledger.fabric.sdk.LifecycleQueryChaincodeDefinitionsRequest;
import org.hyperledger.fabric.sdk.LifecycleQueryInstalledChaincodeProposalResponse;
import org.hyperledger.fabric.sdk.LifecycleQueryInstalledChaincodeRequest;
import org.hyperledger.fabric.sdk.LifecycleQueryInstalledChaincodesProposalResponse;
import org.hyperledger.fabric.sdk.LifecycleQueryInstalledChaincodesRequest;
import org.hyperledger.fabric.sdk.LifecycleRequest;
import org.hyperledger.fabric.sdk.Orderer;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.QueryByChaincodeRequest;
import org.hyperledger.fabric.sdk.QueryLifecycleQueryChaincodeDefinitionRequest;
import org.hyperledger.fabric.sdk.QuerySCCRequest;
import org.hyperledger.fabric.sdk.QueuedBlockEvent;
import org.hyperledger.fabric.sdk.SDKUtils;
import org.hyperledger.fabric.sdk.ServiceDiscovery;
import org.hyperledger.fabric.sdk.TransactionInfo;
import org.hyperledger.fabric.sdk.TransactionProposalRequest;
import org.hyperledger.fabric.sdk.TransactionRequest;
import org.hyperledger.fabric.sdk.UpdateChannelConfiguration;
import org.hyperledger.fabric.sdk.UpgradeProposalRequest;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.exception.CryptoException;
import org.hyperledger.fabric.sdk.exception.EventingException;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.exception.ServiceDiscoveryException;
import org.hyperledger.fabric.sdk.exception.TransactionEventException;
import org.hyperledger.fabric.sdk.exception.TransactionException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.DiagnosticFileDumper;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.security.certgen.TLSCertificateBuilder;
import org.hyperledger.fabric.sdk.security.certgen.TLSCertificateKeyPair;
import org.hyperledger.fabric.sdk.transaction.GetConfigBlockBuilder;
import org.hyperledger.fabric.sdk.transaction.InstallProposalBuilder;
import org.hyperledger.fabric.sdk.transaction.InstantiateProposalBuilder;
import org.hyperledger.fabric.sdk.transaction.JoinPeerProposalBuilder;
import org.hyperledger.fabric.sdk.transaction.LifecycleApproveChaincodeDefinitionForMyOrgProposalBuilder;
import org.hyperledger.fabric.sdk.transaction.LifecycleCheckCommitReadinessBuilder;
import org.hyperledger.fabric.sdk.transaction.LifecycleCommitChaincodeDefinitionProposalBuilder;
import org.hyperledger.fabric.sdk.transaction.LifecycleInstallProposalBuilder;
import org.hyperledger.fabric.sdk.transaction.LifecycleQueryChaincodeDefinitionBuilder;
import org.hyperledger.fabric.sdk.transaction.LifecycleQueryChaincodeDefinitionsBuilder;
import org.hyperledger.fabric.sdk.transaction.LifecycleQueryInstalledChaincodeBuilder;
import org.hyperledger.fabric.sdk.transaction.LifecycleQueryInstalledChaincodesBuilder;
import org.hyperledger.fabric.sdk.transaction.ProposalBuilder;
import org.hyperledger.fabric.sdk.transaction.ProtoUtils;
import org.hyperledger.fabric.sdk.transaction.QueryCollectionsConfigBuilder;
import org.hyperledger.fabric.sdk.transaction.QueryInstalledChaincodesBuilder;
import org.hyperledger.fabric.sdk.transaction.QueryInstantiatedChaincodesBuilder;
import org.hyperledger.fabric.sdk.transaction.QueryPeerChannelsBuilder;
import org.hyperledger.fabric.sdk.transaction.TransactionBuilder;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;
import org.hyperledger.fabric.sdk.transaction.UpgradeProposalBuilder;

public class Channel
implements Serializable {
    private static final long serialVersionUID = -3266164166893832538L;
    private static final Config config = Config.getConfig();
    private static final Log logger = LogFactory.getLog(Channel.class);
    private static final boolean IS_DEBUG_LEVEL = logger.isDebugEnabled();
    private static final boolean IS_WARN_LEVEL = logger.isWarnEnabled();
    private static final boolean IS_TRACE_LEVEL = logger.isTraceEnabled();
    private static final DiagnosticFileDumper diagnosticFileDumper = IS_TRACE_LEVEL ? config.getDiagnosticFileDumper() : null;
    private static final String SYSTEM_CHANNEL_NAME = "";
    private static final long ORDERER_RETRY_WAIT_TIME = config.getOrdererRetryWaitTime();
    private static final long CHANNEL_CONFIG_WAIT_TIME = config.getChannelConfigWaitTime();
    private static final Random RANDOM = new Random();
    private static final String BLOCK_LISTENER_TAG = "BLOCK_LISTENER_HANDLE";
    private static final long DELTA_SWEEP = config.getTransactionListenerCleanUpTimeout();
    private static final String CHAINCODE_EVENTS_TAG = "CHAINCODE_EVENTS_HANDLE";
    final Collection<Orderer> orderers = Collections.synchronizedCollection(new LinkedList());
    private transient Map<String, Orderer> ordererEndpointMap = Collections.synchronizedMap(new HashMap());
    private final String name;
    private transient String toString;
    private final Collection<Peer> peers = Collections.synchronizedSet(new HashSet());
    private final Map<Peer, PeerOptions> peerOptionsMap = Collections.synchronizedMap(new HashMap());
    private transient Map<String, Peer> peerEndpointMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, Collection<Peer>> peerMSPIDMap = new HashMap<String, Collection<Peer>>();
    private final Map<String, Collection<Orderer>> ordererMSPIDMap = new HashMap<String, Collection<Orderer>>();
    private final Map<Peer.PeerRole, Set<Peer>> peerRoleSetMap = Collections.synchronizedMap(new HashMap());
    private transient String chaincodeEventUpgradeListenerHandle;
    private transient String transactionListenerProcessorHandle;
    private final boolean systemChannel;
    private transient LinkedHashMap<String, ChaincodeEventListenerEntry> chainCodeListeners = new LinkedHashMap();
    transient HFClient client;
    private Set<String> discoveryEndpoints = Collections.synchronizedSet(new HashSet());
    transient Thread eventQueueThread = null;
    private volatile transient boolean initialized = false;
    private volatile transient boolean shutdown = false;
    private transient Common.Block genesisBlock;
    private transient Map<String, MSP> msps = new HashMap<String, MSP>();
    private transient ChannelEventQue channelEventQue = new ChannelEventQue();
    private transient LinkedHashMap<String, BL> blockListeners = new LinkedHashMap();
    private transient LinkedHashMap<String, LinkedList<TL>> txListeners = new LinkedHashMap();
    private transient ScheduledFuture<?> sweeper = null;
    private transient ScheduledExecutorService sweeperExecutorService;
    private transient String blh = null;
    private transient ServiceDiscovery serviceDiscovery;
    private static final boolean asLocalhost = config.discoverAsLocalhost();
    volatile transient long lastChaincodeUpgradeEventBlock;
    transient SDPeerAddition sdPeerAddition;
    private transient SDOrdererAddition sdOrdererAddition;
    private Properties serviceDiscoveryProperties;
    private transient ServiceDiscovery.EndorsementSelector endorsementSelector;
    private volatile long lastBlock;

    private Channel(String name, HFClient hfClient, Orderer orderer, ChannelConfiguration channelConfiguration, byte[][] signers) throws InvalidArgumentException, TransactionException {
        this(name, hfClient, false);
        logger.debug((Object)String.format("Creating new channel %s on the Fabric", name));
        Channel ordererChannel = orderer.getChannel();
        try {
            this.addOrderer(orderer);
            Common.Envelope ccEnvelope = Common.Envelope.parseFrom(channelConfiguration.getChannelConfigurationAsBytes());
            Common.Payload ccPayload = Common.Payload.parseFrom(ccEnvelope.getPayload());
            Common.ChannelHeader ccChannelHeader = Common.ChannelHeader.parseFrom(ccPayload.getHeader().getChannelHeader());
            if (ccChannelHeader.getType() != Common.HeaderType.CONFIG_UPDATE.getNumber()) {
                throw new InvalidArgumentException(String.format("Creating channel; %s expected config block type %s, but got: %s", new Object[]{name, Common.HeaderType.CONFIG_UPDATE.name(), Common.HeaderType.forNumber(ccChannelHeader.getType())}));
            }
            if (!name.equals(ccChannelHeader.getChannelId())) {
                throw new InvalidArgumentException(String.format("Expected config block for channel: %s, but got: %s", name, ccChannelHeader.getChannelId()));
            }
            Configtx.ConfigUpdateEnvelope configUpdateEnv = Configtx.ConfigUpdateEnvelope.parseFrom(ccPayload.getData());
            ByteString configUpdate = configUpdateEnv.getConfigUpdate();
            this.sendUpdateChannel(this.client.getUserContext(), configUpdate.toByteArray(), signers, orderer);
            this.getGenesisBlock(orderer);
            if (this.genesisBlock == null) {
                throw new TransactionException(String.format("New channel %s error. Genesis bock returned null", name));
            }
            logger.debug((Object)String.format("Created new channel %s on the Fabric done.", name));
        }
        catch (TransactionException e) {
            orderer.unsetChannel();
            if (null != ordererChannel) {
                orderer.setChannel(ordererChannel);
            }
            logger.error((Object)String.format("Channel %s error: %s", name, e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            orderer.unsetChannel();
            if (null != ordererChannel) {
                orderer.setChannel(ordererChannel);
            }
            String msg = String.format("Channel %s error: %s", name, e.getMessage());
            logger.error((Object)msg, (Throwable)e);
            throw new TransactionException(msg, e);
        }
    }

    Channel(String name, HFClient client) throws InvalidArgumentException {
        this(name, client, false);
    }

    private Channel(String name, HFClient client, boolean systemChannel) throws InvalidArgumentException {
        for (Peer.PeerRole peerRole : EnumSet.allOf(Peer.PeerRole.class)) {
            this.peerRoleSetMap.put(peerRole, Collections.synchronizedSet(new HashSet()));
        }
        this.lastChaincodeUpgradeEventBlock = 0L;
        this.sdPeerAddition = null;
        this.sdOrdererAddition = null;
        this.serviceDiscoveryProperties = new Properties();
        this.endorsementSelector = ServiceDiscovery.DEFAULT_ENDORSEMENT_SELECTION;
        this.lastBlock = -1L;
        this.systemChannel = systemChannel;
        if (systemChannel) {
            name = SYSTEM_CHANNEL_NAME;
            this.initialized = true;
        } else if (Utils.isNullOrEmpty(name)) {
            throw new InvalidArgumentException("Channel name is invalid can not be null or empty.");
        }
        if (null == client) {
            throw new InvalidArgumentException("Channel client is invalid can not be null.");
        }
        this.name = name;
        this.client = client;
        this.toString = "Channel{id: " + config.getNextID() + ", name: " + name + "}";
        logger.debug((Object)String.format("Creating channel: %s, client context %s", this.isSystemChannel() ? "SYSTEM_CHANNEL" : name, client.getUserContext().getName()));
    }

    static Channel newSystemChannel(HFClient client) throws InvalidArgumentException {
        return new Channel(SYSTEM_CHANNEL_NAME, client, true);
    }

    static Channel createNewInstance(String name, HFClient clientContext) throws InvalidArgumentException {
        return new Channel(name, clientContext);
    }

    static Channel createNewInstance(String name, HFClient hfClient, Orderer orderer, ChannelConfiguration channelConfiguration, byte[] ... signers) throws InvalidArgumentException, TransactionException {
        return new Channel(name, hfClient, orderer, channelConfiguration, signers);
    }

    private static void checkHandle(String tag, String handle) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(handle)) {
            throw new InvalidArgumentException("Handle is invalid.");
        }
        if (!handle.startsWith(tag) || !handle.endsWith(tag)) {
            throw new InvalidArgumentException("Handle is wrong type.");
        }
    }

    public String toString() {
        return this.toString;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.toString = "Channel{id: " + config.getNextID() + ", name: " + this.name + "}";
        this.initialized = false;
        this.lastChaincodeUpgradeEventBlock = 0L;
        this.shutdown = false;
        this.msps = new HashMap<String, MSP>();
        this.txListeners = new LinkedHashMap();
        this.channelEventQue = new ChannelEventQue();
        this.blockListeners = new LinkedHashMap();
        this.peerEndpointMap = Collections.synchronizedMap(new HashMap());
        this.setSDPeerAddition(new SDOPeerDefaultAddition(this.getServiceDiscoveryProperties()));
        this.endorsementSelector = ServiceDiscovery.DEFAULT_ENDORSEMENT_SELECTION;
        this.chainCodeListeners = new LinkedHashMap();
        for (Peer peer : this.peers) {
            this.peerEndpointMap.put(peer.getEndpoint(), peer);
        }
        this.ordererEndpointMap = Collections.synchronizedMap(new HashMap());
        for (Orderer orderer : this.orderers) {
            this.ordererEndpointMap.put(orderer.getEndpoint(), orderer);
        }
    }

    public void updateChannelConfiguration(UpdateChannelConfiguration updateChannelConfiguration, byte[] ... signers) throws TransactionException, InvalidArgumentException {
        this.updateChannelConfiguration(this.client.getUserContext(), updateChannelConfiguration, this.getRandomOrderer(), signers);
    }

    public void updateChannelConfiguration(UpdateChannelConfiguration updateChannelConfiguration, Orderer orderer, byte[] ... signers) throws TransactionException, InvalidArgumentException {
        this.updateChannelConfiguration(this.client.getUserContext(), updateChannelConfiguration, orderer, signers);
    }

    public void updateChannelConfiguration(User userContext, UpdateChannelConfiguration updateChannelConfiguration, Orderer orderer, byte[] ... signers) throws TransactionException, InvalidArgumentException {
        this.checkChannelState();
        this.checkOrderer(orderer);
        User.userContextCheck(userContext);
        try {
            long startLastConfigIndex = this.getLastConfigIndex(this.newTransactionContext(userContext), orderer);
            logger.trace((Object)String.format("startLastConfigIndex: %d. Channel config wait time is: %d", startLastConfigIndex, CHANNEL_CONFIG_WAIT_TIME));
            this.sendUpdateChannel(userContext, updateChannelConfiguration.getUpdateChannelConfigurationAsBytes(), signers, orderer);
            long currentLastConfigIndex = -1L;
            long nanoTimeStart = System.nanoTime();
            do {
                if ((currentLastConfigIndex = this.getLastConfigIndex(this.newTransactionContext(userContext), orderer)) == startLastConfigIndex) {
                    long duration = TimeUnit.MILLISECONDS.convert(System.nanoTime() - nanoTimeStart, TimeUnit.NANOSECONDS);
                    if (duration > CHANNEL_CONFIG_WAIT_TIME) {
                        logger.warn((Object)String.format("Channel %s did not get updated last config after %d ms, Config wait time: %d ms. startLastConfigIndex: %d, currentLastConfigIndex: %d ", this.name, duration, CHANNEL_CONFIG_WAIT_TIME, startLastConfigIndex, currentLastConfigIndex));
                        currentLastConfigIndex = startLastConfigIndex - 1L;
                    } else {
                        try {
                            Thread.sleep(ORDERER_RETRY_WAIT_TIME);
                        }
                        catch (InterruptedException e) {
                            TransactionException te = new TransactionException("update channel thread Sleep", e);
                            logger.warn((Object)te.getMessage(), (Throwable)te);
                        }
                    }
                }
                logger.trace((Object)String.format("currentLastConfigIndex: %d", currentLastConfigIndex));
            } while (currentLastConfigIndex == startLastConfigIndex);
        }
        catch (TransactionException e) {
            logger.error((Object)String.format("Channel %s error: %s", this.name, e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            String msg = String.format("Channel %s error: %s", this.name, e.getMessage());
            logger.error((Object)msg, (Throwable)e);
            throw new TransactionException(msg, e);
        }
    }

    private void sendUpdateChannel(User userContext, byte[] configupdate, byte[][] signers, Orderer orderer) throws TransactionException, InvalidArgumentException {
        logger.debug((Object)String.format("Channel %s sendUpdateChannel", this.name));
        this.checkOrderer(orderer);
        try {
            long nanoTimeStart = System.nanoTime();
            int statusCode = 0;
            do {
                TransactionContext transactionContext = this.newTransactionContext(userContext);
                Configtx.ConfigUpdateEnvelope.Builder configUpdateEnvBuilder = Configtx.ConfigUpdateEnvelope.newBuilder();
                configUpdateEnvBuilder.setConfigUpdate(ByteString.copyFrom((byte[])configupdate));
                for (byte[] signer : signers) {
                    configUpdateEnvBuilder.addSignatures(Configtx.ConfigSignature.parseFrom(signer));
                }
                ByteString sigHeaderByteString = ProtoUtils.getSignatureHeaderAsByteString(transactionContext);
                Common.ChannelHeader payloadChannelHeader = ProtoUtils.createChannelHeader(Common.HeaderType.CONFIG_UPDATE, transactionContext.getTxID(), this.name, transactionContext.getEpoch(), transactionContext.getFabricTimestamp(), null, null);
                Common.Header payloadHeader = Common.Header.newBuilder().setChannelHeader(payloadChannelHeader.toByteString()).setSignatureHeader(sigHeaderByteString).build();
                ByteString payloadByteString = Common.Payload.newBuilder().setHeader(payloadHeader).setData(configUpdateEnvBuilder.build().toByteString()).build().toByteString();
                ByteString payloadSignature = transactionContext.signByteStrings(payloadByteString);
                Common.Envelope payloadEnv = Common.Envelope.newBuilder().setSignature(payloadSignature).setPayload(payloadByteString).build();
                Ab.BroadcastResponse trxResult = orderer.sendTransaction(payloadEnv);
                statusCode = trxResult.getStatusValue();
                logger.debug((Object)String.format("Channel %s sendUpdateChannel %d", this.name, statusCode));
                if (statusCode == 404 || statusCode == 503) {
                    long duration = TimeUnit.MILLISECONDS.convert(System.nanoTime() - nanoTimeStart, TimeUnit.NANOSECONDS);
                    if (duration > CHANNEL_CONFIG_WAIT_TIME) {
                        String info = trxResult.getInfo();
                        if (null == info) {
                            info = SYSTEM_CHANNEL_NAME;
                        }
                        throw new TransactionException(String.format("Channel %s update error timed out after %d ms. Status value %d. Status %s. %s", this.name, duration, statusCode, trxResult.getStatus().name(), info));
                    }
                    try {
                        Thread.sleep(ORDERER_RETRY_WAIT_TIME);
                    }
                    catch (InterruptedException e) {
                        TransactionException te = new TransactionException("update thread Sleep", e);
                        logger.warn((Object)te.getMessage(), (Throwable)te);
                    }
                    continue;
                }
                if (200 == statusCode) continue;
                String info = trxResult.getInfo();
                if (null == info) {
                    info = SYSTEM_CHANNEL_NAME;
                }
                throw new TransactionException(String.format("New channel %s error. StatusValue %d. Status %s. %s", this.name, statusCode, SYSTEM_CHANNEL_NAME + (Object)((Object)trxResult.getStatus()), info));
            } while (200 != statusCode);
        }
        catch (TransactionException e) {
            logger.error((Object)String.format("Channel %s error: %s", this.name, e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            String msg = String.format("Channel %s error: %s", this.name, e.getMessage());
            logger.error((Object)msg, (Throwable)e);
            throw new TransactionException(msg, e);
        }
    }

    Enrollment getEnrollment() {
        return this.client.getUserContext().getEnrollment();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getName() {
        return this.name;
    }

    public Channel addPeer(Peer peer) throws InvalidArgumentException {
        return this.addPeer(peer, PeerOptions.createPeerOptions());
    }

    public Channel addPeer(Peer peer, PeerOptions peerOptions) throws InvalidArgumentException {
        if (this.shutdown) {
            throw new InvalidArgumentException(String.format("Channel %s has been shutdown.", this.name));
        }
        if (null == peer) {
            throw new InvalidArgumentException("Peer is invalid can not be null.");
        }
        if (peer.getChannel() != null && peer.getChannel() != this) {
            throw new InvalidArgumentException(String.format("Peer already connected to channel %s", peer.getChannel().getName()));
        }
        if (null == peerOptions) {
            throw new InvalidArgumentException("peerOptions is invalid can not be null.");
        }
        logger.debug((Object)String.format("%s adding peer: %s, peerOptions: %s", this.toString(), peer, SYSTEM_CHANNEL_NAME + peerOptions));
        peer.setChannel(this);
        this.peers.add(peer);
        this.peerOptionsMap.put(peer, peerOptions.clone());
        this.peerEndpointMap.put(peer.getEndpoint(), peer);
        this.addPeerMSPIDMap(peer);
        if (peerOptions.getPeerRoles().contains((Object)Peer.PeerRole.SERVICE_DISCOVERY)) {
            Properties properties = peer.getProperties();
            if (properties == null || properties.isEmpty() || Utils.isNullOrEmpty(properties.getProperty("clientCertFile")) && !properties.containsKey("clientCertBytes")) {
                TLSCertificateBuilder tLSCertificateBuilder = new TLSCertificateBuilder();
                TLSCertificateKeyPair tlsCertificateKeyPair = tLSCertificateBuilder.clientCert();
                peer.setTLSCertificateKeyPair(tlsCertificateKeyPair);
            }
            this.discoveryEndpoints.add(peer.getEndpoint());
        }
        for (Map.Entry entry : this.peerRoleSetMap.entrySet()) {
            if (!peerOptions.getPeerRoles().contains(entry.getKey())) continue;
            ((Set)entry.getValue()).add(peer);
        }
        if (this.isInitialized() && peerOptions.getPeerRoles().contains((Object)Peer.PeerRole.EVENT_SOURCE)) {
            try {
                peer.initiateEventing(this.newTransactionContext(), this.getPeersOptions(peer));
            }
            catch (TransactionException e) {
                logger.error((Object)String.format("Error channel %s enabling eventing on peer %s", this.toString(), peer));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPeerMSPIDMap(Peer peer) {
        String mspid;
        Properties properties = peer.getProperties();
        if (null != properties && !Utils.isNullOrEmpty(mspid = properties.getProperty("org.hyperledger.fabric.sdk.peer.organization_mspid"))) {
            logger.debug((Object)String.format("Channel %s mapping peer %s to mspid %s", this.name, peer, mspid));
            Map<String, Collection<Peer>> map = this.peerMSPIDMap;
            synchronized (map) {
                this.peerMSPIDMap.computeIfAbsent(mspid, k -> new HashSet()).add(peer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePeerMSPIDMap(Peer peer) {
        String mspid;
        Properties properties = peer.getProperties();
        if (null != properties && !Utils.isNullOrEmpty(mspid = properties.getProperty("org.hyperledger.fabric.sdk.peer.organization_mspid"))) {
            logger.debug((Object)String.format("Channel %s removing mapping peer %s to mspid %s", this.name, peer, mspid));
            Map<String, Collection<Peer>> map = this.peerMSPIDMap;
            synchronized (map) {
                Collection<Peer> peers = this.peerMSPIDMap.get(mspid);
                if (peers != null) {
                    peers.remove(peer);
                    if (peers.isEmpty()) {
                        this.peerMSPIDMap.remove(mspid);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Peer> getPeersForOrganization(String mspid) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(mspid)) {
            throw new InvalidArgumentException("The mspid parameter may not be null or empty string.");
        }
        Map<String, Collection<Peer>> map = this.peerMSPIDMap;
        synchronized (map) {
            Collection<Peer> peers = this.peerMSPIDMap.get(mspid);
            if (peers == null) {
                return Collections.emptySet();
            }
            return new LinkedList<Peer>(peers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getPeersOrganizationMSPIDs() {
        Map<String, Collection<Peer>> map = this.peerMSPIDMap;
        synchronized (map) {
            return new LinkedList<String>(this.peerMSPIDMap.keySet());
        }
    }

    public Channel joinPeer(Peer peer) throws ProposalException {
        return this.joinPeer(peer, PeerOptions.createPeerOptions());
    }

    private Collection<Peer> getEventingPeers() {
        return Collections.unmodifiableCollection((Collection)this.peerRoleSetMap.get((Object)Peer.PeerRole.EVENT_SOURCE));
    }

    private Collection<Peer> getEndorsingPeers() {
        return Collections.unmodifiableCollection((Collection)this.peerRoleSetMap.get((Object)Peer.PeerRole.ENDORSING_PEER));
    }

    private Collection<Peer> getChaincodePeers() {
        return Collections.unmodifiableCollection(this.getPeers(EnumSet.of(Peer.PeerRole.CHAINCODE_QUERY, Peer.PeerRole.ENDORSING_PEER)));
    }

    private Collection<Peer> getChaincodeQueryPeers() {
        return Collections.unmodifiableCollection((Collection)this.peerRoleSetMap.get((Object)Peer.PeerRole.CHAINCODE_QUERY));
    }

    private Collection<Peer> getLedgerQueryPeers() {
        return Collections.unmodifiableCollection((Collection)this.peerRoleSetMap.get((Object)Peer.PeerRole.LEDGER_QUERY));
    }

    private Collection<Peer> getServiceDiscoveryPeers() {
        return Collections.unmodifiableCollection((Collection)this.peerRoleSetMap.get((Object)Peer.PeerRole.SERVICE_DISCOVERY));
    }

    public Channel joinPeer(Peer peer, PeerOptions peerOptions) throws ProposalException {
        try {
            return this.joinPeer(this.getRandomOrderer(), peer, peerOptions);
        }
        catch (ProposalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProposalException(e);
        }
    }

    public Channel joinPeer(Orderer orderer, Peer peer, PeerOptions peerOptions) throws ProposalException {
        logger.debug((Object)String.format("Channel %s joining peer %s, url: %s", this.name, peer.getName(), peer.getUrl()));
        if (this.shutdown) {
            throw new ProposalException(String.format("Channel %s has been shutdown.", this.name));
        }
        Channel peerChannel = peer.getChannel();
        if (null != peerChannel && peerChannel != this) {
            throw new ProposalException(String.format("Can not add peer %s to channel %s because it already belongs to channel %s.", peer.getName(), this.name, peerChannel.getName()));
        }
        logger.info((Object)String.format("%s joining %s.", this.toString(), peer));
        if (this.genesisBlock == null && this.orderers.isEmpty()) {
            ProposalException e = new ProposalException("Channel missing genesis block and no orderers configured");
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.genesisBlock = this.getGenesisBlock(orderer);
            logger.debug((Object)String.format("Channel %s got genesis block", this.name));
            Channel systemChannel = Channel.newSystemChannel(this.client);
            TransactionContext transactionContext = systemChannel.newTransactionContext();
            ProposalPackage.Proposal joinProposal = JoinPeerProposalBuilder.newBuilder().context(transactionContext).genesisBlock(this.genesisBlock).build();
            logger.debug((Object)"Getting signed proposal.");
            ProposalPackage.SignedProposal signedProposal = this.getSignedProposal(transactionContext, joinProposal);
            logger.debug((Object)"Got signed proposal.");
            this.addPeer(peer, peerOptions);
            Collection<ProposalResponse> resp = this.sendProposalToPeers(new ArrayList<Peer>(Collections.singletonList(peer)), signedProposal, transactionContext);
            ProposalResponse pro = resp.iterator().next();
            if (pro.getStatus() != ChaincodeResponse.Status.SUCCESS) {
                this.removePeerInternal(peer);
                throw new ProposalException(String.format("Join peer to channel %s failed.  Status %s, details: %s", this.name, pro.getStatus().toString(), pro.getMessage()));
            }
            logger.info((Object)String.format("Peer %s joined into channel %s", peer, this.toString()));
        }
        catch (ProposalException e) {
            logger.error((Object)String.format("%s removing peer %s due to exception %s", this.toString(), peer, e.getMessage()));
            this.removePeerInternal(peer);
            logger.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)String.format("%s removing peer %s due to exception %s", this.toString(), peer, e.getMessage()));
            this.peers.remove(peer);
            this.removePeerMSPIDMap(peer);
            logger.error((Object)e);
            throw new ProposalException(e.getMessage(), e);
        }
        return this;
    }

    private Common.Block getConfigBlock(List<Peer> peers) throws ProposalException, InvalidArgumentException {
        return this.getConfigBlock(this.newTransactionContext(), peers);
    }

    private Common.Block getConfigBlock(TransactionContext transactionContext, List<Peer> peers) throws ProposalException {
        if (this.shutdown) {
            throw new ProposalException(String.format("Channel %s has been shutdown.", this.name));
        }
        if (peers.isEmpty()) {
            throw new ProposalException("No peers go get config block");
        }
        ProposalPackage.SignedProposal signedProposal = null;
        try {
            transactionContext.verify(false);
            ProposalPackage.Proposal proposal = GetConfigBlockBuilder.newBuilder().context(transactionContext).channelId(this.name).build();
            logger.debug((Object)"Getting signed proposal.");
            signedProposal = this.getSignedProposal(transactionContext, proposal);
            logger.debug((Object)"Got signed proposal.");
        }
        catch (Exception e) {
            throw new ProposalException(e);
        }
        ProposalException lastException = new ProposalException(String.format("getConfigBlock for channel %s failed.", this.name));
        for (Peer peer : peers) {
            try {
                Collection<ProposalResponse> resp = this.sendProposalToPeers(new ArrayList<Peer>(Collections.singletonList(peer)), signedProposal, transactionContext);
                if (!resp.isEmpty()) {
                    ProposalResponse pro = resp.iterator().next();
                    if (pro.getStatus() == ChaincodeResponse.Status.SUCCESS) {
                        logger.trace((Object)String.format("getConfigBlock from peer %s on channel %s success", peer, this.name));
                        return Common.Block.parseFrom(pro.getProposalResponse().getResponse().getPayload().toByteArray());
                    }
                    lastException = new ProposalException(String.format("getConfigBlock for channel %s failed with peer %s.  Status %s, details: %s", this.name, peer.getName(), pro.getStatus().toString(), pro.getMessage()));
                    logger.warn((Object)lastException.getMessage());
                    continue;
                }
                logger.warn((Object)String.format("Got empty proposals from %s", peer));
            }
            catch (Exception e) {
                lastException = new ProposalException(String.format("getConfigBlock for channel %s failed with peer %s.", this.name, peer.getName()), e);
                logger.warn((Object)lastException.getMessage());
            }
        }
        throw lastException;
    }

    public void removePeer(Peer peer) throws InvalidArgumentException {
        if (this.shutdown) {
            throw new InvalidArgumentException(String.format("Can not remove peer from channel %s already shutdown.", this.name));
        }
        logger.debug((Object)String.format("removePeer %s from channel %s", peer, this.toString()));
        this.checkPeer(peer);
        this.removePeerInternal(peer);
        peer.shutdown(true);
    }

    private void removePeerInternal(Peer peer) {
        logger.debug((Object)String.format("RemovePeerInternal %s from channel %s", peer, this.toString()));
        this.peers.remove(peer);
        this.peerOptionsMap.remove(peer);
        this.peerEndpointMap.remove(peer.getEndpoint());
        this.removePeerMSPIDMap(peer);
        for (Set<Peer> peerRoleSet : this.peerRoleSetMap.values()) {
            peerRoleSet.remove(peer);
        }
        peer.unsetChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel addOrderer(Orderer orderer) throws InvalidArgumentException {
        String mspid;
        if (this.shutdown) {
            throw new InvalidArgumentException(String.format("Channel %s has been shutdown.", this.name));
        }
        if (null == orderer) {
            throw new InvalidArgumentException("Orderer is invalid can not be null.");
        }
        logger.debug((Object)String.format("Channel %s adding %s", this.toString(), orderer.toString()));
        orderer.setChannel(this);
        this.ordererEndpointMap.put(orderer.getEndpoint(), orderer);
        this.orderers.add(orderer);
        Properties properties = orderer.getProperties();
        if (properties != null && !Utils.isNullOrEmpty(mspid = properties.getProperty("org.hyperledger.fabric.sdk.orderer.organization_mspid"))) {
            Map<String, Collection<Orderer>> map = this.ordererMSPIDMap;
            synchronized (map) {
                this.ordererMSPIDMap.computeIfAbsent(mspid, k -> new HashSet()).add(orderer);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOrderer(Orderer orderer) throws InvalidArgumentException {
        String mspid;
        if (this.shutdown) {
            throw new InvalidArgumentException(String.format("Channel %s has been shutdown.", this.name));
        }
        if (null == orderer) {
            throw new InvalidArgumentException("Orderer is invalid can not be null.");
        }
        logger.debug((Object)String.format("Channel %s removing %s", this.toString(), orderer.toString()));
        this.ordererEndpointMap.remove(orderer.getEndpoint());
        this.orderers.remove(orderer);
        orderer.shutdown(true);
        Properties properties = orderer.getProperties();
        if (properties != null && !Utils.isNullOrEmpty(mspid = properties.getProperty("org.hyperledger.fabric.sdk.orderer.organization_mspid"))) {
            Map<String, Collection<Orderer>> map = this.ordererMSPIDMap;
            synchronized (map) {
                Collection<Orderer> orderers = this.ordererMSPIDMap.get(mspid);
                orderers.remove(orderer);
                if (orderers.isEmpty()) {
                    this.ordererMSPIDMap.remove(mspid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Orderer> getOrderersForOrganization(String mspid) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(mspid)) {
            throw new InvalidArgumentException("The mspid parameter may not be null or empty string.");
        }
        Map<String, Collection<Orderer>> map = this.ordererMSPIDMap;
        synchronized (map) {
            Collection<Orderer> orderers = this.ordererMSPIDMap.get(mspid);
            if (orderers == null) {
                return Collections.emptySet();
            }
            return new LinkedList<Orderer>(orderers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getOrderersOrganizationMSPIDs() {
        Map<String, Collection<Orderer>> map = this.ordererMSPIDMap;
        synchronized (map) {
            return new LinkedList<String>(this.ordererMSPIDMap.keySet());
        }
    }

    public PeerOptions getPeersOptions(Peer peer) {
        PeerOptions ret = this.peerOptionsMap.get(peer);
        if (ret != null) {
            ret = ret.clone();
        }
        return ret;
    }

    public Collection<Peer> getPeers() {
        return Collections.unmodifiableCollection(new ArrayList<Peer>(this.peers));
    }

    public Collection<Peer> getPeers(EnumSet<Peer.PeerRole> roles) {
        HashSet ret = new HashSet(this.getPeers().size());
        for (Peer.PeerRole peerRole : roles) {
            ret.addAll(this.peerRoleSetMap.get((Object)peerRole));
        }
        return Collections.unmodifiableCollection(ret);
    }

    PeerOptions setPeerOptions(Peer peer, PeerOptions peerOptions) throws InvalidArgumentException {
        if (this.initialized) {
            throw new InvalidArgumentException(String.format("Channel %s already initialized.", this.name));
        }
        this.checkPeer(peer);
        PeerOptions ret = this.getPeersOptions(peer);
        this.removePeerInternal(peer);
        this.addPeer(peer, peerOptions);
        return ret;
    }

    private synchronized boolean isChaincodeUpgradeEvent(long blockNumber) {
        boolean ret = false;
        if (blockNumber > this.lastChaincodeUpgradeEventBlock) {
            this.lastChaincodeUpgradeEventBlock = blockNumber;
            ret = true;
        }
        return ret;
    }

    public Channel initialize() throws InvalidArgumentException, TransactionException {
        logger.debug((Object)String.format("Channel %s initialize shutdown %b", this.name, this.shutdown));
        if (this.isInitialized()) {
            return this;
        }
        if (this.shutdown) {
            throw new InvalidArgumentException(String.format("Channel %s has been shutdown.", this.name));
        }
        if (Utils.isNullOrEmpty(this.name)) {
            throw new InvalidArgumentException("Can not initialize channel without a valid name.");
        }
        if (this.client == null) {
            throw new InvalidArgumentException("Can not initialize channel without a client object.");
        }
        User.userContextCheck(this.client.getUserContext());
        if (null == this.sdOrdererAddition) {
            this.setSDOrdererAddition(new SDOrdererDefaultAddition(this.getServiceDiscoveryProperties()));
        }
        if (null == this.sdPeerAddition) {
            this.setSDPeerAddition(new SDOPeerDefaultAddition(this.getServiceDiscoveryProperties()));
        }
        if (this.peers.isEmpty()) {
            logger.warn((Object)String.format("Channel %s has no peers during initialization.", this.name));
        } else {
            try {
                this.loadCACertificates(false);
            }
            catch (Exception e) {
                logger.warn((Object)String.format("Channel %s could not load peer CA certificates from any peers.", this.name));
            }
        }
        Collection<Peer> serviceDiscoveryPeers = this.getServiceDiscoveryPeers();
        if (!serviceDiscoveryPeers.isEmpty()) {
            logger.trace((Object)"Starting service discovery.");
            this.serviceDiscovery = new ServiceDiscovery(this, serviceDiscoveryPeers, this.newTransactionContext());
            this.serviceDiscovery.fullNetworkDiscovery(true);
            this.serviceDiscovery.run();
            logger.trace((Object)"Completed. service discovery.");
        }
        try {
            logger.debug((Object)String.format("Eventque started %s", SYSTEM_CHANNEL_NAME + this.eventQueueThread));
            for (Peer peer : this.getEventingPeers()) {
                peer.initiateEventing(this.newTransactionContext(), this.getPeersOptions(peer));
            }
            this.transactionListenerProcessorHandle = this.registerTransactionListenerProcessor();
            logger.debug((Object)String.format("Channel %s registerTransactionListenerProcessor completed", this.name));
            if (this.serviceDiscovery != null) {
                this.chaincodeEventUpgradeListenerHandle = this.registerChaincodeEventListener(Pattern.compile("^lscc$"), Pattern.compile("^upgrade$"), (handle, blockEvent, chaincodeEvent) -> {
                    logger.debug((Object)String.format("Channel %s got upgrade chaincode event", this.name));
                    if (!this.isShutdown() && this.isChaincodeUpgradeEvent(blockEvent.getBlockNumber())) {
                        this.getExecutorService().execute(() -> this.serviceDiscovery.fullNetworkDiscovery(true));
                    }
                });
            }
            this.startEventQue();
            logger.info((Object)String.format("Channel %s eventThread started shutdown: %b  thread: %s ", this.toString(), this.shutdown, this.eventQueueThread == null ? "null" : this.eventQueueThread.getName()));
            this.initialized = true;
            logger.debug((Object)String.format("Channel %s initialized", this.name));
            return this;
        }
        catch (Exception e) {
            TransactionException exp = new TransactionException(e);
            logger.error((Object)exp.getMessage(), (Throwable)exp);
            throw exp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sdUpdate(ServiceDiscovery.SDNetwork sdNetwork) throws InvalidArgumentException, ServiceDiscoveryException {
        if (this.shutdown) {
            return;
        }
        logger.debug((Object)String.format("Channel %s doing channel update for service discovery.", this.name));
        ArrayList<Orderer> remove = new ArrayList<Orderer>();
        for (Orderer orderer2 : this.getOrderers()) {
            if (sdNetwork.getOrdererEndpoints().contains(orderer2.getEndpoint())) continue;
            remove.add(orderer2);
        }
        remove.forEach(orderer -> {
            try {
                this.removeOrderer((Orderer)orderer);
            }
            catch (InvalidArgumentException e) {
                logger.error((Object)e);
            }
        });
        for (final ServiceDiscovery.SDOrderer sdOrderer : sdNetwork.getSDOrderers()) {
            Orderer orderer3 = this.ordererEndpointMap.get(sdOrderer.getEndPoint());
            if (this.shutdown) {
                return;
            }
            if (null != orderer3) continue;
            logger.debug((Object)String.format("Channel %s doing channel update adding new orderer mspid: %s, endpoint: %s", this.name, sdOrderer.getMspid(), sdOrderer.getEndPoint()));
            this.sdOrdererAddition.addOrderer(new SDOrdererAdditionInfo(){

                @Override
                public String getEndpoint() {
                    return sdOrderer.getEndPoint();
                }

                @Override
                public String getMspId() {
                    return sdOrderer.getMspid();
                }

                @Override
                public Channel getChannel() {
                    return Channel.this;
                }

                @Override
                public HFClient getClient() {
                    return Channel.this.client;
                }

                @Override
                public byte[][] getTLSCerts() {
                    Collection<byte[]> tlsCerts = sdOrderer.getTlsCerts();
                    return (byte[][])tlsCerts.toArray((T[])new byte[tlsCerts.size()][]);
                }

                @Override
                public byte[][] getTLSIntermediateCerts() {
                    Collection<byte[]> tlsCerts = sdOrderer.getTlsIntermediateCerts();
                    return (byte[][])tlsCerts.toArray((T[])new byte[tlsCerts.size()][]);
                }

                @Override
                public Map<String, Orderer> getEndpointMap() {
                    return Collections.unmodifiableMap(Channel.this.ordererEndpointMap);
                }

                @Override
                public Properties getProperties() {
                    return sdOrderer.getProperties();
                }

                @Override
                public boolean isTLS() {
                    return sdOrderer.isTLS();
                }
            });
        }
        remove.clear();
        ArrayList<Peer> removePeers = new ArrayList<Peer>();
        for (Peer peer2 : this.getPeers()) {
            if (sdNetwork.getPeerEndpoints().contains(peer2.getEndpoint()) || this.discoveryEndpoints.contains(peer2.getEndpoint())) continue;
            logger.debug((Object)String.format("Channel %s doing channel update remove unfound peer endpoint %s ", this.name, peer2.getEndpoint()));
            removePeers.add(peer2);
        }
        removePeers.forEach(peer -> {
            try {
                this.removePeer((Peer)peer);
            }
            catch (InvalidArgumentException e) {
                logger.error((Object)e);
            }
        });
        for (final ServiceDiscovery.SDEndorser sdEndorser : sdNetwork.getEndorsers()) {
            final String sdEndorserMspid = sdEndorser.getMspid();
            Peer peer3 = this.peerEndpointMap.get(sdEndorser.getEndpoint());
            if (null == peer3) {
                if (this.shutdown) {
                    return;
                }
                logger.debug((Object)String.format("Channel %s doing channel update found new peer mspid: %s, endpoint: %s", this.name, sdEndorserMspid, sdEndorser.getEndpoint()));
                this.sdPeerAddition.addPeer(new SDPeerAdditionInfo(){

                    @Override
                    public String getMspId() {
                        return sdEndorserMspid;
                    }

                    @Override
                    public String getEndpoint() {
                        return sdEndorser.getEndpoint();
                    }

                    @Override
                    public Channel getChannel() {
                        return Channel.this;
                    }

                    @Override
                    public HFClient getClient() {
                        return Channel.this.client;
                    }

                    @Override
                    public byte[][] getTLSCerts() {
                        Collection<byte[]> tlsCerts = sdEndorser.getTLSCerts();
                        return (byte[][])tlsCerts.toArray((T[])new byte[tlsCerts.size()][]);
                    }

                    @Override
                    public byte[][] getTLSIntermediateCerts() {
                        Collection<byte[]> tlsCerts = sdEndorser.getTLSIntermediateCerts();
                        return (byte[][])tlsCerts.toArray((T[])new byte[tlsCerts.size()][]);
                    }

                    @Override
                    public Map<String, Peer> getEndpointMap() {
                        return Collections.unmodifiableMap(Channel.this.peerEndpointMap);
                    }

                    @Override
                    public String getName() {
                        return sdEndorser.getName();
                    }

                    @Override
                    public Properties getProperties() {
                        Properties properties = new Properties();
                        if (asLocalhost) {
                            properties.put("hostnameOverride", sdEndorser.getName().substring(0, sdEndorser.getName().lastIndexOf(58)));
                        }
                        return properties;
                    }

                    @Override
                    public boolean isTLS() {
                        return sdEndorser.isTLS();
                    }
                });
                continue;
            }
            if (!this.discoveryEndpoints.contains(sdEndorser.getEndpoint()) || peer3.getProperties() != null && !Utils.isNullOrEmpty(peer3.getProperties().getProperty("org.hyperledger.fabric.sdk.peer.organization_mspid"))) continue;
            Map<String, Collection<Peer>> map = this.peerMSPIDMap;
            synchronized (map) {
                this.peerMSPIDMap.computeIfAbsent(sdEndorserMspid, k -> new HashSet()).add(peer3);
            }
            Properties properties = peer3.getProperties();
            if (properties == null) {
                properties = new Properties();
            }
            properties.put("org.hyperledger.fabric.sdk.peer.organization_mspid", sdEndorserMspid);
            peer3.setProperties(properties);
        }
    }

    public Properties getServiceDiscoveryProperties() {
        return this.serviceDiscoveryProperties;
    }

    public void setServiceDiscoveryProperties(Properties serviceDiscoveryProperties) {
        this.serviceDiscoveryProperties = serviceDiscoveryProperties;
    }

    public SDOrdererAddition setSDOrdererAddition(SDOrdererAddition sdOrdererAddition) {
        SDOrdererAddition ret = this.sdOrdererAddition;
        this.sdOrdererAddition = sdOrdererAddition;
        if (null == ret) {
            ret = new SDOrdererDefaultAddition(this.getServiceDiscoveryProperties());
        }
        return ret;
    }

    public SDOrdererAddition getSDOrdererAddition() {
        if (null == this.sdOrdererAddition) {
            this.sdOrdererAddition = new SDOrdererDefaultAddition(this.getServiceDiscoveryProperties());
        }
        return this.sdOrdererAddition;
    }

    @SafeVarargs
    private static byte[] combineCerts(Collection<byte[]> ... certCollections) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            for (Collection<byte[]> certCollection : certCollections) {
                for (byte[] cert : certCollection) {
                    outputStream.write(cert);
                    outputStream.write(10);
                }
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }

    static Object findClientProp(Properties config, String prop, String mspid, String endpoint, String def) {
        String[] split = endpoint.split(":");
        String endpointHost = split[0];
        Object ret = config.getOrDefault((Object)("org.hyperledger.fabric.sdk.discovery.default." + prop), def);
        ret = config.getOrDefault((Object)("org.hyperledger.fabric.sdk.discovery.mspid." + prop + "." + mspid), ret);
        ret = config.getOrDefault((Object)("org.hyperledger.fabric.sdk.discovery.endpoint." + prop + "." + endpointHost), ret);
        ret = config.getOrDefault((Object)("org.hyperledger.fabric.sdk.discovery.endpoint." + prop + "." + endpoint), ret);
        return ret;
    }

    public SDPeerAddition setSDPeerAddition(SDPeerAddition sdPeerAddition) {
        SDPeerAddition ret = this.sdPeerAddition;
        this.sdPeerAddition = sdPeerAddition;
        if (ret == null) {
            ret = new SDOPeerDefaultAddition(this.getServiceDiscoveryProperties());
        }
        return ret;
    }

    public SDPeerAddition getSDPeerAddition() {
        if (null == this.sdPeerAddition) {
            this.sdPeerAddition = new SDOPeerDefaultAddition(this.getServiceDiscoveryProperties());
        }
        return this.sdPeerAddition;
    }

    protected synchronized void loadCACertificates(boolean force) throws InvalidArgumentException, CryptoException, TransactionException {
        if (!force && this.msps != null && !this.msps.isEmpty()) {
            return;
        }
        logger.debug((Object)String.format("Channel %s loadCACertificates", this.name));
        Map<String, MSP> lmsp = this.parseConfigBlock(force);
        if (lmsp == null || lmsp.isEmpty()) {
            throw new InvalidArgumentException("Unable to load CA certificates. Channel " + this.name + " does not have any MSPs.");
        }
        for (MSP msp : lmsp.values()) {
            logger.debug((Object)("loading certificates for MSP : " + msp.getID()));
            List<byte[]> certList = Arrays.asList(msp.getRootCerts());
            if (certList.size() > 0) {
                this.client.getCryptoSuite().loadCACertificatesAsBytes(certList);
            }
            if ((certList = Arrays.asList(msp.getIntermediateCerts())).size() <= 0) continue;
            this.client.getCryptoSuite().loadCACertificatesAsBytes(certList);
        }
        logger.debug((Object)String.format("Channel %s loadCACertificates completed ", this.name));
    }

    private Common.Block getGenesisBlock(Orderer orderer) throws TransactionException {
        try {
            if (this.genesisBlock != null) {
                logger.debug((Object)String.format("Channel %s getGenesisBlock already present", this.name));
            } else {
                long start = System.currentTimeMillis();
                Ab.SeekSpecified seekSpecified = Ab.SeekSpecified.newBuilder().setNumber(0L).build();
                Ab.SeekPosition seekPosition = Ab.SeekPosition.newBuilder().setSpecified(seekSpecified).build();
                Ab.SeekSpecified seekStopSpecified = Ab.SeekSpecified.newBuilder().setNumber(0L).build();
                Ab.SeekPosition seekStopPosition = Ab.SeekPosition.newBuilder().setSpecified(seekStopSpecified).build();
                Ab.SeekInfo seekInfo = Ab.SeekInfo.newBuilder().setStart(seekPosition).setStop(seekStopPosition).setBehavior(Ab.SeekInfo.SeekBehavior.BLOCK_UNTIL_READY).build();
                ArrayList<Ab.DeliverResponse> deliverResponses = new ArrayList<Ab.DeliverResponse>();
                this.seekBlock(this.newTransactionContext(), seekInfo, deliverResponses, orderer);
                Ab.DeliverResponse blockresp = deliverResponses.get(1);
                Common.Block configBlock = blockresp.getBlock();
                if (configBlock == null) {
                    throw new TransactionException(String.format("In getGenesisBlock newest block for channel %s fetch bad deliver returned null:", this.name));
                }
                int dataCount = configBlock.getData().getDataCount();
                if (dataCount < 1) {
                    throw new TransactionException(String.format("In getGenesisBlock bad config block data count %d", dataCount));
                }
                this.genesisBlock = blockresp.getBlock();
            }
        }
        catch (TransactionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            TransactionException exp = new TransactionException("getGenesisBlock " + e.getMessage(), e);
            logger.error((Object)exp.getMessage(), (Throwable)exp);
            throw exp;
        }
        if (this.genesisBlock == null) {
            TransactionException exp = new TransactionException("getGenesisBlock returned null");
            logger.error((Object)exp.getMessage(), (Throwable)exp);
            throw exp;
        }
        logger.debug((Object)String.format("Channel %s getGenesisBlock done.", this.name));
        return this.genesisBlock;
    }

    boolean isSystemChannel() {
        return this.systemChannel;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public byte[] getUpdateChannelConfigurationSignature(UpdateChannelConfiguration updateChannelConfiguration, User signer) throws InvalidArgumentException {
        User.userContextCheck(signer);
        if (null == updateChannelConfiguration) {
            throw new InvalidArgumentException("channelConfiguration is null");
        }
        try {
            TransactionContext transactionContext = this.newTransactionContext(signer);
            ByteString configUpdate = ByteString.copyFrom((byte[])updateChannelConfiguration.getUpdateChannelConfigurationAsBytes());
            ByteString sigHeaderByteString = ProtoUtils.getSignatureHeaderAsByteString(signer, transactionContext);
            ByteString signatureByteSting = transactionContext.signByteStrings(new User[]{signer}, sigHeaderByteString, configUpdate)[0];
            byte[] byArray = Configtx.ConfigSignature.newBuilder().setSignatureHeader(sigHeaderByteString).setSignature(signatureByteSting).build().toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new InvalidArgumentException(e);
        }
        finally {
            logger.debug((Object)"finally done");
        }
    }

    ChannelEventQue getChannelEventQue() {
        return this.channelEventQue;
    }

    ExecutorService getExecutorService() {
        return this.client.getExecutorService();
    }

    protected Map<String, MSP> parseConfigBlock(boolean force) throws TransactionException {
        Map<String, MSP> lmsps = this.msps;
        if (!force && lmsps != null && !lmsps.isEmpty()) {
            return lmsps;
        }
        try {
            Common.Block parseFrom = this.getConfigBlock(this.getShuffledPeers());
            logger.debug((Object)String.format("Channel %s Got config block getting MSP data and anchorPeers data", this.name));
            Common.Envelope envelope = Common.Envelope.parseFrom(parseFrom.getData().getData(0));
            Common.Payload payload = Common.Payload.parseFrom(envelope.getPayload());
            Configtx.ConfigEnvelope configEnvelope = Configtx.ConfigEnvelope.parseFrom(payload.getData());
            Configtx.ConfigGroup channelGroup = configEnvelope.getConfig().getChannelGroup();
            Map<String, MSP> newMSPS = this.traverseConfigGroupsMSP(SYSTEM_CHANNEL_NAME, channelGroup, new HashMap<String, MSP>(20));
            this.msps = Collections.unmodifiableMap(newMSPS);
            return Collections.unmodifiableMap(newMSPS);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TransactionException(e);
        }
    }

    private Map<String, MSP> traverseConfigGroupsMSP(String name, Configtx.ConfigGroup configGroup, Map<String, MSP> msps) throws InvalidProtocolBufferException {
        MspConfigPackage.MSPConfig mspConfig;
        Integer type;
        Configtx.ConfigValue mspv = configGroup.getValuesMap().get("MSP");
        if (null != mspv && !msps.containsKey(name) && (type = Integer.valueOf((mspConfig = MspConfigPackage.MSPConfig.parseFrom(mspv.getValue())).getType())) == 0) {
            MspConfigPackage.FabricMSPConfig fabricMSPConfig = MspConfigPackage.FabricMSPConfig.parseFrom(mspConfig.getConfig());
            msps.put(name, new MSP(name, fabricMSPConfig));
        }
        for (Map.Entry<String, Configtx.ConfigGroup> gm : configGroup.getGroupsMap().entrySet()) {
            this.traverseConfigGroupsMSP(gm.getKey(), gm.getValue(), msps);
        }
        return msps;
    }

    /*
     * WARNING - void declaration
     */
    public AnchorPeersConfigUpdateResult getConfigUpdateAnchorPeers(Peer peer, User userContext, Collection<String> peersToAdd, Collection<String> peersToRemove) throws Exception {
        String[] split;
        Common.Envelope envelope;
        Common.Payload payload;
        Common.Header header;
        Common.ChannelHeader channelHeader;
        boolean reportOnly;
        User.userContextCheck(userContext);
        this.checkPeer(peer);
        this.checkChannelState();
        boolean bl = reportOnly = peersToAdd == null && peersToRemove == null;
        if (!(reportOnly || peersToAdd != null && !peersToAdd.isEmpty() || peersToRemove != null && !peersToRemove.isEmpty())) {
            throw new InvalidArgumentException("No anchor peers to add or remove!");
        }
        if (IS_TRACE_LEVEL) {
            void var8_11;
            StringBuilder sbp = new StringBuilder("null");
            Object sep = SYSTEM_CHANNEL_NAME;
            if (peersToAdd != null) {
                sbp = new StringBuilder("[");
                for (String string : peersToAdd) {
                    sbp.append((String)sep).append("'").append(string).append("'");
                    sep = ", ";
                }
                sbp.append("]");
            }
            StringBuilder stringBuilder = new StringBuilder("null");
            sep = SYSTEM_CHANNEL_NAME;
            if (peersToRemove != null) {
                StringBuilder stringBuilder2 = new StringBuilder("[");
                for (String s : peersToRemove) {
                    stringBuilder2.append((String)sep).append("'").append(s).append("'");
                    sep = ", ";
                }
                stringBuilder2.append("]");
            }
            logger.trace((Object)String.format("getConfigUpdateAnchorPeers channel %s, peer: %s, user: %s, peers to add: %s, peers to remove: %s", this.name, peer.toString(), userContext.getMspId() + ":" + userContext.getName(), sbp.toString(), var8_11.toString()));
        }
        HashSet<String> peersToAddHS = new HashSet<String>(16);
        if (null != peersToAdd) {
            for (String string : peersToAdd) {
                String[] stringArray = this.parseEndpoint(string);
                peersToAddHS.add(stringArray[0] + ":" + stringArray[1]);
            }
        }
        HashSet<String> peersToRemoveHS = new HashSet<String>(16);
        if (null != peersToRemove && !peersToRemove.isEmpty()) {
            for (String string : peersToRemove) {
                String[] ep = this.parseEndpoint(string);
                peersToRemoveHS.add(ep[0] + ":" + ep[1]);
            }
            peersToRemoveHS.removeAll(peersToAddHS);
        }
        HashSet<String> hashSet = new HashSet<String>(peersToAddHS.size());
        HashSet<String> hashSet2 = new HashSet<String>(peersToRemoveHS.size());
        Common.Block configBlock = this.getConfigBlock(Collections.singletonList(peer));
        if (IS_TRACE_LEVEL) {
            logger.trace((Object)String.format("getConfigUpdateAnchorPeers  configBlock: %s", Utils.toHexString(configBlock.toByteArray())));
        }
        if (!Objects.equals(this.name, (channelHeader = Common.ChannelHeader.parseFrom((header = (payload = Common.Payload.parseFrom((envelope = Common.Envelope.parseFrom(configBlock.getData().getData(0))).getPayload())).getHeader()).getChannelHeader())).getChannelId())) {
            throw new InvalidArgumentException(String.format("Expected config block for channel: %s, but got: %s", this.name, channelHeader.getChannelId()));
        }
        Configtx.ConfigEnvelope configEnvelope = Configtx.ConfigEnvelope.parseFrom(payload.getData());
        Configtx.Config config = configEnvelope.getConfig();
        Configtx.Config.Builder configBuilderUpdate = config.toBuilder();
        Configtx.ConfigGroup.Builder channelGroupBuild = configBuilderUpdate.getChannelGroup().toBuilder();
        Map<String, Configtx.ConfigGroup> groupsMap = channelGroupBuild.getGroupsMap();
        Configtx.ConfigGroup.Builder application = groupsMap.get("Application").toBuilder();
        String mspid = userContext.getMspId();
        Configtx.ConfigGroup peerOrgConfigGroup = application.getGroupsMap().get(mspid);
        if (null == peerOrgConfigGroup) {
            StringBuilder sb = new StringBuilder(1000);
            String sep = SYSTEM_CHANNEL_NAME;
            for (String amspid : application.getGroupsMap().keySet()) {
                sb.append(sep).append(amspid);
                sep = ", ";
            }
            throw new InvalidArgumentException(String.format("Expected to find organization matching user context's mspid: %s, but only found %s.", mspid, sb.toString()));
        }
        Configtx.ConfigGroup.Builder peerOrgConfigGroupBuilder = peerOrgConfigGroup.toBuilder();
        String modPolicy = peerOrgConfigGroup.getModPolicy() != null ? peerOrgConfigGroup.getModPolicy() : "Admins";
        Map<String, Configtx.ConfigValue> valuesMap = peerOrgConfigGroupBuilder.getValuesMap();
        Configtx.ConfigValue anchorPeersCV = valuesMap.get("AnchorPeers");
        HashSet<String> currentAP = new HashSet<String>(36);
        if (null != anchorPeersCV && anchorPeersCV.getValue() != null) {
            modPolicy = anchorPeersCV.getModPolicy() != null ? "Admins" : modPolicy;
            Configuration.AnchorPeers anchorPeers = Configuration.AnchorPeers.parseFrom(anchorPeersCV.getValue());
            List<Configuration.AnchorPeer> anchorPeersList = anchorPeers.getAnchorPeersList();
            if (anchorPeersList != null) {
                for (Configuration.AnchorPeer anchorPeer : anchorPeersList) {
                    currentAP.add(anchorPeer.getHost().toLowerCase() + ":" + anchorPeer.getPort());
                }
            }
        }
        if (IS_TRACE_LEVEL) {
            StringBuilder sbp = new StringBuilder("[");
            String sep = SYSTEM_CHANNEL_NAME;
            for (String s : currentAP) {
                sbp.append(sep).append("'").append(s).append("'");
                sep = ", ";
            }
            sbp.append("]");
            logger.trace((Object)String.format("getConfigUpdateAnchorPeers channel %s,  current anchor peers: %s", this.name, sbp.toString()));
        }
        if (reportOnly) {
            logger.trace((Object)"getConfigUpdateAnchorPeers reportOnly");
            AnchorPeersConfigUpdateResult ret = new AnchorPeersConfigUpdateResult();
            ret.currentPeers = currentAP;
            ret.peersAdded = Collections.emptyList();
            ret.peersRemoved = Collections.emptyList();
            ret.updatedPeers = Collections.emptyList();
            if (IS_TRACE_LEVEL) {
                logger.trace((Object)String.format("getConfigUpdateAnchorPeers returned: %s", ret.toString()));
            }
            return ret;
        }
        HashSet<String> peersFinalHS = new HashSet<String>(16);
        Configuration.AnchorPeers.Builder anchorPeers = Configuration.AnchorPeers.newBuilder();
        for (String s : currentAP) {
            if (peersToRemoveHS.contains(s)) {
                hashSet.add(s);
                continue;
            }
            if (peersToAddHS.contains(s)) continue;
            split = s.split(":");
            anchorPeers.addAnchorPeers(Configuration.AnchorPeer.newBuilder().setHost(split[0]).setPort(Integer.parseInt(split[1])).build());
            peersFinalHS.add(s);
        }
        for (String s : peersToAddHS) {
            if (currentAP.contains(s)) continue;
            hashSet2.add(s);
            split = s.split(":");
            anchorPeers.addAnchorPeers(Configuration.AnchorPeer.newBuilder().setHost(split[0]).setPort(Integer.parseInt(split[1])).build());
            peersFinalHS.add(s);
        }
        if (hashSet.isEmpty() && hashSet2.isEmpty()) {
            logger.trace((Object)"getConfigUpdateAnchorPeers no Peers need adding or removing.");
            AnchorPeersConfigUpdateResult ret = new AnchorPeersConfigUpdateResult();
            ret.currentPeers = currentAP;
            ret.peersAdded = Collections.emptyList();
            ret.peersRemoved = Collections.emptyList();
            ret.updatedPeers = Collections.emptyList();
            if (IS_TRACE_LEVEL) {
                logger.trace((Object)String.format("getConfigUpdateAnchorPeers returned: %s", ret.toString()));
            }
            return ret;
        }
        HashMap<String, Configtx.ConfigValue> m = new HashMap<String, Configtx.ConfigValue>(valuesMap);
        m.remove("AnchorPeers");
        m.put("AnchorPeers", Configtx.ConfigValue.newBuilder().setValue(anchorPeers.build().toByteString()).setModPolicy(modPolicy).build());
        Configtx.ConfigGroup build = peerOrgConfigGroupBuilder.putAllValues(m).build();
        m.clear();
        m.putAll(application.getGroupsMap());
        m.put(mspid, (Configtx.ConfigValue)((Object)build));
        application.putAllGroups(m);
        Configtx.ConfigGroup applicationBuilt = application.build();
        m.clear();
        m.putAll(channelGroupBuild.getGroupsMap());
        m.put("Application", (Configtx.ConfigValue)((Object)applicationBuilt));
        channelGroupBuild.putAllGroups(m);
        configBuilderUpdate.setChannelGroup(channelGroupBuild.build());
        Configtx.ConfigUpdate.Builder updateBlockBuilder = Configtx.ConfigUpdate.newBuilder();
        Configtx.Config updated = configBuilderUpdate.build();
        if (IS_TRACE_LEVEL) {
            logger.trace((Object)String.format("getConfigUpdateAnchorPeers  updated configBlock: %s", Utils.toHexString(updated.toByteArray())));
        }
        ProtoUtils.computeUpdate(this.name, config, updated, updateBlockBuilder);
        AnchorPeersConfigUpdateResult ret = new AnchorPeersConfigUpdateResult();
        ret.currentPeers = currentAP;
        ret.peersAdded = hashSet2;
        ret.peersRemoved = hashSet;
        ret.updatedPeers = peersFinalHS;
        ret.updateChannelConfiguration = new UpdateChannelConfiguration(updateBlockBuilder.build().toByteArray());
        if (IS_TRACE_LEVEL) {
            logger.trace((Object)String.format("getConfigUpdateAnchorPeers returned: %s", ret.toString()));
        }
        return ret;
    }

    private Common.Block getConfigurationBlock(TransactionContext transactionContext, Orderer orderer) throws TransactionException {
        logger.debug((Object)String.format("getConfigurationBlock for channel %s", this.name));
        try {
            long lastConfigIndex = this.getLastConfigIndex(transactionContext, orderer);
            logger.debug((Object)String.format("Last config index is %d", lastConfigIndex));
            Common.Block configBlock = this.getBlockByNumber(transactionContext, orderer, lastConfigIndex);
            Common.Envelope envelopeRet = Common.Envelope.parseFrom(configBlock.getData().getData(0));
            Common.Payload payload = Common.Payload.parseFrom(envelopeRet.getPayload());
            Common.ChannelHeader channelHeader = Common.ChannelHeader.parseFrom(payload.getHeader().getChannelHeader());
            if (channelHeader.getType() != Common.HeaderType.CONFIG.getNumber()) {
                throw new TransactionException(String.format("Bad last configuration block type %d, expected %d", channelHeader.getType(), Common.HeaderType.CONFIG.getNumber()));
            }
            if (!this.name.equals(channelHeader.getChannelId())) {
                throw new TransactionException(String.format("Bad last configuration block channel id %s, expected %s", channelHeader.getChannelId(), this.name));
            }
            if (null != diagnosticFileDumper) {
                logger.trace((Object)String.format("Channel %s getConfigurationBlock returned %s", this.name, diagnosticFileDumper.createDiagnosticFile(String.valueOf(configBlock).getBytes())));
            }
            if (!logger.isTraceEnabled()) {
                logger.debug((Object)String.format("Channel %s getConfigurationBlock returned", this.name));
            }
            return configBlock;
        }
        catch (TransactionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TransactionException(e);
        }
    }

    private String[] parseEndpoint(String endPoint) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(endPoint)) {
            throw new InvalidArgumentException("Endpoint is null or empty string");
        }
        try {
            URI uri = new URI("grpc://" + endPoint.toLowerCase());
            String host = uri.getHost();
            if (null == host) {
                throw new InvalidArgumentException(String.format("Endpoint '%s' expected to be format \"host:port\". Hostname part missing", endPoint));
            }
            int port = uri.getPort();
            if (port == -1) {
                throw new InvalidArgumentException(String.format("Endpoint '%s' expected to be format \"host:port\". Port does not seem to be a valid port number. ", endPoint));
            }
            if (port < 1) {
                throw new InvalidArgumentException(String.format("Endpoint '%s' expected to be format \"host:port\". Port does not seem to be a valid port number. ", endPoint));
            }
            if (port > 65535) {
                throw new InvalidArgumentException(String.format("Endpoint '%s' expected to be format \"host:port\". Port does not seem to be a valid port number less than 65535. ", endPoint));
            }
            return new String[]{host, port + SYSTEM_CHANNEL_NAME};
        }
        catch (URISyntaxException e) {
            throw new InvalidArgumentException(String.format("Endpoint '%s' expected to be format \"host:port\".", endPoint), e);
        }
    }

    public byte[] getChannelConfigurationBytes(User userContext, Orderer orderer) throws InvalidArgumentException, TransactionException {
        try {
            Common.Block configBlock = this.getConfigurationBlock(this.newTransactionContext(userContext), orderer);
            Common.Envelope envelopeRet = Common.Envelope.parseFrom(configBlock.getData().getData(0));
            Common.Payload payload = Common.Payload.parseFrom(envelopeRet.getPayload());
            Configtx.ConfigEnvelope configEnvelope = Configtx.ConfigEnvelope.parseFrom(payload.getData());
            return configEnvelope.getConfig().toByteArray();
        }
        catch (Exception e) {
            throw new TransactionException(e);
        }
    }

    public byte[] getChannelConfigurationBytes(User userContext, Peer peer) throws InvalidArgumentException, TransactionException {
        try {
            Common.Block configBlock = this.getConfigBlock(this.newTransactionContext(userContext), Collections.singletonList(peer));
            Common.Envelope envelopeRet = Common.Envelope.parseFrom(configBlock.getData().getData(0));
            Common.Payload payload = Common.Payload.parseFrom(envelopeRet.getPayload());
            Configtx.ConfigEnvelope configEnvelope = Configtx.ConfigEnvelope.parseFrom(payload.getData());
            return configEnvelope.getConfig().toByteArray();
        }
        catch (Exception e) {
            throw new TransactionException(e);
        }
    }

    public byte[] getChannelConfigurationBytes() throws InvalidArgumentException, TransactionException {
        return this.getChannelConfigurationBytes(this.client.getUserContext());
    }

    public byte[] getChannelConfigurationBytes(User userContext) throws InvalidArgumentException, TransactionException {
        Common.Block configBlock = null;
        try {
            List<Peer> peers = this.getShuffledPeers();
            if (!peers.isEmpty()) {
                configBlock = this.getConfigBlock(this.newTransactionContext(userContext), new ArrayList<Peer>(peers));
            } else {
                List<Orderer> shuffledOrderers = this.getShuffledOrderers();
                if (shuffledOrderers.isEmpty()) {
                    throw new InvalidArgumentException(String.format("Channel %s has no peer or orderers defined. Can not get configuration block", this.name));
                }
                StringBuilder sb = new StringBuilder(1000);
                Exception fe = null;
                String sep = SYSTEM_CHANNEL_NAME;
                for (Orderer orderer : shuffledOrderers) {
                    try {
                        configBlock = this.getConfigurationBlock(this.newTransactionContext(userContext), orderer);
                        fe = null;
                        break;
                    }
                    catch (Exception e) {
                        fe = e;
                        sb.append(sep).append(orderer.toString()).append("-").append(e.getMessage());
                        sep = ", ";
                    }
                }
                if (fe != null) {
                    throw new TransactionException(sb.toString(), fe);
                }
            }
            if (configBlock == null) {
                throw new TransactionException("Transaction block could not be retrieved.");
            }
            Common.Envelope envelopeRet = Common.Envelope.parseFrom(configBlock.getData().getData(0));
            Common.Payload payload = Common.Payload.parseFrom(envelopeRet.getPayload());
            Configtx.ConfigEnvelope configEnvelope = Configtx.ConfigEnvelope.parseFrom(payload.getData());
            return configEnvelope.getConfig().toByteArray();
        }
        catch (Exception e) {
            throw new TransactionException(e);
        }
    }

    private long getLastConfigIndex(TransactionContext transactionContext, Orderer orderer) throws TransactionException, InvalidProtocolBufferException {
        Common.Block latestBlock = this.getLatestBlock(orderer, transactionContext);
        Common.BlockMetadata blockMetadata = latestBlock.getMetadata();
        Common.Metadata metaData = Common.Metadata.parseFrom(blockMetadata.getMetadata(1));
        Common.LastConfig lastConfig = Common.LastConfig.parseFrom(metaData.getValue());
        return lastConfig.getIndex();
    }

    private Common.Block getBlockByNumber(TransactionContext transactionContext, Orderer orderer, long number) throws TransactionException {
        logger.trace((Object)String.format("getConfigurationBlock for channel %s", this.name));
        try {
            logger.trace((Object)String.format("Last config index is %d", number));
            Ab.SeekSpecified seekSpecified = Ab.SeekSpecified.newBuilder().setNumber(number).build();
            Ab.SeekPosition seekPosition = Ab.SeekPosition.newBuilder().setSpecified(seekSpecified).build();
            Ab.SeekInfo seekInfo = Ab.SeekInfo.newBuilder().setStart(seekPosition).setStop(seekPosition).setBehavior(Ab.SeekInfo.SeekBehavior.BLOCK_UNTIL_READY).build();
            ArrayList<Ab.DeliverResponse> deliverResponses = new ArrayList<Ab.DeliverResponse>();
            this.seekBlock(transactionContext, seekInfo, deliverResponses, orderer);
            Ab.DeliverResponse blockresp = deliverResponses.get(1);
            Common.Block retBlock = blockresp.getBlock();
            if (retBlock == null) {
                throw new TransactionException(String.format("newest block for channel %s fetch bad deliver returned null:", this.name));
            }
            int dataCount = retBlock.getData().getDataCount();
            if (dataCount < 1) {
                throw new TransactionException(String.format("Bad config block data count %d", dataCount));
            }
            logger.trace((Object)String.format("Received  block for channel %s, block no:%d, transaction count: %d", this.name, retBlock.getHeader().getNumber(), retBlock.getData().getDataCount()));
            return retBlock;
        }
        catch (TransactionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TransactionException(e);
        }
    }

    private int seekBlock(TransactionContext txContext, Ab.SeekInfo seekInfo, List<Ab.DeliverResponse> deliverResponses, Orderer ordererIn) throws TransactionException {
        logger.trace((Object)String.format("seekBlock for channel %s", this.name));
        long start = System.currentTimeMillis();
        int statusRC = 404;
        try {
            do {
                statusRC = 404;
                Orderer orderer = ordererIn != null ? ordererIn : this.getRandomOrderer();
                Ab.DeliverResponse[] deliver = orderer.sendDeliver(ProtoUtils.createSeekInfoEnvelope(txContext, seekInfo, orderer.getClientTLSCertificateDigest()));
                if (deliver.length < 1) {
                    logger.warn((Object)String.format("Genesis block for channel %s fetch bad deliver missing status block only got blocks:%d", this.name, deliver.length));
                    statusRC = 404;
                } else {
                    Ab.DeliverResponse status = deliver[0];
                    statusRC = status.getStatusValue();
                    if (statusRC == 404 || statusRC == 503) {
                        logger.warn((Object)String.format("Bad deliver expected status 200  got  %d, Channel %s", status.getStatusValue(), this.name));
                        statusRC = 404;
                    } else {
                        if (statusRC != 200) {
                            throw new TransactionException(String.format("Bad newest block expected status 200  got  %d, Channel %s", status.getStatusValue(), this.name));
                        }
                        if (deliver.length < 2) {
                            throw new TransactionException(String.format("Newest block for channel %s fetch bad deliver missing genesis block only got %d:", this.name, deliver.length));
                        }
                        deliverResponses.addAll(Arrays.asList(deliver));
                    }
                }
                if (200 == statusRC) continue;
                long duration = System.currentTimeMillis() - start;
                if (duration > config.getGenesisBlockWaitTime()) {
                    throw new TransactionException(String.format("Getting block time exceeded %s seconds for channel %s", Long.toString(TimeUnit.MILLISECONDS.toSeconds(duration)), this.name));
                }
                try {
                    Thread.sleep(ORDERER_RETRY_WAIT_TIME);
                }
                catch (InterruptedException e) {
                    TransactionException te = new TransactionException("seekBlock thread Sleep", e);
                    logger.warn((Object)te.getMessage(), (Throwable)te);
                }
            } while (statusRC != 200);
        }
        catch (TransactionException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TransactionException(e);
        }
        return statusRC;
    }

    private Common.Block getLatestBlock(Orderer orderer, TransactionContext transactionContext) throws TransactionException {
        logger.debug((Object)String.format("getConfigurationBlock for channel %s", this.name));
        Ab.SeekPosition seekPosition = Ab.SeekPosition.newBuilder().setNewest(Ab.SeekNewest.getDefaultInstance()).build();
        Ab.SeekInfo seekInfo = Ab.SeekInfo.newBuilder().setStart(seekPosition).setStop(seekPosition).setBehavior(Ab.SeekInfo.SeekBehavior.BLOCK_UNTIL_READY).build();
        ArrayList<Ab.DeliverResponse> deliverResponses = new ArrayList<Ab.DeliverResponse>();
        this.seekBlock(transactionContext, seekInfo, deliverResponses, orderer);
        Ab.DeliverResponse blockresp = deliverResponses.get(1);
        Common.Block latestBlock = blockresp.getBlock();
        if (latestBlock == null) {
            throw new TransactionException(String.format("newest block for channel %s fetch bad deliver returned null:", this.name));
        }
        logger.trace((Object)String.format("Received latest  block for channel %s, block no:%d", this.name, latestBlock.getHeader().getNumber()));
        return latestBlock;
    }

    public Collection<Orderer> getOrderers() {
        return Collections.unmodifiableCollection(new ArrayList<Orderer>(this.orderers));
    }

    @Deprecated
    public Collection<ProposalResponse> sendInstantiationProposal(InstantiateProposalRequest instantiateProposalRequest) throws InvalidArgumentException, ProposalException {
        return this.sendInstantiationProposal(instantiateProposalRequest, this.getChaincodePeers());
    }

    @Deprecated
    public Collection<ProposalResponse> sendInstantiationProposal(InstantiateProposalRequest instantiateProposalRequest, Collection<Peer> peers) throws InvalidArgumentException, ProposalException {
        this.checkChannelState();
        if (null == instantiateProposalRequest) {
            throw new InvalidArgumentException("InstantiateProposalRequest is null");
        }
        this.checkPeers(peers);
        try {
            TransactionContext transactionContext = this.newTransactionContext(instantiateProposalRequest.getUserContext());
            transactionContext.setProposalWaitTime(instantiateProposalRequest.getProposalWaitTime());
            InstantiateProposalBuilder instantiateProposalbuilder = InstantiateProposalBuilder.newBuilder();
            instantiateProposalbuilder.context(transactionContext);
            instantiateProposalbuilder.argss(instantiateProposalRequest.getArgs());
            instantiateProposalbuilder.chaincodeName(instantiateProposalRequest.getChaincodeName());
            instantiateProposalbuilder.chaincodeType(instantiateProposalRequest.getChaincodeLanguage());
            instantiateProposalbuilder.chaincodePath(instantiateProposalRequest.getChaincodePath());
            instantiateProposalbuilder.chaincodeVersion(instantiateProposalRequest.getChaincodeVersion());
            instantiateProposalbuilder.chaincodEndorsementPolicy(instantiateProposalRequest.getChaincodeEndorsementPolicy());
            instantiateProposalbuilder.chaincodeCollectionConfiguration(instantiateProposalRequest.getChaincodeCollectionConfiguration());
            instantiateProposalbuilder.setTransientMap(instantiateProposalRequest.getTransientMap());
            ProposalPackage.Proposal instantiateProposal = instantiateProposalbuilder.build();
            ProposalPackage.SignedProposal signedProposal = this.getSignedProposal(transactionContext, instantiateProposal);
            return this.sendProposalToPeers(peers, signedProposal, transactionContext);
        }
        catch (Exception e) {
            throw new ProposalException(e);
        }
    }

    private TransactionContext getTransactionContext(TransactionRequest request) {
        return request.getTransactionContext().orElse(this.newTransactionContext(request.getUserContext()));
    }

    public TransactionContext newTransactionContext() {
        return this.newTransactionContext(this.client.getUserContext());
    }

    private TransactionContext newTransactionContext(User userContext) {
        return new TransactionContext(this, userContext, this.client.getCryptoSuite());
    }

    private TransactionContext newTransactionContext(LifecycleRequest lifecycleRequest) throws InvalidArgumentException {
        User userContext = lifecycleRequest.getUserContext();
        if (null == userContext) {
            userContext = this.client.getUserContext();
        }
        User.userContextCheck(userContext);
        TransactionContext transactionContext = new TransactionContext(this, userContext, this.client.getCryptoSuite());
        transactionContext.setProposalWaitTime(lifecycleRequest.getProposalWaitTime());
        transactionContext.verify(lifecycleRequest.isVerifiable());
        return transactionContext;
    }

    @Deprecated
    Collection<ProposalResponse> sendInstallProposal(InstallProposalRequest installProposalRequest) throws ProposalException, InvalidArgumentException {
        return this.sendInstallProposal(installProposalRequest, this.getChaincodePeers());
    }

    @Deprecated
    Collection<ProposalResponse> sendInstallProposal(InstallProposalRequest installProposalRequest, Collection<Peer> peers) throws ProposalException, InvalidArgumentException {
        this.checkChannelState();
        this.checkPeers(peers);
        if (null == installProposalRequest) {
            throw new InvalidArgumentException("InstallProposalRequest is null");
        }
        try {
            TransactionContext transactionContext = this.newTransactionContext(installProposalRequest.getUserContext());
            transactionContext.verify(false);
            transactionContext.setProposalWaitTime(installProposalRequest.getProposalWaitTime());
            InstallProposalBuilder installProposalbuilder = InstallProposalBuilder.newBuilder();
            installProposalbuilder.context(transactionContext);
            installProposalbuilder.setChaincodeLanguage(installProposalRequest.getChaincodeLanguage());
            installProposalbuilder.chaincodeName(installProposalRequest.getChaincodeName());
            installProposalbuilder.chaincodePath(installProposalRequest.getChaincodePath());
            installProposalbuilder.chaincodeVersion(installProposalRequest.getChaincodeVersion());
            installProposalbuilder.setChaincodeSource(installProposalRequest.getChaincodeSourceLocation());
            installProposalbuilder.setChaincodeInputStream(installProposalRequest.getChaincodeInputStream());
            installProposalbuilder.setChaincodeMetaInfLocation(installProposalRequest.getChaincodeMetaInfLocation());
            ProposalPackage.Proposal deploymentProposal = installProposalbuilder.build();
            ProposalPackage.SignedProposal signedProposal = this.getSignedProposal(transactionContext, deploymentProposal);
            return this.sendProposalToPeers(peers, signedProposal, transactionContext);
        }
        catch (Exception e) {
            throw new ProposalException(e);
        }
    }

    @Deprecated
    public Collection<ProposalResponse> sendUpgradeProposal(UpgradeProposalRequest upgradeProposalRequest) throws ProposalException, InvalidArgumentException {
        return this.sendUpgradeProposal(upgradeProposalRequest, this.getChaincodePeers());
    }

    @Deprecated
    public Collection<ProposalResponse> sendUpgradeProposal(UpgradeProposalRequest upgradeProposalRequest, Collection<Peer> peers) throws InvalidArgumentException, ProposalException {
        this.checkChannelState();
        this.checkPeers(peers);
        if (null == upgradeProposalRequest) {
            throw new InvalidArgumentException("Upgradeproposal is null");
        }
        try {
            TransactionContext transactionContext = this.newTransactionContext(upgradeProposalRequest.getUserContext());
            transactionContext.setProposalWaitTime(upgradeProposalRequest.getProposalWaitTime());
            UpgradeProposalBuilder upgradeProposalBuilder = UpgradeProposalBuilder.newBuilder();
            upgradeProposalBuilder.context(transactionContext);
            upgradeProposalBuilder.argss(upgradeProposalRequest.getArgs());
            upgradeProposalBuilder.chaincodeName(upgradeProposalRequest.getChaincodeName());
            upgradeProposalBuilder.chaincodePath(upgradeProposalRequest.getChaincodePath());
            upgradeProposalBuilder.chaincodeVersion(upgradeProposalRequest.getChaincodeVersion());
            upgradeProposalBuilder.chaincodEndorsementPolicy(upgradeProposalRequest.getChaincodeEndorsementPolicy());
            upgradeProposalBuilder.chaincodeCollectionConfiguration(upgradeProposalRequest.getChaincodeCollectionConfiguration());
            ProposalPackage.SignedProposal signedProposal = this.getSignedProposal(transactionContext, upgradeProposalBuilder.build());
            return this.sendProposalToPeers(peers, signedProposal, transactionContext);
        }
        catch (Exception e) {
            throw new ProposalException(e);
        }
    }

    private ProposalPackage.SignedProposal getSignedProposal(TransactionContext transactionContext, ProposalPackage.Proposal proposal) throws CryptoException, InvalidArgumentException {
        ProposalPackage.SignedProposal sp = ProposalPackage.SignedProposal.newBuilder().setProposalBytes(proposal.toByteString()).setSignature(transactionContext.signByteString(proposal.toByteArray())).build();
        return sp;
    }

    private void checkChannelState() throws InvalidArgumentException {
        if (this.shutdown) {
            throw new InvalidArgumentException(String.format("Channel %s has been shutdown.", this.name));
        }
        if (!this.initialized) {
            throw new InvalidArgumentException(String.format("Channel %s has not been initialized.", this.name));
        }
        User.userContextCheck(this.client.getUserContext());
    }

    public BlockInfo queryBlockByHash(byte[] blockHash) throws InvalidArgumentException, ProposalException {
        return this.queryBlockByHash(this.getShuffledPeers(EnumSet.of(Peer.PeerRole.LEDGER_QUERY)), blockHash);
    }

    public BlockInfo queryBlockByHash(byte[] blockHash, User userContext) throws InvalidArgumentException, ProposalException {
        return this.queryBlockByHash(this.getShuffledPeers(EnumSet.of(Peer.PeerRole.LEDGER_QUERY)), blockHash, userContext);
    }

    public BlockInfo queryBlockByHash(Peer peer, byte[] blockHash) throws InvalidArgumentException, ProposalException {
        return this.queryBlockByHash(Collections.singleton(peer), blockHash);
    }

    public BlockInfo queryBlockByHash(Collection<Peer> peers, byte[] blockHash) throws InvalidArgumentException, ProposalException {
        return this.queryBlockByHash(peers, blockHash, this.client.getUserContext());
    }

    public BlockInfo queryBlockByHash(Collection<Peer> peers, byte[] blockHash, User userContext) throws InvalidArgumentException, ProposalException {
        this.checkChannelState();
        this.checkPeers(peers);
        User.userContextCheck(userContext);
        if (blockHash == null) {
            throw new InvalidArgumentException("blockHash parameter is null.");
        }
        try {
            logger.trace((Object)("queryBlockByHash with hash : " + Hex.encodeHexString((byte[])blockHash) + " on channel " + this.name));
            QuerySCCRequest querySCCRequest = new QuerySCCRequest(userContext);
            querySCCRequest.setFcn("GetBlockByHash");
            querySCCRequest.setArgs(this.name);
            querySCCRequest.setArgBytes(new byte[][]{blockHash});
            ProposalResponse proposalResponse = this.sendProposalSerially(querySCCRequest, peers);
            return new BlockInfo(Common.Block.parseFrom(proposalResponse.getProposalResponse().getResponse().getPayload()));
        }
        catch (InvalidProtocolBufferException e) {
            ProposalException proposalException = new ProposalException(e);
            logger.error((Object)proposalException);
            throw proposalException;
        }
    }

    private Peer getRandomLedgerQueryPeer() throws InvalidArgumentException {
        ArrayList<Peer> ledgerQueryPeers = new ArrayList<Peer>(new HashSet<Peer>(this.getLedgerQueryPeers()));
        if (ledgerQueryPeers.isEmpty()) {
            throw new InvalidArgumentException("Channel " + this.name + " does not have any ledger querying peers associated with it.");
        }
        return ledgerQueryPeers.get(RANDOM.nextInt(ledgerQueryPeers.size()));
    }

    private Peer getRandomPeer() throws InvalidArgumentException {
        ArrayList<Peer> randPicks = new ArrayList<Peer>(this.getPeers());
        if (randPicks.isEmpty()) {
            throw new InvalidArgumentException("Channel " + this.name + " does not have any peers associated with it.");
        }
        return randPicks.get(RANDOM.nextInt(randPicks.size()));
    }

    private List<Peer> getShuffledPeers() {
        ArrayList<Peer> peers = new ArrayList<Peer>(this.getPeers());
        Collections.shuffle(peers);
        return peers;
    }

    private List<Peer> getShuffledPeers(EnumSet<Peer.PeerRole> roles) {
        ArrayList<Peer> peers = new ArrayList<Peer>(this.getPeers(roles));
        Collections.shuffle(peers);
        return peers;
    }

    private List<Orderer> getShuffledOrderers() {
        ArrayList<Orderer> orderers = new ArrayList<Orderer>(this.getOrderers());
        Collections.shuffle(orderers);
        return orderers;
    }

    private Orderer getRandomOrderer() throws InvalidArgumentException {
        ArrayList<Orderer> randPicks = new ArrayList<Orderer>(new HashSet<Orderer>(this.getOrderers()));
        if (randPicks.isEmpty()) {
            throw new InvalidArgumentException("Channel " + this.name + " does not have any orderers associated with it.");
        }
        return randPicks.get(RANDOM.nextInt(randPicks.size()));
    }

    private void checkPeer(Peer peer) throws InvalidArgumentException {
        if (peer == null) {
            throw new InvalidArgumentException("Peer value is null.");
        }
        if (this.isSystemChannel()) {
            return;
        }
        if (!this.getPeers().contains(peer)) {
            throw new InvalidArgumentException("Channel " + this.name + " does not have peer " + peer.getName());
        }
        if (peer.getChannel() != this) {
            throw new InvalidArgumentException("Peer " + peer.getName() + " not set for channel " + this.name);
        }
    }

    private void checkOrderer(Orderer orderer) throws InvalidArgumentException {
        if (orderer == null) {
            throw new InvalidArgumentException("Orderer value is null.");
        }
        if (this.isSystemChannel()) {
            return;
        }
        if (!this.getOrderers().contains(orderer)) {
            throw new InvalidArgumentException("Channel " + this.name + " does not have orderer " + orderer.getName());
        }
        if (orderer.getChannel() != this) {
            throw new InvalidArgumentException("Orderer " + orderer.getName() + " not set for channel " + this.name);
        }
    }

    private void checkPeers(Collection<Peer> peers) throws InvalidArgumentException {
        if (peers == null) {
            throw new InvalidArgumentException("Collection of peers is null.");
        }
        if (peers.isEmpty()) {
            throw new InvalidArgumentException("Collection of peers is empty.");
        }
        for (Peer peer : peers) {
            this.checkPeer(peer);
        }
    }

    public BlockInfo queryBlockByNumber(long blockNumber) throws InvalidArgumentException, ProposalException {
        return this.queryBlockByNumber(this.getShuffledPeers(EnumSet.of(Peer.PeerRole.LEDGER_QUERY)), blockNumber);
    }

    public BlockInfo queryBlockByNumber(long blockNumber, User userContext) throws InvalidArgumentException, ProposalException {
        return this.queryBlockByNumber(this.getShuffledPeers(EnumSet.of(Peer.PeerRole.LEDGER_QUERY)), blockNumber, userContext);
    }

    public BlockInfo queryBlockByNumber(Peer peer, long blockNumber) throws InvalidArgumentException, ProposalException {
        return this.queryBlockByNumber(Collections.singleton(peer), blockNumber);
    }

    public BlockInfo queryBlockByNumber(Peer peer, long blockNumber, User userContext) throws InvalidArgumentException, ProposalException {
        return this.queryBlockByNumber(Collections.singleton(peer), blockNumber, userContext);
    }

    public BlockInfo queryBlockByNumber(Collection<Peer> peers, long blockNumber) throws InvalidArgumentException, ProposalException {
        return this.queryBlockByNumber(peers, blockNumber, this.client.getUserContext());
    }

    public BlockInfo queryBlockByNumber(Collection<Peer> peers, long blockNumber, User userContext) throws InvalidArgumentException, ProposalException {
        this.checkChannelState();
        this.checkPeers(peers);
        User.userContextCheck(userContext);
        try {
            logger.debug((Object)("queryBlockByNumber with blockNumber " + blockNumber + " on channel " + this.name));
            QuerySCCRequest querySCCRequest = new QuerySCCRequest(userContext);
            querySCCRequest.setFcn("GetBlockByNumber");
            querySCCRequest.setArgs(this.name, Long.toUnsignedString(blockNumber));
            ProposalResponse proposalResponse = this.sendProposalSerially(querySCCRequest, peers);
            return new BlockInfo(Common.Block.parseFrom(proposalResponse.getProposalResponse().getResponse().getPayload()));
        }
        catch (InvalidProtocolBufferException e) {
            logger.error((Object)e);
            throw new ProposalException(e);
        }
    }

    public BlockInfo queryBlockByTransactionID(String txID) throws InvalidArgumentException, ProposalException {
        return this.queryBlockByTransactionID(this.getShuffledPeers(EnumSet.of(Peer.PeerRole.LEDGER_QUERY)), txID);
    }

    public BlockInfo queryBlockByTransactionID(String txID, User userContext) throws InvalidArgumentException, ProposalException {
        return this.queryBlockByTransactionID(this.getShuffledPeers(EnumSet.of(Peer.PeerRole.LEDGER_QUERY)), txID, userContext);
    }

    public BlockInfo queryBlockByTransactionID(Peer peer, String txID) throws InvalidArgumentException, ProposalException {
        return this.queryBlockByTransactionID(Collections.singleton(peer), txID);
    }

    public BlockInfo queryBlockByTransactionID(Peer peer, String txID, User userContext) throws InvalidArgumentException, ProposalException {
        return this.queryBlockByTransactionID(Collections.singleton(peer), txID, userContext);
    }

    public BlockInfo queryBlockByTransactionID(Collection<Peer> peers, String txID) throws InvalidArgumentException, ProposalException {
        return this.queryBlockByTransactionID(peers, txID, this.client.getUserContext());
    }

    public BlockInfo queryBlockByTransactionID(Collection<Peer> peers, String txID, User userContext) throws InvalidArgumentException, ProposalException {
        this.checkChannelState();
        this.checkPeers(peers);
        User.userContextCheck(userContext);
        if (txID == null) {
            throw new InvalidArgumentException("TxID parameter is null.");
        }
        try {
            logger.debug((Object)("queryBlockByTransactionID with txID " + txID + " \n     on channel " + this.name));
            QuerySCCRequest querySCCRequest = new QuerySCCRequest(userContext);
            querySCCRequest.setFcn("GetBlockByTxID");
            querySCCRequest.setArgs(this.name, txID);
            ProposalResponse proposalResponse = this.sendProposalSerially(querySCCRequest, peers);
            return new BlockInfo(Common.Block.parseFrom(proposalResponse.getProposalResponse().getResponse().getPayload()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new ProposalException(e);
        }
    }

    public BlockchainInfo queryBlockchainInfo() throws ProposalException, InvalidArgumentException {
        return this.queryBlockchainInfo(this.getShuffledPeers(EnumSet.of(Peer.PeerRole.LEDGER_QUERY)), this.client.getUserContext());
    }

    public BlockchainInfo queryBlockchainInfo(User userContext) throws ProposalException, InvalidArgumentException {
        return this.queryBlockchainInfo(this.getShuffledPeers(EnumSet.of(Peer.PeerRole.LEDGER_QUERY)), userContext);
    }

    public BlockchainInfo queryBlockchainInfo(Peer peer) throws ProposalException, InvalidArgumentException {
        return this.queryBlockchainInfo(Collections.singleton(peer), this.client.getUserContext());
    }

    public BlockchainInfo queryBlockchainInfo(Peer peer, User userContext) throws ProposalException, InvalidArgumentException {
        return this.queryBlockchainInfo(Collections.singleton(peer), userContext);
    }

    public BlockchainInfo queryBlockchainInfo(Collection<Peer> peers, User userContext) throws ProposalException, InvalidArgumentException {
        this.checkChannelState();
        this.checkPeers(peers);
        User.userContextCheck(userContext);
        try {
            logger.debug((Object)("queryBlockchainInfo to peer  on channel " + this.name));
            QuerySCCRequest querySCCRequest = new QuerySCCRequest(userContext);
            querySCCRequest.setFcn("GetChainInfo");
            querySCCRequest.setArgs(this.name);
            ProposalResponse proposalResponse = this.sendProposalSerially(querySCCRequest, peers);
            return new BlockchainInfo(Ledger.BlockchainInfo.parseFrom(proposalResponse.getProposalResponse().getResponse().getPayload()));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ProposalException(e);
        }
    }

    public TransactionInfo queryTransactionByID(String txID) throws ProposalException, InvalidArgumentException {
        return this.queryTransactionByID(this.getShuffledPeers(EnumSet.of(Peer.PeerRole.LEDGER_QUERY)), txID, this.client.getUserContext());
    }

    public TransactionInfo queryTransactionByID(String txID, User userContext) throws ProposalException, InvalidArgumentException {
        return this.queryTransactionByID(this.getShuffledPeers(EnumSet.of(Peer.PeerRole.LEDGER_QUERY)), txID, userContext);
    }

    public TransactionInfo queryTransactionByID(Peer peer, String txID) throws ProposalException, InvalidArgumentException {
        return this.queryTransactionByID(Collections.singleton(peer), txID, this.client.getUserContext());
    }

    public TransactionInfo queryTransactionByID(Peer peer, String txID, User userContext) throws ProposalException, InvalidArgumentException {
        return this.queryTransactionByID(Collections.singleton(peer), txID, userContext);
    }

    public TransactionInfo queryTransactionByID(Collection<Peer> peers, String txID, User userContext) throws ProposalException, InvalidArgumentException {
        this.checkChannelState();
        this.checkPeers(peers);
        User.userContextCheck(userContext);
        if (txID == null) {
            throw new InvalidArgumentException("TxID parameter is null.");
        }
        try {
            logger.debug((Object)("queryTransactionByID with txID " + txID + "\n    from peer  on channel " + this.name));
            QuerySCCRequest querySCCRequest = new QuerySCCRequest(userContext);
            querySCCRequest.setFcn("GetTransactionByID");
            querySCCRequest.setArgs(this.name, txID);
            ProposalResponse proposalResponse = this.sendProposalSerially(querySCCRequest, peers);
            return new TransactionInfo(txID, TransactionPackage.ProcessedTransaction.parseFrom(proposalResponse.getProposalResponse().getResponse().getPayload()));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new ProposalException(e);
        }
    }

    Set<String> queryChannels(Peer peer) throws InvalidArgumentException, ProposalException {
        this.checkPeer(peer);
        if (!this.isSystemChannel()) {
            throw new InvalidArgumentException("queryChannels should only be invoked on system channel.");
        }
        try {
            TransactionContext context = this.newTransactionContext();
            ProposalPackage.Proposal q = QueryPeerChannelsBuilder.newBuilder().context(context).build();
            ProposalPackage.SignedProposal qProposal = this.getSignedProposal(context, q);
            Collection<ProposalResponse> proposalResponses = this.sendProposalToPeers(Collections.singletonList(peer), qProposal, context);
            if (null == proposalResponses) {
                throw new ProposalException(String.format("Peer %s channel query return with null for responses", peer.getName()));
            }
            if (proposalResponses.size() != 1) {
                throw new ProposalException(String.format("Peer %s channel query expected one response but got back %d  responses ", peer.getName(), proposalResponses.size()));
            }
            ProposalResponse proposalResponse = proposalResponses.iterator().next();
            if (proposalResponse.getStatus() != ChaincodeResponse.Status.SUCCESS) {
                throw new ProposalException(String.format("Failed exception message is %s, status is %d", proposalResponse.getMessage(), proposalResponse.getStatus().getStatus()));
            }
            ProposalResponsePackage.ProposalResponse fabricResponse = proposalResponse.getProposalResponse();
            if (null == fabricResponse) {
                throw new ProposalException(String.format("Peer %s channel query return with empty fabric response", peer.getName()));
            }
            ProposalResponsePackage.Response fabricResponseResponse = fabricResponse.getResponse();
            if (null == fabricResponseResponse) {
                throw new ProposalException(String.format("Peer %s channel query return with empty fabricResponseResponse", peer.getName()));
            }
            if (200 != fabricResponseResponse.getStatus()) {
                throw new ProposalException(String.format("Peer %s channel query expected 200, actual returned was: %d. " + fabricResponseResponse.getMessage(), peer.getName(), fabricResponseResponse.getStatus()));
            }
            Query.ChannelQueryResponse qr = Query.ChannelQueryResponse.parseFrom(fabricResponseResponse.getPayload());
            HashSet<String> ret = new HashSet<String>(qr.getChannelsCount());
            for (Query.ChannelInfo x : qr.getChannelsList()) {
                ret.add(x.getChannelId());
            }
            return ret;
        }
        catch (ProposalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProposalException(String.format("Query for peer %s channels failed. " + e.getMessage(), this.name), e);
        }
    }

    List<Query.ChaincodeInfo> queryInstalledChaincodes(Peer peer) throws InvalidArgumentException, ProposalException {
        this.checkPeer(peer);
        if (!this.isSystemChannel()) {
            throw new InvalidArgumentException("queryInstalledChaincodes should only be invoked on system channel.");
        }
        try {
            TransactionContext context = this.newTransactionContext();
            ProposalPackage.Proposal q = QueryInstalledChaincodesBuilder.newBuilder().context(context).build();
            ProposalPackage.SignedProposal qProposal = this.getSignedProposal(context, q);
            Collection<ProposalResponse> proposalResponses = this.sendProposalToPeers(Collections.singletonList(peer), qProposal, context);
            if (null == proposalResponses) {
                throw new ProposalException(String.format("Peer %s channel query return with null for responses", peer.getName()));
            }
            if (proposalResponses.size() != 1) {
                throw new ProposalException(String.format("Peer %s channel query expected one response but got back %d  responses ", peer.getName(), proposalResponses.size()));
            }
            ProposalResponse proposalResponse = proposalResponses.iterator().next();
            ProposalResponsePackage.ProposalResponse fabricResponse = proposalResponse.getProposalResponse();
            if (null == fabricResponse) {
                throw new ProposalException(String.format("Peer %s channel query return with empty fabric response", peer.getName()));
            }
            ProposalResponsePackage.Response fabricResponseResponse = fabricResponse.getResponse();
            if (null == fabricResponseResponse) {
                throw new ProposalException(String.format("Peer %s channel query return with empty fabricResponseResponse", peer.getName()));
            }
            if (200 != fabricResponseResponse.getStatus()) {
                throw new ProposalException(String.format("Peer %s channel query expected 200, actual returned was: %d. " + fabricResponseResponse.getMessage(), peer.getName(), fabricResponseResponse.getStatus()));
            }
            Query.ChaincodeQueryResponse chaincodeQueryResponse = Query.ChaincodeQueryResponse.parseFrom(fabricResponseResponse.getPayload());
            return chaincodeQueryResponse.getChaincodesList();
        }
        catch (ProposalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProposalException(String.format("Query for peer %s channels failed. " + e.getMessage(), this.name), e);
        }
    }

    Collection<LifecycleInstallChaincodeProposalResponse> sendLifecycleInstallProposal(LifecycleInstallChaincodeRequest installProposalRequest, Collection<Peer> peers) throws ProposalException, InvalidArgumentException {
        this.checkChannelState();
        this.checkPeers(peers);
        LifecycleChaincodePackage lifecycleChaincodePackage = installProposalRequest.getLifecycleChaincodePackage();
        if (null == lifecycleChaincodePackage) {
            throw new InvalidArgumentException("Install request is missing lifecycle package");
        }
        byte[] chaincodeBytes = lifecycleChaincodePackage.getAsBytes();
        if (null == chaincodeBytes) {
            throw new InvalidArgumentException("InstallProposalRequest lifecycleChaincodePackage bytes is null.");
        }
        if (chaincodeBytes.length == 0) {
            throw new InvalidArgumentException("InstallProposalRequest lifecycleChaincodePackage bytes is empty.");
        }
        try {
            TransactionContext transactionContext = this.newTransactionContext(installProposalRequest);
            transactionContext.verify(false);
            LifecycleInstallProposalBuilder installProposalbuilder = LifecycleInstallProposalBuilder.newBuilder();
            installProposalbuilder.setChaincodeBytes(chaincodeBytes);
            installProposalbuilder.context(transactionContext);
            ProposalPackage.Proposal deploymentProposal = installProposalbuilder.build();
            ProposalPackage.SignedProposal signedProposal = this.getSignedProposal(transactionContext, deploymentProposal);
            return this.sendProposalToPeers(peers, signedProposal, transactionContext, LifecycleInstallChaincodeProposalResponse.class);
        }
        catch (Exception e) {
            throw new ProposalException(e);
        }
    }

    public LifecycleApproveChaincodeDefinitionForMyOrgProposalResponse sendLifecycleApproveChaincodeDefinitionForMyOrgProposal(LifecycleApproveChaincodeDefinitionForMyOrgRequest lifecycleApproveChaincodeDefinitionForMyOrgRequest, Peer peer) throws ProposalException, InvalidArgumentException {
        if (null == lifecycleApproveChaincodeDefinitionForMyOrgRequest) {
            throw new InvalidArgumentException("The lifecycleApproveChaincodeDefinitionForMyOrgRequest parameter can not be null.");
        }
        Collection<LifecycleApproveChaincodeDefinitionForMyOrgProposalResponse> lifecycleApproveChaincodeDefinitionForMyOrgProposalResponses = this.sendLifecycleApproveChaincodeDefinitionForMyOrgProposal(lifecycleApproveChaincodeDefinitionForMyOrgRequest, Collections.singleton(peer));
        return lifecycleApproveChaincodeDefinitionForMyOrgProposalResponses.iterator().next();
    }

    public Collection<LifecycleApproveChaincodeDefinitionForMyOrgProposalResponse> sendLifecycleApproveChaincodeDefinitionForMyOrgProposal(LifecycleApproveChaincodeDefinitionForMyOrgRequest lifecycleApproveChaincodeDefinitionForMyOrgRequest, Collection<Peer> peers) throws ProposalException, InvalidArgumentException {
        if (null == lifecycleApproveChaincodeDefinitionForMyOrgRequest) {
            throw new InvalidArgumentException("The lifecycleApproveChaincodeDefinitionForMyOrgRequest parameter can not be null.");
        }
        this.checkChannelState();
        this.checkPeers(peers);
        try {
            ChaincodeCollectionConfiguration chaincodeCollectionConfiguration;
            String chaincodeCodeValidationPlugin;
            String chaincodeCodeEndorsementPlugin;
            ByteString validationParamter;
            TransactionContext transactionContext = this.newTransactionContext(lifecycleApproveChaincodeDefinitionForMyOrgRequest);
            LifecycleApproveChaincodeDefinitionForMyOrgProposalBuilder approveChaincodeDefinitionForMyOrgProposalBuilder = LifecycleApproveChaincodeDefinitionForMyOrgProposalBuilder.newBuilder();
            if (IS_TRACE_LEVEL) {
                logger.trace((Object)String.format("LifecycleApproveChaincodeDefinitionForMyOrg channel: %s, sequence: %d, chaincodeName: %s, chaincodeVersion: %s, packageId: %s, sourceUnavailable: %b, isInitRequired: %s, validationParameter: '%s', endorsementPolicyPlugin: %s, validationPlugin: %s", this.name, lifecycleApproveChaincodeDefinitionForMyOrgRequest.getSequence(), lifecycleApproveChaincodeDefinitionForMyOrgRequest.getChaincodeName(), lifecycleApproveChaincodeDefinitionForMyOrgRequest.getChaincodeVersion(), lifecycleApproveChaincodeDefinitionForMyOrgRequest.getPackageId(), lifecycleApproveChaincodeDefinitionForMyOrgRequest.isSourceUnavailable(), lifecycleApproveChaincodeDefinitionForMyOrgRequest.isInitRequired() + SYSTEM_CHANNEL_NAME, Utils.toHexString(lifecycleApproveChaincodeDefinitionForMyOrgRequest.getValidationParameter()), lifecycleApproveChaincodeDefinitionForMyOrgRequest.getChaincodeEndorsementPlugin(), lifecycleApproveChaincodeDefinitionForMyOrgRequest.getChaincodeValidationPlugin()));
            }
            approveChaincodeDefinitionForMyOrgProposalBuilder.context(transactionContext);
            approveChaincodeDefinitionForMyOrgProposalBuilder.sequence(lifecycleApproveChaincodeDefinitionForMyOrgRequest.getSequence());
            approveChaincodeDefinitionForMyOrgProposalBuilder.chaincodeName(lifecycleApproveChaincodeDefinitionForMyOrgRequest.getChaincodeName());
            approveChaincodeDefinitionForMyOrgProposalBuilder.version(lifecycleApproveChaincodeDefinitionForMyOrgRequest.getChaincodeVersion());
            String packageId = lifecycleApproveChaincodeDefinitionForMyOrgRequest.getPackageId();
            if (null != packageId) {
                approveChaincodeDefinitionForMyOrgProposalBuilder.setPackageId(packageId);
            } else if (!lifecycleApproveChaincodeDefinitionForMyOrgRequest.isSourceUnavailable()) {
                throw new InvalidArgumentException("The request must have a specific packageId or sourceNone set to true.");
            }
            Boolean initRequired = lifecycleApproveChaincodeDefinitionForMyOrgRequest.isInitRequired();
            if (null != initRequired) {
                approveChaincodeDefinitionForMyOrgProposalBuilder.initRequired(initRequired);
            }
            if (null != (validationParamter = lifecycleApproveChaincodeDefinitionForMyOrgRequest.getValidationParameter())) {
                approveChaincodeDefinitionForMyOrgProposalBuilder.setValidationParamter(validationParamter);
            }
            if (null != (chaincodeCodeEndorsementPlugin = lifecycleApproveChaincodeDefinitionForMyOrgRequest.getChaincodeEndorsementPlugin())) {
                approveChaincodeDefinitionForMyOrgProposalBuilder.chaincodeCodeEndorsementPlugin(chaincodeCodeEndorsementPlugin);
            }
            if (null != (chaincodeCodeValidationPlugin = lifecycleApproveChaincodeDefinitionForMyOrgRequest.getChaincodeValidationPlugin())) {
                approveChaincodeDefinitionForMyOrgProposalBuilder.chaincodeCodeValidationPlugin(chaincodeCodeValidationPlugin);
            }
            if (null != (chaincodeCollectionConfiguration = lifecycleApproveChaincodeDefinitionForMyOrgRequest.getChaincodeCollectionConfiguration())) {
                approveChaincodeDefinitionForMyOrgProposalBuilder.chaincodeCollectionConfiguration(chaincodeCollectionConfiguration.getCollectionConfigPackage());
            }
            ProposalPackage.Proposal deploymentProposal = approveChaincodeDefinitionForMyOrgProposalBuilder.build();
            ProposalPackage.SignedProposal signedProposal = this.getSignedProposal(transactionContext, deploymentProposal);
            return this.sendProposalToPeers(peers, signedProposal, transactionContext, LifecycleApproveChaincodeDefinitionForMyOrgProposalResponse.class);
        }
        catch (Exception e) {
            throw new ProposalException(e);
        }
    }

    public Collection<LifecycleCommitChaincodeDefinitionProposalResponse> sendLifecycleCommitChaincodeDefinitionProposal(LifecycleCommitChaincodeDefinitionRequest lifecycleCommitChaincodeDefinitionRequest, Collection<Peer> peers) throws InvalidArgumentException, ProposalException {
        if (null == lifecycleCommitChaincodeDefinitionRequest) {
            throw new InvalidArgumentException("The lifecycleCommitChaincodeDefinitionRequest parameter can not be null.");
        }
        this.checkChannelState();
        this.checkPeers(peers);
        try {
            ChaincodeCollectionConfiguration chaincodeCollectionConfiguration;
            String chaincodeCodeValidationPlugin;
            String chaincodeCodeEndorsementPlugin;
            ByteString validationParameter;
            if (IS_TRACE_LEVEL) {
                byte[] asBytes;
                String collectionData = "null";
                ChaincodeCollectionConfiguration chaincodeCollectionConfiguration2 = lifecycleCommitChaincodeDefinitionRequest.getChaincodeCollectionConfiguration();
                if (null != chaincodeCollectionConfiguration2 && null != (asBytes = chaincodeCollectionConfiguration2.getAsBytes())) {
                    collectionData = Utils.toHexString(asBytes);
                }
                logger.trace((Object)String.format("LifecycleCommitChaincodeDefinition channel: %s, sequence: %d, chaincodeName: %s, chaincodeVersion: %s, isInitRequired: %s, validationParameter: '%s', endorsementPolicyPlugin: %s, validationPlugin: %s, collectionConfiguration: %s", this.name, lifecycleCommitChaincodeDefinitionRequest.getSequence(), lifecycleCommitChaincodeDefinitionRequest.getChaincodeName(), lifecycleCommitChaincodeDefinitionRequest.getChaincodeVersion(), lifecycleCommitChaincodeDefinitionRequest.isInitRequired() + SYSTEM_CHANNEL_NAME, Utils.toHexString(lifecycleCommitChaincodeDefinitionRequest.getValidationParameter()), lifecycleCommitChaincodeDefinitionRequest.getChaincodeEndorsementPlugin(), lifecycleCommitChaincodeDefinitionRequest.getChaincodeValidationPlugin(), collectionData));
            }
            TransactionContext transactionContext = this.newTransactionContext(lifecycleCommitChaincodeDefinitionRequest);
            LifecycleCommitChaincodeDefinitionProposalBuilder commitChaincodeDefinitionProposalBuilder = LifecycleCommitChaincodeDefinitionProposalBuilder.newBuilder();
            commitChaincodeDefinitionProposalBuilder.context(transactionContext);
            commitChaincodeDefinitionProposalBuilder.chaincodeName(lifecycleCommitChaincodeDefinitionRequest.getChaincodeName());
            commitChaincodeDefinitionProposalBuilder.version(lifecycleCommitChaincodeDefinitionRequest.getChaincodeVersion());
            commitChaincodeDefinitionProposalBuilder.sequence(lifecycleCommitChaincodeDefinitionRequest.getSequence());
            Boolean initRequired = lifecycleCommitChaincodeDefinitionRequest.isInitRequired();
            if (null != initRequired) {
                commitChaincodeDefinitionProposalBuilder.initRequired(initRequired);
            }
            if (null != (validationParameter = lifecycleCommitChaincodeDefinitionRequest.getValidationParameter())) {
                commitChaincodeDefinitionProposalBuilder.setValidationParamter(validationParameter);
            }
            if (null != (chaincodeCodeEndorsementPlugin = lifecycleCommitChaincodeDefinitionRequest.getChaincodeEndorsementPlugin())) {
                commitChaincodeDefinitionProposalBuilder.chaincodeCodeEndorsementPlugin(chaincodeCodeEndorsementPlugin);
            }
            if (null != (chaincodeCodeValidationPlugin = lifecycleCommitChaincodeDefinitionRequest.getChaincodeValidationPlugin())) {
                commitChaincodeDefinitionProposalBuilder.chaincodeCodeValidationPlugin(chaincodeCodeValidationPlugin);
            }
            if (null != (chaincodeCollectionConfiguration = lifecycleCommitChaincodeDefinitionRequest.getChaincodeCollectionConfiguration())) {
                commitChaincodeDefinitionProposalBuilder.chaincodeCollectionConfiguration(chaincodeCollectionConfiguration.getCollectionConfigPackage());
            }
            ProposalPackage.Proposal deploymentProposal = commitChaincodeDefinitionProposalBuilder.build();
            ProposalPackage.SignedProposal signedProposal = this.getSignedProposal(transactionContext, deploymentProposal);
            return this.sendProposalToPeers(peers, signedProposal, transactionContext, LifecycleCommitChaincodeDefinitionProposalResponse.class);
        }
        catch (Exception e) {
            throw new ProposalException(e);
        }
    }

    Collection<LifecycleQueryInstalledChaincodesProposalResponse> lifecycleQueryInstalledChaincodes(LifecycleQueryInstalledChaincodesRequest lifecycleQueryInstalledChaincodesRequest, Collection<Peer> peers) throws InvalidArgumentException, ProposalException {
        logger.trace((Object)"LifecycleQueryInstalledChaincodes");
        if (null == lifecycleQueryInstalledChaincodesRequest) {
            throw new InvalidArgumentException("The lifecycleQueryInstalledChaincodesRequest parameter can not be null.");
        }
        this.checkPeers(peers);
        if (!this.isSystemChannel()) {
            throw new InvalidArgumentException("LifecycleQueryInstalledChaincodes should only be invoked on system channel.");
        }
        try {
            TransactionContext context = this.newTransactionContext(lifecycleQueryInstalledChaincodesRequest);
            ProposalPackage.Proposal proposalBuilder = LifecycleQueryInstalledChaincodesBuilder.newBuilder().context(context).build();
            ProposalPackage.SignedProposal qProposal = this.getSignedProposal(context, proposalBuilder);
            return this.sendProposalToPeers(peers, qProposal, context, LifecycleQueryInstalledChaincodesProposalResponse.class);
        }
        catch (ProposalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProposalException(String.format("Query for peer %s channels failed. " + e.getMessage(), this.name), e);
        }
    }

    Collection<LifecycleQueryInstalledChaincodeProposalResponse> lifecycleQueryInstalledChaincode(LifecycleQueryInstalledChaincodeRequest lifecycleQueryInstalledChaincodeRequest, Collection<Peer> peers) throws InvalidArgumentException, ProposalException {
        if (null == lifecycleQueryInstalledChaincodeRequest) {
            throw new InvalidArgumentException("The lifecycleQueryInstalledChaincodeRequest parameter can not be null.");
        }
        this.checkPeers(peers);
        if (!this.isSystemChannel()) {
            throw new InvalidArgumentException("LifecycleQueryInstalledChaincodes should only be invoked on system channel.");
        }
        try {
            logger.trace((Object)String.format("LifecycleQueryInstalledChaincode packageID: %s", lifecycleQueryInstalledChaincodeRequest.getPackageId()));
            TransactionContext context = this.newTransactionContext(lifecycleQueryInstalledChaincodeRequest);
            LifecycleQueryInstalledChaincodeBuilder lifecycleQueryInstalledChaincodeBuilder = LifecycleQueryInstalledChaincodeBuilder.newBuilder();
            lifecycleQueryInstalledChaincodeBuilder.setPackageId(lifecycleQueryInstalledChaincodeRequest.getPackageId());
            lifecycleQueryInstalledChaincodeBuilder.context(context);
            ProposalPackage.SignedProposal qProposal = this.getSignedProposal(context, lifecycleQueryInstalledChaincodeBuilder.build());
            return this.sendProposalToPeers(peers, qProposal, context, LifecycleQueryInstalledChaincodeProposalResponse.class);
        }
        catch (ProposalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProposalException(String.format("Query for peer %s channels failed. " + e.getMessage(), this.name), e);
        }
    }

    public Collection<LifecycleQueryChaincodeDefinitionsProposalResponse> lifecycleQueryChaincodeDefinitions(LifecycleQueryChaincodeDefinitionsRequest proposalRequest, Collection<Peer> peers) throws InvalidArgumentException, ProposalException {
        if (null == proposalRequest) {
            throw new InvalidArgumentException("The proposal request can not be null.");
        }
        this.checkChannelState();
        this.checkPeers(peers);
        try {
            logger.trace((Object)String.format("lifecycleQueryChaincodeDefinitions channel: %s", this.name));
            TransactionContext context = this.newTransactionContext(proposalRequest);
            LifecycleQueryChaincodeDefinitionsBuilder proposalBuilder = LifecycleQueryChaincodeDefinitionsBuilder.newBuilder();
            proposalBuilder.context(context);
            ProposalPackage.SignedProposal proposal = this.getSignedProposal(context, proposalBuilder.build());
            return this.sendProposalToPeers(peers, proposal, context, LifecycleQueryChaincodeDefinitionsProposalResponse.class);
        }
        catch (Exception e) {
            throw new ProposalException(String.format("QueryChaincodeDefinitions %s channel failed. " + e.getMessage(), this.name), e);
        }
    }

    public Collection<LifecycleCheckCommitReadinessProposalResponse> sendLifecycleCheckCommitReadinessRequest(LifecycleCheckCommitReadinessRequest lifecycleCheckCommitReadinessRequest, Collection<Peer> peers) throws InvalidArgumentException, ProposalException {
        if (null == lifecycleCheckCommitReadinessRequest) {
            throw new InvalidArgumentException("The lifecycleSimulateCommitChaincodeDefinitionRequest parameter can not be null.");
        }
        this.checkChannelState();
        this.checkPeers(peers);
        try {
            Boolean initRequired;
            Collection.CollectionConfigPackage collectionConfigPackage;
            ByteString validationParameter;
            String validationPlugin;
            if (IS_TRACE_LEVEL) {
                byte[] asBytes;
                String collectionData = "null";
                Collection.CollectionConfigPackage chaincodeCollectionConfiguration = lifecycleCheckCommitReadinessRequest.getCollectionConfigPackage();
                if (null != chaincodeCollectionConfiguration && null != (asBytes = chaincodeCollectionConfiguration.toByteArray())) {
                    collectionData = Utils.toHexString(asBytes);
                }
                logger.trace((Object)String.format("LifecycleSimulateCommitChaincodeDefinition channel: %s, sequence: %d, chaincodeName: %s, chaincodeVersion: %s, isInitRequired: %s, validationParameter: '%s', endorsementPolicyPlugin: %s, validationPlugin: %s, collectionConfiguration: %s", this.name, lifecycleCheckCommitReadinessRequest.getSequence(), lifecycleCheckCommitReadinessRequest.getChaincodeName(), lifecycleCheckCommitReadinessRequest.getChaincodeVersion(), lifecycleCheckCommitReadinessRequest.isInitRequired() + SYSTEM_CHANNEL_NAME, Utils.toHexString(lifecycleCheckCommitReadinessRequest.getValidationParameter()), lifecycleCheckCommitReadinessRequest.getChaincodeEndorsementPlugin(), lifecycleCheckCommitReadinessRequest.getChaincodeValidationPlugin(), collectionData));
            }
            TransactionContext context = this.newTransactionContext(lifecycleCheckCommitReadinessRequest);
            LifecycleCheckCommitReadinessBuilder lifecycleCheckCommitReadinessBuilder = LifecycleCheckCommitReadinessBuilder.newBuilder();
            lifecycleCheckCommitReadinessBuilder.setSequence(lifecycleCheckCommitReadinessRequest.getSequence());
            lifecycleCheckCommitReadinessBuilder.setName(lifecycleCheckCommitReadinessRequest.getChaincodeName());
            lifecycleCheckCommitReadinessBuilder.setVersion(lifecycleCheckCommitReadinessRequest.getChaincodeVersion());
            String endorsementPlugin = lifecycleCheckCommitReadinessRequest.getChaincodeEndorsementPlugin();
            if (!Utils.isNullOrEmpty(endorsementPlugin)) {
                lifecycleCheckCommitReadinessBuilder.setEndorsementPlugin(endorsementPlugin);
            }
            if (!Utils.isNullOrEmpty(validationPlugin = lifecycleCheckCommitReadinessRequest.getChaincodeValidationPlugin())) {
                lifecycleCheckCommitReadinessBuilder.setValidationPlugin(validationPlugin);
            }
            if (null != (validationParameter = lifecycleCheckCommitReadinessRequest.getValidationParameter())) {
                lifecycleCheckCommitReadinessBuilder.setValidationParameter(validationParameter);
            }
            if (null != (collectionConfigPackage = lifecycleCheckCommitReadinessRequest.getCollectionConfigPackage())) {
                lifecycleCheckCommitReadinessBuilder.setCollections(collectionConfigPackage);
            }
            if (null != (initRequired = lifecycleCheckCommitReadinessRequest.isInitRequired())) {
                lifecycleCheckCommitReadinessBuilder.setInitRequired(initRequired);
            }
            lifecycleCheckCommitReadinessBuilder.context(context);
            ProposalPackage.SignedProposal qProposal = this.getSignedProposal(context, lifecycleCheckCommitReadinessBuilder.build());
            return this.sendProposalToPeers(peers, qProposal, context, LifecycleCheckCommitReadinessProposalResponse.class);
        }
        catch (Exception e) {
            throw new ProposalException(String.format("CheckCommitReadiness %s channel failed. " + e.getMessage(), this.name), e);
        }
    }

    public Collection<LifecycleQueryChaincodeDefinitionProposalResponse> lifecycleQueryChaincodeDefinition(QueryLifecycleQueryChaincodeDefinitionRequest queryLifecycleQueryChaincodeDefinitionRequest, Collection<Peer> peers) throws InvalidArgumentException, ProposalException {
        if (null == queryLifecycleQueryChaincodeDefinitionRequest) {
            throw new InvalidArgumentException("The queryLifecycleQueryChaincodeDefinitionRequest parameter can not be null.");
        }
        this.checkChannelState();
        this.checkPeers(peers);
        try {
            logger.trace((Object)String.format("LifecycleQueryChaincodeDefinition channel: %s, chaincode name: %s", this.name, queryLifecycleQueryChaincodeDefinitionRequest.getChaincodeName()));
            TransactionContext context = this.newTransactionContext(queryLifecycleQueryChaincodeDefinitionRequest);
            LifecycleQueryChaincodeDefinitionBuilder lifecycleQueryChaincodeDefinitionBuilder = LifecycleQueryChaincodeDefinitionBuilder.newBuilder();
            lifecycleQueryChaincodeDefinitionBuilder.context(context).setChaincodeName(queryLifecycleQueryChaincodeDefinitionRequest.getChaincodeName());
            ProposalPackage.SignedProposal qProposal = this.getSignedProposal(context, lifecycleQueryChaincodeDefinitionBuilder.build());
            return this.sendProposalToPeers(peers, qProposal, context, LifecycleQueryChaincodeDefinitionProposalResponse.class);
        }
        catch (ProposalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProposalException(String.format("Query for peer %s channels failed. " + e.getMessage(), this.name), e);
        }
    }

    public List<Query.ChaincodeInfo> queryInstantiatedChaincodes(Peer peer) throws InvalidArgumentException, ProposalException {
        return this.queryInstantiatedChaincodes(peer, this.client.getUserContext());
    }

    public List<Query.ChaincodeInfo> queryInstantiatedChaincodes(Peer peer, User userContext) throws InvalidArgumentException, ProposalException {
        this.checkChannelState();
        this.checkPeer(peer);
        User.userContextCheck(userContext);
        try {
            TransactionContext context = this.newTransactionContext(userContext);
            ProposalPackage.Proposal q = QueryInstantiatedChaincodesBuilder.newBuilder().context(context).build();
            ProposalPackage.SignedProposal qProposal = this.getSignedProposal(context, q);
            Collection<ProposalResponse> proposalResponses = this.sendProposalToPeers(Collections.singletonList(peer), qProposal, context);
            if (null == proposalResponses) {
                throw new ProposalException(String.format("Peer %s channel query return with null for responses", peer.getName()));
            }
            if (proposalResponses.size() != 1) {
                throw new ProposalException(String.format("Peer %s channel query expected one response but got back %d  responses ", peer.getName(), proposalResponses.size()));
            }
            ProposalResponse proposalResponse = proposalResponses.iterator().next();
            ProposalResponsePackage.ProposalResponse fabricResponse = proposalResponse.getProposalResponse();
            if (null == fabricResponse) {
                throw new ProposalException(String.format("Peer %s channel query return with empty fabric response", peer.getName()));
            }
            ProposalResponsePackage.Response fabricResponseResponse = fabricResponse.getResponse();
            if (null == fabricResponseResponse) {
                throw new ProposalException(String.format("Peer %s channel query return with empty fabricResponseResponse", peer.getName()));
            }
            if (200 != fabricResponseResponse.getStatus()) {
                throw new ProposalException(String.format("Peer %s channel query expected 200, actual returned was: %d. " + fabricResponseResponse.getMessage(), peer.getName(), fabricResponseResponse.getStatus()));
            }
            Query.ChaincodeQueryResponse chaincodeQueryResponse = Query.ChaincodeQueryResponse.parseFrom(fabricResponseResponse.getPayload());
            return chaincodeQueryResponse.getChaincodesList();
        }
        catch (ProposalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProposalException(String.format("Query for peer %s channels failed. " + e.getMessage(), this.name), e);
        }
    }

    public CollectionConfigPackage queryCollectionsConfig(String chaincodeName, Peer peer, User userContext) throws InvalidArgumentException, ProposalException {
        if (Utils.isNullOrEmpty(chaincodeName)) {
            throw new InvalidArgumentException("Parameter chaincodeName expected to be non null or empty string.");
        }
        this.checkChannelState();
        this.checkPeer(peer);
        User.userContextCheck(userContext);
        try {
            TransactionContext context = this.newTransactionContext(userContext);
            QueryCollectionsConfigBuilder queryCollectionsConfigBuilder = QueryCollectionsConfigBuilder.newBuilder().context(context).chaincodeName(chaincodeName);
            ProposalPackage.Proposal q = queryCollectionsConfigBuilder.build();
            ProposalPackage.SignedProposal qProposal = this.getSignedProposal(context, q);
            Collection<ProposalResponse> proposalResponses = this.sendProposalToPeers(Collections.singletonList(peer), qProposal, context);
            if (null == proposalResponses) {
                throw new ProposalException(String.format("Peer %s channel query return with null for responses", peer.getName()));
            }
            if (proposalResponses.size() != 1) {
                throw new ProposalException(String.format("Peer %s channel query expected one response but got back %d  responses ", peer.getName(), proposalResponses.size()));
            }
            ProposalResponse proposalResponse = proposalResponses.iterator().next();
            ProposalResponsePackage.ProposalResponse fabricResponse = proposalResponse.getProposalResponse();
            if (null == fabricResponse) {
                throw new ProposalException(String.format("Peer %s channel query return with empty fabric response", peer.getName()));
            }
            ProposalResponsePackage.Response fabricResponseResponse = fabricResponse.getResponse();
            if (null == fabricResponseResponse) {
                throw new ProposalException(String.format("Peer %s channel query return with empty fabricResponseResponse", peer.getName()));
            }
            if (200 != fabricResponseResponse.getStatus()) {
                throw new ProposalException(String.format("Peer %s channel query expected 200, actual returned was: %d. " + fabricResponseResponse.getMessage(), peer.getName(), fabricResponseResponse.getStatus()));
            }
            return new CollectionConfigPackage(fabricResponseResponse.getPayload());
        }
        catch (ProposalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ProposalException(String.format("Query for peer %s channels failed. " + e.getMessage(), this.name), e);
        }
    }

    public Collection<ProposalResponse> sendTransactionProposal(TransactionProposalRequest transactionProposalRequest) throws ProposalException, InvalidArgumentException {
        return this.sendProposal(transactionProposalRequest, this.getEndorsingPeers());
    }

    public Collection<ProposalResponse> sendTransactionProposalToEndorsers(TransactionProposalRequest transactionProposalRequest, DiscoveryOptions discoveryOptions) throws ProposalException, InvalidArgumentException, ServiceDiscoveryException {
        ServiceDiscovery.SDChaindcode sdChaindcode;
        String chaincodeName = transactionProposalRequest.getChaincodeName() != null ? transactionProposalRequest.getChaincodeName() : transactionProposalRequest.getChaincodeID().getName();
        this.checkChannelState();
        if (null == transactionProposalRequest) {
            throw new InvalidArgumentException("The proposalRequest is null");
        }
        if (Utils.isNullOrEmpty(transactionProposalRequest.getFcn())) {
            throw new InvalidArgumentException("The proposalRequest's fcn is null or empty.");
        }
        if (null == this.serviceDiscovery) {
            throw new ServiceDiscoveryException("The channel is not configured with any peers with the 'discover' role");
        }
        logger.debug((Object)String.format("Channel %s sendTransactionProposalToEndorsers chaincode name: %s", this.name, chaincodeName));
        TransactionContext transactionContext = this.getTransactionContext(transactionProposalRequest);
        transactionContext.verify(transactionProposalRequest.doVerify());
        transactionContext.setProposalWaitTime(transactionProposalRequest.getProposalWaitTime());
        ProposalBuilder proposalBuilder = ProposalBuilder.newBuilder();
        proposalBuilder.context(transactionContext);
        proposalBuilder.request(transactionProposalRequest);
        ProposalPackage.SignedProposal invokeProposal = null;
        try {
            invokeProposal = this.getSignedProposal(transactionContext, proposalBuilder.build());
        }
        catch (CryptoException e) {
            throw new InvalidArgumentException(e);
        }
        List<ServiceDiscoveryChaincodeCalls> serviceDiscoveryChaincodeInterests = discoveryOptions.getServiceDiscoveryChaincodeInterests();
        if (null != serviceDiscoveryChaincodeInterests && !serviceDiscoveryChaincodeInterests.isEmpty()) {
            String firstname = serviceDiscoveryChaincodeInterests.get(0).getName();
            if (!firstname.equals(chaincodeName)) {
                serviceDiscoveryChaincodeInterests.add(0, new ServiceDiscoveryChaincodeCalls(chaincodeName));
            }
            LinkedList<List<ServiceDiscoveryChaincodeCalls>> ccl = new LinkedList<List<ServiceDiscoveryChaincodeCalls>>();
            ccl.add(serviceDiscoveryChaincodeInterests);
            Map<String, ServiceDiscovery.SDChaindcode> sdChaindcodeMap = this.serviceDiscovery.discoverEndorserEndpoints(transactionContext, ccl);
            if (sdChaindcodeMap == null) {
                throw new ServiceDiscoveryException(String.format("Channel %s failed doing service discovery for chaincode %s ", this.name, chaincodeName));
            }
            sdChaindcode = sdChaindcodeMap.get(chaincodeName);
        } else {
            if (discoveryOptions.forceDiscovery) {
                logger.trace((Object)"Forcing discovery.");
                this.serviceDiscovery.networkDiscovery(transactionContext, true);
            }
            sdChaindcode = this.serviceDiscovery.discoverEndorserEndpoint(transactionContext, chaincodeName);
        }
        logger.trace((Object)String.format("Channel %s chaincode %s discovered: %s", this.name, chaincodeName, SYSTEM_CHANNEL_NAME + sdChaindcode));
        if (null == sdChaindcode) {
            throw new ServiceDiscoveryException(String.format("Channel %s failed to find any endorsers for chaincode %s", this.name, chaincodeName));
        }
        if (sdChaindcode.getLayouts() == null || sdChaindcode.getLayouts().isEmpty()) {
            throw new ServiceDiscoveryException(String.format("Channel %s failed to find any endorsers for chaincode %s no layouts found.", this.name, chaincodeName));
        }
        ServiceDiscovery.SDChaindcode sdChaindcodeEndorsementCopy = new ServiceDiscovery.SDChaindcode(sdChaindcode);
        boolean inspectResults = discoveryOptions.inspectResults;
        if (sdChaindcodeEndorsementCopy.ignoreList(discoveryOptions.getIgnoreList()) < 1) {
            throw new ServiceDiscoveryException("Applying ignore list reduced to no available endorser options.");
        }
        if (IS_TRACE_LEVEL && null != discoveryOptions.getIgnoreList() && !discoveryOptions.getIgnoreList().isEmpty()) {
            logger.trace((Object)String.format("SDchaincode after ignore list: %s", sdChaindcodeEndorsementCopy));
        }
        ServiceDiscovery.EndorsementSelector lendorsementSelector = discoveryOptions.endorsementSelector != null ? discoveryOptions.endorsementSelector : this.endorsementSelector;
        try {
            HashMap<ServiceDiscovery.SDEndorser, ProposalResponse> goodResponses = new HashMap<ServiceDiscovery.SDEndorser, ProposalResponse>();
            HashMap<ServiceDiscovery.SDEndorser, ProposalResponse> allTried = new HashMap<ServiceDiscovery.SDEndorser, ProposalResponse>();
            boolean done = false;
            int attempts = 1;
            do {
                if (IS_TRACE_LEVEL) {
                    logger.trace((Object)String.format("Attempts: %d,  chaincode discovery state: %s", attempts, sdChaindcodeEndorsementCopy));
                }
                ServiceDiscovery.SDEndorserState sdEndorserState = lendorsementSelector.endorserSelector(sdChaindcodeEndorsementCopy);
                if (IS_TRACE_LEVEL) {
                    StringBuilder sb = new StringBuilder(1000);
                    String sep = SYSTEM_CHANNEL_NAME;
                    for (ServiceDiscovery.SDEndorser sDEndorser : sdEndorserState.getSdEndorsers()) {
                        sb.append(sep).append(sDEndorser);
                        sep = ", ";
                    }
                    logger.trace((Object)String.format("Attempts: %d,  chaincode discovery state: %s. Endorser selector picked: %s. With selected endorsers: %s", attempts, sdChaindcodeEndorsementCopy.name, sdEndorserState.getPickedLayout(), sb.toString()));
                }
                Collection<ServiceDiscovery.SDEndorser> ep = sdEndorserState.getSdEndorsers();
                ep = new ArrayList<ServiceDiscovery.SDEndorser>(ep);
                if (IS_TRACE_LEVEL) {
                    StringBuilder sb = new StringBuilder(1000);
                    String sep = SYSTEM_CHANNEL_NAME;
                    for (ServiceDiscovery.SDEndorser sdEndorser3 : ep) {
                        sb.append(sep).append(sdEndorser3);
                    }
                    logger.trace((Object)String.format("Channel %s, chaincode %s attempts: %d requested endorsements: %s", this.name, chaincodeName, attempts, sb.toString()));
                }
                ep.removeIf(sdEndorser -> goodResponses.keySet().contains(sdEndorser));
                if (ep.isEmpty()) {
                    logger.debug((Object)String.format("Channel %s, chaincode %s attempts: %d endorser selector returned no additional endorements needed.", this.name, chaincodeName, attempts));
                    Collection<ServiceDiscovery.SDEndorser> needed = sdChaindcode.meetsEndorsmentPolicy(goodResponses.keySet());
                    if (needed != null) {
                        ArrayList<ProposalResponse> ret = new ArrayList<ProposalResponse>(needed.size());
                        needed.forEach(s -> ret.add((ProposalResponse)goodResponses.get(s)));
                        if (IS_DEBUG_LEVEL) {
                            StringBuilder stringBuilder = new StringBuilder(1000);
                            Object sep = SYSTEM_CHANNEL_NAME;
                            for (ProposalResponse proposalResponse : ret) {
                                stringBuilder.append((String)sep).append(proposalResponse.getPeer());
                                sep = ", ";
                            }
                            logger.debug((Object)String.format("Channel %s, chaincode %s attempts: %d got all needed endorsements: %s", this.name, chaincodeName, attempts, stringBuilder.toString()));
                        }
                        return ret;
                    }
                    logger.debug((Object)String.format("Channel %s, chaincode %s attempts: %d missing needed endorsements", this.name, chaincodeName, attempts));
                    if (inspectResults) {
                        return allTried.values();
                    }
                    throw new ServiceDiscoveryException(String.format("Could not meet endorsement policy for chaincode %s", chaincodeName));
                }
                HashMap<String, Peer> lpeerEndpointMap = new HashMap<String, Peer>(this.peerEndpointMap);
                HashMap<ServiceDiscovery.SDEndorser, Peer> endorsers = new HashMap<ServiceDiscovery.SDEndorser, Peer>(ep.size());
                HashMap<PeerExactMatch, ServiceDiscovery.SDEndorser> hashMap = new HashMap<PeerExactMatch, ServiceDiscovery.SDEndorser>(ep.size());
                for (final ServiceDiscovery.SDEndorser sdEndorser4 : ep) {
                    Peer epeer = (Peer)lpeerEndpointMap.get(sdEndorser4.getEndpoint());
                    if (epeer != null && !epeer.hasConnected()) {
                        Properties properties = epeer.getProperties();
                        byte[] bytes = Channel.combineCerts(sdEndorser4.getTLSCerts(), sdEndorser4.getTLSIntermediateCerts());
                        properties.put("pemBytes", bytes);
                        epeer.setProperties(properties);
                    } else if (null == epeer) {
                        epeer = this.sdPeerAddition.addPeer(new SDPeerAdditionInfo(){

                            @Override
                            public String getMspId() {
                                return sdEndorser4.getMspid();
                            }

                            @Override
                            public String getEndpoint() {
                                return sdEndorser4.getEndpoint();
                            }

                            @Override
                            public Channel getChannel() {
                                return Channel.this;
                            }

                            @Override
                            public HFClient getClient() {
                                return Channel.this.client;
                            }

                            @Override
                            public byte[][] getTLSCerts() {
                                return (byte[][])sdEndorser4.getTLSCerts().toArray((T[])new byte[sdEndorser4.getTLSCerts().size()][]);
                            }

                            @Override
                            public byte[][] getTLSIntermediateCerts() {
                                return (byte[][])sdEndorser4.getTLSIntermediateCerts().toArray((T[])new byte[sdEndorser4.getTLSIntermediateCerts().size()][]);
                            }

                            @Override
                            public Map<String, Peer> getEndpointMap() {
                                return Collections.unmodifiableMap(Channel.this.peerEndpointMap);
                            }

                            @Override
                            public String getName() {
                                return sdEndorser4.getName();
                            }

                            @Override
                            public Properties getProperties() {
                                Properties properties = new Properties();
                                if (asLocalhost) {
                                    properties.put("hostnameOverride", sdEndorser4.getName().substring(0, sdEndorser4.getName().lastIndexOf(58)));
                                }
                                return properties;
                            }

                            @Override
                            public boolean isTLS() {
                                return sdEndorser4.isTLS();
                            }
                        });
                    }
                    endorsers.put(sdEndorser4, epeer);
                    hashMap.put(new PeerExactMatch(epeer), sdEndorser4);
                }
                Collection<ProposalResponse> proposalResponses = this.sendProposalToPeers(endorsers.values(), invokeProposal, transactionContext);
                HashSet<ServiceDiscovery.SDEndorser> loopGood = new HashSet<ServiceDiscovery.SDEndorser>();
                HashSet<ServiceDiscovery.SDEndorser> loopBad = new HashSet<ServiceDiscovery.SDEndorser>();
                for (ProposalResponse proposalResponse : proposalResponses) {
                    ServiceDiscovery.SDEndorser sdEndorser5 = (ServiceDiscovery.SDEndorser)hashMap.get(new PeerExactMatch(proposalResponse.getPeer()));
                    allTried.put(sdEndorser5, proposalResponse);
                    ChaincodeResponse.Status status = proposalResponse.getStatus();
                    if (ChaincodeResponse.Status.SUCCESS.equals((Object)status)) {
                        goodResponses.put(sdEndorser5, proposalResponse);
                        logger.trace((Object)String.format("Channel %s, chaincode %s attempts %d good endorsements: %s", this.name, chaincodeName, attempts, sdEndorser5));
                        loopGood.add(sdEndorser5);
                        continue;
                    }
                    logger.debug((Object)String.format("Channel %s, chaincode %s attempts %d bad endorsements: %s", this.name, chaincodeName, attempts, sdEndorser5));
                    loopBad.add(sdEndorser5);
                }
                Collection<ServiceDiscovery.SDEndorser> required = sdChaindcode.meetsEndorsmentPolicy(goodResponses.keySet());
                if (required != null) {
                    ArrayList<ProposalResponse> ret = new ArrayList<ProposalResponse>(required.size());
                    required.forEach(s -> ret.add((ProposalResponse)goodResponses.get(s)));
                    if (IS_DEBUG_LEVEL) {
                        StringBuilder sb = new StringBuilder(1000);
                        String sep = SYSTEM_CHANNEL_NAME;
                        for (ProposalResponse proposalResponse : ret) {
                            sb.append(sep).append(proposalResponse.getPeer());
                            sep = ", ";
                        }
                        logger.debug((Object)String.format("Channel %s, chaincode %s got all needed endorsements: %s", this.name, chaincodeName, sb.toString()));
                    }
                    return ret;
                }
                sdChaindcodeEndorsementCopy.endorsedList(loopGood);
                if (sdChaindcodeEndorsementCopy.ignoreListSDEndorser(loopBad) >= 1) continue;
                done = true;
            } while (!done && ++attempts <= 5);
            logger.debug((Object)String.format("Endorsements not achieved chaincode: %s, done: %b, attempts: %d", chaincodeName, done, attempts));
            if (inspectResults) {
                return allTried.values();
            }
            throw new ServiceDiscoveryException(String.format("Could not meet endorsement policy for chaincode %s", chaincodeName));
        }
        catch (ProposalException e) {
            throw e;
        }
        catch (Exception e) {
            ProposalException exp = new ProposalException(e);
            logger.error((Object)exp.getMessage(), (Throwable)exp);
            throw exp;
        }
    }

    public Collection<String> getDiscoveredChaincodeNames() {
        if (this.serviceDiscovery == null) {
            return Collections.emptyList();
        }
        return this.serviceDiscovery.getDiscoveredChaincodeNames();
    }

    public Collection<ProposalResponse> sendTransactionProposal(TransactionProposalRequest transactionProposalRequest, Collection<Peer> peers) throws ProposalException, InvalidArgumentException {
        return this.sendProposal(transactionProposalRequest, peers);
    }

    public Collection<ProposalResponse> queryByChaincode(QueryByChaincodeRequest queryByChaincodeRequest) throws InvalidArgumentException, ProposalException {
        return this.queryByChaincode(queryByChaincodeRequest, this.getChaincodeQueryPeers());
    }

    public Collection<ProposalResponse> queryByChaincode(QueryByChaincodeRequest queryByChaincodeRequest, Collection<Peer> peers) throws InvalidArgumentException, ProposalException {
        return this.sendProposal(queryByChaincodeRequest, peers);
    }

    private ProposalResponse sendProposalSerially(TransactionRequest proposalRequest, Collection<Peer> peers) throws ProposalException {
        ProposalException lastException = new ProposalException("ProposalRequest failed.");
        for (Peer peer : peers) {
            try {
                ProposalResponse proposalResponse;
                ChaincodeResponse.Status status;
                Collection<ProposalResponse> proposalResponses = this.sendProposal(proposalRequest, Collections.singletonList(peer));
                if (proposalResponses.isEmpty()) {
                    logger.warn((Object)String.format("Proposal request to peer %s failed", peer));
                }
                if ((status = (proposalResponse = proposalResponses.iterator().next()).getStatus()).getStatus() < 400) {
                    return proposalResponse;
                }
                if (status.getStatus() > 499) {
                    lastException = new ProposalException(String.format("Channel %s got exception on peer %s %d. %s ", this.name, peer, status.getStatus(), proposalResponse.getMessage()));
                    continue;
                }
                throw new ProposalException(String.format("Channel %s got exception on peer %s %d. %s ", this.name, peer, status.getStatus(), proposalResponse.getMessage()));
            }
            catch (Exception e) {
                lastException = new ProposalException(String.format("Channel %s failed proposal on peer %s  %s", this.name, peer.getName(), e.getMessage()), e);
                logger.warn((Object)lastException.getMessage());
            }
        }
        throw lastException;
    }

    private Collection<ProposalResponse> sendProposal(TransactionRequest proposalRequest, Collection<Peer> peers) throws InvalidArgumentException, ProposalException {
        this.checkChannelState();
        this.checkPeers(peers);
        if (null == proposalRequest) {
            throw new InvalidArgumentException("The proposalRequest is null");
        }
        if (Utils.isNullOrEmpty(proposalRequest.getFcn())) {
            throw new InvalidArgumentException("The proposalRequest's fcn is null or empty.");
        }
        try {
            TransactionContext transactionContext = this.getTransactionContext(proposalRequest);
            transactionContext.verify(proposalRequest.doVerify());
            transactionContext.setProposalWaitTime(proposalRequest.getProposalWaitTime());
            ProposalBuilder proposalBuilder = ProposalBuilder.newBuilder();
            proposalBuilder.context(transactionContext);
            proposalBuilder.request(proposalRequest);
            ProposalPackage.SignedProposal invokeProposal = this.getSignedProposal(transactionContext, proposalBuilder.build());
            return this.sendProposalToPeers(peers, invokeProposal, transactionContext);
        }
        catch (ProposalException e) {
            throw e;
        }
        catch (Exception e) {
            ProposalException exp = new ProposalException(e);
            logger.error((Object)exp.getMessage(), (Throwable)exp);
            throw exp;
        }
    }

    public ServiceDiscovery.EndorsementSelector setSDEndorserSelector(ServiceDiscovery.EndorsementSelector endorsementSelector) {
        ServiceDiscovery.EndorsementSelector ret = this.endorsementSelector;
        this.endorsementSelector = endorsementSelector;
        return ret;
    }

    private Collection<ProposalResponse> sendProposalToPeers(Collection<Peer> peers, ProposalPackage.SignedProposal signedProposal, TransactionContext transactionContext) throws InvalidArgumentException, ProposalException {
        return this.sendProposalToPeers(peers, signedProposal, transactionContext, ProposalResponse.class);
    }

    private <T extends ProposalResponse> Collection<T> sendProposalToPeers(Collection<Peer> peers, ProposalPackage.SignedProposal signedProposal, TransactionContext transactionContext, Class<T> clazz) throws InvalidArgumentException, ProposalException {
        Constructor<T> declaredConstructor;
        this.checkPeers(peers);
        if (transactionContext.getVerify()) {
            try {
                this.loadCACertificates(false);
            }
            catch (Exception e) {
                throw new ProposalException(e);
            }
        }
        try {
            declaredConstructor = clazz.getDeclaredConstructor(TransactionContext.class, Integer.TYPE, String.class);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidArgumentException(e);
        }
        String txID = transactionContext.getTxID();
        class Pair {
            private final Peer peer;
            private final Future<ProposalResponsePackage.ProposalResponse> future;

            Pair(Peer peer, Future<ProposalResponsePackage.ProposalResponse> future) {
                this.peer = peer;
                this.future = future;
            }
        }
        ArrayList<Pair> peerFuturePairs = new ArrayList<Pair>();
        for (Peer peer : peers) {
            CompletableFuture<ProposalResponsePackage.ProposalResponse> proposalResponseListenableFuture;
            logger.debug((Object)String.format("Channel %s send proposal to %s, txID: %s", this.name, peer.toString(), txID));
            if (null != diagnosticFileDumper) {
                logger.trace((Object)String.format("Sending to channel %s, peer: %s, proposal: %s, txID: %s", this.name, peer, txID, diagnosticFileDumper.createDiagnosticProtobufFile(signedProposal.toByteArray())));
            }
            try {
                proposalResponseListenableFuture = peer.sendProposalAsync(signedProposal);
            }
            catch (Exception e) {
                proposalResponseListenableFuture = new CompletableFuture();
                proposalResponseListenableFuture.completeExceptionally(e);
            }
            peerFuturePairs.add(new Pair(peer, proposalResponseListenableFuture));
        }
        ArrayList<ProposalResponse> proposalResponses = new ArrayList<ProposalResponse>();
        for (Pair peerFuturePair : peerFuturePairs) {
            String message;
            ProposalResponsePackage.ProposalResponse fabricResponse = null;
            int status = 500;
            String peerName = peerFuturePair.peer.toString();
            try {
                fabricResponse = (ProposalResponsePackage.ProposalResponse)peerFuturePair.future.get(transactionContext.getProposalWaitTime(), TimeUnit.MILLISECONDS);
                message = fabricResponse.getResponse().getMessage();
                status = fabricResponse.getResponse().getStatus();
                peerFuturePair.peer.setHasConnected();
                logger.debug((Object)String.format("Channel %s, transaction: %s got back from peer %s status: %d, message: %s", this.name, txID, peerName, status, message));
                if (null != diagnosticFileDumper) {
                    logger.trace((Object)String.format("Got back from channel %s, peer: %s, proposal response: %s", this.name, peerName, diagnosticFileDumper.createDiagnosticProtobufFile(fabricResponse.toByteArray())));
                }
            }
            catch (InterruptedException e) {
                message = "Sending proposal with transaction: " + txID + " to " + peerName + " failed because of interruption";
                logger.error((Object)message, (Throwable)e);
            }
            catch (TimeoutException e) {
                message = String.format("Channel %s sending proposal with transaction %s to %s failed because of timeout(%d milliseconds) expiration", this.toString(), txID, peerName, transactionContext.getProposalWaitTime());
                logger.error((Object)message, (Throwable)e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Error) {
                    String emsg = "Sending proposal with txID: " + txID + " to " + peerName + " failed because of " + cause.getMessage();
                    logger.error((Object)emsg, (Throwable)new Exception(cause));
                    throw (Error)cause;
                }
                message = cause instanceof StatusRuntimeException ? String.format("Channel %s Sending proposal with transaction: %s to %s failed because of: gRPC failure=%s", this.toString(), txID, peerName, ((StatusRuntimeException)cause).getStatus()) : String.format("Channel %s sending proposal with transaction: %s to %s failed because of: %s", this.toString(), txID, peerName, cause.getMessage());
                logger.error((Object)message, (Throwable)new Exception(cause));
            }
            ProposalResponse proposalResponse = null;
            try {
                proposalResponse = (ProposalResponse)declaredConstructor.newInstance(transactionContext, status, message);
            }
            catch (Exception e) {
                throw new InvalidArgumentException(e);
            }
            proposalResponse.setProposalResponse(fabricResponse);
            proposalResponse.setProposal(signedProposal);
            proposalResponse.setPeer(peerFuturePair.peer);
            if (fabricResponse != null && transactionContext.getVerify()) {
                proposalResponse.verify(this.client.getCryptoSuite());
            }
            proposalResponses.add(proposalResponse);
        }
        return proposalResponses;
    }

    public CompletableFuture<BlockEvent.TransactionEvent> sendTransaction(Collection<ProposalResponse> proposalResponses, User userContext) {
        return this.sendTransaction(proposalResponses, this.getOrderers(), userContext);
    }

    public CompletableFuture<BlockEvent.TransactionEvent> sendTransaction(Collection<? extends ProposalResponse> proposalResponses) {
        return this.sendTransaction(proposalResponses, this.getOrderers());
    }

    public CompletableFuture<BlockEvent.TransactionEvent> sendTransaction(Collection<? extends ProposalResponse> proposalResponses, Collection<Orderer> orderers) {
        return this.sendTransaction(proposalResponses, orderers, this.client.getUserContext());
    }

    public CompletableFuture<BlockEvent.TransactionEvent> sendTransaction(Collection<? extends ProposalResponse> proposalResponses, Collection<Orderer> orderers, User userContext) {
        return this.sendTransaction(proposalResponses, TransactionOptions.createTransactionOptions().orderers(orderers).userContext(userContext));
    }

    public CompletableFuture<BlockEvent.TransactionEvent> sendTransaction(Collection<? extends ProposalResponse> proposalResponses, TransactionOptions transactionOptions) {
        return this.doSendTransaction(proposalResponses, transactionOptions).whenComplete((result, exception) -> this.logCompletion("sendTransaction", (Object)result, (Throwable)exception));
    }

    private <T> T logCompletion(String message, T result, Throwable exception) {
        if (exception != null) {
            logger.error((Object)("Future completed exceptionally: " + message), exception);
        }
        return result;
    }

    private CompletableFuture<BlockEvent.TransactionEvent> doSendTransaction(Collection<? extends ProposalResponse> proposalResponses, TransactionOptions transactionOptions) {
        try {
            CompletableFuture<BlockEvent.TransactionEvent> sret;
            boolean replyonly;
            HashSet<ProposalResponse> invalid;
            int consistencyGroups;
            if (null == transactionOptions) {
                throw new InvalidArgumentException("Parameter transactionOptions can't be null");
            }
            this.checkChannelState();
            User userContext = transactionOptions.userContext != null ? transactionOptions.userContext : this.client.getUserContext();
            User.userContextCheck(userContext);
            if (null == proposalResponses) {
                throw new InvalidArgumentException("sendTransaction proposalResponses was null");
            }
            ArrayList<Orderer> orderers = transactionOptions.orderers != null ? transactionOptions.orderers : new ArrayList<Orderer>(this.getOrderers());
            ArrayList<Orderer> shuffeledOrderers = new ArrayList<Orderer>(orderers);
            if (transactionOptions.shuffleOrders) {
                Collections.shuffle(shuffeledOrderers);
            }
            if (config.getProposalConsistencyValidation() && ((consistencyGroups = SDKUtils.getProposalConsistencySets(proposalResponses, invalid = new HashSet<ProposalResponse>()).size()) != 1 || !invalid.isEmpty())) {
                throw new IllegalArgumentException(String.format("The proposal responses have %d inconsistent groups with %d that are invalid. Expected all to be consistent and none to be invalid.", consistencyGroups, invalid.size()));
            }
            LinkedList<ProposalResponsePackage.Endorsement> ed = new LinkedList<ProposalResponsePackage.Endorsement>();
            ProposalPackage.Proposal proposal = null;
            ByteString proposalResponsePayload = null;
            String proposalTransactionID = null;
            TransactionContext transactionContext = null;
            for (ProposalResponse proposalResponse : proposalResponses) {
                ed.add(proposalResponse.getProposalResponse().getEndorsement());
                if (proposal == null) {
                    proposal = proposalResponse.getProposal();
                    proposalTransactionID = proposalResponse.getTransactionID();
                    if (proposalTransactionID == null) {
                        throw new InvalidArgumentException("Proposals with missing transaction ID");
                    }
                    proposalResponsePayload = proposalResponse.getProposalResponse().getPayload();
                    if (proposalResponsePayload == null) {
                        throw new InvalidArgumentException("Proposals with missing payload.");
                    }
                    transactionContext = proposalResponse.getTransactionContext();
                    if (transactionContext != null) continue;
                    throw new InvalidArgumentException("Proposals with missing transaction context.");
                }
                String transactionID = proposalResponse.getTransactionID();
                if (transactionID == null) {
                    throw new InvalidArgumentException("Proposals with missing transaction id.");
                }
                if (proposalTransactionID.equals(transactionID)) continue;
                throw new InvalidArgumentException(String.format("Proposals with different transaction IDs %s,  and %s", proposalTransactionID, transactionID));
            }
            TransactionBuilder transactionBuilder = TransactionBuilder.newBuilder();
            Common.Payload payload = transactionBuilder.chaincodeProposal(proposal).endorsements(ed).proposalResponsePayload(proposalResponsePayload).build();
            Common.Envelope transactionEnvelope = this.createTransactionEnvelope(payload, transactionContext);
            NOfEvents nOfEvents = transactionOptions.nOfEvents;
            if (nOfEvents == null) {
                nOfEvents = NOfEvents.createNofEvents();
                Collection<Peer> eventingPeers = this.getEventingPeers();
                boolean anyAdded = false;
                if (!eventingPeers.isEmpty()) {
                    anyAdded = true;
                    nOfEvents.addPeers(eventingPeers);
                }
                if (!anyAdded) {
                    nOfEvents = NOfEvents.createNoEvents();
                }
            } else if (nOfEvents != NOfEvents.nofNoEvents) {
                String foundIssues;
                StringBuilder issues = new StringBuilder(100);
                Collection<Peer> eventingPeers = this.getEventingPeers();
                nOfEvents.unSeenPeers().forEach(peer -> {
                    if (peer.getChannel() != this) {
                        issues.append(String.format("Peer %s added to NOFEvents does not belong this channel. ", peer.getName()));
                    } else if (!eventingPeers.contains(peer)) {
                        issues.append(String.format("Peer %s added to NOFEvents is not a eventing Peer in this channel. ", peer.getName()));
                    }
                });
                if (nOfEvents.unSeenPeers().isEmpty()) {
                    issues.append("NofEvents had no added  Peer eventing services.");
                }
                if (!(foundIssues = issues.toString()).isEmpty()) {
                    throw new InvalidArgumentException(foundIssues);
                }
            }
            boolean bl = replyonly = nOfEvents == NOfEvents.nofNoEvents || this.getEventingPeers().isEmpty();
            if (replyonly) {
                logger.debug((Object)String.format("Completing transaction id %s immediately no peer eventing services found in channel %s.", proposalTransactionID, this.name));
                sret = new CompletableFuture();
            } else {
                sret = this.registerTxListener(proposalTransactionID, nOfEvents, transactionOptions.failFast);
            }
            logger.debug((Object)String.format("Channel %s sending transaction to orderer(s) with TxID %s ", this.name, proposalTransactionID));
            boolean success = false;
            Exception lException = null;
            Ab.BroadcastResponse resp = null;
            Orderer failed = null;
            for (Orderer orderer : shuffeledOrderers) {
                if (failed != null) {
                    logger.warn((Object)String.format("Channel %s  %s failed. Now trying %s.", this.name, failed, orderer));
                }
                failed = orderer;
                try {
                    if (null != diagnosticFileDumper) {
                        logger.trace((Object)String.format("Sending to channel %s, orderer: %s, transaction: %s", this.name, orderer.getName(), diagnosticFileDumper.createDiagnosticProtobufFile(transactionEnvelope.toByteArray())));
                    }
                    resp = orderer.sendTransaction(transactionEnvelope);
                    lException = null;
                    if (resp.getStatus() == Common.Status.SUCCESS) {
                        success = true;
                        break;
                    }
                    logger.warn((Object)String.format("Channel %s %s failed. Status returned %s", this.name, orderer, this.getRespData(resp)));
                }
                catch (Exception e) {
                    String emsg = String.format("Channel %s unsuccessful sendTransaction to orderer %s (%s)", this.name, orderer.getName(), orderer.getUrl());
                    if (resp != null) {
                        emsg = String.format("Channel %s unsuccessful sendTransaction to orderer %s (%s).  %s", this.name, orderer.getName(), orderer.getUrl(), this.getRespData(resp));
                    }
                    logger.error((Object)emsg);
                    lException = new Exception(emsg, e);
                }
            }
            if (success) {
                logger.debug((Object)String.format("Channel %s successful sent to Orderer transaction id: %s", this.name, proposalTransactionID));
                if (replyonly) {
                    sret.complete(null);
                }
                return sret;
            }
            String emsg = String.format("Channel %s failed to place transaction %s on Orderer. Cause: UNSUCCESSFUL. %s", this.name, proposalTransactionID, this.getRespData(resp));
            this.unregisterTxListener(proposalTransactionID);
            CompletableFuture<BlockEvent.TransactionEvent> ret = new CompletableFuture<BlockEvent.TransactionEvent>();
            ret.completeExceptionally(lException != null ? new Exception(emsg, lException) : new Exception(emsg));
            return ret;
        }
        catch (Exception e) {
            CompletableFuture<BlockEvent.TransactionEvent> future = new CompletableFuture<BlockEvent.TransactionEvent>();
            future.completeExceptionally(e);
            return future;
        }
    }

    private String getRespData(Ab.BroadcastResponse resp) {
        StringBuilder respdata = new StringBuilder(400);
        if (resp != null) {
            String info;
            Common.Status status = resp.getStatus();
            if (null != status) {
                respdata.append(status.name());
                respdata.append("-");
                respdata.append(status.getNumber());
            }
            if (null != (info = resp.getInfo()) && !info.isEmpty()) {
                if (respdata.length() > 0) {
                    respdata.append(", ");
                }
                respdata.append("Additional information: ").append(info);
            }
        }
        return respdata.toString();
    }

    private Common.Envelope createTransactionEnvelope(Common.Payload transactionPayload, TransactionContext transactionContext) throws CryptoException, InvalidArgumentException {
        return Common.Envelope.newBuilder().setPayload(transactionPayload.toByteString()).setSignature(ByteString.copyFrom((byte[])transactionContext.sign(transactionPayload.toByteArray()))).build();
    }

    byte[] getChannelConfigurationSignature(ChannelConfiguration channelConfiguration, User signer) throws InvalidArgumentException {
        User.userContextCheck(signer);
        if (null == channelConfiguration) {
            throw new InvalidArgumentException("channelConfiguration is null");
        }
        try {
            Common.Envelope ccEnvelope = Common.Envelope.parseFrom(channelConfiguration.getChannelConfigurationAsBytes());
            Common.Payload ccPayload = Common.Payload.parseFrom(ccEnvelope.getPayload());
            TransactionContext transactionContext = this.newTransactionContext(signer);
            Configtx.ConfigUpdateEnvelope configUpdateEnv = Configtx.ConfigUpdateEnvelope.parseFrom(ccPayload.getData());
            ByteString configUpdate = configUpdateEnv.getConfigUpdate();
            ByteString sigHeaderByteString = ProtoUtils.getSignatureHeaderAsByteString(signer, transactionContext);
            ByteString signatureByteSting = transactionContext.signByteStrings(new User[]{signer}, sigHeaderByteString, configUpdate)[0];
            byte[] byArray = Configtx.ConfigSignature.newBuilder().setSignatureHeader(sigHeaderByteString).setSignature(signatureByteSting).build().toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new InvalidArgumentException(e);
        }
        finally {
            logger.debug((Object)"finally done");
        }
    }

    public String registerBlockListener(BlockListener listener) throws InvalidArgumentException {
        if (this.shutdown) {
            throw new InvalidArgumentException(String.format("Channel %s has been shutdown.", this.name));
        }
        if (null == listener) {
            throw new InvalidArgumentException("Listener parameter is null.");
        }
        String handle = new BL(listener).getHandle();
        logger.trace((Object)String.format("Register event BlockEvent listener %s", handle));
        return handle;
    }

    public String registerBlockListener(BlockingQueue<QueuedBlockEvent> blockEventQueue) throws InvalidArgumentException {
        if (this.shutdown) {
            throw new InvalidArgumentException(String.format("Channel %s has been shutdown.", this.name));
        }
        if (null == blockEventQueue) {
            throw new InvalidArgumentException("BlockEventQueue parameter is null.");
        }
        String handle = new BL(blockEventQueue, -1L, null).getHandle();
        logger.trace((Object)String.format("Register QueuedBlockEvent listener %s", handle));
        return handle;
    }

    public String registerBlockListener(BlockingQueue<QueuedBlockEvent> blockEventQueue, long timeout, TimeUnit timeUnit) throws InvalidArgumentException {
        if (this.shutdown) {
            throw new InvalidArgumentException(String.format("Channel %s has been shutdown.", this.name));
        }
        if (null == blockEventQueue) {
            throw new InvalidArgumentException("BlockEventQueue parameter is null.");
        }
        if (timeout < 0L) {
            throw new InvalidArgumentException(String.format("Timeout parameter must be greater than 0 not %d", timeout));
        }
        if (null == timeUnit) {
            throw new InvalidArgumentException("TimeUnit parameter must not be null.");
        }
        String handle = new BL(blockEventQueue, timeout, timeUnit).getHandle();
        logger.trace((Object)String.format("Register QueuedBlockEvent listener %s", handle));
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterBlockListener(String handle) throws InvalidArgumentException {
        if (this.shutdown) {
            throw new InvalidArgumentException(String.format("Channel %s has been shutdown.", this.name));
        }
        Channel.checkHandle(BLOCK_LISTENER_TAG, handle);
        logger.trace((Object)String.format("Unregister BlockListener with handle %s.", handle));
        LinkedHashMap<String, BL> lblockListeners = this.blockListeners;
        if (lblockListeners == null) {
            return false;
        }
        LinkedHashMap<String, BL> linkedHashMap = lblockListeners;
        synchronized (linkedHashMap) {
            return null != lblockListeners.remove(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getBlockListenerHandles() throws InvalidArgumentException {
        if (this.shutdown) {
            throw new InvalidArgumentException(String.format("Channel %s has been shutdown.", this.name));
        }
        LinkedHashMap<String, BL> lblockListeners = this.blockListeners;
        if (lblockListeners == null) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, BL> linkedHashMap = lblockListeners;
        synchronized (linkedHashMap) {
            HashSet<String> ret = new HashSet<String>(lblockListeners.keySet());
            String ltransactionListenerProcessorHandle = this.transactionListenerProcessorHandle;
            if (null != ltransactionListenerProcessorHandle) {
                ret.remove(ltransactionListenerProcessorHandle);
            }
            return Collections.unmodifiableSet(ret);
        }
    }

    private void startEventQue() {
        if (this.eventQueueThread != null) {
            return;
        }
        this.client.getExecutorService().execute(() -> {
            this.eventQueueThread = Thread.currentThread();
            while (!this.shutdown) {
                BlockEvent blockEvent;
                if (!this.initialized) {
                    try {
                        logger.debug((Object)("not intialized:" + this.initialized));
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        logger.warn((Object)e);
                    }
                    continue;
                }
                try {
                    blockEvent = this.channelEventQue.getNextEvent();
                }
                catch (EventingException e) {
                    if (this.shutdown) continue;
                    logger.error((Object)e);
                    continue;
                }
                if (blockEvent == null) {
                    logger.warn((Object)"GOT null block event.");
                    continue;
                }
                try {
                    String blockchainID = blockEvent.getChannelId();
                    String from = String.format("Channel %s eventqueue got block event with block number: %d for channel: %s, from %s", this.name, blockEvent.getBlockNumber(), blockchainID, blockEvent.getPeer() != null ? SYSTEM_CHANNEL_NAME + blockEvent.getPeer() : SYSTEM_CHANNEL_NAME);
                    logger.trace((Object)from);
                    if (!Objects.equals(this.name, blockchainID)) {
                        logger.warn((Object)String.format("Channel %s eventqueue got block event NOT FOR ME  channelId %s  from %s", this.name, blockchainID, from));
                        continue;
                    }
                    ArrayList<BL> blcopy = new ArrayList<BL>(this.blockListeners.size() + 3);
                    LinkedHashMap<String, BL> linkedHashMap = this.blockListeners;
                    synchronized (linkedHashMap) {
                        blcopy.addAll(this.blockListeners.values());
                    }
                    for (BL l : blcopy) {
                        try {
                            logger.trace((Object)String.format("Sending block event '%s' to block listener %s", from, l.handle));
                            if (l.listener != null) {
                                this.client.getExecutorService().execute(() -> l.listener.received(blockEvent));
                                continue;
                            }
                            if (l.blockingQueue == null) continue;
                            if (l.timeout < 0L || l.timeUnit == null) {
                                l.blockingQueue.put(new QueuedBlockEvent(l.handle, blockEvent));
                                continue;
                            }
                            if (l.blockingQueue.offer(new QueuedBlockEvent(l.handle, blockEvent), l.timeout, l.timeUnit)) continue;
                            logger.warn((Object)String.format("Error calling block listener %s on channel: %s event: %s could not be added in time %d %s ", new Object[]{l.handle, this.name, from, l.timeout, l.timeUnit}));
                        }
                        catch (Throwable e) {
                            logger.error((Object)String.format("Error calling block listener %s on channel: %s event: %s ", l.handle, this.name, from), e);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Unable to parse event", (Throwable)e);
                    logger.debug((Object)"event:\n)");
                    logger.debug((Object)blockEvent.toString());
                }
            }
            logger.info((Object)String.format("Channel %s eventThread shutting down. shutdown: %b  thread: %s ", this.name, this.shutdown, Thread.currentThread().getName()));
        });
    }

    private String registerTransactionListenerProcessor() throws InvalidArgumentException {
        logger.debug((Object)String.format("Channel %s registerTransactionListenerProcessor starting", this.name));
        return this.registerBlockListener((BlockEvent blockEvent) -> {
            HFClient lclient = this.client;
            if (null == lclient || this.shutdown) {
                return;
            }
            String source = blockEvent.getPeer() != null ? blockEvent.getPeer().toString() : "not peer!";
            logger.debug((Object)String.format("is peer %b, is filtered: %b", blockEvent.getPeer() != null, blockEvent.isFiltered()));
            Iterable<BlockEvent.TransactionEvent> transactionEvents = blockEvent.getTransactionEvents();
            if (transactionEvents == null || !transactionEvents.iterator().hasNext()) {
                if (this.isLaterBlock(blockEvent.getBlockNumber())) {
                    ServiceDiscovery lserviceDiscovery = this.serviceDiscovery;
                    if (null != lserviceDiscovery) {
                        this.client.getExecutorService().execute(() -> lserviceDiscovery.fullNetworkDiscovery(true));
                    }
                } else {
                    lclient.getExecutorService().execute(() -> {
                        try {
                            if (!this.shutdown) {
                                this.loadCACertificates(true);
                            }
                        }
                        catch (Exception e) {
                            logger.warn((Object)String.format("Channel %s failed to load certificates for an update", this.name), (Throwable)e);
                        }
                    });
                }
                return;
            }
            if (this.txListeners.isEmpty() || this.shutdown) {
                return;
            }
            block5: for (BlockEvent.TransactionEvent transactionEvent : blockEvent.getTransactionEvents()) {
                logger.debug((Object)String.format("Channel %s got event from %s for transaction %s in block number: %d", this.name, source, transactionEvent.getTransactionID(), blockEvent.getBlockNumber()));
                ArrayList<TL> txL = new ArrayList<TL>(this.txListeners.size() + 2);
                LinkedHashMap<String, LinkedList<TL>> linkedHashMap = this.txListeners;
                synchronized (linkedHashMap) {
                    LinkedList<TL> list = this.txListeners.get(transactionEvent.getTransactionID());
                    if (null != list) {
                        txL.addAll(list);
                    }
                }
                for (TL l : txL) {
                    try {
                        if (this.shutdown) continue block5;
                        if (!l.eventReceived(transactionEvent)) continue;
                        l.fire(transactionEvent);
                    }
                    catch (Throwable e) {
                        logger.error((Object)e);
                    }
                }
            }
        });
    }

    private synchronized boolean isLaterBlock(long blockno) {
        if (blockno > this.lastBlock) {
            this.lastBlock = blockno;
            return true;
        }
        return false;
    }

    void runSweeper() {
        if (this.shutdown || DELTA_SWEEP < 1L) {
            return;
        }
        if (this.sweeper == null) {
            this.sweeperExecutorService = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            });
            this.sweeper = this.sweeperExecutorService.scheduleAtFixedRate(() -> {
                block6: {
                    try {
                        if (this.txListeners == null) break block6;
                        LinkedHashMap<String, LinkedList<TL>> linkedHashMap = this.txListeners;
                        synchronized (linkedHashMap) {
                            Iterator<Map.Entry<String, LinkedList<TL>>> it = this.txListeners.entrySet().iterator();
                            while (it.hasNext()) {
                                Map.Entry<String, LinkedList<TL>> es = it.next();
                                LinkedList<TL> tlLinkedList = es.getValue();
                                tlLinkedList.removeIf(TL::sweepMe);
                                if (!tlLinkedList.isEmpty()) continue;
                                it.remove();
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Sweeper got error:" + e.getMessage()), (Throwable)e);
                    }
                }
            }, 0L, DELTA_SWEEP, TimeUnit.MILLISECONDS);
        }
    }

    private CompletableFuture<BlockEvent.TransactionEvent> registerTxListener(String txid, NOfEvents nOfEvents, boolean failFast) {
        CompletableFuture<BlockEvent.TransactionEvent> future = new CompletableFuture<BlockEvent.TransactionEvent>();
        new TL(txid, future, nOfEvents, failFast);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterTxListener(String txid) {
        LinkedHashMap<String, LinkedList<TL>> linkedHashMap = this.txListeners;
        synchronized (linkedHashMap) {
            this.txListeners.remove(txid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerChaincodeEventListener(Pattern chaincodeId, Pattern eventName, ChaincodeEventListener chaincodeEventListener) throws InvalidArgumentException {
        if (this.shutdown) {
            throw new InvalidArgumentException(String.format("Channel %s has been shutdown.", this.name));
        }
        if (chaincodeId == null) {
            throw new InvalidArgumentException("The chaincodeId argument may not be null.");
        }
        if (eventName == null) {
            throw new InvalidArgumentException("The eventName argument may not be null.");
        }
        if (chaincodeEventListener == null) {
            throw new InvalidArgumentException("The chaincodeEventListener argument may not be null.");
        }
        ChaincodeEventListenerEntry chaincodeEventListenerEntry = new ChaincodeEventListenerEntry(chaincodeId, eventName, chaincodeEventListener);
        Channel channel = this;
        synchronized (channel) {
            if (null == this.blh) {
                this.blh = this.registerChaincodeListenerProcessor();
            }
        }
        return chaincodeEventListenerEntry.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterChaincodeEventListener(String handle) throws InvalidArgumentException {
        boolean ret;
        if (this.shutdown) {
            throw new InvalidArgumentException(String.format("Channel %s has been shutdown.", this.name));
        }
        Channel.checkHandle(CHAINCODE_EVENTS_TAG, handle);
        Serializable serializable = this.chainCodeListeners;
        synchronized (serializable) {
            ret = null != this.chainCodeListeners.remove(handle);
        }
        serializable = this;
        synchronized (serializable) {
            if (null != this.blh && this.chainCodeListeners.isEmpty()) {
                this.unregisterBlockListener(this.blh);
                this.blh = null;
            }
        }
        return ret;
    }

    private String registerChaincodeListenerProcessor() throws InvalidArgumentException {
        logger.debug((Object)String.format("Channel %s registerChaincodeListenerProcessor starting", this.name));
        return this.registerBlockListener((BlockEvent blockEvent) -> {
            if (this.chainCodeListeners.isEmpty()) {
                return;
            }
            LinkedList<Object> chaincodeEvents = new LinkedList<Object>();
            for (BlockEvent.TransactionEvent transactionEvent : blockEvent.getTransactionEvents()) {
                logger.debug((Object)String.format("Channel %s got event for transaction %s ", this.name, transactionEvent.getTransactionID()));
                for (BlockInfo.TransactionEnvelopeInfo.TransactionActionInfo info : transactionEvent.getTransactionActionInfos()) {
                    ChaincodeEvent event = info.getEvent();
                    if (null == event) continue;
                    chaincodeEvents.add(event);
                }
            }
            if (!chaincodeEvents.isEmpty()) {
                class MatchPair {
                    final ChaincodeEventListenerEntry eventListener;
                    final ChaincodeEvent event;

                    MatchPair(ChaincodeEventListenerEntry eventListener, ChaincodeEvent event) {
                        this.eventListener = eventListener;
                        this.event = event;
                    }
                }
                LinkedList<MatchPair> matches = new LinkedList<MatchPair>();
                LinkedHashMap<String, ChaincodeEventListenerEntry> linkedHashMap = this.chainCodeListeners;
                synchronized (linkedHashMap) {
                    for (ChaincodeEventListenerEntry chaincodeEventListenerEntry : this.chainCodeListeners.values()) {
                        for (ChaincodeEvent chaincodeEvent : chaincodeEvents) {
                            if (!chaincodeEventListenerEntry.isMatch(chaincodeEvent)) continue;
                            matches.add(new MatchPair(chaincodeEventListenerEntry, chaincodeEvent));
                        }
                    }
                }
                for (MatchPair match : matches) {
                    ChaincodeEventListenerEntry chaincodeEventListenerEntry;
                    chaincodeEventListenerEntry = match.eventListener;
                    ChaincodeEvent ce = match.event;
                    chaincodeEventListenerEntry.fire(blockEvent, ce);
                }
            }
        });
    }

    public synchronized void shutdown(boolean force) {
        if (this.shutdown) {
            return;
        }
        String ltransactionListenerProcessorHandle = this.transactionListenerProcessorHandle;
        this.transactionListenerProcessorHandle = null;
        if (null != ltransactionListenerProcessorHandle) {
            try {
                this.unregisterBlockListener(ltransactionListenerProcessorHandle);
            }
            catch (Exception e) {
                logger.error((Object)String.format("Shutting down channel %s transactionListenerProcessorHandle", this.name), (Throwable)e);
            }
        }
        String lchaincodeEventUpgradeListenerHandle = this.chaincodeEventUpgradeListenerHandle;
        this.chaincodeEventUpgradeListenerHandle = null;
        if (null != lchaincodeEventUpgradeListenerHandle) {
            try {
                this.unregisterChaincodeEventListener(lchaincodeEventUpgradeListenerHandle);
            }
            catch (Exception e) {
                logger.error((Object)String.format("Shutting down channel %s chaincodeEventUpgradeListenr", this.name), (Throwable)e);
            }
        }
        this.initialized = false;
        this.shutdown = true;
        ServiceDiscovery lserviceDiscovery = this.serviceDiscovery;
        this.serviceDiscovery = null;
        if (null != lserviceDiscovery) {
            lserviceDiscovery.shutdown();
        }
        if (this.chainCodeListeners != null) {
            this.chainCodeListeners.clear();
        }
        if (this.blockListeners != null) {
            this.blockListeners.clear();
        }
        if (this.client != null) {
            this.client.removeChannel(this);
        }
        this.client = null;
        for (Peer peer : new ArrayList<Peer>(this.getPeers())) {
            try {
                this.removePeerInternal(peer);
                peer.shutdown(force);
            }
            catch (Exception exception) {}
        }
        this.peers.clear();
        this.peerMSPIDMap.clear();
        this.ordererMSPIDMap.clear();
        this.peerEndpointMap.clear();
        this.ordererEndpointMap.clear();
        for (Set set : this.peerRoleSetMap.values()) {
            set.clear();
        }
        for (Orderer orderer : this.getOrderers()) {
            orderer.shutdown(force);
        }
        this.orderers.clear();
        if (null != this.eventQueueThread) {
            this.eventQueueThread.interrupt();
            this.eventQueueThread = null;
        }
        ScheduledFuture<?> lsweeper = this.sweeper;
        this.sweeper = null;
        if (null != lsweeper) {
            lsweeper.cancel(true);
        }
        ScheduledExecutorService scheduledExecutorService = this.sweeperExecutorService;
        this.sweeperExecutorService = null;
        if (null != scheduledExecutorService) {
            scheduledExecutorService.shutdownNow();
        }
    }

    public void serializeChannel(File file) throws IOException, InvalidArgumentException {
        if (null == file) {
            throw new InvalidArgumentException("File parameter may not be null");
        }
        Files.write(Paths.get(file.getAbsolutePath(), new String[0]), this.serializeChannel(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serializeChannel() throws IOException, InvalidArgumentException {
        if (this.isShutdown()) {
            throw new InvalidArgumentException(String.format("Channel %s has been shutdown.", this.getName()));
        }
        ObjectOutputStream out = null;
        try {
            ByteArrayOutputStream bai = new ByteArrayOutputStream();
            out = new ObjectOutputStream(bai);
            out.writeObject(this);
            out.flush();
            byte[] byArray = bai.toByteArray();
            return byArray;
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown(true);
        }
        finally {
            super.finalize();
        }
    }

    private class ChaincodeEventListenerEntry {
        private final Pattern chaincodeIdPattern;
        private final Pattern eventNamePattern;
        private final ChaincodeEventListener chaincodeEventListener;
        private final String handle;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ChaincodeEventListenerEntry(Pattern chaincodeIdPattern, Pattern eventNamePattern, ChaincodeEventListener chaincodeEventListener) {
            this.chaincodeIdPattern = chaincodeIdPattern;
            this.eventNamePattern = eventNamePattern;
            this.chaincodeEventListener = chaincodeEventListener;
            this.handle = Channel.CHAINCODE_EVENTS_TAG + Utils.generateUUID() + Channel.CHAINCODE_EVENTS_TAG;
            LinkedHashMap linkedHashMap = Channel.this.chainCodeListeners;
            synchronized (linkedHashMap) {
                Channel.this.chainCodeListeners.put(this.handle, this);
            }
        }

        boolean isMatch(ChaincodeEvent chaincodeEvent) {
            return this.chaincodeIdPattern.matcher(chaincodeEvent.getChaincodeId()).matches() && this.eventNamePattern.matcher(chaincodeEvent.getEventName()).matches();
        }

        void fire(BlockEvent blockEvent, ChaincodeEvent ce) {
            Channel.this.client.getExecutorService().execute(() -> this.chaincodeEventListener.received(this.handle, blockEvent, ce));
        }
    }

    private class TL {
        final String txID;
        final long createTime = System.currentTimeMillis();
        final AtomicBoolean fired = new AtomicBoolean(false);
        final CompletableFuture<BlockEvent.TransactionEvent> future;
        final boolean failFast;
        final Set<Peer> peers;
        private final NOfEvents nOfEvents;
        long sweepTime = System.currentTimeMillis() + (long)((double)Channel.access$1800() * 1.5);

        TL(String txID, CompletableFuture<BlockEvent.TransactionEvent> future, NOfEvents nOfEvents, boolean failFast) {
            this.txID = txID;
            this.future = future;
            this.nOfEvents = new NOfEvents(nOfEvents);
            this.peers = new HashSet<Peer>(nOfEvents.unSeenPeers());
            this.failFast = failFast;
            this.addListener();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean eventReceived(BlockEvent.TransactionEvent transactionEvent) {
            boolean isEmpty;
            this.sweepTime = System.currentTimeMillis() + DELTA_SWEEP;
            Peer peer = transactionEvent.getPeer();
            if (peer != null && !this.peers.contains(peer)) {
                return false;
            }
            if (this.failFast && !transactionEvent.isValid()) {
                return true;
            }
            if (peer != null) {
                this.nOfEvents.seen(peer);
                logger.debug((Object)String.format("Channel %s seen transaction event %s for peer %s", Channel.this.name, this.txID, peer.toString()));
            }
            TL tL = this;
            synchronized (tL) {
                isEmpty = this.nOfEvents.ready;
            }
            return isEmpty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addListener() {
            Channel.this.runSweeper();
            LinkedHashMap linkedHashMap = Channel.this.txListeners;
            synchronized (linkedHashMap) {
                LinkedList tl = Channel.this.txListeners.computeIfAbsent(this.txID, k -> new LinkedList());
                tl.add(this);
            }
        }

        boolean sweepMe() {
            boolean ret;
            boolean bl = ret = this.sweepTime < System.currentTimeMillis() || this.fired.get() || this.future.isDone();
            if (IS_WARN_LEVEL && ret) {
                StringBuilder sb = new StringBuilder(10000);
                String sep = "Non reporting peers: ";
                for (Peer peer : this.nOfEvents.unSeenPeers()) {
                    sb.append(sep).append(peer.toString()).append(" status:").append(peer.getEventingStatus());
                    sep = ", ";
                }
                logger.warn((Object)String.format("Force removing transaction listener after %d ms for transaction %s. %s. sweep timeout: %b, fired: %b, future done:%b", System.currentTimeMillis() - this.createTime, this.txID, sb.toString(), this.sweepTime < System.currentTimeMillis(), this.fired.get(), this.future.isDone()));
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fire(BlockEvent.TransactionEvent transactionEvent) {
            if (this.fired.getAndSet(true)) {
                return;
            }
            LinkedHashMap linkedHashMap = Channel.this.txListeners;
            synchronized (linkedHashMap) {
                LinkedList l = (LinkedList)Channel.this.txListeners.get(this.txID);
                if (null != l) {
                    l.removeFirstOccurrence(this);
                    if (l.size() == 0) {
                        Channel.this.txListeners.remove(this.txID);
                    }
                }
            }
            if (this.future.isDone()) {
                this.fired.set(true);
                return;
            }
            if (transactionEvent.isValid()) {
                logger.debug((Object)String.format("Completing future for channel %s and transaction id: %s", Channel.this.name, this.txID));
                Channel.this.client.getExecutorService().execute(() -> this.future.complete(transactionEvent));
            } else {
                logger.debug((Object)String.format("Completing future as exception for channel %s and transaction id: %s, validation code: %02X", Channel.this.name, this.txID, transactionEvent.getValidationCode()));
                Channel.this.client.getExecutorService().execute(() -> this.future.completeExceptionally(new TransactionEventException(String.format("Received invalid transaction event. Transaction ID %s status %s", transactionEvent.getTransactionID(), transactionEvent.getValidationCode()), transactionEvent)));
            }
        }
    }

    class BL {
        final BlockListener listener;
        final String handle = "BLOCK_LISTENER_HANDLE" + Utils.generateUUID() + "BLOCK_LISTENER_HANDLE";
        private final BlockingQueue<QueuedBlockEvent> blockingQueue;
        private final long timeout;
        private final TimeUnit timeUnit;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        BL(BlockListener listener) {
            logger.debug((Object)String.format("Channel %s blockListener %s starting", Channel.this.name, this.handle));
            LinkedHashMap linkedHashMap = Channel.this.blockListeners;
            synchronized (linkedHashMap) {
                Channel.this.blockListeners.put(this.handle, this);
            }
            this.listener = listener;
            this.blockingQueue = null;
            this.timeout = Long.MAX_VALUE;
            this.timeUnit = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        BL(BlockingQueue<QueuedBlockEvent> blockingQueue, long timeout, TimeUnit timeUnit) {
            logger.debug((Object)String.format("Channel %s blockListener %s starting", Channel.this.name, this.handle));
            LinkedHashMap linkedHashMap = Channel.this.blockListeners;
            synchronized (linkedHashMap) {
                Channel.this.blockListeners.put(this.handle, this);
            }
            this.blockingQueue = blockingQueue;
            this.timeout = timeout;
            this.timeUnit = timeUnit;
            this.listener = null;
        }

        public String getHandle() {
            return this.handle;
        }
    }

    class ChannelEventQue {
        private final BlockingQueue<BlockEvent> events = new LinkedBlockingQueue<BlockEvent>();
        private Throwable eventException;

        ChannelEventQue() {
        }

        void eventError(Throwable t) {
            this.eventException = t;
        }

        boolean addBEvent(BlockEvent event) {
            if (Channel.this.shutdown) {
                return false;
            }
            this.events.add(event);
            return true;
        }

        BlockEvent getNextEvent() throws EventingException {
            BlockEvent ret;
            block7: {
                if (Channel.this.shutdown) {
                    throw new EventingException(String.format("Channel %s has been shutdown", Channel.this.name));
                }
                ret = null;
                if (this.eventException != null) {
                    throw new EventingException(this.eventException);
                }
                try {
                    ret = this.events.take();
                }
                catch (InterruptedException e) {
                    if (Channel.this.shutdown) {
                        throw new EventingException(String.format("channel %s is shutdown", Channel.this.name), e);
                    }
                    logger.warn((Object)e);
                    if (this.eventException == null) break block7;
                    EventingException eve = new EventingException(e);
                    logger.error((Object)eve.getMessage(), (Throwable)eve);
                    throw eve;
                }
            }
            if (this.eventException != null) {
                throw new EventingException(this.eventException);
            }
            if (Channel.this.shutdown) {
                throw new EventingException(String.format("Channel %s has been shutdown.", Channel.this.name));
            }
            return ret;
        }
    }

    class MSP {
        final String orgName;
        final MspConfigPackage.FabricMSPConfig fabricMSPConfig;
        byte[][] adminCerts;
        byte[][] rootCerts;
        byte[][] intermediateCerts;

        MSP(String orgName, MspConfigPackage.FabricMSPConfig fabricMSPConfig) {
            this.orgName = orgName;
            this.fabricMSPConfig = fabricMSPConfig;
        }

        String getID() {
            return this.fabricMSPConfig.getName();
        }

        byte[][] getAdminCerts() {
            if (null == this.adminCerts) {
                this.adminCerts = new byte[this.fabricMSPConfig.getAdminsList().size()][];
                int i = 0;
                for (ByteString cert : this.fabricMSPConfig.getAdminsList()) {
                    this.adminCerts[i++] = cert.toByteArray();
                }
            }
            return this.adminCerts;
        }

        byte[][] getRootCerts() {
            if (null == this.rootCerts) {
                this.rootCerts = new byte[this.fabricMSPConfig.getRootCertsList().size()][];
                int i = 0;
                for (ByteString cert : this.fabricMSPConfig.getRootCertsList()) {
                    this.rootCerts[i++] = cert.toByteArray();
                }
            }
            return this.rootCerts;
        }

        byte[][] getIntermediateCerts() {
            if (null == this.intermediateCerts) {
                this.intermediateCerts = new byte[this.fabricMSPConfig.getIntermediateCertsList().size()][];
                int i = 0;
                for (ByteString cert : this.fabricMSPConfig.getIntermediateCertsList()) {
                    this.intermediateCerts[i++] = cert.toByteArray();
                }
            }
            return this.intermediateCerts;
        }
    }

    public static class PeerOptions
    implements Cloneable,
    Serializable {
        private static final long serialVersionUID = -6906605662806520793L;
        protected EnumSet<Peer.PeerRole> peerRoles;
        protected Boolean newest = true;
        protected Long startEvents;
        protected Long stopEvents = Long.MAX_VALUE;
        protected boolean registerEventsForFilteredBlocks = false;

        public String toString() {
            StringBuilder sb = new StringBuilder(1000);
            sb.append("PeerOptions( " + String.format("newest: %s, startEvents: %s, stopEvents: %s, registerEventsForFilteredBlocks: %s", Channel.SYSTEM_CHANNEL_NAME + this.newest, Channel.SYSTEM_CHANNEL_NAME + this.startEvents, Channel.SYSTEM_CHANNEL_NAME + this.stopEvents, this.registerEventsForFilteredBlocks));
            if (this.peerRoles != null && !this.peerRoles.isEmpty()) {
                sb.append(", PeerRoles:[");
                String sep = Channel.SYSTEM_CHANNEL_NAME;
                for (Peer.PeerRole peerRole : this.peerRoles) {
                    sb.append(sep).append(peerRole.getPropertyName());
                    sep = " ,";
                }
                sb.append("]");
            }
            sb.append(")");
            return sb.toString();
        }

        public boolean isRegisterEventsForFilteredBlocks() {
            return this.registerEventsForFilteredBlocks;
        }

        public PeerOptions registerEventsForFilteredBlocks() {
            this.registerEventsForFilteredBlocks = true;
            return this;
        }

        public PeerOptions registerEventsForBlocks() {
            this.registerEventsForFilteredBlocks = false;
            return this;
        }

        public Boolean getNewest() {
            return this.newest;
        }

        public Long getStartEvents() {
            return this.startEvents;
        }

        public Long getStopEvents() {
            return this.stopEvents;
        }

        protected PeerOptions() {
        }

        public static PeerOptions createPeerOptions() {
            return new PeerOptions();
        }

        public EnumSet<Peer.PeerRole> getPeerRoles() {
            if (this.peerRoles == null) {
                this.peerRoles = EnumSet.complementOf(EnumSet.of(Peer.PeerRole.SERVICE_DISCOVERY));
            }
            return this.peerRoles;
        }

        public PeerOptions setPeerRoles(EnumSet<Peer.PeerRole> peerRoles) {
            this.peerRoles = peerRoles;
            return this;
        }

        public PeerOptions addPeerRole(Peer.PeerRole peerRole) {
            if (this.peerRoles == null) {
                this.peerRoles = EnumSet.noneOf(Peer.PeerRole.class);
            }
            this.peerRoles.add(peerRole);
            return this;
        }

        public PeerOptions startEvents(long start) {
            this.startEvents = start;
            this.newest = null;
            return this;
        }

        public PeerOptions startEventsNewest() {
            this.startEvents = null;
            this.newest = true;
            return this;
        }

        public PeerOptions stopEvents(long stop) {
            this.stopEvents = stop;
            return this;
        }

        public PeerOptions clone() {
            try {
                return (PeerOptions)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class DiscoveryOptions {
        Set<String> ignoreList = new HashSet<String>();
        ServiceDiscovery.EndorsementSelector endorsementSelector = null;
        boolean inspectResults = false;
        boolean forceDiscovery = false;
        List<ServiceDiscoveryChaincodeCalls> serviceDiscoveryChaincodeInterests = null;

        List<ServiceDiscoveryChaincodeCalls> getServiceDiscoveryChaincodeInterests() {
            return this.serviceDiscoveryChaincodeInterests;
        }

        public static DiscoveryOptions createDiscoveryOptions() {
            return new DiscoveryOptions();
        }

        public boolean isInspectResults() {
            return this.inspectResults;
        }

        public DiscoveryOptions setInspectResults(boolean inspectResults) {
            this.inspectResults = inspectResults;
            return this;
        }

        public DiscoveryOptions setEndorsementSelector(ServiceDiscovery.EndorsementSelector endorsementSelector) throws InvalidArgumentException {
            if (endorsementSelector == null) {
                throw new InvalidArgumentException("endorsementSelector parameter is null.");
            }
            this.endorsementSelector = endorsementSelector;
            return this;
        }

        public DiscoveryOptions setServiceDiscoveryChaincodeInterests(ServiceDiscoveryChaincodeCalls ... serviceDiscoveryChaincodeInterests) {
            if (this.serviceDiscoveryChaincodeInterests == null) {
                this.serviceDiscoveryChaincodeInterests = new LinkedList<ServiceDiscoveryChaincodeCalls>();
            }
            this.serviceDiscoveryChaincodeInterests.addAll(new ArrayList<ServiceDiscoveryChaincodeCalls>(Arrays.asList(serviceDiscoveryChaincodeInterests)));
            return this;
        }

        public DiscoveryOptions setForceDiscovery(boolean forceDiscovery) {
            this.forceDiscovery = forceDiscovery;
            return this;
        }

        public DiscoveryOptions ignoreEndpoints(String ... endpoints) throws InvalidArgumentException {
            if (endpoints == null) {
                throw new InvalidArgumentException("endpoints parameter is null.");
            }
            for (String endpoint : endpoints) {
                if (endpoint == null) {
                    throw new InvalidArgumentException("endpoints parameter is null.");
                }
                this.ignoreList.add(endpoint);
            }
            return this;
        }

        Collection<String> getIgnoreList() {
            return this.ignoreList;
        }
    }

    public static class ServiceDiscoveryChaincodeCalls {
        String name;
        List<String> collections;
        private Protocol.ChaincodeCall ret = null;

        ServiceDiscoveryChaincodeCalls(String chaincodeName) {
            this.name = chaincodeName;
        }

        public ServiceDiscoveryChaincodeCalls addCollections(String ... collectionName) {
            if (this.collections == null) {
                this.collections = new LinkedList<String>();
            }
            this.collections.addAll(new ArrayList<String>(Arrays.asList(collectionName)));
            return this;
        }

        String write(List<ServiceDiscoveryChaincodeCalls> dep) {
            String sep2;
            StringBuilder cns = new StringBuilder(1000);
            cns.append("ServiceDiscoveryChaincodeCalls(name: ").append(this.name);
            String sep = Channel.SYSTEM_CHANNEL_NAME;
            List<String> collections = this.getCollections();
            if (!collections.isEmpty()) {
                cns.append(", collections:[");
                sep2 = Channel.SYSTEM_CHANNEL_NAME;
                for (String collection : collections) {
                    cns.append(sep2).append(collection);
                    sep2 = ", ";
                }
                cns.append("]");
            }
            if (dep != null && !dep.isEmpty()) {
                cns.append(" ,dependents:[");
                sep2 = Channel.SYSTEM_CHANNEL_NAME;
                for (ServiceDiscoveryChaincodeCalls chaincodeCalls : dep) {
                    cns.append(sep2).append(chaincodeCalls.write(null));
                    sep2 = ", ";
                }
                cns.append("]");
            }
            cns.append(")");
            return cns.toString();
        }

        public static ServiceDiscoveryChaincodeCalls createServiceDiscoveryChaincodeCalls(String name) throws InvalidArgumentException {
            if (Utils.isNullOrEmpty(name)) {
                throw new InvalidArgumentException("The name parameter must be non null nor an empty string.");
            }
            return new ServiceDiscoveryChaincodeCalls(name);
        }

        Protocol.ChaincodeCall build() {
            if (this.ret == null) {
                Protocol.ChaincodeCall.Builder builder = Protocol.ChaincodeCall.newBuilder().setName(this.name);
                if (this.collections != null && !this.collections.isEmpty()) {
                    builder.addAllCollectionNames(this.collections);
                }
                this.ret = builder.build();
            }
            return this.ret;
        }

        String getName() {
            return this.name;
        }

        List<String> getCollections() {
            return this.collections == null ? Collections.emptyList() : this.collections;
        }
    }

    public static class TransactionOptions {
        List<Orderer> orderers;
        boolean shuffleOrders = true;
        NOfEvents nOfEvents;
        User userContext;
        boolean failFast = true;

        public TransactionOptions failFast(boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        public TransactionOptions userContext(User userContext) {
            this.userContext = userContext;
            return this;
        }

        public TransactionOptions orderers(Orderer ... orderers) {
            this.orderers = new ArrayList<Orderer>(Arrays.asList(orderers));
            return this;
        }

        public TransactionOptions shuffleOrders(boolean shuffleOrders) {
            this.shuffleOrders = shuffleOrders;
            return this;
        }

        public TransactionOptions nOfEvents(NOfEvents nOfEvents) {
            this.nOfEvents = nOfEvents == NOfEvents.nofNoEvents ? nOfEvents : new NOfEvents(nOfEvents);
            return this;
        }

        public static TransactionOptions createTransactionOptions() {
            return new TransactionOptions();
        }

        public TransactionOptions orderers(Collection<Orderer> orderers) {
            return this.orderers(orderers.toArray(new Orderer[orderers.size()]));
        }
    }

    public static class NOfEvents {
        boolean ready = false;
        boolean started = false;
        private long n = Long.MAX_VALUE;
        private HashSet<Peer> peers = new HashSet();
        private HashSet<NOfEvents> nOfEvents = new HashSet();
        public static NOfEvents nofNoEvents = new NOfEvents(){

            @Override
            public NOfEvents addNOfs(NOfEvents ... nOfEvents) {
                throw new IllegalArgumentException("Can not add any events.");
            }

            @Override
            public NOfEvents addPeers(Peer ... peers) {
                throw new IllegalArgumentException("Can not add any events.");
            }

            @Override
            public NOfEvents setN(int n) {
                throw new IllegalArgumentException("Can not set N");
            }

            @Override
            public NOfEvents addPeers(Collection<Peer> peers) {
                throw new IllegalArgumentException("Can not add any events.");
            }
        };

        public NOfEvents setN(int n) {
            if (n < 1) {
                throw new IllegalArgumentException(String.format("N was %d but needs to be greater than 0.  ", n));
            }
            this.n = n;
            return this;
        }

        public NOfEvents addPeers(Peer ... peers) {
            if (peers == null || peers.length == 0) {
                throw new IllegalArgumentException("Peers added must be not null or empty.");
            }
            this.peers.addAll(Arrays.asList(peers));
            return this;
        }

        public NOfEvents addPeers(Collection<Peer> peers) {
            this.addPeers(peers.toArray(new Peer[peers.size()]));
            return this;
        }

        public NOfEvents addNOfs(NOfEvents ... nOfEvents) {
            if (nOfEvents == null || nOfEvents.length == 0) {
                throw new IllegalArgumentException("nofEvents added must be not null or empty.");
            }
            for (NOfEvents n : nOfEvents) {
                if (nofNoEvents == n) {
                    throw new IllegalArgumentException("nofNoEvents may not be added as an event.");
                }
                if (this.inHayStack(n)) {
                    throw new IllegalArgumentException("nofEvents already was added..");
                }
                this.nOfEvents.add(new NOfEvents(n));
            }
            return this;
        }

        private boolean inHayStack(NOfEvents needle) {
            if (this == needle) {
                return true;
            }
            for (NOfEvents straw : this.nOfEvents) {
                if (!straw.inHayStack(needle)) continue;
                return true;
            }
            return false;
        }

        public NOfEvents addNOfs(Collection<NOfEvents> nofs) {
            this.addNOfs(nofs.toArray(new NOfEvents[nofs.size()]));
            return this;
        }

        synchronized Collection<Peer> unSeenPeers() {
            HashSet<Peer> unseen = new HashSet<Peer>(16);
            unseen.addAll(this.peers);
            for (NOfEvents nOfEvents : this.nOfEvents) {
                unseen.addAll(nofNoEvents.unSeenPeers());
            }
            return unseen;
        }

        synchronized boolean seen(Peer peer) {
            if (!this.started) {
                this.started = true;
                this.n = Long.min(this.peers.size() + this.nOfEvents.size(), this.n);
            }
            if (!this.ready) {
                if (this.peers.remove(peer) && --this.n == 0L) {
                    this.ready = true;
                }
                if (!this.ready) {
                    Iterator<NOfEvents> ni = this.nOfEvents.iterator();
                    while (ni.hasNext()) {
                        NOfEvents e = ni.next();
                        if (!e.seen(peer)) continue;
                        ni.remove();
                        if (--this.n != 0L) continue;
                        this.ready = true;
                        break;
                    }
                }
            }
            if (this.ready) {
                this.peers.clear();
                this.nOfEvents.clear();
            }
            return this.ready;
        }

        NOfEvents(NOfEvents nof) {
            if (nofNoEvents == nof) {
                throw new IllegalArgumentException("nofNoEvents may not be copied.");
            }
            this.ready = false;
            this.started = false;
            this.n = nof.n;
            this.peers = new HashSet<Peer>(nof.peers);
            for (NOfEvents nofc : nof.nOfEvents) {
                this.nOfEvents.add(new NOfEvents(nofc));
            }
        }

        private NOfEvents() {
        }

        public static NOfEvents createNofEvents() {
            return new NOfEvents();
        }

        public static NOfEvents createNoEvents() {
            return nofNoEvents;
        }

        static {
            NOfEvents.nofNoEvents.ready = true;
        }
    }

    private static class PeerExactMatch {
        final Peer peer;

        private PeerExactMatch(Peer peer) {
            this.peer = peer;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PeerExactMatch)) {
                return false;
            }
            return this.peer == ((PeerExactMatch)obj).peer;
        }

        public int hashCode() {
            return System.identityHashCode(this.peer);
        }
    }

    public static class AnchorPeersConfigUpdateResult {
        private UpdateChannelConfiguration updateChannelConfiguration = null;
        private Collection<String> peersAdded = Collections.emptyList();
        private Collection<String> peersRemoved = Collections.emptyList();
        private Collection<String> currentPeers = Collections.emptyList();
        private Collection<String> updatedPeers = Collections.emptyList();

        public UpdateChannelConfiguration getUpdateChannelConfiguration() {
            return this.updateChannelConfiguration;
        }

        public Collection<String> getPeersAdded() {
            return this.peersAdded;
        }

        public Collection<String> getPeersRemoved() {
            return this.peersRemoved;
        }

        public Collection<String> getCurrentPeers() {
            return this.currentPeers;
        }

        public Collection<String> getUpdatedPeers() {
            return this.updatedPeers;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(10000);
            sb.append("AnchorPeersConfigUpdateResult:{peersAdded= ");
            if (this.peersAdded == null) {
                sb.append("null");
            } else {
                sb.append(this.peersAdded.toString());
            }
            sb.append(", peersRemoved= ");
            if (this.peersRemoved == null) {
                sb.append("null");
            } else {
                sb.append(this.peersRemoved.toString());
            }
            sb.append(", currentPeers= ");
            if (this.currentPeers == null) {
                sb.append("null");
            } else {
                sb.append(this.currentPeers.toString());
            }
            sb.append(", updatedPeers= ");
            if (this.updatedPeers == null) {
                sb.append("null");
            } else {
                sb.append(this.updatedPeers.toString());
            }
            sb.append(", updateChannelConfiguration= ");
            if (this.updateChannelConfiguration == null) {
                sb.append("null");
            } else {
                sb.append(Utils.toHexString(this.updateChannelConfiguration.getUpdateChannelConfigurationAsBytes()));
            }
            sb.append("}");
            return sb.toString();
        }
    }

    public static class SDOPeerDefaultAddition
    implements SDPeerAddition {
        protected final Properties config;

        public SDOPeerDefaultAddition(Properties config) {
            this.config = config == null ? new Properties() : (Properties)config.clone();
        }

        @Override
        public Peer addPeer(SDPeerAdditionInfo sdPeerAddition) throws InvalidArgumentException, ServiceDiscoveryException {
            byte[] pemBytes;
            Properties properties = sdPeerAddition.getProperties();
            String name = sdPeerAddition.getName();
            String endpoint = sdPeerAddition.getEndpoint();
            String mspid = sdPeerAddition.getMspId();
            String protocol = (String)Channel.findClientProp(this.config, "protocol", mspid, endpoint, sdPeerAddition.isTLS() ? "grpcs:" : "grpc:");
            Peer peer = sdPeerAddition.getEndpointMap().get(endpoint);
            if (null != peer) {
                return peer;
            }
            String clientCertFile = (String)Channel.findClientProp(this.config, "clientCertFile", mspid, endpoint, null);
            byte[] clientCertBytes = (byte[])Channel.findClientProp(this.config, "clientCertBytes", mspid, endpoint, null);
            if (null != clientCertBytes) {
                properties.put("clientCertBytes", clientCertBytes);
            } else if (null != clientCertFile) {
                properties.put("clientCertFile", clientCertFile);
            }
            properties.put("org.hyperledger.fabric.sdk.peer.organization_mspid", sdPeerAddition.getMspId());
            byte[] clientKeyBytes = (byte[])Channel.findClientProp(this.config, "clientKeyBytes", mspid, endpoint, null);
            String clientKeyFile = (String)Channel.findClientProp(this.config, "clientKeyFile", mspid, endpoint, null);
            if (null != clientKeyBytes) {
                properties.put("clientKeyBytes", clientKeyBytes);
            } else if (null != clientKeyFile) {
                properties.put("clientKeyFile", clientKeyFile);
            }
            String hostnameOverride = (String)Channel.findClientProp(this.config, "hostnameOverride", mspid, endpoint, null);
            if (null != hostnameOverride) {
                properties.put("hostnameOverride", hostnameOverride);
            }
            if ((pemBytes = sdPeerAddition.getAllTLSCerts()).length > 0) {
                properties.put("pemBytes", pemBytes);
            }
            peer = sdPeerAddition.getClient().newPeer(name, protocol + "//" + endpoint, properties);
            sdPeerAddition.getChannel().addPeer(peer, PeerOptions.createPeerOptions().setPeerRoles(EnumSet.of(Peer.PeerRole.ENDORSING_PEER, Peer.PeerRole.EVENT_SOURCE, Peer.PeerRole.LEDGER_QUERY, Peer.PeerRole.CHAINCODE_QUERY, Peer.PeerRole.SERVICE_DISCOVERY)));
            return peer;
        }
    }

    public static class SDOrdererDefaultAddition
    implements SDOrdererAddition {
        protected final Properties config;

        public SDOrdererDefaultAddition(Properties config) {
            this.config = config == null ? new Properties() : (Properties)config.clone();
        }

        @Override
        public Orderer addOrderer(SDOrdererAdditionInfo sdOrdererAdditionInfo) throws InvalidArgumentException, ServiceDiscoveryException {
            byte[] pemBytes;
            String hostnameOverride;
            byte[] clientKeyBytes;
            byte[] clientCertBytes;
            String clientKeyFile;
            Properties properties = sdOrdererAdditionInfo.getProperties();
            String endpoint = sdOrdererAdditionInfo.getEndpoint();
            String mspid = sdOrdererAdditionInfo.getMspId();
            String protocol = (String)Channel.findClientProp(this.config, "protocol", mspid, endpoint, sdOrdererAdditionInfo.isTLS() ? "grpcs:" : "grpc:");
            String clientCertFile = (String)Channel.findClientProp(this.config, "clientCertFile", mspid, endpoint, null);
            if (null != clientCertFile) {
                properties.put("clientCertFile", clientCertFile);
            }
            if (null != (clientKeyFile = (String)Channel.findClientProp(this.config, "clientKeyFile", mspid, endpoint, null))) {
                properties.put("clientKeyFile", clientKeyFile);
            }
            if (null != (clientCertBytes = (byte[])Channel.findClientProp(this.config, "clientCertBytes", mspid, endpoint, null))) {
                properties.put("clientCertBytes", clientCertBytes);
            }
            if (null != (clientKeyBytes = (byte[])Channel.findClientProp(this.config, "clientKeyBytes", mspid, endpoint, null))) {
                properties.put("clientKeyBytes", clientKeyBytes);
            }
            if (null != (hostnameOverride = (String)Channel.findClientProp(this.config, "hostnameOverride", mspid, endpoint, null))) {
                properties.put("hostnameOverride", hostnameOverride);
            }
            if ((pemBytes = sdOrdererAdditionInfo.getAllTLSCerts()).length > 0) {
                properties.put("pemBytes", pemBytes);
            }
            properties.put("org.hyperledger.fabric.sdk.orderer.organization_mspid", sdOrdererAdditionInfo.getMspId());
            Orderer orderer = sdOrdererAdditionInfo.getClient().newOrderer(endpoint, protocol + "//" + endpoint, properties);
            sdOrdererAdditionInfo.getChannel().addOrderer(orderer);
            return orderer;
        }
    }

    public static interface SDOrdererAddition {
        public Orderer addOrderer(SDOrdererAdditionInfo var1) throws InvalidArgumentException, ServiceDiscoveryException;
    }

    public static interface SDOrdererAdditionInfo {
        public String getEndpoint();

        public Properties getProperties();

        public String getMspId();

        public Channel getChannel();

        public HFClient getClient();

        public byte[][] getTLSCerts();

        public byte[][] getTLSIntermediateCerts();

        default public byte[] getAllTLSCerts() throws ServiceDiscoveryException {
            try {
                return Channel.combineCerts(new Collection[]{Arrays.asList(this.getTLSCerts()), Arrays.asList(this.getTLSIntermediateCerts())});
            }
            catch (IOException e) {
                throw new ServiceDiscoveryException(e);
            }
        }

        public Map<String, Orderer> getEndpointMap();

        public boolean isTLS();
    }

    public static interface SDPeerAddition {
        public Peer addPeer(SDPeerAdditionInfo var1) throws InvalidArgumentException, ServiceDiscoveryException;
    }

    public static interface SDPeerAdditionInfo {
        public String getName();

        public String getMspId();

        public String getEndpoint();

        public Channel getChannel();

        public HFClient getClient();

        public byte[][] getTLSCerts();

        public byte[][] getTLSIntermediateCerts();

        default public byte[] getAllTLSCerts() throws ServiceDiscoveryException {
            try {
                return Channel.combineCerts(new Collection[]{Arrays.asList(this.getTLSCerts()), Arrays.asList(this.getTLSIntermediateCerts())});
            }
            catch (IOException e) {
                throw new ServiceDiscoveryException(e);
            }
        }

        public Map<String, Peer> getEndpointMap();

        public Properties getProperties();

        public boolean isTLS();
    }
}

