/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.helper.Utils;

public class ChannelConfiguration {
    private static final Log logger = LogFactory.getLog(ChannelConfiguration.class);
    private static final boolean IS_TRACE_LEVEL = logger.isTraceEnabled();
    private byte[] configBytes = null;

    public ChannelConfiguration() {
    }

    public ChannelConfiguration(File configFile) throws IOException, InvalidArgumentException {
        if (configFile == null) {
            throw new InvalidArgumentException("ChannelConfiguration configFile must be non-null");
        }
        logger.trace((Object)String.format("Creating ChannelConfiguration from file %s", configFile.getAbsolutePath()));
        try (FileInputStream is = new FileInputStream(configFile);){
            this.configBytes = IOUtils.toByteArray((InputStream)is);
        }
    }

    public ChannelConfiguration(byte[] configAsBytes) throws InvalidArgumentException {
        if (configAsBytes == null) {
            throw new InvalidArgumentException("ChannelConfiguration configAsBytes must be non-null");
        }
        logger.trace((Object)"Creating ChannelConfiguration from bytes");
        this.configBytes = configAsBytes;
    }

    public void setChannelConfiguration(byte[] channelConfigurationAsBytes) throws InvalidArgumentException {
        if (channelConfigurationAsBytes == null) {
            throw new InvalidArgumentException("ChannelConfiguration channelConfigurationAsBytes must be non-null");
        }
        logger.trace((Object)"Creating setChannelConfiguration from bytes");
        this.configBytes = channelConfigurationAsBytes;
    }

    public byte[] getChannelConfigurationAsBytes() {
        if (this.configBytes == null) {
            logger.error((Object)"ChannelConfiguration configBytes is null!");
        } else if (IS_TRACE_LEVEL) {
            logger.trace((Object)String.format("getChannelConfigurationAsBytes: %s", Utils.toHexString(this.configBytes)));
        }
        return this.configBytes;
    }
}

