/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Timestamp;
import java.lang.ref.WeakReference;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.sdk.exception.InvalidProtocolBufferRuntimeException;

class ChannelHeaderDeserializer {
    private final ByteString byteString;
    private WeakReference<Common.ChannelHeader> channelHeader;

    ChannelHeaderDeserializer(ByteString byteString) {
        this.byteString = byteString;
    }

    Common.ChannelHeader getChannelHeader() {
        Common.ChannelHeader ret = null;
        if (this.channelHeader != null) {
            ret = (Common.ChannelHeader)this.channelHeader.get();
        }
        if (null == ret) {
            try {
                ret = Common.ChannelHeader.parseFrom(this.byteString);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
            this.channelHeader = new WeakReference<Common.ChannelHeader>(ret);
        }
        return ret;
    }

    String getChannelId() {
        return this.getChannelHeader().getChannelId();
    }

    long getEpoch() {
        return this.getChannelHeader().getEpoch();
    }

    Timestamp getTimestamp() {
        return this.getChannelHeader().getTimestamp();
    }

    String getTxId() {
        return this.getChannelHeader().getTxId();
    }

    int getType() {
        return this.getChannelHeader().getType();
    }

    int getVersion() {
        return this.getChannelHeader().getVersion();
    }
}

