/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Collection;
import java.util.LinkedList;
import org.hyperledger.fabric.protos.peer.Collection;

public class CollectionConfigPackage {
    private final ByteString collectionConfigBytes;
    private Collection.CollectionConfigPackage cp;

    CollectionConfigPackage(ByteString collectionConfig) {
        this.collectionConfigBytes = collectionConfig;
    }

    public Collection.CollectionConfigPackage getCollectionConfigPackage() throws InvalidProtocolBufferException {
        if (null == this.cp) {
            this.cp = Collection.CollectionConfigPackage.parseFrom(this.collectionConfigBytes);
        }
        return this.cp;
    }

    public Collection<CollectionConfig> getCollectionConfigs() throws InvalidProtocolBufferException {
        LinkedList<CollectionConfig> ret = new LinkedList<CollectionConfig>();
        for (Collection.CollectionConfig collectionConfig : this.getCollectionConfigPackage().getConfigList()) {
            ret.add(new CollectionConfig(collectionConfig));
        }
        return ret;
    }

    public static class CollectionConfig {
        final Collection.CollectionConfig collectionConfig;
        final Collection.StaticCollectionConfig getStaticCollectionConfig;

        public String getName() {
            return this.getStaticCollectionConfig.getName();
        }

        public int getRequiredPeerCount() {
            return this.getStaticCollectionConfig.getRequiredPeerCount();
        }

        public int getMaximumPeerCount() {
            return this.getStaticCollectionConfig.getMaximumPeerCount();
        }

        public long getBlockToLive() {
            return this.getStaticCollectionConfig.getBlockToLive();
        }

        CollectionConfig(Collection.CollectionConfig collectionConfig) {
            this.collectionConfig = collectionConfig;
            this.getStaticCollectionConfig = collectionConfig.getStaticCollectionConfig();
        }

        public Collection.CollectionConfig getCollectionConfig() {
            Collection.StaticCollectionConfig staticCollectionConfig = this.collectionConfig.getStaticCollectionConfig();
            return this.collectionConfig;
        }
    }
}

