/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.spotify.futures.ListenableFuturesExtra;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.discovery.DiscoveryGrpc;
import org.hyperledger.fabric.protos.discovery.Protocol;
import org.hyperledger.fabric.protos.peer.EndorserGrpc;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.sdk.exception.PeerException;
import org.hyperledger.fabric.sdk.helper.Config;

class EndorserClient {
    private static final Config config = Config.getConfig();
    private static final Log logger = LogFactory.getLog(EndorserClient.class);
    private static final boolean IS_TRACE_LEVEL = logger.isTraceEnabled();
    private ManagedChannel managedChannel;
    private EndorserGrpc.EndorserFutureStub futureStub;
    private DiscoveryGrpc.DiscoveryFutureStub discoveryFutureStub;
    private boolean shutdown = false;
    private final String toString;

    EndorserClient(String channelName, String name, String url, ManagedChannelBuilder<?> channelBuilder) {
        this.managedChannel = channelBuilder.build();
        this.futureStub = EndorserGrpc.newFutureStub((Channel)this.managedChannel);
        this.discoveryFutureStub = DiscoveryGrpc.newFutureStub((Channel)this.managedChannel);
        this.toString = "EndorserClient{id: " + config.getNextID() + ", channel: " + channelName + ", name:" + name + ", url: " + url + "}";
        logger.trace((Object)("Created " + this.toString()));
    }

    public String toString() {
        return this.toString;
    }

    synchronized void shutdown(boolean force) {
        if (IS_TRACE_LEVEL) {
            logger.trace((Object)String.format("%s shutdown called force: %b, shutdown: %b, managedChannel: %s", this.toString(), force, this.shutdown, "" + this.managedChannel));
        }
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        ManagedChannel lchannel = this.managedChannel;
        this.managedChannel = null;
        this.discoveryFutureStub = null;
        this.futureStub = null;
        if (lchannel == null) {
            return;
        }
        if (force) {
            try {
                lchannel.shutdownNow();
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        } else {
            boolean isTerminated = false;
            try {
                isTerminated = lchannel.shutdown().awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.debug((Object)this.toString(), (Throwable)e);
            }
            if (!isTerminated) {
                try {
                    lchannel.shutdownNow();
                }
                catch (Exception e) {
                    logger.warn((Object)this.toString(), (Throwable)e);
                }
            }
        }
    }

    public CompletableFuture<ProposalResponsePackage.ProposalResponse> sendProposalAsync(ProposalPackage.SignedProposal proposal) {
        if (this.shutdown) {
            CompletableFuture<ProposalResponsePackage.ProposalResponse> ret = new CompletableFuture<ProposalResponsePackage.ProposalResponse>();
            ret.completeExceptionally(new PeerException("Shutdown " + this.toString()));
            return ret;
        }
        CompletableFuture future = ListenableFuturesExtra.toCompletableFuture(this.futureStub.processProposal(proposal));
        return future.exceptionally(throwable -> {
            throw new CompletionException(String.format("%s %s", this.toString, throwable.getMessage()), (Throwable)throwable);
        });
    }

    public CompletableFuture<Protocol.Response> sendDiscoveryRequestAsync(Protocol.SignedRequest signedRequest) {
        if (this.shutdown) {
            CompletableFuture<Protocol.Response> ret = new CompletableFuture<Protocol.Response>();
            ret.completeExceptionally(new PeerException("Shutdown " + this.toString()));
            return ret;
        }
        CompletableFuture future = ListenableFuturesExtra.toCompletableFuture(this.discoveryFutureStub.discover(signedRequest));
        return future.exceptionally(throwable -> {
            throw new CompletionException(String.format("%s %s", this.toString, throwable.getMessage()), (Throwable)throwable);
        });
    }

    boolean isChannelActive() {
        boolean ret;
        ManagedChannel lchannel = this.managedChannel;
        if (null == lchannel) {
            logger.trace((Object)(this.toString() + "Grpc channel needs creation."));
            return false;
        }
        boolean isTerminated = lchannel.isTerminated();
        boolean isShutdown = lchannel.isShutdown();
        boolean bl = ret = !lchannel.isShutdown() && !isTerminated;
        if (IS_TRACE_LEVEL) {
            logger.trace((Object)String.format("%s grpc channel isActive: %b, isShutdown: %b, isTerminated: %b, state: %s ", this.toString(), ret, isShutdown, isTerminated, "" + lchannel.getState(false)));
        }
        return ret;
    }

    public void finalize() throws Throwable {
        try {
            if (!this.shutdown) {
                logger.warn((Object)(this.toString() + " finalized not shutdown is Active" + this.isChannelActive()));
            }
            this.shutdown(true);
        }
        finally {
            super.finalize();
        }
    }
}

