/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.common.collect.ImmutableMap;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.hyperledger.fabric.sdk.exception.CryptoException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.security.CryptoPrimitives;

class Endpoint {
    private static final Log logger = LogFactory.getLog(Endpoint.class);
    private static final String SSLPROVIDER = Config.getConfig().getDefaultSSLProvider();
    private static final String SSLNEGOTIATION = Config.getConfig().getDefaultSSLNegotiationType();
    private final String addr;
    private final int port;
    private final String url;
    private byte[] clientTLSCertificateDigest;
    private byte[] tlsClientCertificatePEMBytes;
    private NettyChannelBuilder channelBuilder;
    private static final Map<String, String> CN_CACHE = Collections.synchronizedMap(new HashMap());
    private static final Pattern METHOD_PATTERN = Pattern.compile("grpc\\.NettyChannelBuilderOption\\.([^.]*)$");
    private static final Map<Class<?>, Class<?>> WRAPPERS_TO_PRIM = new ImmutableMap.Builder().put(Boolean.class, Boolean.TYPE).put(Byte.class, Byte.TYPE).put(Character.class, Character.TYPE).put(Double.class, Double.TYPE).put(Float.class, Float.TYPE).put(Integer.class, Integer.TYPE).put(Long.class, Long.TYPE).put(Short.class, Short.TYPE).put(Void.class, Void.TYPE).build();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Endpoint(String url, Properties properties) {
        logger.trace((Object)String.format("Creating endpoint for url %s", url));
        this.url = url;
        String cn = null;
        String sslp = null;
        String nt = null;
        byte[] pemBytes = null;
        X509Certificate[] clientCert = null;
        PrivateKey clientKey = null;
        Properties purl = Utils.parseGrpcUrl(url);
        String protocol = purl.getProperty("protocol");
        this.addr = purl.getProperty("host");
        this.port = Integer.parseInt(purl.getProperty("port"));
        if (properties != null) {
            AbstractMap.SimpleImmutableEntry<PrivateKey, X509Certificate[]> clientTLSProps = this.getClientTLSProps(properties);
            if (clientTLSProps != null) {
                clientCert = clientTLSProps.getValue();
                clientKey = clientTLSProps.getKey();
            }
            if ("grpcs".equals(protocol)) {
                CryptoPrimitives cp;
                try {
                    cp = new CryptoPrimitives();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                try (ByteArrayOutputStream bis = new ByteArrayOutputStream(64000);){
                    byte[] pb = (byte[])properties.get("pemBytes");
                    if (null != pb) {
                        bis.write(pb);
                    }
                    if (properties.containsKey("pemFile")) {
                        String[] pems;
                        String pemFile = properties.getProperty("pemFile");
                        for (String pem : pems = pemFile.split("[ \t]*,[ \t]*")) {
                            if (null == pem || pem.isEmpty()) continue;
                            try {
                                bis.write(Files.readAllBytes(Paths.get(pem, new String[0])));
                            }
                            catch (IOException e) {
                                throw new RuntimeException(String.format("Failed to read certificate file %s", new File(pem).getAbsolutePath()), e);
                            }
                        }
                    }
                    pemBytes = bis.toByteArray();
                    logger.trace((Object)String.format("Endpoint %s pemBytes: %s", url, Hex.encodeHexString((byte[])pemBytes)));
                    if (pemBytes.length == 0) {
                        pemBytes = null;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read CA certificates file %s", e);
                }
                if (pemBytes == null) {
                    logger.warn((Object)String.format("Endpoint %s is grpcs with no CA certificates", url));
                }
                if (null != pemBytes) {
                    try {
                        String cnKey;
                        cn = properties.getProperty("hostnameOverride");
                        if (cn == null && "true".equals(properties.getProperty("trustServerCertificate")) && (cn = CN_CACHE.get(cnKey = new String(pemBytes, StandardCharsets.UTF_8))) == null) {
                            X500Name x500name = new JcaX509CertificateHolder((X509Certificate)cp.bytesToCertificate(pemBytes)).getSubject();
                            RDN rdn = x500name.getRDNs(BCStyle.CN)[0];
                            cn = IETFUtils.valueToString((ASN1Encodable)rdn.getFirst().getValue());
                            CN_CACHE.put(cnKey, cn);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Error getting Subject CN from certificate. Try setting it specifically with hostnameOverride property. " + e.getMessage()));
                    }
                }
                byte[] ckb = null;
                byte[] ccb = null;
                if (properties.containsKey("clientKeyFile") && properties.containsKey("clientKeyBytes")) {
                    throw new RuntimeException("Properties \"clientKeyFile\" and \"clientKeyBytes\" must cannot both be set");
                }
                if (properties.containsKey("clientCertFile") && properties.containsKey("clientCertBytes")) {
                    throw new RuntimeException("Properties \"clientCertFile\" and \"clientCertBytes\" must cannot both be set");
                }
                if (properties.containsKey("clientKeyFile") || properties.containsKey("clientCertFile")) {
                    if (properties.getProperty("clientKeyFile") == null || properties.getProperty("clientCertFile") == null) throw new RuntimeException("Properties \"clientKeyFile\" and \"clientCertFile\" must both be set or both be null");
                    try {
                        logger.trace((Object)String.format("Endpoint %s reading clientKeyFile: %s", url, properties.getProperty("clientKeyFile")));
                        ckb = Files.readAllBytes(Paths.get(properties.getProperty("clientKeyFile"), new String[0]));
                        logger.trace((Object)String.format("Endpoint %s reading clientCertFile: %s", url, properties.getProperty("clientCertFile")));
                        ccb = Files.readAllBytes(Paths.get(properties.getProperty("clientCertFile"), new String[0]));
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to parse TLS client key and/or cert", e);
                    }
                } else if (properties.containsKey("clientKeyBytes") || properties.containsKey("clientCertBytes")) {
                    ckb = (byte[])properties.get("clientKeyBytes");
                    ccb = (byte[])properties.get("clientCertBytes");
                    if (ckb == null || ccb == null) {
                        throw new RuntimeException("Properties \"clientKeyBytes\" and \"clientCertBytes\" must both be set or both be null");
                    }
                }
                if (ckb != null && ccb != null) {
                    String what = "private key";
                    byte[] whatBytes = new byte[]{};
                    try {
                        logger.trace((Object)("client TLS private key bytes size:" + ckb.length));
                        whatBytes = ckb;
                        logger.trace((Object)("client TLS key bytes:" + Hex.encodeHexString((byte[])ckb)));
                        clientKey = cp.bytesToPrivateKey(ckb);
                        logger.trace((Object)"converted TLS key.");
                        what = "certificate";
                        whatBytes = ccb;
                        logger.trace((Object)("client TLS certificate bytes:" + Hex.encodeHexString((byte[])ccb)));
                        clientCert = new X509Certificate[]{(X509Certificate)cp.bytesToCertificate(ccb)};
                        logger.trace((Object)"converted client TLS certificate.");
                        this.tlsClientCertificatePEMBytes = ccb;
                    }
                    catch (CryptoException e) {
                        logger.error((Object)String.format("Failed endpoint %s to parse %s TLS client %s", url, what, new String(whatBytes)));
                        throw new RuntimeException(String.format("Failed endpoint %s to parse TLS client %s", url, what), e);
                    }
                }
                if (null == (sslp = properties.getProperty("sslProvider"))) {
                    sslp = SSLPROVIDER;
                    logger.trace((Object)String.format("Endpoint %s specific SSL provider not found use global value: %s ", url, SSLPROVIDER));
                }
                if (!"openSSL".equals(sslp) && !"JDK".equals(sslp)) {
                    throw new RuntimeException(String.format("Endpoint %s property of sslProvider has to be either openSSL or JDK. value: '%s'", url, sslp));
                }
                nt = properties.getProperty("negotiationType");
                if (null == nt) {
                    nt = SSLNEGOTIATION;
                    logger.trace((Object)String.format("Endpoint %s specific Negotiation type not found use global value: %s ", url, SSLNEGOTIATION));
                }
                if (!"TLS".equals(nt) && !"plainText".equals(nt)) {
                    throw new RuntimeException(String.format("Endpoint %s property of negotiationType has to be either TLS or plainText. value: '%s'", url, nt));
                }
            }
        }
        try {
            if (protocol.equalsIgnoreCase("grpc")) {
                this.channelBuilder = NettyChannelBuilder.forAddress((String)this.addr, (int)this.port).negotiationType(NegotiationType.PLAINTEXT);
                this.addNettyBuilderProps(this.channelBuilder, properties);
                return;
            }
            if (!protocol.equalsIgnoreCase("grpcs")) throw new RuntimeException("invalid protocol: " + protocol);
            if (pemBytes == null) {
                this.channelBuilder = NettyChannelBuilder.forAddress((String)this.addr, (int)this.port);
                this.addNettyBuilderProps(this.channelBuilder, properties);
                return;
            }
            try {
                SslContext sslContext;
                logger.trace((Object)String.format("Endpoint %s Negotiation type: '%s', SSLprovider: '%s'", url, nt, sslp));
                SslProvider sslprovider = sslp.equals("openSSL") ? SslProvider.OPENSSL : SslProvider.JDK;
                NegotiationType ntype = nt.equals("TLS") ? NegotiationType.TLS : NegotiationType.PLAINTEXT;
                SslContextBuilder clientContextBuilder = this.getSslContextBuilder(clientCert, clientKey, sslprovider);
                logger.trace((Object)String.format("Endpoint %s  final server pemBytes: %s", url, Hex.encodeHexString((byte[])pemBytes)));
                try (ByteArrayInputStream myInputStream = new ByteArrayInputStream(pemBytes);){
                    sslContext = clientContextBuilder.trustManager((InputStream)myInputStream).build();
                }
                this.channelBuilder = NettyChannelBuilder.forAddress((String)this.addr, (int)this.port).sslContext(sslContext).negotiationType(ntype);
                if (cn != null) {
                    logger.debug((Object)String.format("Endpoint %s, using CN overrideAuthority: '%s'", url, cn));
                    this.channelBuilder.overrideAuthority(cn);
                }
                this.addNettyBuilderProps(this.channelBuilder, properties);
                return;
            }
            catch (SSLException sslex) {
                throw new RuntimeException(sslex);
            }
        }
        catch (RuntimeException e) {
            logger.error((Object)String.format("Endpoint %s, exception '%s'", url, e.getMessage()), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)String.format("Endpoint %s, exception '%s'", url, e.getMessage()), (Throwable)e);
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    SslContextBuilder getSslContextBuilder(X509Certificate[] clientCert, PrivateKey clientKey, SslProvider sslprovider) {
        SslContextBuilder clientContextBuilder = GrpcSslContexts.configure((SslContextBuilder)SslContextBuilder.forClient(), (SslProvider)sslprovider);
        if (clientKey != null && clientCert != null) {
            clientContextBuilder = clientContextBuilder.keyManager(clientKey, clientCert);
        } else {
            logger.debug((Object)String.format("Endpoint %s with no ssl context", this.url));
        }
        return clientContextBuilder;
    }

    byte[] getClientTLSCertificateDigest() {
        if (this.tlsClientCertificatePEMBytes != null && this.clientTLSCertificateDigest == null) {
            String pemCert = new String(this.tlsClientCertificatePEMBytes, StandardCharsets.UTF_8);
            byte[] derBytes = Base64.getDecoder().decode(pemCert.replaceAll("-+[ \t]*(BEGIN|END)[ \t]+CERTIFICATE[ \t]*-+", "").replaceAll("\\s", "").trim());
            SHA256Digest digest = new SHA256Digest();
            this.clientTLSCertificateDigest = new byte[digest.getDigestSize()];
            digest.update(derBytes, 0, derBytes.length);
            digest.doFinal(this.clientTLSCertificateDigest, 0);
        }
        return this.clientTLSCertificateDigest;
    }

    private void addNettyBuilderProps(NettyChannelBuilder channelBuilder, Properties props) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (props == null) {
            return;
        }
        for (Map.Entry<Object, Object> es : props.entrySet()) {
            Object[] objectArray;
            Object methodprop = es.getKey();
            if (methodprop == null) continue;
            String methodprops = String.valueOf(methodprop);
            Matcher match = METHOD_PATTERN.matcher(methodprops);
            String methodName = null;
            if (match.matches() && match.groupCount() == 1) {
                methodName = match.group(1).trim();
            }
            if (null == methodName || "forAddress".equals(methodName) || "build".equals(methodName)) continue;
            Object parmsArrayO = es.getValue();
            if (!(parmsArrayO instanceof Object[])) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = parmsArrayO;
            } else {
                objectArray = (Object[])parmsArrayO;
            }
            Object[] parmsArray = objectArray;
            Class[] classParms = new Class[parmsArray.length];
            for (int i = 0; i < parmsArray.length; ++i) {
                Object oparm = parmsArray[i];
                if (null == oparm) {
                    classParms[i] = Object.class;
                    continue;
                }
                Class<?> unwrapped = WRAPPERS_TO_PRIM.get(oparm.getClass());
                if (null != unwrapped) {
                    classParms[i] = unwrapped;
                    continue;
                }
                Class<?> clz = oparm.getClass();
                Class<?> ecz = clz.getEnclosingClass();
                if (null != ecz && ecz.isEnum()) {
                    clz = ecz;
                }
                classParms[i] = clz;
            }
            Utils.invokeMethod(channelBuilder, methodName, classParms, parmsArray);
            if (!logger.isTraceEnabled()) continue;
            logger.trace((Object)String.format("Endpoint with url: %s set managed channel builder method %s (%s) ", this.url, methodName, Arrays.toString(parmsArray)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    AbstractMap.SimpleImmutableEntry<PrivateKey, X509Certificate[]> getClientTLSProps(Properties properties) {
        byte[] ckb = null;
        byte[] ccb = null;
        if (properties.containsKey("clientKeyFile") && properties.containsKey("clientKeyBytes")) {
            throw new RuntimeException("Properties \"clientKeyFile\" and \"clientKeyBytes\" must cannot both be set");
        }
        if (properties.containsKey("clientCertFile") && properties.containsKey("clientCertBytes")) {
            throw new RuntimeException("Properties \"clientCertFile\" and \"clientCertBytes\" must cannot both be set");
        }
        if (properties.containsKey("clientKeyFile") || properties.containsKey("clientCertFile")) {
            if (properties.getProperty("clientKeyFile") == null || properties.getProperty("clientCertFile") == null) throw new RuntimeException("Properties \"clientKeyFile\" and \"clientCertFile\" must both be set or both be null");
            try {
                logger.trace((Object)String.format("Endpoint %s reading clientKeyFile: %s", this.url, new File(properties.getProperty("clientKeyFile")).getAbsolutePath()));
                ckb = Files.readAllBytes(Paths.get(properties.getProperty("clientKeyFile"), new String[0]));
                logger.trace((Object)String.format("Endpoint %s reading clientCertFile: %s", this.url, new File(properties.getProperty("clientCertFile")).getAbsolutePath()));
                ccb = Files.readAllBytes(Paths.get(properties.getProperty("clientCertFile"), new String[0]));
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to parse TLS client key and/or cert", e);
            }
        } else if (properties.containsKey("clientKeyBytes") || properties.containsKey("clientCertBytes")) {
            ckb = (byte[])properties.get("clientKeyBytes");
            ccb = (byte[])properties.get("clientCertBytes");
            if (ckb == null || ccb == null) {
                throw new RuntimeException("Properties \"clientKeyBytes\" and \"clientCertBytes\" must both be set or both be null");
            }
        }
        if (ckb == null || ccb == null) return null;
        String what = "private key";
        byte[] whatBytes = new byte[]{};
        try {
            CryptoPrimitives cp;
            try {
                cp = new CryptoPrimitives();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.trace((Object)("client TLS private key bytes size:" + ckb.length));
            whatBytes = ckb;
            logger.trace((Object)("client TLS key bytes:" + Hex.encodeHexString((byte[])ckb)));
            PrivateKey clientKey = cp.bytesToPrivateKey(ckb);
            logger.trace((Object)"converted TLS key.");
            what = "certificate";
            whatBytes = ccb;
            logger.trace((Object)("client TLS certificate bytes:" + Hex.encodeHexString((byte[])ccb)));
            X509Certificate[] clientCert = new X509Certificate[]{(X509Certificate)cp.bytesToCertificate(ccb)};
            logger.trace((Object)"converted client TLS certificate.");
            this.tlsClientCertificatePEMBytes = ccb;
            return new AbstractMap.SimpleImmutableEntry<PrivateKey, X509Certificate[]>(clientKey, clientCert);
        }
        catch (CryptoException e) {
            logger.error((Object)String.format("Failed endpoint %s to parse %s TLS client %s", this.url, what, new String(whatBytes)));
            throw new RuntimeException(String.format("Failed endpoint %s to parse TLS client %s", this.url, what), e);
        }
    }

    ManagedChannelBuilder<?> getChannelBuilder() {
        return this.channelBuilder;
    }

    String getHost() {
        return this.addr;
    }

    int getPort() {
        return this.port;
    }

    static Endpoint createEndpoint(String url, Properties properties) {
        return new Endpoint(url, properties);
    }
}

