/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.ref.WeakReference;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.sdk.EndorserTransactionEnvDeserializer;
import org.hyperledger.fabric.sdk.PayloadDeserializer;
import org.hyperledger.fabric.sdk.exception.InvalidProtocolBufferRuntimeException;

class EnvelopeDeserializer {
    protected final ByteString byteString;
    private final byte validcode;
    private WeakReference<Common.Envelope> envelope;
    private WeakReference<PayloadDeserializer> payload;
    private Integer type = null;

    EnvelopeDeserializer(ByteString byteString, byte validcode) {
        this.byteString = byteString;
        this.validcode = validcode;
    }

    Common.Envelope getEnvelope() {
        Common.Envelope ret;
        Common.Envelope envelope = ret = this.envelope != null ? (Common.Envelope)this.envelope.get() : null;
        if (ret == null) {
            try {
                ret = Common.Envelope.parseFrom(this.byteString);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
            this.envelope = new WeakReference<Common.Envelope>(ret);
        }
        return ret;
    }

    byte[] getSignature() {
        return this.getEnvelope().getSignature().toByteArray();
    }

    PayloadDeserializer getPayload() {
        PayloadDeserializer ret = null;
        if (this.payload != null) {
            ret = (PayloadDeserializer)this.payload.get();
        }
        if (ret == null) {
            ret = new PayloadDeserializer(this.getEnvelope().getPayload());
            this.payload = new WeakReference<PayloadDeserializer>(ret);
        }
        return ret;
    }

    int getType() {
        if (this.type == null) {
            this.type = this.getPayload().getHeader().getChannelHeader().getType();
        }
        return this.type;
    }

    public boolean isValid() {
        return this.validcode == 0;
    }

    public byte validationCode() {
        return this.validcode;
    }

    static EnvelopeDeserializer newInstance(ByteString byteString, byte b) throws InvalidProtocolBufferException {
        EnvelopeDeserializer ret;
        int type = Common.ChannelHeader.parseFrom(Common.Payload.parseFrom(Common.Envelope.parseFrom(byteString).getPayload()).getHeader().getChannelHeader()).getType();
        switch (type) {
            case 3: {
                ret = new EndorserTransactionEnvDeserializer(byteString, b);
                break;
            }
            default: {
                ret = new EnvelopeDeserializer(byteString, b);
            }
        }
        return ret;
    }
}

