/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.peer.Query;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.ChannelConfiguration;
import org.hyperledger.fabric.sdk.InstallProposalRequest;
import org.hyperledger.fabric.sdk.InstantiateProposalRequest;
import org.hyperledger.fabric.sdk.LifecycleApproveChaincodeDefinitionForMyOrgRequest;
import org.hyperledger.fabric.sdk.LifecycleCheckCommitReadinessRequest;
import org.hyperledger.fabric.sdk.LifecycleCommitChaincodeDefinitionRequest;
import org.hyperledger.fabric.sdk.LifecycleInstallChaincodeProposalResponse;
import org.hyperledger.fabric.sdk.LifecycleInstallChaincodeRequest;
import org.hyperledger.fabric.sdk.LifecycleQueryChaincodeDefinitionsRequest;
import org.hyperledger.fabric.sdk.LifecycleQueryInstalledChaincodeProposalResponse;
import org.hyperledger.fabric.sdk.LifecycleQueryInstalledChaincodeRequest;
import org.hyperledger.fabric.sdk.LifecycleQueryInstalledChaincodesProposalResponse;
import org.hyperledger.fabric.sdk.LifecycleQueryInstalledChaincodesRequest;
import org.hyperledger.fabric.sdk.NetworkConfig;
import org.hyperledger.fabric.sdk.Orderer;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.QueryByChaincodeRequest;
import org.hyperledger.fabric.sdk.QueryLifecycleQueryChaincodeDefinitionRequest;
import org.hyperledger.fabric.sdk.TransactionProposalRequest;
import org.hyperledger.fabric.sdk.UpdateChannelConfiguration;
import org.hyperledger.fabric.sdk.UpgradeProposalRequest;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.exception.CryptoException;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.NetworkConfigurationException;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.exception.TransactionException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.security.CryptoSuite;

public class HFClient {
    private static final Config config = Config.getConfig();
    private CryptoSuite cryptoSuite;
    protected ExecutorService executorService;
    private static final Log logger;
    private final Map<String, Channel> channels = new HashMap<String, Channel>();
    private User userContext;
    protected final ThreadFactory threadFactory = Executors.defaultThreadFactory();
    private static final int CLIENT_THREAD_EXECUTOR_COREPOOLSIZE;
    private static final int CLIENT_THREAD_EXECUTOR_MAXIMUMPOOLSIZE;
    private static final long CLIENT_THREAD_EXECUTOR_KEEPALIVETIME;
    private static final TimeUnit CLIENT_THREAD_EXECUTOR_KEEPALIVETIMEUNIT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService getExecutorService() {
        if (null == this.executorService) {
            HFClient hFClient = this;
            synchronized (hFClient) {
                if (null == this.executorService) {
                    this.executorService = new ThreadPoolExecutor(CLIENT_THREAD_EXECUTOR_COREPOOLSIZE, CLIENT_THREAD_EXECUTOR_MAXIMUMPOOLSIZE, CLIENT_THREAD_EXECUTOR_KEEPALIVETIME, CLIENT_THREAD_EXECUTOR_KEEPALIVETIMEUNIT, new SynchronousQueue<Runnable>(), r -> {
                        Thread t = this.threadFactory.newThread(r);
                        t.setDaemon(true);
                        return t;
                    });
                }
            }
        }
        return this.executorService;
    }

    public User getUserContext() {
        return this.userContext;
    }

    private HFClient() {
    }

    public CryptoSuite getCryptoSuite() {
        return this.cryptoSuite;
    }

    public void setCryptoSuite(CryptoSuite cryptoSuite) throws CryptoException, InvalidArgumentException {
        if (null == cryptoSuite) {
            throw new InvalidArgumentException("CryptoSuite parameter is null.");
        }
        if (this.cryptoSuite != null && cryptoSuite != this.cryptoSuite) {
            throw new InvalidArgumentException("CryptoSuite may only be set once.");
        }
        this.cryptoSuite = cryptoSuite;
    }

    public synchronized void setExecutorService(ExecutorService executorService) throws InvalidArgumentException {
        if (executorService == null) {
            throw new InvalidArgumentException("Executor service can not be null.");
        }
        if (this.executorService != null && this.executorService != executorService) {
            throw new InvalidArgumentException("Executor service has already been set.");
        }
        this.executorService = executorService;
    }

    public static HFClient createNewInstance() {
        return new HFClient();
    }

    private void setDefaultProperties(Properties props) {
        if (!props.containsKey("grpc.NettyChannelBuilderOption.keepAliveTime")) {
            props.put("grpc.NettyChannelBuilderOption.keepAliveTime", new Object[]{2L, TimeUnit.MINUTES});
        }
        if (!props.containsKey("grpc.NettyChannelBuilderOption.keepAliveTimeout")) {
            props.put("grpc.NettyChannelBuilderOption.keepAliveTimeout", new Object[]{20L, TimeUnit.SECONDS});
        }
        if (!props.containsKey("grpc.NettyChannelBuilderOption.keepAliveWithoutCalls")) {
            props.put("grpc.NettyChannelBuilderOption.keepAliveWithoutCalls", new Object[]{true});
        }
    }

    public Channel loadChannelFromConfig(String channelName, NetworkConfig networkConfig, NetworkConfig.NetworkConfigAddPeerHandler networkConfigAddPeerHandler, NetworkConfig.NetworkConfigAddOrdererHandler networkConfigAddOrdererHandler) throws InvalidArgumentException, NetworkConfigurationException {
        this.clientCheck();
        if (channelName == null || channelName.isEmpty()) {
            throw new InvalidArgumentException("channelName must be specified");
        }
        if (networkConfig == null) {
            throw new InvalidArgumentException("networkConfig must be specified");
        }
        if (null == networkConfigAddPeerHandler) {
            throw new InvalidArgumentException("networkConfigAddPeerHandler is null.");
        }
        if (null == networkConfigAddOrdererHandler) {
            throw new InvalidArgumentException("networkConfigAddOrdererHandler is null.");
        }
        if (this.channels.containsKey(channelName)) {
            throw new InvalidArgumentException(String.format("Channel with name %s already exists", channelName));
        }
        return networkConfig.loadChannel(this, channelName, networkConfigAddPeerHandler, networkConfigAddOrdererHandler);
    }

    public Channel loadChannelFromConfig(String channelName, NetworkConfig networkConfig) throws InvalidArgumentException, NetworkConfigurationException {
        this.clientCheck();
        if (channelName == null || channelName.isEmpty()) {
            throw new InvalidArgumentException("channelName must be specified");
        }
        if (networkConfig == null) {
            throw new InvalidArgumentException("networkConfig must be specified");
        }
        if (this.channels.containsKey(channelName)) {
            throw new InvalidArgumentException(String.format("Channel with name %s already exists", channelName));
        }
        return networkConfig.loadChannel(this, channelName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel newChannel(String name) throws InvalidArgumentException {
        this.clientCheck();
        if (Utils.isNullOrEmpty(name)) {
            throw new InvalidArgumentException("Channel name can not be null or empty string.");
        }
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            if (this.channels.containsKey(name)) {
                throw new InvalidArgumentException(String.format("Channel by the name %s already exists", name));
            }
            logger.trace((Object)("Creating channel :" + name));
            Channel newChannel = Channel.createNewInstance(name, this);
            this.channels.put(name, newChannel);
            return newChannel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel newChannel(String name, Orderer orderer, ChannelConfiguration channelConfiguration, byte[] ... channelConfigurationSignatures) throws TransactionException, InvalidArgumentException {
        this.clientCheck();
        if (Utils.isNullOrEmpty(name)) {
            throw new InvalidArgumentException("Channel name can not be null or empty string.");
        }
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            if (this.channels.containsKey(name)) {
                throw new InvalidArgumentException(String.format("Channel by the name %s already exits", name));
            }
            logger.trace((Object)("Creating channel :" + name));
            Channel newChannel = Channel.createNewInstance(name, this, orderer, channelConfiguration, channelConfigurationSignatures);
            this.channels.put(name, newChannel);
            return newChannel;
        }
    }

    public Channel deSerializeChannel(File file) throws IOException, ClassNotFoundException, InvalidArgumentException {
        if (null == file) {
            throw new InvalidArgumentException("File parameter may not be null");
        }
        return this.deSerializeChannel(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel deSerializeChannel(byte[] channelBytes) throws IOException, ClassNotFoundException, InvalidArgumentException {
        Channel channel;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(channelBytes));
            channel = (Channel)in.readObject();
            String name = channel.getName();
            Map<String, Channel> map = this.channels;
            synchronized (map) {
                if (null != this.getChannel(name)) {
                    channel.shutdown(true);
                    throw new InvalidArgumentException(String.format("Channel %s already exists in the client", name));
                }
                this.channels.put(name, channel);
                channel.client = this;
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return channel;
    }

    public Peer newPeer(String name, String grpcURL, Properties properties) throws InvalidArgumentException {
        this.clientCheck();
        this.setDefaultProperties(properties);
        return Peer.createNewInstance(name, grpcURL, properties);
    }

    public Peer newPeer(String name, String grpcURL) throws InvalidArgumentException {
        this.clientCheck();
        return Peer.createNewInstance(name, grpcURL, new Properties());
    }

    public Channel getChannel(String name) {
        return this.channels.get(name);
    }

    @Deprecated
    public InstallProposalRequest newInstallProposalRequest() {
        return new InstallProposalRequest(this.userContext);
    }

    public LifecycleInstallChaincodeRequest newLifecycleInstallChaincodeRequest() {
        return new LifecycleInstallChaincodeRequest(this.userContext);
    }

    public LifecycleQueryInstalledChaincodeRequest newLifecycleQueryInstalledChaincodeRequest() {
        return new LifecycleQueryInstalledChaincodeRequest(this.userContext);
    }

    public LifecycleQueryInstalledChaincodesRequest newLifecycleQueryInstalledChaincodesRequest() {
        return new LifecycleQueryInstalledChaincodesRequest(this.userContext);
    }

    public LifecycleApproveChaincodeDefinitionForMyOrgRequest newLifecycleApproveChaincodeDefinitionForMyOrgRequest() {
        return new LifecycleApproveChaincodeDefinitionForMyOrgRequest(this.userContext);
    }

    public LifecycleCheckCommitReadinessRequest newLifecycleSimulateCommitChaincodeDefinitionRequest() {
        return new LifecycleCheckCommitReadinessRequest(this.userContext);
    }

    public LifecycleCommitChaincodeDefinitionRequest newLifecycleCommitChaincodeDefinitionRequest() {
        return new LifecycleCommitChaincodeDefinitionRequest(this.userContext);
    }

    public LifecycleQueryChaincodeDefinitionsRequest newLifecycleQueryChaincodeDefinitionsRequest() {
        return new LifecycleQueryChaincodeDefinitionsRequest(this.userContext);
    }

    public QueryLifecycleQueryChaincodeDefinitionRequest newQueryLifecycleQueryChaincodeDefinitionRequest() {
        return new QueryLifecycleQueryChaincodeDefinitionRequest(this.userContext);
    }

    public Collection<LifecycleInstallChaincodeProposalResponse> sendLifecycleInstallChaincodeRequest(LifecycleInstallChaincodeRequest lifecycleInstallChaincodeRequest, Collection<Peer> peers) throws ProposalException, InvalidArgumentException {
        if (null == lifecycleInstallChaincodeRequest) {
            throw new InvalidArgumentException("The lifecycleInstallChaincodeRequest parameter can not be null.");
        }
        this.clientCheck();
        lifecycleInstallChaincodeRequest.setSubmitted();
        Channel systemChannel = Channel.newSystemChannel(this);
        return systemChannel.sendLifecycleInstallProposal(lifecycleInstallChaincodeRequest, peers);
    }

    public Collection<LifecycleQueryInstalledChaincodeProposalResponse> sendLifecycleQueryInstalledChaincode(LifecycleQueryInstalledChaincodeRequest lifecycleQueryInstalledChaincodeRequest, Collection<Peer> peers) throws InvalidArgumentException, ProposalException {
        if (null == lifecycleQueryInstalledChaincodeRequest) {
            throw new InvalidArgumentException("The lifecycleQueryInstalledChaincodeRequest parameter can not be null.");
        }
        this.clientCheck();
        if (null == peers) {
            throw new InvalidArgumentException("The parameter peers set to null");
        }
        if (peers.isEmpty()) {
            throw new InvalidArgumentException("Peers to query is empty.");
        }
        if (lifecycleQueryInstalledChaincodeRequest == null) {
            throw new InvalidArgumentException("The lifecycleQueryInstalledChaincoded parameter must not be null.");
        }
        if (Utils.isNullOrEmpty(lifecycleQueryInstalledChaincodeRequest.getPackageId())) {
            throw new InvalidArgumentException("The lifecycleQueryInstalledChaincoded packageID parameter must not be null.");
        }
        try {
            Channel systemChannel = Channel.newSystemChannel(this);
            return systemChannel.lifecycleQueryInstalledChaincode(lifecycleQueryInstalledChaincodeRequest, peers);
        }
        catch (ProposalException e) {
            logger.error((Object)String.format("lifecycleQueryInstalledChaincodeRequest for failed. %s", e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public Collection<LifecycleQueryInstalledChaincodesProposalResponse> sendLifecycleQueryInstalledChaincodes(LifecycleQueryInstalledChaincodesRequest lifecycleQueryInstalledChaincodesRequest, Collection<Peer> peers) throws InvalidArgumentException, ProposalException {
        if (null == lifecycleQueryInstalledChaincodesRequest) {
            throw new InvalidArgumentException("The lifecycleQueryInstalledChaincodesRequest parameter can not be null.");
        }
        this.clientCheck();
        if (null == peers) {
            throw new InvalidArgumentException("The peers set to null");
        }
        if (peers.isEmpty()) {
            throw new InvalidArgumentException("The peers parameter is empty.");
        }
        try {
            Channel systemChannel = Channel.newSystemChannel(this);
            return systemChannel.lifecycleQueryInstalledChaincodes(lifecycleQueryInstalledChaincodesRequest, peers);
        }
        catch (ProposalException e) {
            logger.error((Object)e);
            throw e;
        }
    }

    @Deprecated
    public InstantiateProposalRequest newInstantiationProposalRequest() {
        return new InstantiateProposalRequest(this.userContext);
    }

    @Deprecated
    public UpgradeProposalRequest newUpgradeProposalRequest() {
        return new UpgradeProposalRequest(this.userContext);
    }

    public TransactionProposalRequest newTransactionProposalRequest() {
        return TransactionProposalRequest.newInstance(this.userContext);
    }

    public QueryByChaincodeRequest newQueryProposalRequest() {
        return QueryByChaincodeRequest.newInstance(this.userContext);
    }

    public User setUserContext(User userContext) {
        if (null == this.cryptoSuite) {
            throw new IllegalStateException("No cryptoSuite has been set.");
        }
        User.userContextCheck(userContext);
        User ret = this.userContext;
        this.userContext = userContext;
        logger.debug((Object)String.format("Setting user context to MSPID: %s user: %s", userContext.getMspId(), userContext.getName()));
        return ret;
    }

    public Orderer newOrderer(String name, String grpcURL) throws InvalidArgumentException {
        this.clientCheck();
        return this.newOrderer(name, grpcURL, new Properties());
    }

    public Orderer newOrderer(String name, String grpcURL, Properties properties) throws InvalidArgumentException {
        this.clientCheck();
        this.setDefaultProperties(properties);
        return Orderer.createNewInstance(name, grpcURL, properties);
    }

    public Set<String> queryChannels(Peer peer) throws InvalidArgumentException, ProposalException {
        this.clientCheck();
        if (null == peer) {
            throw new InvalidArgumentException("peer set to null");
        }
        try {
            Channel systemChannel = Channel.newSystemChannel(this);
            return systemChannel.queryChannels(peer);
        }
        catch (ProposalException e) {
            logger.error((Object)String.format("queryChannels for peer %s failed." + e.getMessage(), peer.getName()), (Throwable)e);
            throw e;
        }
    }

    @Deprecated
    public List<Query.ChaincodeInfo> queryInstalledChaincodes(Peer peer) throws InvalidArgumentException, ProposalException {
        this.clientCheck();
        if (null == peer) {
            throw new InvalidArgumentException("peer set to null");
        }
        try {
            Channel systemChannel = Channel.newSystemChannel(this);
            return systemChannel.queryInstalledChaincodes(peer);
        }
        catch (ProposalException e) {
            logger.error((Object)String.format("queryInstalledChaincodes for peer %s failed." + e.getMessage(), peer.getName()), (Throwable)e);
            throw e;
        }
    }

    public byte[] getChannelConfigurationSignature(ChannelConfiguration channelConfiguration, User signer) throws InvalidArgumentException {
        this.clientCheck();
        Channel systemChannel = Channel.newSystemChannel(this);
        return systemChannel.getChannelConfigurationSignature(channelConfiguration, signer);
    }

    public byte[] getUpdateChannelConfigurationSignature(UpdateChannelConfiguration updateChannelConfiguration, User signer) throws InvalidArgumentException {
        this.clientCheck();
        Channel systemChannel = Channel.newSystemChannel(this);
        return systemChannel.getUpdateChannelConfigurationSignature(updateChannelConfiguration, signer);
    }

    @Deprecated
    public Collection<ProposalResponse> sendInstallProposal(InstallProposalRequest installProposalRequest, Collection<Peer> peers) throws ProposalException, InvalidArgumentException {
        this.clientCheck();
        Channel systemChannel = Channel.newSystemChannel(this);
        return systemChannel.sendInstallProposal(installProposalRequest, peers);
    }

    private void clientCheck() throws InvalidArgumentException {
        if (null == this.cryptoSuite) {
            throw new InvalidArgumentException("No cryptoSuite has been set.");
        }
        User.userContextCheck(this.userContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChannel(Channel channel) {
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            String name = channel.getName();
            if (this.channels.get(name) == channel) {
                this.channels.remove(name);
            }
        }
    }

    static {
        if (null == System.getProperty("org.hyperledger.fabric.sdk.logGRPC")) {
            Logger.getLogger("io.netty").setLevel(Level.OFF);
            Logger.getLogger("io.grpc").setLevel(Level.OFF);
        }
        logger = LogFactory.getLog(HFClient.class);
        CLIENT_THREAD_EXECUTOR_COREPOOLSIZE = config.getClientThreadExecutorCorePoolSize();
        CLIENT_THREAD_EXECUTOR_MAXIMUMPOOLSIZE = config.getClientThreadExecutorMaxiumPoolSize();
        CLIENT_THREAD_EXECUTOR_KEEPALIVETIME = config.getClientThreadExecutorKeepAliveTime();
        CLIENT_THREAD_EXECUTOR_KEEPALIVETIMEUNIT = config.getClientThreadExecutorKeepAliveTimeUnit();
    }
}

