/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.ref.WeakReference;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.msp.Identities;
import org.hyperledger.fabric.sdk.ChannelHeaderDeserializer;
import org.hyperledger.fabric.sdk.exception.InvalidProtocolBufferRuntimeException;

class HeaderDeserializer {
    private final Common.Header header;
    private WeakReference<ChannelHeaderDeserializer> channelHeader;

    HeaderDeserializer(Common.Header header) {
        this.header = header;
    }

    Common.Header getHeader() {
        return this.header;
    }

    ChannelHeaderDeserializer getChannelHeader() {
        ChannelHeaderDeserializer ret = null;
        if (this.channelHeader != null) {
            ret = (ChannelHeaderDeserializer)this.channelHeader.get();
        }
        if (ret == null) {
            ret = new ChannelHeaderDeserializer(this.getHeader().getChannelHeader());
            this.channelHeader = new WeakReference<ChannelHeaderDeserializer>(ret);
        }
        return ret;
    }

    Identities.SerializedIdentity getCreator() {
        try {
            Common.SignatureHeader signatureHeader1 = Common.SignatureHeader.parseFrom(this.header.getSignatureHeader());
            return Identities.SerializedIdentity.parseFrom(signatureHeader1.getCreator());
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidProtocolBufferRuntimeException(e);
        }
    }

    byte[] getNonce() {
        try {
            Common.SignatureHeader signatureHeader1 = Common.SignatureHeader.parseFrom(this.header.getSignatureHeader());
            return signatureHeader1.getNonce().toByteArray();
        }
        catch (InvalidProtocolBufferException e) {
            throw new InvalidProtocolBufferRuntimeException(e);
        }
    }
}

