/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import org.hyperledger.fabric.sdk.ChaincodeCollectionConfiguration;
import org.hyperledger.fabric.sdk.LifecycleChaincodeEndorsementPolicy;
import org.hyperledger.fabric.sdk.LifecycleRequest;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.Utils;

public class LifecycleApproveChaincodeDefinitionForMyOrgRequest
extends LifecycleRequest {
    private static final Config config = Config.getConfig();
    protected String chaincodeName;
    protected String chaincodeVersion;
    private String packageId;
    private boolean sourceUnavailable = false;
    private long sequence;
    private ChaincodeCollectionConfiguration chaincodeCollectionConfiguration;
    private String chaincodeEndorsementPlugin = null;
    private Boolean initRequired = null;
    private String chaincodeValidationPlugin = null;
    private ByteString validationParameter = null;

    LifecycleApproveChaincodeDefinitionForMyOrgRequest(User userContext) {
        super(userContext);
    }

    boolean isSourceUnavailable() {
        return this.sourceUnavailable;
    }

    public void setSourceUnavailable(boolean sourceUnavailable) throws InvalidArgumentException {
        if (this.packageId != null) {
            throw new InvalidArgumentException("Source none can not be set to true if packageId has been provided already");
        }
        this.sourceUnavailable = sourceUnavailable;
    }

    public void setValidationParameter(byte[] validationParameter) throws InvalidArgumentException {
        if (null == validationParameter) {
            throw new InvalidArgumentException("The valdiationParameter parameter can not be null.");
        }
        this.validationParameter = ByteString.copyFrom((byte[])validationParameter);
    }

    public void setChaincodeEndorsementPolicy(LifecycleChaincodeEndorsementPolicy lifecycleChaincodeEndorsementPolicy) throws InvalidArgumentException {
        if (null == lifecycleChaincodeEndorsementPolicy) {
            throw new InvalidArgumentException("The lifecycleChaincodeEndorsementPolicy parameter can not be null.");
        }
        this.validationParameter = lifecycleChaincodeEndorsementPolicy.getByteString();
    }

    Boolean isInitRequired() {
        return this.initRequired;
    }

    public void setInitRequired(boolean initRequired) {
        this.initRequired = initRequired;
    }

    String getChaincodeName() {
        return this.chaincodeName;
    }

    public void setChaincodeName(String chaincodeName) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(chaincodeName)) {
            throw new InvalidArgumentException("The chaincodeName parameter can not be null or empty.");
        }
        this.chaincodeName = chaincodeName;
    }

    String getChaincodeVersion() {
        return this.chaincodeVersion;
    }

    public void setChaincodeVersion(String chaincodeVersion) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(chaincodeVersion)) {
            throw new InvalidArgumentException("The chaincodeVersion parameter can not be null or empty.");
        }
        this.chaincodeVersion = chaincodeVersion;
    }

    long getSequence() {
        return this.sequence;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    String getPackageId() {
        return this.packageId;
    }

    public void setPackageId(String packageId) throws InvalidArgumentException {
        if (this.sourceUnavailable) {
            throw new InvalidArgumentException("The source none has be set to true already. Can not have packageId set when source none set to true.");
        }
        if (Utils.isNullOrEmpty(packageId)) {
            throw new InvalidArgumentException("The packageId parameter can not be null or empty.");
        }
        this.packageId = packageId;
    }

    ChaincodeCollectionConfiguration getChaincodeCollectionConfiguration() {
        return this.chaincodeCollectionConfiguration;
    }

    public void setChaincodeCollectionConfiguration(ChaincodeCollectionConfiguration chaincodeCollectionConfiguration) throws InvalidArgumentException {
        if (null == chaincodeCollectionConfiguration) {
            throw new InvalidArgumentException("The chaincodeCollectionConfiguration may not be null");
        }
        this.chaincodeCollectionConfiguration = chaincodeCollectionConfiguration;
    }

    String getChaincodeEndorsementPlugin() {
        return this.chaincodeEndorsementPlugin;
    }

    String getChaincodeValidationPlugin() {
        return this.chaincodeValidationPlugin;
    }

    public void setChaincodeEndorsementPlugin(String chaincodeEndorsementPlugin) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(chaincodeEndorsementPlugin)) {
            throw new InvalidArgumentException("The getChaincodeEndorsementPlugin parameter can not be null or empty.");
        }
        this.chaincodeEndorsementPlugin = chaincodeEndorsementPlugin;
    }

    public void setChaincodeValidationPlugin(String chaincodeValidationPlugin) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(chaincodeValidationPlugin)) {
            throw new InvalidArgumentException("The getChaincodeValidationPlugin parameter can not be null or empty.");
        }
        this.chaincodeValidationPlugin = chaincodeValidationPlugin;
    }

    ByteString getValidationParameter() {
        return this.validationParameter;
    }
}

