/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import io.grpc.netty.shaded.io.netty.util.internal.StringUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.hyperledger.fabric.protos.common.MspPrincipal;
import org.hyperledger.fabric.protos.common.Policies;
import org.hyperledger.fabric.protos.peer.Policy;
import org.hyperledger.fabric.sdk.exception.ChaincodeEndorsementPolicyParseException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class LifecycleChaincodeEndorsementPolicy {
    private static final Pattern noofPattern = Pattern.compile("^(\\d+)-of$");
    private ByteString serializedPolicy = null;

    private LifecycleChaincodeEndorsementPolicy() {
    }

    LifecycleChaincodeEndorsementPolicy(ByteString serializedPolicy) {
        this.serializedPolicy = serializedPolicy;
    }

    private static Policies.SignaturePolicy parsePolicy(IndexedHashMap<String, MspPrincipal.MSPPrincipal> identities, Map<?, ?> mp) throws ChaincodeEndorsementPolicyParseException {
        if (mp == null) {
            throw new ChaincodeEndorsementPolicyParseException("No policy section was found in the document.");
        }
        if (!(mp instanceof Map)) {
            throw new ChaincodeEndorsementPolicyParseException("Policy expected object section was not found in the document.");
        }
        Iterator<Map.Entry<?, ?>> iterator = mp.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<?, ?> ks = iterator.next();
            Object ko = ks.getKey();
            Object vo = ks.getValue();
            String key = (String)ko;
            if ("signed-by".equals(key)) {
                if (!(vo instanceof String)) {
                    throw new ChaincodeEndorsementPolicyParseException("signed-by expecting a string value");
                }
                MspPrincipal.MSPPrincipal mspPrincipal = (MspPrincipal.MSPPrincipal)identities.get(vo);
                if (null == mspPrincipal) {
                    throw new ChaincodeEndorsementPolicyParseException(String.format("No identity found by name %s in signed-by.", vo));
                }
                return Policies.SignaturePolicy.newBuilder().setSignedBy(identities.getKeysIndex((String)vo)).build();
            }
            Matcher match = noofPattern.matcher(key);
            if (match.matches() && match.groupCount() == 1) {
                String matchStingNo = match.group(1).trim();
                int matchNo = Integer.parseInt(matchStingNo);
                if (!(vo instanceof List)) {
                    throw new ChaincodeEndorsementPolicyParseException(String.format("%s expected to have list but found %s.", key, String.valueOf(vo)));
                }
                List voList = (List)vo;
                if (voList.size() < matchNo) {
                    throw new ChaincodeEndorsementPolicyParseException(String.format("%s expected to have at least %d items to match but only found %d.", key, matchNo, voList.size()));
                }
                Policies.SignaturePolicy.NOutOf.Builder spBuilder = Policies.SignaturePolicy.NOutOf.newBuilder().setN(matchNo);
                for (Map nlo : voList) {
                    Policies.SignaturePolicy sp = LifecycleChaincodeEndorsementPolicy.parsePolicy(identities, nlo);
                    spBuilder.addRules(sp);
                }
                return Policies.SignaturePolicy.newBuilder().setNOutOf(spBuilder.build()).build();
            }
            throw new ChaincodeEndorsementPolicyParseException(String.format("Unsupported policy type %s", key));
        }
        throw new ChaincodeEndorsementPolicyParseException("No values found for policy");
    }

    private static IndexedHashMap<String, MspPrincipal.MSPPrincipal> parseIdentities(Map<?, ?> identities) throws ChaincodeEndorsementPolicyParseException {
        IndexedHashMap<String, MspPrincipal.MSPPrincipal> ret = new IndexedHashMap<String, MspPrincipal.MSPPrincipal>();
        for (Map.Entry<?, ?> kp : identities.entrySet()) {
            MspPrincipal.MSPRole.MSPRoleType mspRoleType;
            Object key = kp.getKey();
            Object val = kp.getValue();
            if (!(key instanceof String)) {
                throw new ChaincodeEndorsementPolicyParseException(String.format("In identities key expected String got %s ", key == null ? "null" : key.getClass().getName()));
            }
            if (null != ret.get(key)) {
                throw new ChaincodeEndorsementPolicyParseException(String.format("In identities with key %s is listed more than once ", key));
            }
            if (!(val instanceof Map)) {
                throw new ChaincodeEndorsementPolicyParseException(String.format("In identities with key %s value expected Map got %s ", key, val == null ? "null" : val.getClass().getName()));
            }
            Object role = ((Map)val).get("role");
            if (!(role instanceof Map)) {
                throw new ChaincodeEndorsementPolicyParseException(String.format("In identities with key %s value expected Map for role got %s ", key, role == null ? "null" : role.getClass().getName()));
            }
            Map roleMap = (Map)role;
            Object nameObj = roleMap.get("name");
            if (!(nameObj instanceof String)) {
                throw new ChaincodeEndorsementPolicyParseException(String.format("In identities with key %s name expected String in role got %s ", key, nameObj == null ? "null" : nameObj.getClass().getName()));
            }
            String name = (String)nameObj;
            name = name.trim();
            Object mspId = roleMap.get("mspId");
            if (!(mspId instanceof String)) {
                throw new ChaincodeEndorsementPolicyParseException(String.format("In identities with key %s mspId expected String in role got %s ", key, mspId == null ? "null" : mspId.getClass().getName()));
            }
            if (StringUtil.isNullOrEmpty((String)((String)mspId))) {
                throw new ChaincodeEndorsementPolicyParseException(String.format("In identities with key %s mspId must not be null or empty String in role ", key));
            }
            switch (name) {
                case "member": {
                    mspRoleType = MspPrincipal.MSPRole.MSPRoleType.MEMBER;
                    break;
                }
                case "admin": {
                    mspRoleType = MspPrincipal.MSPRole.MSPRoleType.ADMIN;
                    break;
                }
                case "client": {
                    mspRoleType = MspPrincipal.MSPRole.MSPRoleType.CLIENT;
                    break;
                }
                case "peer": {
                    mspRoleType = MspPrincipal.MSPRole.MSPRoleType.PEER;
                    break;
                }
                default: {
                    throw new ChaincodeEndorsementPolicyParseException(String.format("In identities with key %s name expected member, admin, client, or peer in role got %s ", key, name));
                }
            }
            MspPrincipal.MSPRole mspRole = MspPrincipal.MSPRole.newBuilder().setRole(mspRoleType).setMspIdentifier((String)mspId).build();
            MspPrincipal.MSPPrincipal principal = MspPrincipal.MSPPrincipal.newBuilder().setPrincipalClassification(MspPrincipal.MSPPrincipal.Classification.ROLE).setPrincipal(mspRole.toByteString()).build();
            ret.put((String)key, principal);
        }
        if (ret.size() == 0) {
            throw new ChaincodeEndorsementPolicyParseException("No identities were found in the policy specification");
        }
        return ret;
    }

    public static LifecycleChaincodeEndorsementPolicy fromSignaturePolicyYamlFile(Path yamlPolicyFile) throws IOException, ChaincodeEndorsementPolicyParseException {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        Map load = (Map)yaml.load((InputStream)new FileInputStream(yamlPolicyFile.toFile()));
        Map mp = (Map)load.get("policy");
        if (null == mp) {
            throw new ChaincodeEndorsementPolicyParseException("The policy file has no policy section");
        }
        IndexedHashMap<String, MspPrincipal.MSPPrincipal> identities = LifecycleChaincodeEndorsementPolicy.parseIdentities((Map)load.get("identities"));
        Policies.SignaturePolicy sp = LifecycleChaincodeEndorsementPolicy.parsePolicy(identities, mp);
        return new LifecycleChaincodeEndorsementPolicy(Policy.ApplicationPolicy.newBuilder().setSignaturePolicy(Policies.SignaturePolicyEnvelope.newBuilder().setVersion(0).addAllIdentities(identities.values()).setRule(sp).build()).build().toByteString());
    }

    public static LifecycleChaincodeEndorsementPolicy fromPolicyReference(String channelConfigPolicyReference) throws IOException, ChaincodeEndorsementPolicyParseException {
        return new LifecycleChaincodeEndorsementPolicy(Policy.ApplicationPolicy.newBuilder().setChannelConfigPolicyReference(channelConfigPolicyReference).build().toByteString());
    }

    public static LifecycleChaincodeEndorsementPolicy fromStream(InputStream inputStream) throws IOException {
        return new LifecycleChaincodeEndorsementPolicy(ByteString.copyFrom((byte[])IOUtils.toByteArray((InputStream)inputStream)));
    }

    public static LifecycleChaincodeEndorsementPolicy fromBytes(byte[] policyAsBytes) {
        return new LifecycleChaincodeEndorsementPolicy(ByteString.copyFrom((byte[])policyAsBytes));
    }

    public byte[] getSerializedPolicyBytes() {
        return this.serializedPolicy.toByteArray();
    }

    ByteString getByteString() {
        return this.serializedPolicy;
    }

    private static class IndexedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        final HashMap<K, Integer> kmap = new HashMap();

        private IndexedHashMap() {
        }

        @Override
        public V put(K key, V value) {
            this.kmap.put(key, this.size());
            return super.put(key, value);
        }

        Integer getKeysIndex(String n) {
            return this.kmap.get(n);
        }
    }
}

