/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.json.JsonObject;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.sdk.TransactionRequest;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.DiagnosticFileDumper;
import org.hyperledger.fabric.sdk.helper.Utils;

public class LifecycleChaincodePackage {
    private static final Log logger = LogFactory.getLog(LifecycleChaincodePackage.class);
    private static final Config config = Config.getConfig();
    private static final boolean IS_TRACE_LEVEL = logger.isTraceEnabled();
    private static final DiagnosticFileDumper diagnosticFileDumper = IS_TRACE_LEVEL ? config.getDiagnosticFileDumper() : null;
    private final byte[] pBytes;

    private LifecycleChaincodePackage(byte[] packageBytes) {
        this.pBytes = new byte[packageBytes.length];
        System.arraycopy(packageBytes, 0, this.pBytes, 0, packageBytes.length);
    }

    public static LifecycleChaincodePackage fromFile(File policyFile) throws IOException, InvalidArgumentException {
        if (null == policyFile) {
            throw new InvalidArgumentException("The parameter policyFile may not be null.");
        }
        try (FileInputStream is = new FileInputStream(policyFile);){
            byte[] packageBytes = IOUtils.toByteArray((InputStream)is);
            LifecycleChaincodePackage lifecycleChaincodePackage = LifecycleChaincodePackage.fromBytes(packageBytes);
            return lifecycleChaincodePackage;
        }
    }

    public static LifecycleChaincodePackage fromStream(InputStream inputStream) throws IOException, InvalidArgumentException {
        if (null == inputStream) {
            throw new InvalidArgumentException("The parameter inputStream may not be null.");
        }
        byte[] packageBytes = IOUtils.toByteArray((InputStream)inputStream);
        return LifecycleChaincodePackage.fromBytes(packageBytes);
    }

    public static LifecycleChaincodePackage fromBytes(byte[] packageBytes) throws InvalidArgumentException {
        if (null == packageBytes) {
            throw new InvalidArgumentException("The parameter packageBytes may not be null.");
        }
        return new LifecycleChaincodePackage(packageBytes);
    }

    public byte[] getAsBytes() {
        byte[] ret = new byte[this.pBytes.length];
        System.arraycopy(this.pBytes, 0, ret, 0, this.pBytes.length);
        return ret;
    }

    public void toFile(Path path, OpenOption ... options) throws IOException {
        Files.write(path, this.pBytes, options);
    }

    public static LifecycleChaincodePackage fromSource(String label, Path chaincodeSource, TransactionRequest.Type chaincodeType, String chaincodePath, Path chaincodeMetaInfLocation) throws IOException, InvalidArgumentException {
        if (Utils.isNullOrEmpty(label)) {
            throw new InvalidArgumentException("The parameter label may not be null or empty.");
        }
        if (null == chaincodeSource) {
            throw new InvalidArgumentException(" The parameter chaincodeSource may not be null.");
        }
        if (null == chaincodeType) {
            throw new InvalidArgumentException(" The parameter chaincodeType may not be null.");
        }
        byte[] mataDataBytes = LifecycleChaincodePackage.generatePackageMataDataBytes(label, chaincodePath, chaincodeType);
        byte[] dataBytes = LifecycleChaincodePackage.generatePackageDataBytes(chaincodeSource, chaincodeMetaInfLocation, chaincodeType, chaincodePath);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(500000);
        TarArchiveOutputStream archiveOutputStream = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)bos));
        archiveOutputStream.setLongFileMode(2);
        TarArchiveEntry archiveEntry = new TarArchiveEntry("metadata.json");
        archiveEntry.setMode(33188);
        archiveEntry.setSize((long)mataDataBytes.length);
        archiveOutputStream.putArchiveEntry((ArchiveEntry)archiveEntry);
        archiveOutputStream.write(mataDataBytes);
        archiveOutputStream.closeArchiveEntry();
        archiveEntry = new TarArchiveEntry("code.tar.gz");
        archiveEntry.setMode(33188);
        archiveEntry.setSize((long)dataBytes.length);
        archiveOutputStream.putArchiveEntry((ArchiveEntry)archiveEntry);
        archiveOutputStream.write(dataBytes);
        archiveOutputStream.closeArchiveEntry();
        archiveOutputStream.close();
        return LifecycleChaincodePackage.fromBytes(bos.toByteArray());
    }

    static byte[] generatePackageDataBytes(Path chaincodeSource, Path chaincodeMetaInfLocation, TransactionRequest.Type chaincodeLanguage, String chaincodePath) throws IOException {
        String message;
        String dplang;
        logger.debug((Object)"generatePackageDataBytes");
        if (null == chaincodeSource) {
            throw new IllegalArgumentException("Missing chaincodeSource ");
        }
        File projectSourceDir = null;
        String targetPathPrefix = null;
        File metainf = null;
        if (null != chaincodeMetaInfLocation) {
            File chaincodemetainflocation = chaincodeMetaInfLocation.toFile();
            if (!chaincodemetainflocation.exists()) {
                throw new IllegalArgumentException(String.format("Directory to find chaincode META-INF %s does not exist", chaincodemetainflocation.getAbsolutePath()));
            }
            if (!chaincodemetainflocation.isDirectory()) {
                throw new IllegalArgumentException(String.format("Directory to find chaincode META-INF %s is not a directory", chaincodemetainflocation.getAbsolutePath()));
            }
            metainf = new File(chaincodemetainflocation, "META-INF");
            logger.trace((Object)("META-INF directory is " + metainf.getAbsolutePath()));
            if (!metainf.exists()) {
                throw new IllegalArgumentException(String.format("The META-INF directory does not exist in %s", chaincodemetainflocation.getAbsolutePath()));
            }
            if (!metainf.isDirectory()) {
                throw new IllegalArgumentException(String.format("The META-INF in %s is not a directory.", chaincodemetainflocation.getAbsolutePath()));
            }
            File[] files = metainf.listFiles();
            if (files == null) {
                throw new IllegalArgumentException("null for listFiles on: " + chaincodemetainflocation.getAbsolutePath());
            }
            if (files.length < 1) {
                throw new IllegalArgumentException(String.format("The META-INF directory %s is empty.", metainf.getAbsolutePath()));
            }
            logger.trace((Object)String.format("chaincode META-INF found %s", metainf.getAbsolutePath()));
        }
        switch (chaincodeLanguage) {
            case GO_LANG: {
                if (Utils.isNullOrEmpty(chaincodePath)) {
                    throw new IllegalArgumentException("Missing chaincodePath in InstallRequest");
                }
                dplang = "Go";
                Chaincode.ChaincodeSpec.Type ccType = Chaincode.ChaincodeSpec.Type.GOLANG;
                projectSourceDir = Paths.get(chaincodeSource.toString(), "src", chaincodePath).toFile();
                targetPathPrefix = Paths.get("src", chaincodePath).toString();
                break;
            }
            case JAVA: {
                if (!Utils.isNullOrEmpty(chaincodePath)) {
                    throw new IllegalArgumentException("chaincodePath must be null for Java chaincode");
                }
                dplang = "Java";
                Chaincode.ChaincodeSpec.Type ccType = Chaincode.ChaincodeSpec.Type.JAVA;
                targetPathPrefix = "src";
                projectSourceDir = Paths.get(chaincodeSource.toString(), new String[0]).toFile();
                break;
            }
            case NODE: {
                if (!Utils.isNullOrEmpty(chaincodePath)) {
                    throw new IllegalArgumentException("chaincodePath must be null for Node chaincode");
                }
                dplang = "Node";
                Chaincode.ChaincodeSpec.Type ccType = Chaincode.ChaincodeSpec.Type.NODE;
                projectSourceDir = Paths.get(chaincodeSource.toString(), new String[0]).toFile();
                targetPathPrefix = "src";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected chaincode language: " + (Object)((Object)chaincodeLanguage));
            }
        }
        byte[] data = null;
        if (!projectSourceDir.exists()) {
            message = "The project source directory does not exist: " + projectSourceDir.getAbsolutePath();
            logger.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        if (!projectSourceDir.isDirectory()) {
            message = "The project source directory is not a directory: " + projectSourceDir.getAbsolutePath();
            logger.error((Object)message);
            throw new IllegalArgumentException(message);
        }
        logger.debug((Object)String.format("Creating chaincode package language %s chaincode from directory: '%s' with source location: '%s'. chaincodePath:'%s'", dplang, projectSourceDir.getAbsolutePath(), targetPathPrefix, chaincodePath));
        data = Utils.generateTarGz(projectSourceDir, targetPathPrefix, metainf);
        if (null != diagnosticFileDumper) {
            logger.trace((Object)String.format("Creatating chaincode package language %s chaincode from directory: '%s' with source location: '%s'. chaincodePath:'%s' tar file dump %s", dplang, projectSourceDir.getAbsolutePath(), targetPathPrefix, chaincodePath, diagnosticFileDumper.createDiagnosticTarFile(data)));
        }
        return data;
    }

    static byte[] generatePackageMataDataBytes(String label, String path, TransactionRequest.Type type) {
        if (path == null) {
            path = "";
        }
        return String.format("{\"path\":%s,\"type\":\"%s\",\"label\":%s}", new Gson().toJson((Object)path), type.toPackageName(), new Gson().toJson((Object)label)).getBytes(StandardCharsets.UTF_8);
    }

    /*
     * Exception decompiling
     */
    public JsonObject getMetaInfJson() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public byte[] getChaincodePayloadBytes() throws IOException {
        try (TarArchiveInputStream tarInput = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new ByteArrayInputStream(this.pBytes)));){
            TarArchiveEntry currentEntry = tarInput.getNextTarEntry();
            while (currentEntry != null) {
                if (!currentEntry.getName().equals("metadata.json")) {
                    byte[] buf = new byte[(int)currentEntry.getSize()];
                    tarInput.read(buf, 0, (int)currentEntry.getSize());
                    byte[] byArray = buf;
                    return byArray;
                }
                currentEntry = tarInput.getNextTarEntry();
            }
        }
        return null;
    }

    public TransactionRequest.Type getType() throws IOException {
        JsonObject metaInfJson = this.getMetaInfJson();
        if (null != metaInfJson) {
            String type;
            String string = type = metaInfJson.containsKey((Object)"type") ? metaInfJson.getString("type") : null;
            if (null != type) {
                return TransactionRequest.Type.fromPackageName(type);
            }
        }
        return null;
    }

    public String getLabel() throws IOException {
        JsonObject metaInfJson = this.getMetaInfJson();
        if (null != metaInfJson) {
            String label;
            String string = label = metaInfJson.containsKey((Object)"label") ? metaInfJson.getString("label") : null;
            if (null != label) {
                return label;
            }
        }
        return null;
    }

    public String getPath() throws IOException {
        JsonObject metaInfJson = this.getMetaInfJson();
        if (null != metaInfJson) {
            return metaInfJson.containsKey((Object)"path") ? metaInfJson.getString("path") : null;
        }
        return null;
    }
}

