/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.protos.peer.lifecycle.Lifecycle;
import org.hyperledger.fabric.sdk.ChaincodeResponse;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

public final class LifecycleCheckCommitReadinessProposalResponse
extends ProposalResponse {
    private Lifecycle.CheckCommitReadinessResult checkCommitReadinessResult;

    LifecycleCheckCommitReadinessProposalResponse(TransactionContext transactionContext, int status, String message) {
        super(transactionContext, status, message);
    }

    public Lifecycle.CheckCommitReadinessResult getApprovalStatusResults() throws ProposalException {
        if (null == this.checkCommitReadinessResult) {
            if (this.getStatus() != ChaincodeResponse.Status.SUCCESS) {
                throw new ProposalException(String.format("Fabric response failed on peer %s  %s", this.getPeer(), this.getMessage()));
            }
            ProposalResponsePackage.ProposalResponse fabricResponse = this.getProposalResponse();
            if (null == fabricResponse) {
                throw new ProposalException(String.format("Proposal has no Fabric response. %s", this.getPeer()));
            }
            ByteString payload = fabricResponse.getResponse().getPayload();
            if (payload == null) {
                throw new ProposalException(String.format("Fabric response has no payload  %s", this.getPeer()));
            }
            try {
                this.checkCommitReadinessResult = Lifecycle.CheckCommitReadinessResult.parseFrom(payload);
            }
            catch (Exception e) {
                throw new ProposalException(String.format("Failure on peer %s %s", this.getPeer(), e.getMessage()), e);
            }
        }
        return this.checkCommitReadinessResult;
    }

    public Set<String> getApprovedOrgs() throws ProposalException {
        return this.getApprovalsMap().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<String> getUnApprovedOrgs() throws ProposalException {
        return this.getApprovalsMap().entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Map<String, Boolean> getApprovalsMap() throws ProposalException {
        Lifecycle.CheckCommitReadinessResult approvalStatusResults = this.getApprovalStatusResults();
        return approvalStatusResults == null ? Collections.emptyMap() : approvalStatusResults.getApprovalsMap();
    }
}

