/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import org.hyperledger.fabric.protos.peer.Collection;
import org.hyperledger.fabric.sdk.ChaincodeCollectionConfiguration;
import org.hyperledger.fabric.sdk.LifecycleChaincodeEndorsementPolicy;
import org.hyperledger.fabric.sdk.LifecycleRequest;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.Utils;

public class LifecycleCheckCommitReadinessRequest
extends LifecycleRequest {
    private static final Config config = Config.getConfig();
    private static final Boolean lifecycleInitRequiredDefault = config.getLifecycleInitRequiredDefault();
    private long sequence;
    private String chaincodeName;
    private String chaincodeVersion;
    private String chaincodeEndorsementPlugin;
    private String chaincodeValidationPlugin;
    private Collection.CollectionConfigPackage collectionConfigPackage;
    private Boolean initRequired;
    private ByteString validationParameter;

    LifecycleCheckCommitReadinessRequest(User userContext) {
        super(userContext);
        if (!Utils.isNullOrEmpty(config.getDefaultChaincodeEndorsementPlugin())) {
            this.chaincodeEndorsementPlugin = config.getDefaultChaincodeEndorsementPlugin();
        }
        if (!Utils.isNullOrEmpty(config.getDefaultChaincodeValidationPlugin())) {
            this.chaincodeValidationPlugin = config.getDefaultChaincodeValidationPlugin();
        }
        this.initRequired = lifecycleInitRequiredDefault;
    }

    ByteString getValidationParameter() {
        return this.validationParameter;
    }

    public void setValidationParameter(byte[] validationParameter) throws InvalidArgumentException {
        if (null == validationParameter) {
            throw new InvalidArgumentException("The parameter validationParameter may not be null.");
        }
        this.validationParameter = ByteString.copyFrom((byte[])validationParameter);
    }

    long getSequence() {
        return this.sequence;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    String getChaincodeName() {
        return this.chaincodeName;
    }

    public void setChaincodeName(String chaincodeName) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(chaincodeName)) {
            throw new InvalidArgumentException("The name parameter can not be null or empty.");
        }
        this.chaincodeName = chaincodeName;
    }

    String getChaincodeVersion() {
        return this.chaincodeVersion;
    }

    public void setChaincodeVersion(String chaincodeVersion) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(chaincodeVersion)) {
            throw new InvalidArgumentException("The version parameter can not be null or empty.");
        }
        this.chaincodeVersion = chaincodeVersion;
    }

    String getChaincodeEndorsementPlugin() {
        return this.chaincodeEndorsementPlugin;
    }

    public void setChaincodeEndorsementPlugin(String chaincodeEndorsementPlugin) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(chaincodeEndorsementPlugin)) {
            throw new InvalidArgumentException("The chaincodeEndorsementPlugin parameter can not be null or empty.");
        }
        this.chaincodeEndorsementPlugin = chaincodeEndorsementPlugin;
    }

    String getChaincodeValidationPlugin() {
        return this.chaincodeValidationPlugin;
    }

    public void setChaincodeValidationPlugin(String chaincodeValidationPlugin) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(chaincodeValidationPlugin)) {
            throw new InvalidArgumentException("The chaincodeValidationPlugin parameter can not be null or empty.");
        }
        this.chaincodeValidationPlugin = chaincodeValidationPlugin;
    }

    public void setChaincodeEndorsementPolicy(LifecycleChaincodeEndorsementPolicy lifecycleChaincodeEndorsementPolicy) throws InvalidArgumentException {
        if (null == lifecycleChaincodeEndorsementPolicy) {
            throw new InvalidArgumentException("The parameter lifecycleChaincodeEndorsementPolicy may not be null.");
        }
        this.validationParameter = lifecycleChaincodeEndorsementPolicy.getByteString();
    }

    Collection.CollectionConfigPackage getCollectionConfigPackage() {
        return this.collectionConfigPackage;
    }

    Boolean isInitRequired() {
        return this.initRequired;
    }

    public void setInitRequired(boolean initRequired) {
        this.initRequired = initRequired;
    }

    public void setChaincodeCollectionConfiguration(ChaincodeCollectionConfiguration collectionConfigPackage) throws InvalidArgumentException {
        if (null == collectionConfigPackage) {
            throw new InvalidArgumentException("The parameter collectionConfigPackage may not be null.");
        }
        this.collectionConfigPackage = collectionConfigPackage.getCollectionConfigPackage();
    }
}

