/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import org.hyperledger.fabric.sdk.ChaincodeCollectionConfiguration;
import org.hyperledger.fabric.sdk.LifecycleChaincodeEndorsementPolicy;
import org.hyperledger.fabric.sdk.LifecycleRequest;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.Utils;

public class LifecycleCommitChaincodeDefinitionRequest
extends LifecycleRequest {
    private static final Config config = Config.getConfig();
    protected String chaincodeName;
    protected String chaincodeVersion;
    private long sequence;
    private ChaincodeCollectionConfiguration chaincodeCollectionConfiguration;
    private String chaincodeEndorsementPlugin = null;
    private Boolean initRequired = null;
    private ByteString validationParameter = null;
    private String chaincodeValidationPlugin;

    LifecycleCommitChaincodeDefinitionRequest(User userContext) {
        super(userContext);
    }

    Boolean isInitRequired() {
        return this.initRequired;
    }

    public void setInitRequired(boolean initRequired) {
        this.initRequired = initRequired;
    }

    String getChaincodeName() {
        return this.chaincodeName;
    }

    public void setChaincodeName(String chaincodeName) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(chaincodeName)) {
            throw new InvalidArgumentException("The chaincodeName parameter can not be null or empty.");
        }
        this.chaincodeName = chaincodeName;
    }

    String getChaincodeVersion() {
        return this.chaincodeVersion;
    }

    public void setChaincodeVersion(String chaincodeVersion) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(chaincodeVersion)) {
            throw new InvalidArgumentException("The chaincodeVersion parameter can not be null or empty.");
        }
        this.chaincodeVersion = chaincodeVersion;
    }

    long getSequence() {
        return this.sequence;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    ChaincodeCollectionConfiguration getChaincodeCollectionConfiguration() {
        return this.chaincodeCollectionConfiguration;
    }

    public void setChaincodeCollectionConfiguration(ChaincodeCollectionConfiguration chaincodeCollectionConfiguration) throws InvalidArgumentException {
        if (null == chaincodeCollectionConfiguration) {
            throw new InvalidArgumentException(" The parameter chaincodeCollectionConfiguration may not be null.");
        }
        this.chaincodeCollectionConfiguration = chaincodeCollectionConfiguration;
    }

    public void setChaincodeEndorsementPolicy(LifecycleChaincodeEndorsementPolicy chaincodeEndorsementPolicy) throws InvalidArgumentException {
        if (null == chaincodeEndorsementPolicy) {
            throw new InvalidArgumentException(" The parameter chaincodeEndorsementPolicy may not be null.");
        }
        this.validationParameter = chaincodeEndorsementPolicy.getByteString();
    }

    String getChaincodeEndorsementPlugin() {
        return this.chaincodeEndorsementPlugin;
    }

    public void setChaincodeEndorsementPlugin(String chaincodeEndorsementPlugin) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(chaincodeEndorsementPlugin)) {
            throw new InvalidArgumentException("The chaincodeEndorsementPlugin parameter can not be null or empty.");
        }
        this.chaincodeEndorsementPlugin = chaincodeEndorsementPlugin;
    }

    String getChaincodeValidationPlugin() {
        return this.chaincodeValidationPlugin;
    }

    public void setChaincodeValidationPlugin(String chaincodeValidationPlugin) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(chaincodeValidationPlugin)) {
            throw new InvalidArgumentException("The chaincodeValidationPlugin parameter can not be null or empty.");
        }
        this.chaincodeValidationPlugin = chaincodeValidationPlugin;
    }

    ByteString getValidationParameter() {
        return this.validationParameter;
    }

    public void setValidationParameter(byte[] validationParameter) throws InvalidArgumentException {
        if (null == validationParameter) {
            throw new InvalidArgumentException(" The parameter validationParameter may not be null.");
        }
        this.validationParameter = ByteString.copyFrom((byte[])validationParameter);
    }
}

