/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.hyperledger.fabric.protos.peer.lifecycle.Lifecycle;
import org.hyperledger.fabric.sdk.ChaincodeResponse;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

public class LifecycleInstallChaincodeProposalResponse
extends ProposalResponse {
    LifecycleInstallChaincodeProposalResponse(TransactionContext transactionContext, int status, String message) {
        super(transactionContext, status, message);
    }

    public String getPackageId() throws ProposalException {
        if (ChaincodeResponse.Status.SUCCESS != this.getStatus()) {
            throw new ProposalException(String.format("Status of install proposal did not ret ok for %s, %s ", new Object[]{this.getPeer(), this.getStatus()}));
        }
        ByteString payload = this.getProposalResponse().getResponse().getPayload();
        Lifecycle.InstallChaincodeResult installChaincodeResult = null;
        try {
            installChaincodeResult = Lifecycle.InstallChaincodeResult.parseFrom(payload);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ProposalException(String.format("Bad protobuf received for install proposal %s", this.getPeer()));
        }
        return installChaincodeResult.getPackageId();
    }
}

