/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import org.hyperledger.fabric.protos.peer.Collection;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.protos.peer.lifecycle.Lifecycle;
import org.hyperledger.fabric.sdk.ChaincodeCollectionConfiguration;
import org.hyperledger.fabric.sdk.ChaincodeResponse;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

public class LifecycleQueryChaincodeDefinitionProposalResponse
extends ProposalResponse {
    private Lifecycle.QueryChaincodeDefinitionResult queryChaincodeDefinitionResult = null;

    LifecycleQueryChaincodeDefinitionProposalResponse(TransactionContext transactionContext, int status, String message) {
        super(transactionContext, status, message);
    }

    private Lifecycle.QueryChaincodeDefinitionResult parsePayload() throws ProposalException {
        if (null == this.queryChaincodeDefinitionResult) {
            if (this.getStatus() != ChaincodeResponse.Status.SUCCESS) {
                throw new ProposalException(String.format("Fabric response failed on peer %s  %s", this.getPeer(), this.getMessage()));
            }
            ProposalResponsePackage.ProposalResponse fabricResponse = this.getProposalResponse();
            if (null == fabricResponse) {
                throw new ProposalException("Proposal has no Fabric response.");
            }
            ByteString payload = fabricResponse.getPayload();
            if (payload == null) {
                throw new ProposalException("Fabric response has no payload");
            }
            try {
                byte[] chaincodeActionResponsePayload = this.getChaincodeActionResponsePayload();
                if (null == chaincodeActionResponsePayload) {
                    throw new ProposalException("Fabric chaincode action response payload is null.");
                }
                this.queryChaincodeDefinitionResult = Lifecycle.QueryChaincodeDefinitionResult.parseFrom(this.getChaincodeActionResponsePayload());
            }
            catch (Exception e) {
                throw new ProposalException(String.format("Failure on peer %s %s", this.getPeer(), e.getMessage()), e);
            }
        }
        return this.queryChaincodeDefinitionResult;
    }

    public byte[] getValidationParameter() throws ProposalException {
        ByteString payloadBytes = this.parsePayload().getValidationParameter();
        if (null == payloadBytes) {
            return null;
        }
        return payloadBytes.toByteArray();
    }

    public String getVersion() throws ProposalException {
        return this.parsePayload().getVersion();
    }

    public boolean getInitRequired() throws ProposalException {
        return this.parsePayload().getInitRequired();
    }

    public long getSequence() throws ProposalException {
        return this.parsePayload().getSequence();
    }

    public ChaincodeCollectionConfiguration getChaincodeCollectionConfiguration() throws ProposalException {
        Collection.CollectionConfigPackage collections = this.parsePayload().getCollections();
        if (null == collections || !this.parsePayload().hasCollections()) {
            return null;
        }
        try {
            return ChaincodeCollectionConfiguration.fromCollectionConfigPackage(collections);
        }
        catch (InvalidArgumentException e) {
            throw new ProposalException(e);
        }
    }

    public String getEndorsementPlugin() throws ProposalException {
        return this.parsePayload().getEndorsementPlugin();
    }

    public String getValidationPlugin() throws ProposalException {
        return this.parsePayload().getValidationPlugin();
    }
}

