/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.protos.peer.lifecycle.Lifecycle;
import org.hyperledger.fabric.sdk.ChaincodeResponse;
import org.hyperledger.fabric.sdk.LifecycleQueryChaincodeDefinitionsResult;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

public final class LifecycleQueryChaincodeDefinitionsProposalResponse
extends ProposalResponse {
    private Lifecycle.QueryChaincodeDefinitionsResult queryChaincodeDefinitionsResult;

    LifecycleQueryChaincodeDefinitionsProposalResponse(TransactionContext transactionContext, int status, String message) {
        super(transactionContext, status, message);
    }

    private Lifecycle.QueryChaincodeDefinitionsResult getPayload() throws ProposalException {
        if (null == this.queryChaincodeDefinitionsResult) {
            if (this.getStatus() != ChaincodeResponse.Status.SUCCESS) {
                throw new ProposalException(String.format("Fabric response failed on peer %s  %s", this.getPeer(), this.getMessage()));
            }
            ProposalResponsePackage.ProposalResponse fabricResponse = this.getProposalResponse();
            if (null == fabricResponse) {
                throw new ProposalException(String.format("Proposal has no Fabric response. %s", this.getPeer()));
            }
            ByteString responsePayload = fabricResponse.getResponse().getPayload();
            if (responsePayload == null) {
                throw new ProposalException(String.format("Fabric response has no payload  %s", this.getPeer()));
            }
            try {
                this.queryChaincodeDefinitionsResult = Lifecycle.QueryChaincodeDefinitionsResult.parseFrom(responsePayload);
            }
            catch (Exception e) {
                throw new ProposalException(String.format("Failure on peer %s %s", this.getPeer(), e.getMessage()), e);
            }
        }
        return this.queryChaincodeDefinitionsResult;
    }

    public Collection<LifecycleQueryChaincodeDefinitionsResult> getLifecycleQueryChaincodeDefinitionsResult() throws ProposalException {
        Lifecycle.QueryChaincodeDefinitionsResult payload = this.getPayload();
        if (payload == null) {
            return Collections.emptyList();
        }
        List<Lifecycle.QueryChaincodeDefinitionsResult.ChaincodeDefinition> chaincodeDefinitions = payload.getChaincodeDefinitionsList();
        if (chaincodeDefinitions == null) {
            return Collections.emptyList();
        }
        return chaincodeDefinitions.stream().map(LifecycleQueryChaincodeDefinitionsResult::new).collect(Collectors.toList());
    }
}

