/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import org.hyperledger.fabric.protos.peer.Collection;
import org.hyperledger.fabric.protos.peer.lifecycle.Lifecycle;
import org.hyperledger.fabric.sdk.ChaincodeCollectionConfiguration;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.ProposalException;

public final class LifecycleQueryChaincodeDefinitionsResult {
    private final Lifecycle.QueryChaincodeDefinitionsResult.ChaincodeDefinition chaincodeDefinition;

    LifecycleQueryChaincodeDefinitionsResult(Lifecycle.QueryChaincodeDefinitionsResult.ChaincodeDefinition chaincodeDefinition) {
        this.chaincodeDefinition = chaincodeDefinition;
    }

    public String getName() {
        return this.chaincodeDefinition.getName();
    }

    public long getSequence() {
        return this.chaincodeDefinition.getSequence();
    }

    public String getVersion() {
        return this.chaincodeDefinition.getVersion();
    }

    public String getEndorsementPlugin() {
        return this.chaincodeDefinition.getEndorsementPlugin();
    }

    public String getValidationPlugin() {
        return this.chaincodeDefinition.getValidationPlugin();
    }

    public byte[] getValidationParameter() {
        ByteString payloadBytes = this.chaincodeDefinition.getValidationParameter();
        return payloadBytes == null ? null : payloadBytes.toByteArray();
    }

    public ChaincodeCollectionConfiguration getChaincodeCollectionConfiguration() throws ProposalException {
        Collection.CollectionConfigPackage collections = this.chaincodeDefinition.getCollections();
        try {
            return collections == null ? null : ChaincodeCollectionConfiguration.fromCollectionConfigPackage(collections);
        }
        catch (InvalidArgumentException e) {
            throw new ProposalException(e);
        }
    }

    public boolean getInitRequired() {
        return this.chaincodeDefinition.getInitRequired();
    }
}

