/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.protos.peer.lifecycle.Lifecycle;
import org.hyperledger.fabric.sdk.ChaincodeResponse;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

public class LifecycleQueryInstalledChaincodeProposalResponse
extends ProposalResponse {
    Lifecycle.QueryInstalledChaincodeResult queryChaincodeDefinitionResult;

    LifecycleQueryInstalledChaincodeProposalResponse(TransactionContext transactionContext, int status, String message) {
        super(transactionContext, status, message);
    }

    private Lifecycle.QueryInstalledChaincodeResult parsePayload() throws ProposalException {
        if (null == this.queryChaincodeDefinitionResult) {
            if (this.getStatus() != ChaincodeResponse.Status.SUCCESS) {
                throw new ProposalException(String.format("Fabric response failed on peer %s  %s", this.getPeer(), this.getMessage()));
            }
            ProposalResponsePackage.ProposalResponse fabricResponse = this.getProposalResponse();
            if (null == fabricResponse) {
                throw new ProposalException(String.format("Proposal has no Fabric response. %s", this.getPeer()));
            }
            ByteString payload = fabricResponse.getResponse().getPayload();
            if (payload == null) {
                throw new ProposalException(String.format("Fabric response has no payload  %s", this.getPeer()));
            }
            try {
                this.queryChaincodeDefinitionResult = Lifecycle.QueryInstalledChaincodeResult.parseFrom(payload);
            }
            catch (Exception e) {
                throw new ProposalException(String.format("Failure on peer %s %s", this.getPeer(), e.getMessage()), e);
            }
        }
        return this.queryChaincodeDefinitionResult;
    }

    public String getPackageId() throws ProposalException {
        Lifecycle.QueryInstalledChaincodeResult queryInstalledChaincodeResult = this.parsePayload();
        if (queryInstalledChaincodeResult == null) {
            return null;
        }
        return queryInstalledChaincodeResult.getPackageId();
    }

    public String getLabel() throws ProposalException {
        Lifecycle.QueryInstalledChaincodeResult queryInstalledChaincodeResult = this.parsePayload();
        if (queryInstalledChaincodeResult == null) {
            return null;
        }
        return queryInstalledChaincodeResult.getLabel();
    }
}

