/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collection;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.protos.peer.lifecycle.Lifecycle;
import org.hyperledger.fabric.sdk.ChaincodeResponse;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

public class LifecycleQueryInstalledChaincodesProposalResponse
extends ProposalResponse {
    Lifecycle.QueryInstalledChaincodesResult queryChaincodeDefinitionResult;

    LifecycleQueryInstalledChaincodesProposalResponse(TransactionContext transactionContext, int status, String message) {
        super(transactionContext, status, message);
    }

    private Lifecycle.QueryInstalledChaincodesResult parsePayload() throws ProposalException {
        if (null == this.queryChaincodeDefinitionResult) {
            if (this.getStatus() != ChaincodeResponse.Status.SUCCESS) {
                throw new ProposalException(String.format("Fabric response failed on peer %s  %s", this.getPeer(), this.getMessage()));
            }
            ProposalResponsePackage.ProposalResponse fabricResponse = this.getProposalResponse();
            if (null == fabricResponse) {
                throw new ProposalException(String.format("Proposal has no Fabric response. %s", this.getPeer()));
            }
            ByteString payload = fabricResponse.getResponse().getPayload();
            if (payload == null) {
                throw new ProposalException(String.format("Fabric response has no payload  %s", this.getPeer()));
            }
            try {
                this.queryChaincodeDefinitionResult = Lifecycle.QueryInstalledChaincodesResult.parseFrom(payload);
            }
            catch (Exception e) {
                throw new ProposalException(String.format("Failure on peer %s %s", this.getPeer(), e.getMessage()), e);
            }
        }
        return this.queryChaincodeDefinitionResult;
    }

    public Collection<LifecycleQueryInstalledChaincodesResult> getLifecycleQueryInstalledChaincodesResult() throws ProposalException {
        Lifecycle.QueryInstalledChaincodesResult queryInstalledChaincodesResult = this.parsePayload();
        ArrayList<LifecycleQueryInstalledChaincodesResult> ret = new ArrayList<LifecycleQueryInstalledChaincodesResult>(queryInstalledChaincodesResult.getInstalledChaincodesCount());
        for (Lifecycle.QueryInstalledChaincodesResult.InstalledChaincode qr : queryInstalledChaincodesResult.getInstalledChaincodesList()) {
            ret.add(new LifecycleQueryInstalledChaincodesResult(qr));
        }
        return ret;
    }

    public class LifecycleQueryInstalledChaincodesResult {
        private final Lifecycle.QueryInstalledChaincodesResult.InstalledChaincode installedChaincode;

        LifecycleQueryInstalledChaincodesResult(Lifecycle.QueryInstalledChaincodesResult.InstalledChaincode installedChaincode) {
            this.installedChaincode = installedChaincode;
        }

        public String getLabel() {
            return this.installedChaincode.getLabel();
        }

        public String getPackageId() {
            return this.installedChaincode.getPackageId();
        }
    }
}

