/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.Enrollment;
import org.hyperledger.fabric.sdk.HFClient;
import org.hyperledger.fabric.sdk.Orderer;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.NetworkConfigurationException;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.identity.X509Enrollment;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class NetworkConfig {
    private static final String URL_PROP_NAME = "url";
    private final JsonObject jsonConfig;
    private final OrgInfo clientOrganization;
    private Map<String, Node> orderers;
    private Map<String, Node> peers;
    private Map<String, OrgInfo> organizations;
    private static final Log logger = LogFactory.getLog(NetworkConfig.class);
    private static final NetworkConfigAddPeerHandler networkConfigAddPeerHandlerDefault = (networkConfig, client, channel, peerName, peerURL, peerProperties, peerOptions, jsonPeer) -> {
        try {
            Peer peer = client.newPeer(peerName, peerURL, peerProperties);
            channel.addPeer(peer, peerOptions);
        }
        catch (Exception e) {
            throw new NetworkConfigurationException(String.format("Error on creating channel %s peer %s", channel.getName(), peerName), e);
        }
    };
    private static final NetworkConfigAddOrdererHandler networkConfigAddOrdererHandlerDefault = (networkConfig, client, channel, ordererName, ordererURL, ordererProperties, jsonOrderer) -> {
        try {
            Orderer orderer = client.newOrderer(ordererName, ordererURL, ordererProperties);
            channel.addOrderer(orderer);
        }
        catch (Exception e) {
            throw new NetworkConfigurationException(String.format("Error on creating channel %s orderer %s", channel.getName(), ordererName), e);
        }
    };
    private static final Map<Peer.PeerRole, String> roleNameRemapHash = new HashMap<Peer.PeerRole, String>();

    public Collection<String> getPeerNames() {
        if (this.peers == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(this.peers.keySet());
    }

    public Collection<String> getOrdererNames() {
        if (this.orderers == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(this.orderers.keySet());
    }

    private Properties getNodeProperties(String type, String name, Map<String, Node> nodes) {
        if (Utils.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("Parameter name is null or empty.");
        }
        Node node = nodes.get(name);
        if (node == null) {
            throw new IllegalArgumentException(String.format("%s %s not found.", type, name));
        }
        if (null == node.properties) {
            return new Properties();
        }
        return (Properties)node.properties.clone();
    }

    private void setNodeProperties(String type, String name, Map<String, Node> nodes, Properties properties) {
        if (Utils.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("Parameter name is null or empty.");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Parameter properties is null.");
        }
        Node node = nodes.get(name);
        if (node == null) {
            throw new IllegalArgumentException(String.format("%S %s not found.", type, name));
        }
        Properties ourCopyProps = new Properties();
        ourCopyProps.putAll((Map<?, ?>)properties);
        node.properties = ourCopyProps;
    }

    public Properties getPeerProperties(String name) {
        return this.getNodeProperties("Peer", name, this.peers);
    }

    public Properties getOrdererProperties(String name) {
        return this.getNodeProperties("Orderer", name, this.orderers);
    }

    public void setPeerProperties(String name, Properties properties) {
        this.setNodeProperties("Peer", name, this.peers, properties);
    }

    public void setOrdererProperties(String name, Properties properties) {
        this.setNodeProperties("Orderer", name, this.orderers, properties);
    }

    private String getNodeUrl(String type, String name, Map<String, Node> nodes) {
        if (Utils.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("Parameter name is null or empty.");
        }
        Node node = nodes.get(name);
        if (node == null) {
            throw new IllegalStateException(String.format("%s %s not found.", type, name));
        }
        return node.getUrl();
    }

    public String getPeerUrl(String name) {
        return this.getNodeUrl("Peer", name, this.peers);
    }

    private NetworkConfig(JsonObject jsonConfig) throws NetworkConfigurationException {
        String orgName;
        this.jsonConfig = jsonConfig;
        String configName = NetworkConfig.getJsonValueAsString((JsonValue)jsonConfig.get((Object)"name"));
        if (configName == null || configName.isEmpty()) {
            throw new NetworkConfigurationException("Network config must have a name");
        }
        String configVersion = NetworkConfig.getJsonValueAsString((JsonValue)jsonConfig.get((Object)"version"));
        if (configVersion == null || configVersion.isEmpty()) {
            throw new NetworkConfigurationException("Network config must have a version");
        }
        this.createAllPeers();
        this.createAllOrderers();
        Map<String, JsonObject> foundCertificateAuthorities = this.findCertificateAuthorities();
        this.createAllOrganizations(foundCertificateAuthorities);
        JsonObject jsonClient = NetworkConfig.getJsonObject(jsonConfig, "client");
        String string = orgName = jsonClient == null ? null : NetworkConfig.getJsonValueAsString((JsonValue)jsonClient.get((Object)"organization"));
        if (orgName == null || orgName.isEmpty()) {
            throw new NetworkConfigurationException("A client organization must be specified");
        }
        this.clientOrganization = this.getOrganizationInfo(orgName);
        if (this.clientOrganization == null) {
            throw new NetworkConfigurationException("Client organization " + orgName + " is not defined");
        }
    }

    public static NetworkConfig fromYamlFile(File configFile) throws IOException, NetworkConfigurationException {
        return NetworkConfig.fromFile(configFile, false);
    }

    public static NetworkConfig fromJsonFile(File configFile) throws IOException, NetworkConfigurationException {
        return NetworkConfig.fromFile(configFile, true);
    }

    public static NetworkConfig fromYamlStream(InputStream configStream) throws NetworkConfigurationException {
        logger.trace((Object)"NetworkConfig.fromYamlStream...");
        if (configStream == null) {
            throw new IllegalArgumentException("configStream must be specified");
        }
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        Map map = (Map)yaml.load(configStream);
        JsonObjectBuilder builder = Json.createObjectBuilder((Map)map);
        JsonObject jsonConfig = builder.build();
        return NetworkConfig.fromJsonObject(jsonConfig);
    }

    public static NetworkConfig fromJsonStream(InputStream configStream) throws NetworkConfigurationException {
        logger.trace((Object)"NetworkConfig.fromJsonStream...");
        if (configStream == null) {
            throw new IllegalArgumentException("configStream must be specified");
        }
        try (JsonReader reader = Json.createReader((InputStream)configStream);){
            JsonObject jsonConfig = (JsonObject)reader.read();
            NetworkConfig networkConfig = NetworkConfig.fromJsonObject(jsonConfig);
            return networkConfig;
        }
    }

    public static NetworkConfig fromJsonObject(JsonObject jsonConfig) throws NetworkConfigurationException {
        if (jsonConfig == null) {
            throw new IllegalArgumentException("jsonConfig must be specified");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("NetworkConfig.fromJsonObject: %s", jsonConfig.toString()));
        }
        return NetworkConfig.load(jsonConfig);
    }

    private static NetworkConfig fromFile(File configFile, boolean isJson) throws IOException, NetworkConfigurationException {
        if (configFile == null) {
            throw new IllegalArgumentException("configFile must be specified");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("NetworkConfig.fromFile: %s  isJson = %b", configFile.getAbsolutePath(), isJson));
        }
        try (FileInputStream stream = new FileInputStream(configFile);){
            NetworkConfig networkConfig = isJson ? NetworkConfig.fromJsonStream(stream) : NetworkConfig.fromYamlStream(stream);
            return networkConfig;
        }
    }

    private static NetworkConfig load(JsonObject jsonConfig) throws NetworkConfigurationException {
        if (jsonConfig == null) {
            throw new IllegalArgumentException("config must be specified");
        }
        return new NetworkConfig(jsonConfig);
    }

    public OrgInfo getClientOrganization() {
        return this.clientOrganization;
    }

    public OrgInfo getOrganizationInfo(String orgName) {
        return this.organizations.get(orgName);
    }

    public Map<String, OrgInfo> getPeerOrgInfos(String peerName) {
        if (Utils.isNullOrEmpty(peerName)) {
            throw new IllegalArgumentException("peerName can not be null or empty.");
        }
        if (this.organizations == null || this.organizations.isEmpty()) {
            return new HashMap<String, OrgInfo>();
        }
        HashMap<String, OrgInfo> ret = new HashMap<String, OrgInfo>(16);
        this.organizations.forEach((name, orgInfo) -> {
            if (orgInfo.getPeerNames().contains(peerName)) {
                ret.put((String)name, (OrgInfo)orgInfo);
            }
        });
        return ret;
    }

    public UserInfo getPeerAdmin() throws NetworkConfigurationException {
        return this.getPeerAdmin(this.clientOrganization.getName());
    }

    public UserInfo getPeerAdmin(String orgName) throws NetworkConfigurationException {
        OrgInfo org = this.getOrganizationInfo(orgName);
        if (org == null) {
            throw new NetworkConfigurationException(String.format("Organization %s is not defined", orgName));
        }
        return org.getPeerAdmin();
    }

    Channel loadChannel(HFClient client, String channelName) throws NetworkConfigurationException, InvalidArgumentException {
        return this.loadChannel(client, channelName, networkConfigAddPeerHandlerDefault, networkConfigAddOrdererHandlerDefault);
    }

    Channel loadChannel(HFClient client, String channelName, NetworkConfigAddPeerHandler networkConfigAddPeerHandler, NetworkConfigAddOrdererHandler networkConfigAddOrdererHandler) throws NetworkConfigurationException, InvalidArgumentException {
        JsonObject channels;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("NetworkConfig.loadChannel: %s", channelName));
        }
        if (null == (channels = NetworkConfig.getJsonObject(this.jsonConfig, "channels"))) {
            throw new NetworkConfigurationException("Channel configuration has no channels defined.");
        }
        JsonObject jsonChannel = NetworkConfig.getJsonObject(channels, channelName);
        if (null == jsonChannel) {
            Set<String> channelNames = this.getChannelNames();
            if (channelNames.isEmpty()) {
                throw new NetworkConfigurationException("Channel configuration has no channels defined.");
            }
            throw new NetworkConfigurationException(String.format("Channel %s not found in configuration file. Found channel names: %s ", channelName, String.join((CharSequence)", ", channelNames)));
        }
        Channel channel = client.getChannel(channelName);
        if (channel != null) {
            throw new NetworkConfigurationException(String.format("Channel %s is already configured in the client!", channelName));
        }
        return this.reconstructChannel(client, channelName, jsonChannel, networkConfigAddPeerHandler, networkConfigAddOrdererHandler);
    }

    private void createAllOrderers() throws NetworkConfigurationException {
        if (this.orderers != null) {
            throw new NetworkConfigurationException("INTERNAL ERROR: orderers have already been initialized!");
        }
        this.orderers = new HashMap<String, Node>();
        JsonObject jsonOrderers = NetworkConfig.getJsonObject(this.jsonConfig, "orderers");
        if (jsonOrderers != null) {
            for (Map.Entry entry : jsonOrderers.entrySet()) {
                String ordererName = (String)entry.getKey();
                JsonObject jsonOrderer = NetworkConfig.getJsonValueAsObject((JsonValue)entry.getValue());
                if (jsonOrderer == null) {
                    throw new NetworkConfigurationException(String.format("Error loading config. Invalid orderer entry: %s", ordererName));
                }
                Node orderer = this.createNode(jsonOrderer);
                if (orderer == null) {
                    throw new NetworkConfigurationException(String.format("Error loading config. Invalid orderer entry: %s", ordererName));
                }
                this.orderers.put(ordererName, orderer);
            }
        }
    }

    private void createAllPeers() throws NetworkConfigurationException {
        if (this.peers != null) {
            throw new NetworkConfigurationException("INTERNAL ERROR: peers have already been initialized!");
        }
        this.peers = new HashMap<String, Node>();
        JsonObject jsonPeers = NetworkConfig.getJsonObject(this.jsonConfig, "peers");
        if (jsonPeers != null) {
            for (Map.Entry entry : jsonPeers.entrySet()) {
                String peerName = (String)entry.getKey();
                JsonObject jsonPeer = NetworkConfig.getJsonValueAsObject((JsonValue)entry.getValue());
                if (jsonPeer == null) {
                    throw new NetworkConfigurationException(String.format("Error loading config. Invalid peer entry: %s", peerName));
                }
                Node peer = this.createNode(jsonPeer);
                if (peer == null) {
                    throw new NetworkConfigurationException(String.format("Error loading config. Invalid peer entry: %s", peerName));
                }
                this.peers.put(peerName, peer);
            }
        }
    }

    private Map<String, JsonObject> findCertificateAuthorities() throws NetworkConfigurationException {
        HashMap<String, JsonObject> ret = new HashMap<String, JsonObject>();
        JsonObject jsonCertificateAuthorities = NetworkConfig.getJsonObject(this.jsonConfig, "certificateAuthorities");
        if (null != jsonCertificateAuthorities) {
            for (Map.Entry entry : jsonCertificateAuthorities.entrySet()) {
                String name = (String)entry.getKey();
                JsonObject jsonCA = NetworkConfig.getJsonValueAsObject((JsonValue)entry.getValue());
                if (jsonCA == null) {
                    throw new NetworkConfigurationException(String.format("Error loading config. Invalid CA entry: %s", name));
                }
                ret.put(name, jsonCA);
            }
        }
        return ret;
    }

    private void createAllOrganizations(Map<String, JsonObject> foundCertificateAuthorities) throws NetworkConfigurationException {
        if (this.organizations != null) {
            throw new NetworkConfigurationException("INTERNAL ERROR: organizations have already been initialized!");
        }
        this.organizations = new HashMap<String, OrgInfo>();
        JsonObject jsonOrganizations = NetworkConfig.getJsonObject(this.jsonConfig, "organizations");
        if (jsonOrganizations != null) {
            for (Map.Entry entry : jsonOrganizations.entrySet()) {
                String orgName = (String)entry.getKey();
                JsonObject jsonOrg = NetworkConfig.getJsonValueAsObject((JsonValue)entry.getValue());
                if (jsonOrg == null) {
                    throw new NetworkConfigurationException(String.format("Error loading config. Invalid Organization entry: %s", orgName));
                }
                OrgInfo org = this.createOrg(orgName, jsonOrg, foundCertificateAuthorities);
                this.organizations.put(orgName, org);
            }
        }
    }

    private Channel reconstructChannel(HFClient client, String channelName, JsonObject jsonChannel, NetworkConfigAddPeerHandler networkConfigAddPeerHandler, NetworkConfigAddOrdererHandler networkConfigAddOrdererHandler) throws NetworkConfigurationException, InvalidArgumentException {
        Channel channel = client.newChannel(channelName);
        JsonArray ordererNames = NetworkConfig.getJsonValueAsArray((JsonValue)jsonChannel.get((Object)"orderers"));
        if (ordererNames != null) {
            for (JsonValue jsonVal : ordererNames) {
                String ordererName = NetworkConfig.getJsonValueAsString(jsonVal);
                Node node = this.orderers.get(ordererName);
                if (null == node) {
                    throw new NetworkConfigurationException(String.format("Error constructing channel %s. Orderer %s not defined in configuration", channelName, ordererName));
                }
                logger.debug((Object)String.format("Channel %s, adding orderer %s, url: %s", channel.getName(), ordererName, node.url));
                Properties nodeProps = node.properties;
                if (null != nodeProps) {
                    nodeProps = (Properties)nodeProps.clone();
                }
                networkConfigAddOrdererHandler.addOrderer(this, client, channel, ordererName, node.url, nodeProps, node.jsonObject);
            }
        }
        JsonObject jsonPeers = NetworkConfig.getJsonObject(jsonChannel, "peers");
        boolean foundPeer = false;
        if (jsonPeers != null) {
            for (Map.Entry entry : jsonPeers.entrySet()) {
                JsonObject jsonPeer;
                String peerName = (String)entry.getKey();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)String.format("NetworkConfig.reconstructChannel: Processing peer %s", peerName));
                }
                if ((jsonPeer = NetworkConfig.getJsonValueAsObject((JsonValue)entry.getValue())) == null) {
                    throw new NetworkConfigurationException(String.format("Error constructing channel %s. Invalid peer entry: %s", channelName, peerName));
                }
                Node node = this.peers.get(peerName);
                if (node == null) {
                    throw new NetworkConfigurationException(String.format("Error constructing channel %s. Peer %s not defined in configuration", channelName, peerName));
                }
                Channel.PeerOptions peerOptions = Channel.PeerOptions.createPeerOptions();
                for (Peer.PeerRole peerRole : Peer.PeerRole.values()) {
                    NetworkConfig.setPeerRole(channelName, peerOptions, jsonPeer, peerRole);
                }
                logger.debug((Object)String.format("Channel %s, adding peer %s, url: %s", channel.getName(), peerName, node.url));
                Properties nodeProps = node.properties;
                if (null != nodeProps) {
                    nodeProps = (Properties)nodeProps.clone();
                }
                networkConfigAddPeerHandler.addPeer(this, client, channel, peerName, node.url, nodeProps, peerOptions, node.jsonObject);
                foundPeer = true;
            }
        }
        if (!foundPeer) {
            throw new NetworkConfigurationException(String.format("Error constructing channel %s. At least one peer must be specified", channelName));
        }
        return channel;
    }

    private static void setPeerRole(String channelName, Channel.PeerOptions peerOptions, JsonObject jsonPeer, Peer.PeerRole role) throws NetworkConfigurationException {
        String propName = NetworkConfig.roleNameRemap(role);
        JsonValue val = (JsonValue)jsonPeer.get((Object)propName);
        if (val != null) {
            Boolean isSet = NetworkConfig.getJsonValueAsBoolean(val);
            if (isSet == null) {
                throw new NetworkConfigurationException(String.format("Error constructing channel %s. Role %s has invalid boolean value: %s", channelName, propName, val.toString()));
            }
            if (isSet.booleanValue()) {
                peerOptions.addPeerRole(role);
            }
        }
    }

    private static String roleNameRemap(Peer.PeerRole peerRole) {
        String remap = roleNameRemapHash.get((Object)peerRole);
        return remap == null ? peerRole.getPropertyName() : remap;
    }

    private Node createNode(JsonObject jsonNode) {
        String url = jsonNode.getString(URL_PROP_NAME, null);
        if (url == null) {
            return null;
        }
        Properties props = NetworkConfig.extractProperties(jsonNode, "grpcOptions");
        String value = props.getProperty("grpc.keepalive_time_ms");
        if (null != value) {
            props.remove("grpc.keepalive_time_ms");
            props.put("grpc.NettyChannelBuilderOption.keepAliveTime", new Object[]{Long.parseLong(value), TimeUnit.MILLISECONDS});
        }
        if (null != (value = props.getProperty("grpc.keepalive_timeout_ms"))) {
            props.remove("grpc.keepalive_timeout_ms");
            props.put("grpc.NettyChannelBuilderOption.keepAliveTimeout", new Object[]{Long.parseLong(value), TimeUnit.MILLISECONDS});
        }
        if (null != (value = props.getProperty("grpc.keepalive_without_calls"))) {
            props.remove("grpc.keepalive_without_calls");
            props.put("grpc.NettyChannelBuilderOption.keepAliveWithoutCalls", new Object[]{Boolean.valueOf(value)});
        }
        this.getTLSCerts(jsonNode, props);
        return new Node(url, props, jsonNode);
    }

    private void getTLSCerts(JsonObject jsonOrderer, Properties props) {
        JsonObject jsonTlsCaCerts = NetworkConfig.getJsonObject(jsonOrderer, "tlsCACerts");
        if (jsonTlsCaCerts != null) {
            String pemFilename = NetworkConfig.getJsonValueAsString((JsonValue)jsonTlsCaCerts.get((Object)"path"));
            if (pemFilename != null) {
                props.put("pemFile", pemFilename);
            }
            byte[] pemBytes = NetworkConfig.getJsonValueAsList((JsonValue)jsonTlsCaCerts.get((Object)"pem"), NetworkConfig::getJsonValueAsString).stream().collect(Collectors.joining("\n")).getBytes();
            props.put("pemBytes", pemBytes);
            JsonObject jsonTlsClientCerts = NetworkConfig.getJsonObject(jsonTlsCaCerts, "client");
            if (jsonTlsClientCerts != null) {
                String keyfile = NetworkConfig.getJsonValueAsString((JsonValue)jsonTlsClientCerts.get((Object)"keyfile"));
                String certfile = NetworkConfig.getJsonValueAsString((JsonValue)jsonTlsClientCerts.get((Object)"certfile"));
                if (keyfile != null) {
                    props.put("tlsClientKeyFile", keyfile);
                }
                if (certfile != null) {
                    props.put("tlsClientCertFile", certfile);
                }
                String keyBytes = NetworkConfig.getJsonValueAsString((JsonValue)jsonTlsClientCerts.get((Object)"keyPem"));
                String certBytes = NetworkConfig.getJsonValueAsString((JsonValue)jsonTlsClientCerts.get((Object)"certPem"));
                if (keyBytes != null) {
                    props.put("tlsClientKeyBytes", keyBytes.getBytes());
                }
                if (certBytes != null) {
                    props.put("tlsClientCertBytes", certBytes.getBytes());
                }
            }
        }
    }

    private OrgInfo createOrg(String orgName, JsonObject jsonOrg, Map<String, JsonObject> foundCertificateAuthorities) throws NetworkConfigurationException {
        JsonArray jsonCertificateAuthorities;
        String msgPrefix = String.format("Organization %s", orgName);
        String mspId = NetworkConfig.getJsonValueAsString((JsonValue)jsonOrg.get((Object)"mspid"));
        OrgInfo org = new OrgInfo(orgName, mspId);
        JsonArray jsonPeers = NetworkConfig.getJsonValueAsArray((JsonValue)jsonOrg.get((Object)"peers"));
        if (jsonPeers != null) {
            for (Object peer : jsonPeers) {
                String peerName = NetworkConfig.getJsonValueAsString((JsonValue)peer);
                if (peerName == null) continue;
                org.addPeerName(peerName);
                Node node = this.peers.get(peerName);
                if (null != node) {
                    if (null == node.properties) {
                        node.properties = new Properties();
                    }
                    node.properties.put("org.hyperledger.fabric.sdk.peer.organization_mspid", org.getMspId());
                    continue;
                }
                throw new NetworkConfigurationException(String.format("Organization %s has peer %s listed not found in any channel peer list.", orgName, peerName));
            }
        }
        if ((jsonCertificateAuthorities = NetworkConfig.getJsonValueAsArray((JsonValue)jsonOrg.get((Object)"certificateAuthorities"))) != null) {
            for (JsonValue jsonCA : jsonCertificateAuthorities) {
                String caName = NetworkConfig.getJsonValueAsString(jsonCA);
                if (caName == null) continue;
                JsonObject jsonObject = foundCertificateAuthorities.get(caName);
                if (jsonObject != null) {
                    org.addCertificateAuthority(this.createCA(caName, jsonObject, org));
                    continue;
                }
                throw new NetworkConfigurationException(String.format("%s: Certificate Authority %s is not defined", msgPrefix, caName));
            }
        }
        String adminPrivateKeyString = NetworkConfig.extractPemString(jsonOrg, "adminPrivateKey", msgPrefix);
        String signedCert = NetworkConfig.extractPemString(jsonOrg, "signedCert", msgPrefix);
        if (!Utils.isNullOrEmpty(adminPrivateKeyString) && !Utils.isNullOrEmpty(signedCert)) {
            PrivateKey privateKey;
            try {
                privateKey = NetworkConfig.getPrivateKeyFromString(adminPrivateKeyString);
            }
            catch (IOException ioe) {
                throw new NetworkConfigurationException(String.format("%s: Invalid private key", msgPrefix), ioe);
            }
            try {
                org.peerAdmin = new UserInfo(mspId, "PeerAdmin_" + mspId + "_" + orgName, null);
            }
            catch (Exception e) {
                throw new NetworkConfigurationException(e.getMessage(), e);
            }
            org.peerAdmin.setEnrollment(new X509Enrollment(privateKey, signedCert));
        }
        return org;
    }

    private static PrivateKey getPrivateKeyFromString(String data) throws IOException {
        PrivateKeyInfo pemPair;
        StringReader pemReader = new StringReader(data);
        try (PEMParser pemParser = new PEMParser((Reader)pemReader);){
            pemPair = (PrivateKeyInfo)pemParser.readObject();
        }
        return new JcaPEMKeyConverter().getPrivateKey(pemPair);
    }

    private static String extractPemString(JsonObject json, String fieldName, String msgPrefix) throws NetworkConfigurationException {
        String path = null;
        String pemString = null;
        JsonObject jsonField = NetworkConfig.getJsonValueAsObject((JsonValue)json.get((Object)fieldName));
        if (jsonField != null) {
            path = NetworkConfig.getJsonValueAsString((JsonValue)jsonField.get((Object)"path"));
            pemString = NetworkConfig.getJsonValueAsString((JsonValue)jsonField.get((Object)"pem"));
        }
        if (path != null && pemString != null) {
            throw new NetworkConfigurationException(String.format("%s should not specify both %s path and pem", msgPrefix, fieldName));
        }
        if (path != null) {
            File pemFile = new File(path);
            String fullPathname = pemFile.getAbsolutePath();
            if (!pemFile.exists()) {
                throw new NetworkConfigurationException(String.format("%s: %s file %s does not exist", msgPrefix, fieldName, fullPathname));
            }
            try (FileInputStream stream = new FileInputStream(pemFile);){
                pemString = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ioe) {
                throw new NetworkConfigurationException(String.format("Failed to read file: %s", fullPathname), ioe);
            }
        }
        return pemString;
    }

    private CAInfo createCA(String name, JsonObject jsonCA, OrgInfo org) throws NetworkConfigurationException {
        String url = NetworkConfig.getJsonValueAsString((JsonValue)jsonCA.get((Object)URL_PROP_NAME));
        Properties httpOptions = NetworkConfig.extractProperties(jsonCA, "httpOptions");
        ArrayList<UserInfo> regUsers = new ArrayList<UserInfo>();
        List<JsonObject> registrars = NetworkConfig.getJsonValueAsList((JsonValue)jsonCA.get((Object)"registrar"), NetworkConfig::getJsonValueAsObject);
        for (JsonObject registrar : registrars) {
            String enrollId = NetworkConfig.getJsonValueAsString((JsonValue)registrar.get((Object)"enrollId"));
            String enrollSecret = NetworkConfig.getJsonValueAsString((JsonValue)registrar.get((Object)"enrollSecret"));
            try {
                regUsers.add(new UserInfo(org.mspId, enrollId, enrollSecret));
            }
            catch (Exception e) {
                throw new NetworkConfigurationException(e.getMessage(), e);
            }
        }
        CAInfo caInfo = new CAInfo(name, url, regUsers, httpOptions);
        String caName = NetworkConfig.getJsonValueAsString((JsonValue)jsonCA.get((Object)"caName"));
        if (caName != null) {
            caInfo.setCaName(caName);
        }
        Properties properties = new Properties();
        if ("false".equals(httpOptions.getProperty("verify"))) {
            properties.setProperty("allowAllHostNames", "true");
        }
        this.getTLSCerts(jsonCA, properties);
        caInfo.setProperties(properties);
        return caInfo;
    }

    private static Properties extractProperties(JsonObject json, String fieldName) {
        Properties props = new Properties();
        JsonObject options = NetworkConfig.getJsonObject(json, fieldName);
        if (options != null) {
            for (Map.Entry entry : options.entrySet()) {
                String key = (String)entry.getKey();
                JsonValue value = (JsonValue)entry.getValue();
                props.setProperty(key, NetworkConfig.getJsonValue(value));
            }
        }
        return props;
    }

    private static String getJsonValue(JsonValue value) {
        String s = null;
        if (value != null) {
            Boolean b;
            s = NetworkConfig.getJsonValueAsString(value);
            if (s == null) {
                s = NetworkConfig.getJsonValueAsNumberString(value);
            }
            if (s == null && (b = NetworkConfig.getJsonValueAsBoolean(value)) != null) {
                s = b != false ? "true" : "false";
            }
        }
        return s;
    }

    private static JsonObject getJsonValueAsObject(JsonValue value) {
        return value != null && value.getValueType() == JsonValue.ValueType.OBJECT ? value.asJsonObject() : null;
    }

    private static JsonArray getJsonValueAsArray(JsonValue value) {
        return value != null && value.getValueType() == JsonValue.ValueType.ARRAY ? value.asJsonArray() : null;
    }

    private static <T> List<T> getJsonValueAsList(JsonValue value, Function<JsonValue, T> map) {
        return NetworkConfig.getJsonValueAsList(value).stream().map(map).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<JsonValue> getJsonValueAsList(JsonValue value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value.getValueType() == JsonValue.ValueType.ARRAY) {
            return value.asJsonArray();
        }
        return Collections.singletonList(value);
    }

    private static String getJsonValueAsString(JsonValue value) {
        return value != null && value.getValueType() == JsonValue.ValueType.STRING ? ((JsonString)value).getString() : null;
    }

    private static String getJsonValueAsNumberString(JsonValue value) {
        return value != null && value.getValueType() == JsonValue.ValueType.NUMBER ? value.toString() : null;
    }

    private static Boolean getJsonValueAsBoolean(JsonValue value) {
        if (value != null) {
            if (value.getValueType() == JsonValue.ValueType.TRUE) {
                return true;
            }
            if (value.getValueType() == JsonValue.ValueType.FALSE) {
                return false;
            }
        }
        return null;
    }

    private static JsonObject getJsonObject(JsonObject object, String propName) {
        JsonObject obj = null;
        JsonValue val = (JsonValue)object.get((Object)propName);
        if (val != null && val.getValueType() == JsonValue.ValueType.OBJECT) {
            obj = val.asJsonObject();
        }
        return obj;
    }

    public Set<String> getChannelNames() {
        HashSet<String> result = new HashSet<String>();
        JsonObject channels = NetworkConfig.getJsonObject(this.jsonConfig, "channels");
        if (channels != null) {
            result.addAll(channels.keySet());
        }
        return result;
    }

    static {
        roleNameRemapHash.put(Peer.PeerRole.SERVICE_DISCOVERY, "discover");
    }

    public static class CAInfo {
        private final String name;
        private final String url;
        private final Properties httpOptions;
        private String caName;
        private Properties properties;
        private final List<UserInfo> registrars;

        CAInfo(String name, String url, List<UserInfo> registrars, Properties httpOptions) {
            this.name = name;
            this.url = url;
            this.httpOptions = httpOptions;
            this.registrars = registrars;
        }

        private void setCaName(String caName) {
            this.caName = caName;
        }

        public String getName() {
            return this.name;
        }

        public String getCAName() {
            return this.caName;
        }

        public String getUrl() {
            return this.url;
        }

        public Properties getHttpOptions() {
            return this.httpOptions;
        }

        void setProperties(Properties properties) {
            this.properties = properties;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public Collection<UserInfo> getRegistrars() {
            return new LinkedList<UserInfo>(this.registrars);
        }
    }

    public static class OrgInfo {
        private final String name;
        private final String mspId;
        private final List<String> peerNames = new ArrayList<String>();
        private final List<CAInfo> certificateAuthorities = new ArrayList<CAInfo>();
        private UserInfo peerAdmin;

        OrgInfo(String orgName, String mspId) {
            this.name = orgName;
            this.mspId = mspId;
        }

        private void addPeerName(String peerName) {
            this.peerNames.add(peerName);
        }

        private void addCertificateAuthority(CAInfo ca) {
            this.certificateAuthorities.add(ca);
        }

        public String getName() {
            return this.name;
        }

        public String getMspId() {
            return this.mspId;
        }

        public List<String> getPeerNames() {
            return new LinkedList<String>(this.peerNames);
        }

        public List<CAInfo> getCertificateAuthorities() {
            return new LinkedList<CAInfo>(this.certificateAuthorities);
        }

        public UserInfo getPeerAdmin() {
            return this.peerAdmin;
        }
    }

    public static class UserInfo
    implements User {
        protected String name;
        protected String enrollSecret;
        protected String mspid;
        private Set<String> roles;
        private String account;
        private String affiliation;
        private Enrollment enrollment;

        public void setName(String name) {
            this.name = name;
        }

        public void setEnrollSecret(String enrollSecret) {
            this.enrollSecret = enrollSecret;
        }

        public String getMspid() {
            return this.mspid;
        }

        public void setMspid(String mspid) {
            this.mspid = mspid;
        }

        public void setRoles(Set<String> roles) {
            this.roles = roles;
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public void setAffiliation(String affiliation) {
            this.affiliation = affiliation;
        }

        public void setEnrollment(Enrollment enrollment) {
            this.enrollment = enrollment;
        }

        UserInfo(String mspid, String name, String enrollSecret) {
            this.name = name;
            this.enrollSecret = enrollSecret;
            this.mspid = mspid;
        }

        public String getEnrollSecret() {
            return this.enrollSecret;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Set<String> getRoles() {
            return this.roles;
        }

        @Override
        public String getAccount() {
            return this.account;
        }

        @Override
        public String getAffiliation() {
            return this.affiliation;
        }

        @Override
        public Enrollment getEnrollment() {
            return this.enrollment;
        }

        @Override
        public String getMspId() {
            return this.mspid;
        }
    }

    private static class Node {
        private final String url;
        public final JsonObject jsonObject;
        private Properties properties;

        private Node(String url, Properties properties, JsonObject jsonObject) {
            this.url = url;
            this.properties = properties;
            this.jsonObject = jsonObject;
        }

        private String getUrl() {
            return this.url;
        }
    }

    public static interface NetworkConfigAddOrdererHandler {
        public void addOrderer(NetworkConfig var1, HFClient var2, Channel var3, String var4, String var5, Properties var6, JsonObject var7) throws NetworkConfigurationException;
    }

    public static interface NetworkConfigAddPeerHandler {
        public void addPeer(NetworkConfig var1, HFClient var2, Channel var3, String var4, String var5, Properties var6, Channel.PeerOptions var7, JsonObject var8) throws NetworkConfigurationException;
    }
}

