/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.orderer.Ab;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.Endpoint;
import org.hyperledger.fabric.sdk.OrdererClient;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.TransactionException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.Utils;

public class Orderer
implements Serializable {
    public static final String ORDERER_ORGANIZATION_MSPID_PROPERTY = "org.hyperledger.fabric.sdk.orderer.organization_mspid";
    private static final Config config = Config.getConfig();
    private static final Log logger = LogFactory.getLog(Orderer.class);
    private static final long serialVersionUID = 4281642068914263247L;
    private final Properties properties;
    private final String name;
    private final String url;
    private transient boolean shutdown = false;
    private Channel channel;
    private volatile transient OrdererClient ordererClient = null;
    private transient byte[] clientTLSCertificateDigest;
    private String channelName = "";
    private transient String id = config.getNextID();
    private String endPoint;
    private transient String toString;

    Orderer(String name, String url, Properties properties) throws InvalidArgumentException {
        if (Utils.isNullOrEmpty(name)) {
            throw new InvalidArgumentException("Invalid name for orderer");
        }
        Exception e = Utils.checkGrpcUrl(url);
        if (e != null) {
            throw new InvalidArgumentException(e);
        }
        this.name = name;
        this.url = url;
        this.properties = properties == null ? new Properties() : (Properties)properties.clone();
        logger.trace((Object)("Created " + this.toString()));
    }

    static Orderer createNewInstance(String name, String url, Properties properties) throws InvalidArgumentException {
        return new Orderer(name, url, properties);
    }

    byte[] getClientTLSCertificateDigest() {
        if (null == this.clientTLSCertificateDigest) {
            this.clientTLSCertificateDigest = Endpoint.createEndpoint(this.url, this.properties).getClientTLSCertificateDigest();
        }
        return this.clientTLSCertificateDigest;
    }

    public Properties getProperties() {
        return this.properties == null ? null : (Properties)this.properties.clone();
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    void unsetChannel() {
        logger.debug((Object)String.format("%s unsetting channel", this.toString()));
        this.channel = null;
        this.channelName = "";
    }

    Channel getChannel() {
        return this.channel;
    }

    void setChannel(Channel channel) throws InvalidArgumentException {
        if (channel == null) {
            throw new InvalidArgumentException("setChannel Channel can not be null");
        }
        if (null != this.channel && this.channel != channel) {
            throw new InvalidArgumentException(String.format("Can not add orderer %s to channel %s because it already belongs to channel %s.", this.name, channel.getName(), this.channel.getName()));
        }
        logger.debug((Object)String.format("%s setting channel %s", this.toString(), channel));
        this.channel = channel;
        this.channelName = channel.getName();
        this.toString = null;
    }

    Ab.BroadcastResponse sendTransaction(Common.Envelope transaction) throws Exception {
        if (this.shutdown) {
            throw new TransactionException(String.format("Orderer %s was shutdown.", this.name));
        }
        logger.debug((Object)String.format("Orderer.sendTransaction %s", this.toString()));
        OrdererClient localOrdererClient = this.getOrdererClient();
        try {
            return localOrdererClient.sendTransaction(transaction);
        }
        catch (Throwable t) {
            this.removeOrdererClient(true);
            throw t;
        }
    }

    Ab.DeliverResponse[] sendDeliver(Common.Envelope transaction) throws TransactionException {
        if (this.shutdown) {
            throw new TransactionException(String.format("Orderer %s was shutdown.", this.name));
        }
        OrdererClient localOrdererClient = this.getOrdererClient();
        logger.debug((Object)String.format("%s Orderer.sendDeliver", this.toString()));
        try {
            return localOrdererClient.sendDeliver(transaction);
        }
        catch (Throwable t) {
            logger.error((Object)String.format("%s removing %s due to %s", this.toString(), localOrdererClient, t.getMessage()));
            this.removeOrdererClient(true);
            throw t;
        }
    }

    private synchronized OrdererClient getOrdererClient() {
        OrdererClient localOrdererClient = this.ordererClient;
        if (localOrdererClient == null || !localOrdererClient.isChannelActive()) {
            logger.trace((Object)String.format("Channel %s creating new orderer client %s", this.channelName, this.toString()));
            this.ordererClient = localOrdererClient = new OrdererClient(this, Endpoint.createEndpoint(this.url, this.properties).getChannelBuilder(), this.properties);
        }
        return localOrdererClient;
    }

    private synchronized void removeOrdererClient(boolean force) {
        OrdererClient localOrderClient = this.ordererClient;
        this.ordererClient = null;
        if (null != localOrderClient) {
            logger.debug((Object)String.format("Channel %s removing orderer client %s, isActive: %b", this.channelName, this.toString(), localOrderClient.isChannelActive()));
            try {
                localOrderClient.shutdown(force);
            }
            catch (Exception e) {
                logger.error((Object)(this.toString() + " error message: " + e.getMessage()));
                logger.trace((Object)e);
            }
        }
    }

    synchronized void shutdown(boolean force) {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        logger.debug((Object)String.format("Shutting down %s", this.toString()));
        this.removeOrdererClient(true);
        this.channel = null;
        this.channelName = "";
    }

    String getEndpoint() {
        if (null == this.endPoint) {
            Properties properties = Utils.parseGrpcUrl(this.url);
            this.endPoint = properties.get("host") + ":" + properties.getProperty("port").toLowerCase().trim();
        }
        return this.endPoint;
    }

    protected void finalize() throws Throwable {
        try {
            logger.trace((Object)("finalize " + this.toString()));
            this.shutdown(true);
        }
        finally {
            super.finalize();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.id = config.getNextID();
    }

    public String toString() {
        String ltoString = this.toString;
        if (ltoString == null) {
            String mspid = "";
            if (this.properties != null && !Utils.isNullOrEmpty(this.properties.getProperty(ORDERER_ORGANIZATION_MSPID_PROPERTY))) {
                mspid = ", mspid: " + this.properties.getProperty(ORDERER_ORGANIZATION_MSPID_PROPERTY);
            }
            this.toString = ltoString = "Orderer{id: " + this.id + ", channelName: " + this.channelName + ", name:" + this.name + ", url: " + this.url + mspid + "}";
        }
        return ltoString;
    }
}

