/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.orderer.Ab;
import org.hyperledger.fabric.protos.orderer.AtomicBroadcastGrpc;
import org.hyperledger.fabric.sdk.Orderer;
import org.hyperledger.fabric.sdk.exception.TransactionException;
import org.hyperledger.fabric.sdk.helper.Config;

class OrdererClient {
    private static final Log logger = LogFactory.getLog(OrdererClient.class);
    private static final boolean IS_TRACE_LEVEL = logger.isTraceEnabled();
    private static final Config config = Config.getConfig();
    private static final long ORDERER_WAIT_TIME = config.getOrdererWaitTime();
    private final String channelName;
    private final ManagedChannelBuilder<?> channelBuilder;
    private final String toString;
    private boolean shutdown = false;
    private ManagedChannel managedChannel = null;
    private final String name;
    private final long ordererWaitTimeMilliSecs;

    OrdererClient(Orderer orderer, ManagedChannelBuilder<?> channelBuilder, Properties properties) {
        this.channelBuilder = channelBuilder;
        this.name = orderer.getName();
        String url = orderer.getUrl();
        this.channelName = orderer.getChannel().getName();
        this.toString = "OrdererClient{id: " + config.getNextID() + ", channel: " + this.channelName + ", name: " + this.name + ", url: " + url + "}";
        if (null == properties) {
            this.ordererWaitTimeMilliSecs = ORDERER_WAIT_TIME;
        } else {
            String ordererWaitTimeMilliSecsString = properties.getProperty("ordererWaitTimeMilliSecs", Long.toString(ORDERER_WAIT_TIME));
            long tempOrdererWaitTimeMilliSecs = ORDERER_WAIT_TIME;
            try {
                tempOrdererWaitTimeMilliSecs = Long.parseLong(ordererWaitTimeMilliSecsString);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)String.format("Orderer %s wait time %s not parsable.", this.toString(), ordererWaitTimeMilliSecsString), (Throwable)e);
            }
            this.ordererWaitTimeMilliSecs = tempOrdererWaitTimeMilliSecs;
        }
    }

    synchronized void shutdown(boolean force) {
        if (IS_TRACE_LEVEL) {
            logger.trace((Object)String.format("%s shutdown called force: %b, shutdown: %b, managedChannel: %s", this.toString(), force, this.shutdown, "" + this.managedChannel));
        }
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        ManagedChannel lchannel = this.managedChannel;
        this.managedChannel = null;
        if (lchannel == null) {
            return;
        }
        if (force) {
            try {
                lchannel.shutdownNow();
            }
            catch (Exception e) {
                logger.warn((Object)e);
            }
        } else {
            boolean isTerminated = false;
            try {
                isTerminated = lchannel.shutdown().awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                logger.debug((Object)this.toString(), (Throwable)e);
            }
            if (!isTerminated) {
                try {
                    lchannel.shutdownNow();
                }
                catch (Exception e) {
                    logger.warn((Object)this.toString(), (Throwable)e);
                }
            }
        }
    }

    public void finalize() throws Throwable {
        try {
            this.shutdown(true);
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Ab.BroadcastResponse sendTransaction(Common.Envelope envelope) throws Exception {
        Ab.BroadcastResponse broadcastResponse;
        logger.trace((Object)(this.toString() + " OrdererClient.sendTransaction entered."));
        StreamObserver<Common.Envelope> nso = null;
        if (this.shutdown) {
            throw new TransactionException(this.toString() + " is shutdown");
        }
        ManagedChannel lmanagedChannel = this.managedChannel;
        if (IS_TRACE_LEVEL && lmanagedChannel != null) {
            logger.trace((Object)String.format("%s  managed channel isTerminated: %b, isShutdown: %b, state: %s", this.toString(), lmanagedChannel.isTerminated(), lmanagedChannel.isShutdown(), lmanagedChannel.getState(false).name()));
        }
        if (lmanagedChannel == null || lmanagedChannel.isTerminated() || lmanagedChannel.isShutdown()) {
            if (lmanagedChannel != null && lmanagedChannel.isTerminated()) {
                logger.warn((Object)String.format("%s managed channel was marked terminated", this.toString()));
            }
            if (lmanagedChannel != null && lmanagedChannel.isShutdown()) {
                logger.warn((Object)String.format("%s managed channel was marked shutdown.", this.toString()));
            }
            this.managedChannel = lmanagedChannel = this.channelBuilder.build();
        }
        if (IS_TRACE_LEVEL && lmanagedChannel != null) {
            logger.trace((Object)String.format("%s  managed channel isTerminated: %b, isShutdown: %b, state: %s", this.toString(), lmanagedChannel.isTerminated(), lmanagedChannel.isShutdown(), lmanagedChannel.getState(false).name()));
        }
        try {
            final CountDownLatch finishLatch = new CountDownLatch(1);
            AtomicBroadcastGrpc.AtomicBroadcastStub broadcast = AtomicBroadcastGrpc.newStub((Channel)lmanagedChannel);
            final Ab.BroadcastResponse[] ret = new Ab.BroadcastResponse[1];
            final Throwable[] throwable = new Throwable[]{null};
            StreamObserver<Ab.BroadcastResponse> so = new StreamObserver<Ab.BroadcastResponse>(){

                public void onNext(Ab.BroadcastResponse resp) {
                    logger.debug((Object)(OrdererClient.this.toString() + " resp status value: " + resp.getStatusValue() + ", resp: " + (Object)((Object)resp.getStatus())));
                    if (resp.getStatus() == Common.Status.SUCCESS) {
                        ret[0] = resp;
                    } else {
                        throwable[0] = new TransactionException(String.format("Channel %s orderer %s status returned failure code %d (%s) during orderer next", OrdererClient.this.channelName, OrdererClient.this.name, resp.getStatusValue(), resp.getStatus().name()));
                    }
                    finishLatch.countDown();
                }

                public void onError(Throwable t) {
                    if (!OrdererClient.this.shutdown) {
                        ManagedChannel lmanagedChannel = OrdererClient.this.managedChannel;
                        OrdererClient.this.managedChannel = null;
                        if (lmanagedChannel == null) {
                            logger.error((Object)(OrdererClient.this.toString() + " managed channel was null."));
                        } else {
                            logger.error((Object)String.format("%s  managed channel isTerminated: %b, isShutdown: %b, state: %s", OrdererClient.this.toString(), lmanagedChannel.isTerminated(), lmanagedChannel.isShutdown(), lmanagedChannel.getState(false).name()));
                        }
                        logger.error((Object)String.format("Received error %s  %s", this.toString(), t.getMessage()), t);
                    }
                    throwable[0] = t;
                    finishLatch.countDown();
                }

                public void onCompleted() {
                    logger.trace((Object)(OrdererClient.this.toString() + " onComplete received."));
                    finishLatch.countDown();
                }
            };
            nso = broadcast.broadcast(so);
            nso.onNext((Object)envelope);
            try {
                if (!finishLatch.await(this.ordererWaitTimeMilliSecs, TimeUnit.MILLISECONDS)) {
                    TransactionException ste = new TransactionException(String.format("Channel %s, send transactions failed on orderer %s. Reason:  timeout after %d ms.", this.channelName, this.toString(), this.ordererWaitTimeMilliSecs));
                    logger.error((Object)("sendTransaction error " + ste.getMessage()), (Throwable)ste);
                    throw ste;
                }
                if (throwable[0] != null) {
                    Throwable t = throwable[0];
                    if (t instanceof StatusRuntimeException) {
                        StatusRuntimeException sre = (StatusRuntimeException)t;
                        Status status = sre.getStatus();
                        logger.error((Object)String.format("%s grpc status Code:%s, Description %s, ", this.toString(), status.getDescription(), status.getCode() + ""), sre.getCause());
                    }
                    TransactionException ste = new TransactionException(String.format("Channel %s, send transaction failed on orderer %s. Reason: %s", this.channelName, this.toString(), throwable[0].getMessage()), throwable[0]);
                    logger.error((Object)(this.toString() + "sendTransaction error " + ste.getMessage()), (Throwable)ste);
                    throw ste;
                }
                logger.debug((Object)(this.toString() + " done waiting for reply! Got:" + ret[0]));
            }
            catch (InterruptedException e) {
                logger.error((Object)this.toString(), (Throwable)e);
            }
            broadcastResponse = ret[0];
            if (null == nso) return broadcastResponse;
        }
        catch (Throwable t) {
            try {
                this.managedChannel = null;
                throw t;
            }
            catch (Throwable throwable2) {
                if (null == nso) throw throwable2;
                try {
                    nso.onCompleted();
                    throw throwable2;
                }
                catch (Exception e) {
                    logger.debug((Object)String.format("Exception completing sendTransaction with %s %s", this.toString(), e.getMessage()), (Throwable)e);
                }
                throw throwable2;
            }
        }
        try {
            nso.onCompleted();
            return broadcastResponse;
        }
        catch (Exception e) {
            logger.debug((Object)String.format("Exception completing sendTransaction with %s %s", this.toString(), e.getMessage()), (Throwable)e);
        }
        return broadcastResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Ab.DeliverResponse[] sendDeliver(Common.Envelope envelope) throws TransactionException {
        Ab.DeliverResponse[] deliverResponseArray;
        logger.trace((Object)(this.toString() + " OrdererClient.sendDeliver entered."));
        if (this.shutdown) {
            throw new TransactionException("Orderer client is shutdown");
        }
        StreamObserver<Common.Envelope> nso = null;
        ManagedChannel lmanagedChannel = this.managedChannel;
        if (IS_TRACE_LEVEL && lmanagedChannel != null) {
            logger.trace((Object)String.format("%s  managed channel isTerminated: %b, isShutdown: %b, state: %s", this.toString(), lmanagedChannel.isTerminated(), lmanagedChannel.isShutdown(), lmanagedChannel.getState(false).name()));
        }
        if (lmanagedChannel == null || lmanagedChannel.isTerminated() || lmanagedChannel.isShutdown()) {
            if (lmanagedChannel != null && lmanagedChannel.isTerminated()) {
                logger.warn((Object)String.format("%s managed channel was marked terminated", this.toString()));
            }
            if (lmanagedChannel != null && lmanagedChannel.isShutdown()) {
                logger.warn((Object)String.format("%s managed channel was marked shutdown.", this.toString()));
            }
            this.managedChannel = lmanagedChannel = this.channelBuilder.build();
        }
        if (IS_TRACE_LEVEL && lmanagedChannel != null) {
            logger.trace((Object)String.format("%s  managed channel isTerminated: %b, isShutdown: %b, state: %s", this.toString(), lmanagedChannel.isTerminated(), lmanagedChannel.isShutdown(), lmanagedChannel.getState(false).name()));
        }
        try {
            AtomicBroadcastGrpc.AtomicBroadcastStub broadcast = AtomicBroadcastGrpc.newStub((Channel)lmanagedChannel);
            final ArrayList retList = new ArrayList();
            final ArrayList throwableList = new ArrayList();
            final CountDownLatch finishLatch = new CountDownLatch(1);
            StreamObserver<Ab.DeliverResponse> so = new StreamObserver<Ab.DeliverResponse>(){
                boolean done = false;

                public void onNext(Ab.DeliverResponse resp) {
                    logger.debug((Object)(OrdererClient.this.toString() + "sendDeliver resp status value: " + resp.getStatusValue() + ", resp: " + (Object)((Object)resp.getStatus()) + ", type case: " + (Object)((Object)resp.getTypeCase())));
                    if (this.done) {
                        logger.trace((Object)(OrdererClient.this.toString() + " sendDeliver done!"));
                        return;
                    }
                    if (resp.getTypeCase() == Ab.DeliverResponse.TypeCase.STATUS) {
                        this.done = true;
                        retList.add(0, resp);
                        finishLatch.countDown();
                    } else {
                        retList.add(resp);
                    }
                }

                public void onError(Throwable t) {
                    if (!OrdererClient.this.shutdown) {
                        ManagedChannel lmanagedChannel = OrdererClient.this.managedChannel;
                        OrdererClient.this.managedChannel = null;
                        if (lmanagedChannel == null) {
                            logger.error((Object)(OrdererClient.this.toString() + " managed channel was null."));
                        } else {
                            logger.error((Object)String.format("%s  managed channel isTerminated: %b, isShutdown: %b, state: %s", OrdererClient.this.toString(), lmanagedChannel.isTerminated(), lmanagedChannel.isShutdown(), lmanagedChannel.getState(false).name()));
                        }
                        logger.error((Object)String.format("Received error on %s %s", OrdererClient.this.toString(), t.getMessage()), t);
                    }
                    throwableList.add(t);
                    finishLatch.countDown();
                }

                public void onCompleted() {
                    logger.trace((Object)(OrdererClient.this.toString() + " onCompleted."));
                    finishLatch.countDown();
                }
            };
            nso = broadcast.deliver(so);
            nso.onNext((Object)envelope);
            try {
                if (!finishLatch.await(this.ordererWaitTimeMilliSecs, TimeUnit.MILLISECONDS)) {
                    TransactionException ex = new TransactionException(String.format("Channel %s sendDeliver time exceeded for orderer %s, timed out at %d ms.", this.channelName, this.toString(), this.ordererWaitTimeMilliSecs));
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
                logger.trace((Object)(this.toString() + " Done waiting for reply!"));
            }
            catch (InterruptedException e) {
                logger.error((Object)(this.toString() + " " + e.getMessage()), (Throwable)e);
            }
            if (!throwableList.isEmpty()) {
                Throwable throwable = (Throwable)throwableList.get(0);
                TransactionException e = new TransactionException(String.format("Channel %s sendDeliver failed on orderer %s. Reason: %s", this.channelName, this.toString(), throwable.getMessage()), throwable);
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
            deliverResponseArray = retList.toArray(new Ab.DeliverResponse[0]);
            if (null == nso) return deliverResponseArray;
        }
        catch (Throwable t) {
            try {
                this.managedChannel = null;
                logger.error((Object)(this.toString() + " received error " + t.getMessage()), t);
                throw t;
            }
            catch (Throwable throwable) {
                if (null == nso) throw throwable;
                try {
                    logger.debug((Object)(this.toString() + "completed."));
                    nso.onCompleted();
                    throw throwable;
                }
                catch (Exception e) {
                    logger.debug((Object)String.format("Exception completing sendDeliver with %s %s", this.toString(), e.getMessage()), (Throwable)e);
                }
                throw throwable;
            }
        }
        try {
            logger.debug((Object)(this.toString() + "completed."));
            nso.onCompleted();
            return deliverResponseArray;
        }
        catch (Exception e) {
            logger.debug((Object)String.format("Exception completing sendDeliver with %s %s", this.toString(), e.getMessage()), (Throwable)e);
        }
        return deliverResponseArray;
    }

    public String toString() {
        return this.toString;
    }

    boolean isChannelActive() {
        ManagedChannel lchannel = this.managedChannel;
        if (null == lchannel) {
            logger.trace((Object)(this.toString() + " Grpc channel needs creation."));
            return false;
        }
        boolean isTerminated = lchannel.isTerminated();
        boolean isShutdown = lchannel.isShutdown();
        boolean ret = !lchannel.isShutdown() && !isTerminated;
        logger.trace((Object)String.format("%s grpc channel isActive: %b, isShutdown: %b, isTerminated: %b, state: %s ", this.toString(), ret, isShutdown, isTerminated, "" + lchannel.getState(false)));
        return ret;
    }
}

