/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.ref.WeakReference;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.sdk.HeaderDeserializer;
import org.hyperledger.fabric.sdk.exception.InvalidProtocolBufferRuntimeException;

class PayloadDeserializer {
    private final ByteString byteString;
    private WeakReference<Common.Payload> payload;

    PayloadDeserializer(ByteString byteString) {
        this.byteString = byteString;
    }

    Common.Payload getPayload() {
        Common.Payload ret = null;
        if (this.payload != null) {
            ret = (Common.Payload)this.payload.get();
        }
        if (ret == null) {
            try {
                ret = Common.Payload.parseFrom(this.byteString);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
            this.payload = new WeakReference<Common.Payload>(ret);
        }
        return ret;
    }

    HeaderDeserializer getHeader() {
        return new HeaderDeserializer(this.getPayload().getHeader());
    }
}

