/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.discovery.Protocol;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.sdk.BlockEvent;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.EndorserClient;
import org.hyperledger.fabric.sdk.Endpoint;
import org.hyperledger.fabric.sdk.PeerEventServiceClient;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.PeerEventingServiceException;
import org.hyperledger.fabric.sdk.exception.PeerException;
import org.hyperledger.fabric.sdk.exception.TransactionException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.security.certgen.TLSCertificateKeyPair;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

public class Peer
implements Serializable {
    public static final String PEER_ORGANIZATION_MSPID_PROPERTY = "org.hyperledger.fabric.sdk.peer.organization_mspid";
    private static final Config config = Config.getConfig();
    private static final Log logger = LogFactory.getLog(Peer.class);
    private static final boolean IS_DEBUG_LEVEL = logger.isDebugEnabled();
    private static final boolean IS_TRACE_LEVEL = logger.isTraceEnabled();
    private static final long serialVersionUID = -5273194649991828876L;
    private static final long PEER_EVENT_RETRY_WAIT_TIME = config.getPeerRetryWaitTime();
    private transient String id;
    private Properties properties;
    private final String name;
    private final String url;
    private volatile transient EndorserClient endorserClent;
    private transient PeerEventServiceClient peerEventingClient;
    private volatile transient boolean shutdown = false;
    private Channel channel;
    private String channelName;
    private transient TransactionContext transactionContext;
    private transient long lastConnectTime;
    private transient AtomicLong reconnectCount;
    private transient BlockEvent lastBlockEvent;
    private transient long lastBlockNumber = -1L;
    private transient byte[] clientTLSCertificateDigest;
    private transient boolean foundClientTLSCertificateDigest;
    private transient boolean connected = false;
    private String endPoint = null;
    private String protocol = null;
    private transient PeerEventingServiceDisconnected disconnectedHandler = Peer.getDefaultDisconnectHandler();
    private transient String toString;

    boolean hasConnected() {
        return this.connected;
    }

    Peer(String name, String grpcURL, Properties properties) throws InvalidArgumentException {
        this.reconnectCount = new AtomicLong(0L);
        this.id = config.getNextID();
        Exception e = Utils.checkGrpcUrl(grpcURL);
        if (e != null) {
            throw new InvalidArgumentException("Bad peer url.", e);
        }
        if (Utils.isNullOrEmpty(name)) {
            throw new InvalidArgumentException("Invalid name for peer");
        }
        this.url = grpcURL;
        this.name = name;
        this.properties = properties == null ? new Properties() : (Properties)properties.clone();
        logger.debug((Object)("Created " + this.toString()));
    }

    static Peer createNewInstance(String name, String grpcURL, Properties properties) throws InvalidArgumentException {
        return new Peer(name, grpcURL, properties);
    }

    public String getName() {
        return this.name;
    }

    public Properties getProperties() {
        return this.properties == null ? null : (Properties)this.properties.clone();
    }

    void unsetChannel() {
        logger.debug((Object)(this.toString() + " unset " + this.channel));
        this.channel = null;
    }

    BlockEvent getLastBlockEvent() {
        return this.lastBlockEvent;
    }

    ExecutorService getExecutorService() {
        return this.channel.getExecutorService();
    }

    void initiateEventing(TransactionContext transactionContext, Channel.PeerOptions peersOptions) throws TransactionException {
        this.transactionContext = transactionContext.retryTransactionSameContext();
        if (this.peerEventingClient == null && !this.shutdown) {
            this.peerEventingClient = new PeerEventServiceClient(this, Endpoint.createEndpoint(this.url, this.properties), this.properties, peersOptions);
            this.peerEventingClient.connect(transactionContext);
        }
    }

    Channel getChannel() {
        return this.channel;
    }

    boolean isShutdown() {
        return this.shutdown;
    }

    void setChannel(Channel channel) throws InvalidArgumentException {
        if (null != this.channel) {
            throw new InvalidArgumentException(String.format("Can not add peer %s to channel %s because it already belongs to channel %s.", this.name, channel.getName(), this.channel.getName()));
        }
        logger.debug((Object)String.format("%s setting channel to %s, from %s", this.toString(), "" + channel, "" + this.channel));
        this.channel = channel;
        this.channelName = channel.getName();
        this.toString = null;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object otherPeer) {
        if (this == otherPeer) {
            return true;
        }
        if (otherPeer == null) {
            return false;
        }
        if (!(otherPeer instanceof Peer)) {
            return false;
        }
        Peer p = (Peer)otherPeer;
        return Objects.equals(this.name, p.name) && Objects.equals(this.url, p.url);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url);
    }

    CompletableFuture<ProposalResponsePackage.ProposalResponse> sendProposalAsync(ProposalPackage.SignedProposal proposal) {
        try {
            this.checkSendProposal(proposal);
        }
        catch (Exception e) {
            CompletableFuture<ProposalResponsePackage.ProposalResponse> future = new CompletableFuture<ProposalResponsePackage.ProposalResponse>();
            future.completeExceptionally(e);
            return future;
        }
        if (IS_DEBUG_LEVEL) {
            logger.debug((Object)String.format("peer.sendProposalAsync %s", this.toString()));
        }
        EndorserClient localEndorserClient = this.getEndorserClient();
        return localEndorserClient.sendProposalAsync(proposal).exceptionally(throwable -> {
            this.removeEndorserClient(true);
            if (throwable instanceof CompletionException) {
                throw (CompletionException)throwable;
            }
            throw new CompletionException((Throwable)throwable);
        });
    }

    private synchronized EndorserClient getEndorserClient() {
        EndorserClient localEndorserClient = this.endorserClent;
        if (null == localEndorserClient || !localEndorserClient.isChannelActive()) {
            if (IS_TRACE_LEVEL) {
                logger.trace((Object)String.format("Channel %s creating new endorser client %s", this.channelName, this.toString()));
            }
            Endpoint endpoint = Endpoint.createEndpoint(this.url, this.properties);
            this.foundClientTLSCertificateDigest = true;
            this.clientTLSCertificateDigest = endpoint.getClientTLSCertificateDigest();
            localEndorserClient = new EndorserClient(this.channelName, this.name, this.url, endpoint.getChannelBuilder());
            if (IS_DEBUG_LEVEL) {
                logger.debug((Object)String.format("%s created new  %s", this.toString(), localEndorserClient.toString()));
            }
            this.endorserClent = localEndorserClient;
        }
        return localEndorserClient;
    }

    private synchronized void removeEndorserClient(boolean force) {
        EndorserClient localEndorserClient = this.endorserClent;
        this.endorserClent = null;
        if (null != localEndorserClient) {
            if (IS_DEBUG_LEVEL) {
                logger.debug((Object)String.format("Peer %s removing endorser client %s, isActive: %b", this.toString(), localEndorserClient.toString(), localEndorserClient.isChannelActive()));
            }
            try {
                localEndorserClient.shutdown(force);
            }
            catch (Exception e) {
                logger.warn((Object)(this.toString() + " error message: " + e.getMessage()));
            }
        }
    }

    CompletableFuture<Protocol.Response> sendDiscoveryRequestAsync(Protocol.SignedRequest discoveryRequest) {
        logger.debug((Object)String.format("peer.sendDiscoveryRequstAsync %s", this.toString()));
        EndorserClient localEndorserClient = this.getEndorserClient();
        return localEndorserClient.sendDiscoveryRequestAsync(discoveryRequest).exceptionally(throwable -> {
            this.removeEndorserClient(true);
            if (throwable instanceof CompletionException) {
                throw (CompletionException)throwable;
            }
            throw new CompletionException((Throwable)throwable);
        });
    }

    synchronized byte[] getClientTLSCertificateDigest() {
        byte[] lclientTLSCertificateDigest = this.clientTLSCertificateDigest;
        if (lclientTLSCertificateDigest == null && !this.foundClientTLSCertificateDigest) {
            this.foundClientTLSCertificateDigest = true;
            Endpoint endpoint = Endpoint.createEndpoint(this.url, this.properties);
            lclientTLSCertificateDigest = endpoint.getClientTLSCertificateDigest();
        }
        return lclientTLSCertificateDigest;
    }

    private void checkSendProposal(ProposalPackage.SignedProposal proposal) throws PeerException, InvalidArgumentException {
        if (this.shutdown) {
            throw new PeerException(String.format("%s was shutdown.", this.toString()));
        }
        if (proposal == null) {
            throw new PeerException(this.toString() + " Proposal is null");
        }
        Exception e = Utils.checkGrpcUrl(this.url);
        if (e != null) {
            throw new InvalidArgumentException("Bad peer url.", e);
        }
    }

    synchronized void shutdown(boolean force) {
        if (this.shutdown) {
            return;
        }
        String me = this.toString();
        logger.debug((Object)(me + " is shutting down."));
        this.shutdown = true;
        this.channel = null;
        this.lastBlockEvent = null;
        this.lastBlockNumber = -1L;
        this.removeEndorserClient(force);
        PeerEventServiceClient lpeerEventingClient = this.peerEventingClient;
        this.peerEventingClient = null;
        if (null != lpeerEventingClient) {
            logger.debug((Object)(me + " is shutting down " + lpeerEventingClient));
            lpeerEventingClient.shutdown(force);
        }
        logger.debug((Object)(me + " is shut down."));
    }

    String getEventingStatus() {
        PeerEventServiceClient lpeerEventingClient = this.peerEventingClient;
        if (null == lpeerEventingClient) {
            return " eventing client service not active.";
        }
        return lpeerEventingClient.getStatus();
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.shutdown) {
                logger.debug((Object)(this.toString() + " finalized without previous shutdown."));
            }
            this.shutdown(true);
        }
        finally {
            super.finalize();
        }
    }

    void reconnectPeerEventServiceClient(PeerEventServiceClient failedPeerEventServiceClient, final Throwable throwable) {
        Channel.PeerOptions peerOptions;
        if (this.shutdown) {
            logger.debug((Object)(this.toString() + "not reconnecting PeerEventServiceClient shutdown "));
            return;
        }
        PeerEventingServiceDisconnected ldisconnectedHandler = this.disconnectedHandler;
        if (null == ldisconnectedHandler) {
            return;
        }
        TransactionContext ltransactionContext = this.transactionContext;
        if (ltransactionContext == null) {
            logger.warn((Object)(this.toString() + " not reconnecting PeerEventServiceClient no transaction available "));
            return;
        }
        final TransactionContext fltransactionContext = ltransactionContext.retryTransactionSameContext();
        ExecutorService executorService = this.getExecutorService();
        Channel.PeerOptions peerOptions2 = peerOptions = null != failedPeerEventServiceClient.getPeerOptions() ? failedPeerEventServiceClient.getPeerOptions() : Channel.PeerOptions.createPeerOptions();
        if (!(this.shutdown || executorService == null || executorService.isShutdown() || executorService.isTerminated())) {
            executorService.execute(() -> ldisconnectedHandler.disconnected(new PeerEventingServiceDisconnectEvent(){

                @Override
                public BlockEvent getLatestBLockReceived() {
                    return Peer.this.lastBlockEvent;
                }

                @Override
                public long getLastConnectTime() {
                    return Peer.this.lastConnectTime;
                }

                @Override
                public long getReconnectCount() {
                    return Peer.this.reconnectCount.longValue();
                }

                @Override
                public Throwable getExceptionThrown() {
                    return throwable;
                }

                @Override
                public void reconnect(Long startBLockNumber) throws TransactionException {
                    logger.trace((Object)String.format("%s reconnecting. Starting block number: %s", Peer.this.toString(), startBLockNumber == null ? "newest" : startBLockNumber));
                    Peer.this.reconnectCount.getAndIncrement();
                    if (startBLockNumber == null) {
                        peerOptions.startEventsNewest();
                    } else {
                        peerOptions.startEvents(startBLockNumber);
                    }
                    if (!Peer.this.shutdown) {
                        PeerEventServiceClient lpeerEventingClient = new PeerEventServiceClient(Peer.this, Endpoint.createEndpoint(Peer.this.url, Peer.this.properties), Peer.this.properties, peerOptions);
                        lpeerEventingClient.connect(fltransactionContext);
                        Peer.this.peerEventingClient = lpeerEventingClient;
                    }
                }
            }));
        }
    }

    void setLastConnectTime(long lastConnectTime) {
        this.lastConnectTime = lastConnectTime;
    }

    void resetReconnectCount() {
        this.connected = true;
        this.reconnectCount = new AtomicLong(0L);
    }

    long getReconnectCount() {
        return this.reconnectCount.longValue();
    }

    synchronized void setTLSCertificateKeyPair(TLSCertificateKeyPair tlsCertificateKeyPair) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put("clientKeyBytes", tlsCertificateKeyPair.getKeyPemBytes());
        this.properties.put("clientCertBytes", tlsCertificateKeyPair.getCertPEMBytes());
        Endpoint endpoint = Endpoint.createEndpoint(this.url, this.properties);
        this.foundClientTLSCertificateDigest = true;
        this.clientTLSCertificateDigest = endpoint.getClientTLSCertificateDigest();
        this.removeEndorserClient(true);
        this.endorserClent = new EndorserClient(this.channelName, this.name, this.url, endpoint.getChannelBuilder());
    }

    void setHasConnected() {
        this.connected = true;
    }

    void setProperties(Properties properties) {
        this.properties = properties == null ? new Properties() : properties;
        this.toString = null;
    }

    private static PeerEventingServiceDisconnected getDefaultDisconnectHandler() {
        return new PeerEventingServiceDisconnected(){

            @Override
            public synchronized void disconnected(PeerEventingServiceDisconnectEvent event) {
                BlockEvent lastBlockEvent = event.getLatestBLockReceived();
                Throwable thrown = event.getExceptionThrown();
                long sleepTime = PEER_EVENT_RETRY_WAIT_TIME;
                if (thrown instanceof PeerEventingServiceException) {
                    sleepTime = Math.min(5000L, PEER_EVENT_RETRY_WAIT_TIME + event.getReconnectCount() * 100L);
                }
                Long startBlockNumber = null;
                if (null != lastBlockEvent) {
                    startBlockNumber = lastBlockEvent.getBlockNumber();
                }
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)(this.toString() + " " + e.getMessage()));
                }
                try {
                    event.reconnect(startBlockNumber);
                }
                catch (TransactionException e) {
                    logger.warn((Object)(this.toString() + " " + e.getMessage()));
                }
            }
        };
    }

    public PeerEventingServiceDisconnected getPeerEventingServiceDisconnected() {
        return this.disconnectedHandler;
    }

    public PeerEventingServiceDisconnected setPeerEventingServiceDisconnected(PeerEventingServiceDisconnected newPeerEventingServiceDisconnectedHandler) {
        PeerEventingServiceDisconnected ret = this.disconnectedHandler;
        this.disconnectedHandler = newPeerEventingServiceDisconnectedHandler;
        return ret;
    }

    synchronized void setLastBlockSeen(BlockEvent lastBlockSeen) {
        this.connected = true;
        long newLastBlockNumber = lastBlockSeen.getBlockNumber();
        if (this.lastBlockNumber < newLastBlockNumber) {
            this.lastBlockNumber = newLastBlockNumber;
            this.lastBlockEvent = lastBlockSeen;
            if (IS_TRACE_LEVEL) {
                logger.trace((Object)(this.toString() + " last block seen: " + this.lastBlockNumber));
            }
        }
    }

    String getEndpoint() {
        if (null == this.endPoint) {
            Properties properties = Utils.parseGrpcUrl(this.url);
            this.endPoint = properties.get("host") + ":" + properties.getProperty("port").toLowerCase().trim();
        }
        return this.endPoint;
    }

    public String getProtocol() {
        if (null == this.protocol) {
            Properties properties = Utils.parseGrpcUrl(this.url);
            this.protocol = properties.getProperty("protocol");
        }
        return this.protocol;
    }

    public String toString() {
        String ltoString = this.toString;
        if (ltoString == null) {
            String mspid = "";
            if (this.properties != null && !Utils.isNullOrEmpty(this.properties.getProperty(PEER_ORGANIZATION_MSPID_PROPERTY))) {
                mspid = ", mspid: " + this.properties.getProperty(PEER_ORGANIZATION_MSPID_PROPERTY);
            }
            this.toString = ltoString = "Peer{ id: " + this.id + ", name: " + this.name + ", channelName: " + this.channelName + ", url: " + this.url + mspid + "}";
        }
        return ltoString;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.disconnectedHandler = Peer.getDefaultDisconnectHandler();
        this.connected = false;
        this.reconnectCount = new AtomicLong(0L);
        this.id = config.getNextID();
        this.lastBlockNumber = -1L;
        logger.debug((Object)String.format("Reserialized peer: %s", this.toString()));
    }

    public static enum PeerRole {
        ENDORSING_PEER("endorsingPeer"),
        CHAINCODE_QUERY("chaincodeQuery"),
        LEDGER_QUERY("ledgerQuery"),
        EVENT_SOURCE("eventSource"),
        SERVICE_DISCOVERY("serviceDiscovery");

        public static final EnumSet<PeerRole> ALL;
        public static final EnumSet<PeerRole> NO_EVENT_SOURCE;
        private final String propertyName;

        private PeerRole(String propertyName) {
            this.propertyName = propertyName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        static {
            ALL = EnumSet.allOf(PeerRole.class);
            NO_EVENT_SOURCE = EnumSet.complementOf(EnumSet.of(EVENT_SOURCE));
        }
    }

    public static interface PeerEventingServiceDisconnectEvent {
        public BlockEvent getLatestBLockReceived();

        public long getLastConnectTime();

        public long getReconnectCount();

        public Throwable getExceptionThrown();

        public void reconnect(Long var1) throws TransactionException;
    }

    public static interface PeerEventingServiceDisconnected {
        public void disconnected(PeerEventingServiceDisconnectEvent var1);
    }
}

