/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.orderer.Ab;
import org.hyperledger.fabric.protos.peer.DeliverGrpc;
import org.hyperledger.fabric.protos.peer.EventsPackage;
import org.hyperledger.fabric.sdk.BlockEvent;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.Endpoint;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.exception.PeerEventingServiceException;
import org.hyperledger.fabric.sdk.exception.TransactionException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.transaction.ProtoUtils;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

class PeerEventServiceClient {
    private static final Config config = Config.getConfig();
    private static final long PEER_EVENT_REGISTRATION_WAIT_TIME = config.getPeerEventRegistrationWaitTime();
    private static final long PEER_EVENT_RECONNECTION_WARNING_RATE = config.getPeerEventReconnectionWarningRate();
    private static final Log logger = LogFactory.getLog(PeerEventServiceClient.class);
    private String channelName = null;
    private final ManagedChannelBuilder channelBuilder;
    private final String name;
    private final String url;
    private long peerEventRegistrationWaitTimeMilliSecs = PEER_EVENT_REGISTRATION_WAIT_TIME;
    private final Channel.PeerOptions peerOptions;
    private final boolean filterBlock;
    private byte[] clientTLSCertificateDigest;
    StreamObserver<Common.Envelope> nso = null;
    StreamObserver<EventsPackage.DeliverResponse> so = null;
    private Channel.ChannelEventQue channelEventQue;
    private volatile boolean shutdown = false;
    private ManagedChannel managedChannel = null;
    private Peer peer;
    private final String toString;

    PeerEventServiceClient(Peer peer, Endpoint endpoint, Properties properties, Channel.PeerOptions peerOptions) {
        this.channelBuilder = endpoint.getChannelBuilder();
        this.filterBlock = peerOptions.isRegisterEventsForFilteredBlocks();
        this.peer = peer;
        this.peerOptions = peerOptions;
        this.name = peer.getName();
        this.url = peer.getUrl();
        if (peer.isShutdown()) {
            logger.debug((Object)"PeerEventServiceClient not starting peer has shutdown.");
            this.shutdown = true;
            this.toString = "PeerEventServiceClient{id: " + config.getNextID() + ", channel: null, peerName: " + this.name + ", url: " + this.url + "}";
            return;
        }
        Channel channel = peer.getChannel();
        if (channel == null) {
            logger.debug((Object)"Peer no longer associated with a channel not connecting.");
            this.shutdown = true;
            this.toString = "PeerEventServiceClient{id: " + config.getNextID() + ", channel: null, peerName: " + this.name + ", url: " + this.url + "}";
            return;
        }
        this.channelName = channel.getName();
        this.toString = "PeerEventServiceClient{id: " + config.getNextID() + ", channel: " + this.channelName + ", peerName: " + this.name + ", url: " + this.url + "}";
        this.clientTLSCertificateDigest = endpoint.getClientTLSCertificateDigest();
        this.channelEventQue = channel.getChannelEventQue();
        if (null == properties) {
            this.peerEventRegistrationWaitTimeMilliSecs = PEER_EVENT_REGISTRATION_WAIT_TIME;
        } else {
            String peerEventRegistrationWaitTime = properties.getProperty("peerEventRegistrationWaitTime", Long.toString(PEER_EVENT_REGISTRATION_WAIT_TIME));
            long tempPeerWaitTimeMilliSecs = PEER_EVENT_REGISTRATION_WAIT_TIME;
            try {
                tempPeerWaitTimeMilliSecs = Long.parseLong(peerEventRegistrationWaitTime);
            }
            catch (NumberFormatException e) {
                logger.warn((Object)String.format("Peer event service registration %s wait time %s not parsable.", this.toString, peerEventRegistrationWaitTime), (Throwable)e);
            }
            this.peerEventRegistrationWaitTimeMilliSecs = tempPeerWaitTimeMilliSecs;
        }
    }

    Channel.PeerOptions getPeerOptions() {
        return this.peerOptions.clone();
    }

    public String toString() {
        return this.toString;
    }

    synchronized void shutdown(boolean force) {
        if (this.shutdown) {
            return;
        }
        String me = this.toString();
        logger.debug((Object)(me + " is shutting down."));
        this.shutdown = true;
        StreamObserver<EventsPackage.DeliverResponse> lsno = this.so;
        this.nso = null;
        this.so = null;
        if (null != lsno) {
            try {
                lsno.onCompleted();
            }
            catch (Exception e) {
                logger.error((Object)(this.toString() + " error message: " + e.getMessage()), (Throwable)e);
            }
        }
        ManagedChannel lchannel = this.managedChannel;
        this.managedChannel = null;
        if (lchannel != null) {
            if (force) {
                lchannel.shutdownNow();
            } else {
                boolean isTerminated = false;
                try {
                    isTerminated = lchannel.shutdown().awaitTermination(3L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    logger.debug((Object)(me + " error message: " + e.getMessage()), (Throwable)e);
                }
                if (!isTerminated) {
                    lchannel.shutdownNow();
                }
            }
        }
        this.channelEventQue = null;
        logger.debug((Object)(me + " is down."));
    }

    public void finalize() throws Throwable {
        try {
            this.shutdown(true);
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void connectEnvelope(Common.Envelope envelope) {
        if (this.shutdown) {
            logger.warn((Object)String.format("%s not connecting is shutdown.", this.toString()));
            return;
        }
        final AtomicBoolean retry = new AtomicBoolean(true);
        ManagedChannel lmanagedChannel = this.managedChannel;
        if (lmanagedChannel == null || lmanagedChannel.isTerminated() || lmanagedChannel.isShutdown()) {
            this.managedChannel = lmanagedChannel = this.channelBuilder.build();
        }
        DeliverGrpc.DeliverStub broadcast = DeliverGrpc.newStub((io.grpc.Channel)lmanagedChannel);
        final ArrayList<PeerEventingServiceException> throwableList = new ArrayList<PeerEventingServiceException>();
        final CountDownLatch finishLatch = new CountDownLatch(1);
        this.so = new StreamObserver<EventsPackage.DeliverResponse>(){

            public void onNext(EventsPackage.DeliverResponse resp) {
                logger.trace((Object)String.format("DeliverResponse %s resp status value:%d  status %s, typecase %s ", new Object[]{PeerEventServiceClient.this.toString(), resp.getStatusValue(), resp.getStatus(), resp.getTypeCase()}));
                EventsPackage.DeliverResponse.TypeCase typeCase = resp.getTypeCase();
                if (typeCase == EventsPackage.DeliverResponse.TypeCase.STATUS) {
                    logger.debug((Object)String.format("DeliverResponse  %s setting done.", PeerEventServiceClient.this.toString()));
                    if (resp.getStatus() == Common.Status.SUCCESS) {
                        PeerEventServiceClient.this.peer.setLastConnectTime(System.currentTimeMillis());
                        PeerEventServiceClient.this.peer.resetReconnectCount();
                    } else {
                        long rec = PeerEventServiceClient.this.peer.getReconnectCount();
                        PeerEventingServiceException peerEventingServiceException = new PeerEventingServiceException(String.format("%s attempts %s Status returned failure code %d (%s) during peer service event registration", PeerEventServiceClient.this.toString(), rec, resp.getStatusValue(), resp.getStatus().name()));
                        peerEventingServiceException.setResponse(resp);
                        if (rec % 10L == 0L) {
                            logger.warn((Object)(PeerEventServiceClient.this.toString() + " " + peerEventingServiceException.getMessage()));
                        }
                        throwableList.add(peerEventingServiceException);
                    }
                } else if (typeCase == EventsPackage.DeliverResponse.TypeCase.FILTERED_BLOCK || typeCase == EventsPackage.DeliverResponse.TypeCase.BLOCK) {
                    if (typeCase == EventsPackage.DeliverResponse.TypeCase.BLOCK) {
                        logger.trace((Object)String.format("%s got event block hex hashcode: %016x, block number: %d", PeerEventServiceClient.this.toString(), resp.getBlock().hashCode(), resp.getBlock().getHeader().getNumber()));
                    } else {
                        logger.trace((Object)String.format("%s got event block hex hashcode: %016x, block number: %d", PeerEventServiceClient.this.toString(), resp.getFilteredBlock().hashCode(), resp.getFilteredBlock().getNumber()));
                    }
                    PeerEventServiceClient.this.peer.setLastConnectTime(System.currentTimeMillis());
                    long reconnectCount = PeerEventServiceClient.this.peer.getReconnectCount();
                    if (reconnectCount > 1L) {
                        logger.info((Object)String.format("%s reconnected after %d attempts on channel %s, peer %s, url %s", PeerEventServiceClient.this.toString(), reconnectCount, PeerEventServiceClient.this.channelName, PeerEventServiceClient.this.name, PeerEventServiceClient.this.url));
                    }
                    PeerEventServiceClient.this.peer.resetReconnectCount();
                    BlockEvent blockEvent = new BlockEvent(PeerEventServiceClient.this.peer, resp);
                    PeerEventServiceClient.this.peer.setLastBlockSeen(blockEvent);
                    PeerEventServiceClient.this.channelEventQue.addBEvent(blockEvent);
                } else {
                    logger.error((Object)String.format("%s got event block with unknown type: %s, %d", PeerEventServiceClient.this.toString(), typeCase.name(), typeCase.getNumber()));
                    PeerEventingServiceException peerEventingServiceException = new PeerEventingServiceException(String.format("%s got event block with unknown type: %s, %d", PeerEventServiceClient.this.toString(), typeCase.name(), typeCase.getNumber()));
                    peerEventingServiceException.setResponse(resp);
                    throwableList.add(peerEventingServiceException);
                }
                finishLatch.countDown();
            }

            public void onError(Throwable t) {
                ManagedChannel llmanagedChannel = PeerEventServiceClient.this.managedChannel;
                if (llmanagedChannel != null) {
                    try {
                        llmanagedChannel.shutdownNow();
                    }
                    catch (Exception e) {
                        logger.warn((Object)String.format("Received error on %s, attempts %d. %s shut down of grpc channel.", PeerEventServiceClient.this.toString(), PeerEventServiceClient.this.peer == null ? -1L : PeerEventServiceClient.this.peer.getReconnectCount(), e.getMessage()), (Throwable)e);
                    }
                    PeerEventServiceClient.this.managedChannel = null;
                }
                if (!PeerEventServiceClient.this.shutdown) {
                    long reconnectCount = PeerEventServiceClient.this.peer.getReconnectCount();
                    if (PEER_EVENT_RECONNECTION_WARNING_RATE > 1L && reconnectCount % PEER_EVENT_RECONNECTION_WARNING_RATE == 1L) {
                        logger.warn((Object)String.format("Received error on  %s, attempts %d. %s", PeerEventServiceClient.this.toString(), reconnectCount, t.getMessage()));
                    } else {
                        logger.trace((Object)String.format("Received error on %s, attempts %d. %s", PeerEventServiceClient.this.toString(), reconnectCount, t.getMessage()));
                    }
                    if (retry.getAndSet(false)) {
                        PeerEventServiceClient.this.peer.reconnectPeerEventServiceClient(PeerEventServiceClient.this, t);
                    }
                }
                finishLatch.countDown();
            }

            public void onCompleted() {
                logger.debug((Object)String.format("DeliverResponse onCompleted %s setting done.", PeerEventServiceClient.this.toString()));
                finishLatch.countDown();
            }
        };
        this.nso = this.filterBlock ? broadcast.deliverFiltered(this.so) : broadcast.deliver(this.so);
        this.nso.onNext((Object)envelope);
        if (!finishLatch.await(this.peerEventRegistrationWaitTimeMilliSecs, TimeUnit.MILLISECONDS)) {
            PeerEventingServiceException ex = new PeerEventingServiceException(String.format("Channel %s connect time exceeded for peer eventing service %s, timed out at %d ms.", this.channelName, this.name, this.peerEventRegistrationWaitTimeMilliSecs));
            ex.setTimedOut(this.peerEventRegistrationWaitTimeMilliSecs);
            logger.warn((Object)(this.toString() + " " + ex.getMessage()));
            throwableList.add(0, ex);
        }
        logger.trace((Object)(this.toString() + " done waiting for reply!"));
        if (!throwableList.isEmpty()) {
            ManagedChannel llmanagedChannel = this.managedChannel;
            if (llmanagedChannel != null) {
                llmanagedChannel.shutdownNow();
                this.managedChannel = null;
            }
            Throwable throwable = (Throwable)throwableList.get(0);
            if (retry.getAndSet(false)) {
                this.peer.reconnectPeerEventServiceClient(this, throwable);
            }
        }
        if (null == this.nso) return;
        try {
            this.nso.onCompleted();
            return;
        }
        catch (Exception e) {
            logger.debug((Object)String.format("Exception completing connect with %s %s", this.toString(), e.getMessage()), (Throwable)e);
        }
        return;
        catch (InterruptedException e) {
            try {
                ManagedChannel llmanagedChannel = this.managedChannel;
                if (llmanagedChannel != null) {
                    llmanagedChannel.shutdownNow();
                    this.managedChannel = null;
                }
                logger.error((Object)(this.toString() + " error message: " + e.getMessage()), (Throwable)e);
                if (retry.getAndSet(false)) {
                    this.peer.reconnectPeerEventServiceClient(this, e);
                }
                if (null == this.nso) return;
            }
            catch (Throwable throwable) {
                if (null == this.nso) throw throwable;
                try {
                    this.nso.onCompleted();
                    throw throwable;
                }
                catch (Exception e2) {
                    logger.debug((Object)String.format("Exception completing connect with %s %s", this.toString(), e2.getMessage()), (Throwable)e2);
                }
                throw throwable;
            }
            try {
                this.nso.onCompleted();
                return;
            }
            catch (Exception e3) {
                logger.debug((Object)String.format("Exception completing connect with %s %s", this.toString(), e3.getMessage()), (Throwable)e3);
            }
            return;
        }
    }

    boolean isChannelActive() {
        ManagedChannel lchannel = this.managedChannel;
        return lchannel != null && !lchannel.isShutdown() && !lchannel.isTerminated();
    }

    void connect(TransactionContext transactionContext) throws TransactionException {
        if (this.shutdown) {
            return;
        }
        this.peerVent(transactionContext);
    }

    private void peerVent(TransactionContext transactionContext) throws TransactionException {
        logger.trace((Object)(this.toString() + "peerVent  transaction: " + transactionContext));
        if (this.shutdown) {
            logger.debug((Object)"peerVent not starting, shutting down.");
            return;
        }
        try {
            Ab.SeekPosition.Builder start = Ab.SeekPosition.newBuilder();
            if (null != this.peerOptions.getNewest()) {
                start.setNewest(Ab.SeekNewest.getDefaultInstance());
            } else if (this.peerOptions.getStartEvents() != null) {
                start.setSpecified(Ab.SeekSpecified.newBuilder().setNumber(this.peerOptions.getStartEvents()));
            } else {
                start.setNewest(Ab.SeekNewest.getDefaultInstance());
            }
            Common.Envelope envelope = ProtoUtils.createSeekInfoEnvelope(transactionContext, start.build(), Ab.SeekPosition.newBuilder().setSpecified(Ab.SeekSpecified.newBuilder().setNumber(this.peerOptions.getStopEvents()).build()).build(), Ab.SeekInfo.SeekBehavior.BLOCK_UNTIL_READY, this.clientTLSCertificateDigest);
            this.connectEnvelope(envelope);
        }
        catch (Exception e) {
            throw new TransactionException(this.toString() + " error message: " + e.getMessage(), e);
        }
    }

    String getStatus() {
        ManagedChannel lmanagedChannel = this.managedChannel;
        if (lmanagedChannel == null) {
            return "No grpc managed channel active. peer eventing client service is shutdown: " + this.shutdown;
        }
        return "peer eventing client service is shutdown: " + this.shutdown + ", grpc isShutdown: " + lmanagedChannel.isShutdown() + ", grpc isTerminated: " + lmanagedChannel.isTerminated() + ", grpc state: " + lmanagedChannel.getState(false);
    }
}

