/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.ref.WeakReference;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.common.Common;
import org.hyperledger.fabric.protos.ledger.rwset.Rwset;
import org.hyperledger.fabric.protos.msp.Identities;
import org.hyperledger.fabric.protos.peer.ProposalPackage;
import org.hyperledger.fabric.protos.peer.ProposalResponsePackage;
import org.hyperledger.fabric.sdk.ChaincodeID;
import org.hyperledger.fabric.sdk.ChaincodeResponse;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.ProposalResponsePayloadDeserializer;
import org.hyperledger.fabric.sdk.TxReadWriteSetInfo;
import org.hyperledger.fabric.sdk.exception.CryptoException;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.exception.ProposalException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.DiagnosticFileDumper;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.security.CryptoSuite;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

public class ProposalResponse
extends ChaincodeResponse {
    private static final Log logger = LogFactory.getLog(ProposalResponse.class);
    private static final Config config = Config.getConfig();
    private static final boolean IS_TRACE_LEVEL = logger.isTraceEnabled();
    private static final DiagnosticFileDumper diagnosticFileDumper = IS_TRACE_LEVEL ? config.getDiagnosticFileDumper() : null;
    private boolean isVerified = false;
    private boolean hasBeenVerified = false;
    private WeakReference<ProposalResponsePayloadDeserializer> proposalResponsePayload;
    private ProposalPackage.Proposal proposal;
    private ProposalResponsePackage.ProposalResponse proposalResponse;
    private Peer peer = null;
    private ChaincodeID chaincodeID = null;
    private final TransactionContext transactionContext;

    ProposalResponse(TransactionContext transactionContext, int status, String message) {
        super(transactionContext.getTxID(), transactionContext.getChannelID(), status, message);
        this.transactionContext = transactionContext;
    }

    TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    ProposalResponsePayloadDeserializer getProposalResponsePayloadDeserializer() throws InvalidArgumentException {
        if (this.isInvalid()) {
            throw new InvalidArgumentException("Proposal response is invalid.");
        }
        ProposalResponsePayloadDeserializer ret = null;
        if (this.proposalResponsePayload != null) {
            ret = (ProposalResponsePayloadDeserializer)this.proposalResponsePayload.get();
        }
        if (ret == null) {
            try {
                ret = new ProposalResponsePayloadDeserializer(this.proposalResponse.getPayload());
            }
            catch (Exception e) {
                throw new InvalidArgumentException(e);
            }
            this.proposalResponsePayload = new WeakReference<ProposalResponsePayloadDeserializer>(ret);
        }
        return ret;
    }

    ByteString getPayloadBytes() {
        return this.proposalResponse.getPayload();
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean verify(CryptoSuite crypto) {
        logger.trace((Object)String.format("%s verifying transaction: %s endorsement.", this.peer, this.getTransactionID()));
        if (this.hasBeenVerified) {
            logger.trace((Object)String.format("%s transaction: %s was already verified returned %b", this.peer, this.getTransactionID(), this.isVerified));
            return this.isVerified;
        }
        try {
            if (this.isInvalid()) {
                this.isVerified = false;
                logger.debug((Object)String.format("%s for transaction %s returned invalid. Setting verify to false", this.peer, this.getTransactionID()));
                boolean bl = false;
                return bl;
            }
            ProposalResponsePackage.Endorsement endorsement = this.proposalResponse.getEndorsement();
            ByteString sig = endorsement.getSignature();
            byte[] endorserCertifcate = null;
            byte[] signature = null;
            byte[] data = null;
            try {
                Identities.SerializedIdentity endorser = Identities.SerializedIdentity.parseFrom(endorsement.getEndorser());
                ByteString plainText = this.proposalResponse.getPayload().concat(endorsement.getEndorser());
                if (config.extraLogLevel(10) && null != diagnosticFileDumper) {
                    StringBuilder sb = new StringBuilder(10000);
                    sb.append("payload TransactionBuilderbytes in hex: " + DatatypeConverter.printHexBinary((byte[])this.proposalResponse.getPayload().toByteArray()));
                    sb.append("\n");
                    sb.append("endorser bytes in hex: " + DatatypeConverter.printHexBinary((byte[])endorsement.getEndorser().toByteArray()));
                    sb.append("\n");
                    sb.append("plainText bytes in hex: " + DatatypeConverter.printHexBinary((byte[])plainText.toByteArray()));
                    logger.trace((Object)("payload TransactionBuilderbytes:  " + diagnosticFileDumper.createDiagnosticFile(sb.toString())));
                }
                if (sig == null || sig.isEmpty()) {
                    logger.warn((Object)String.format("%s %s returned signature is empty verify set to false.", this.peer, this.getTransactionID()));
                    this.isVerified = false;
                } else {
                    endorserCertifcate = endorser.getIdBytes().toByteArray();
                    signature = sig.toByteArray();
                    data = plainText.toByteArray();
                    this.isVerified = crypto.verify(endorserCertifcate, config.getSignatureAlgorithm(), signature, data);
                    if (!this.isVerified) {
                        logger.warn((Object)String.format("%s transaction: %s verify: Failed to verify. Endorsers certificate: %s, signature: %s, signing algorithm: %s, signed data: %s.", this.peer, this.getTransactionID(), Utils.toHexString(endorserCertifcate), Utils.toHexString(signature), config.getSignatureAlgorithm(), Utils.toHexString(data)));
                    }
                }
            }
            catch (InvalidProtocolBufferException | CryptoException e) {
                logger.error((Object)String.format("%s transaction: %s verify: Failed to verify. Endorsers certificate: %s, signature: %s, signing algorithm: %s, signed data: %s.", this.peer, this.getTransactionID(), Utils.toHexString(endorserCertifcate), Utils.toHexString(signature), config.getSignatureAlgorithm(), Utils.toHexString(data)), e);
                logger.error((Object)String.format("%s transaction: %s verify: Cannot retrieve peer identity from ProposalResponse. Error is: %s", this.peer, this.getTransactionID(), e.getMessage()), e);
                this.isVerified = false;
            }
            logger.debug((Object)String.format("%s finished verify for transaction %s returning %b", this.peer, this.getTransactionID(), this.isVerified));
            boolean bl = this.isVerified;
            return bl;
        }
        finally {
            this.hasBeenVerified = true;
        }
    }

    public ProposalPackage.Proposal getProposal() {
        return this.proposal;
    }

    public void setProposal(ProposalPackage.SignedProposal signedProposal) throws ProposalException {
        try {
            this.proposal = ProposalPackage.Proposal.parseFrom(signedProposal.getProposalBytes());
        }
        catch (InvalidProtocolBufferException e) {
            throw new ProposalException(String.format("%s transaction: %s Proposal exception", this.peer, this.getTransactionID()), (Exception)((Object)e));
        }
    }

    public ProposalResponsePackage.ProposalResponse getProposalResponse() {
        return this.proposalResponse;
    }

    public void setProposalResponse(ProposalResponsePackage.ProposalResponse proposalResponse) {
        this.proposalResponse = proposalResponse;
    }

    public Peer getPeer() {
        return this.peer;
    }

    void setPeer(Peer peer) {
        this.peer = peer;
    }

    public ChaincodeID getChaincodeID() throws InvalidArgumentException {
        try {
            if (this.chaincodeID == null) {
                Common.Header header = Common.Header.parseFrom(this.proposal.getHeader());
                Common.ChannelHeader channelHeader = Common.ChannelHeader.parseFrom(header.getChannelHeader());
                ProposalPackage.ChaincodeHeaderExtension chaincodeHeaderExtension = ProposalPackage.ChaincodeHeaderExtension.parseFrom(channelHeader.getExtension());
                this.chaincodeID = new ChaincodeID(chaincodeHeaderExtension.getChaincodeId());
            }
            return this.chaincodeID;
        }
        catch (Exception e) {
            throw new InvalidArgumentException(e);
        }
    }

    public byte[] getChaincodeActionResponsePayload() throws InvalidArgumentException {
        if (this.isInvalid()) {
            throw new InvalidArgumentException("Proposal response is invalid.");
        }
        try {
            ProposalResponsePayloadDeserializer proposalResponsePayloadDeserializer = this.getProposalResponsePayloadDeserializer();
            ByteString ret = proposalResponsePayloadDeserializer.getExtension().getChaincodeAction().getResponse().getPayload();
            return ret != null ? ret.toByteArray() : null;
        }
        catch (InvalidArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidArgumentException(e);
        }
    }

    public int getChaincodeActionResponseStatus() throws InvalidArgumentException {
        if (this.statusReturnCode != -1) {
            return this.statusReturnCode;
        }
        try {
            ProposalResponsePayloadDeserializer proposalResponsePayloadDeserializer = this.getProposalResponsePayloadDeserializer();
            this.statusReturnCode = proposalResponsePayloadDeserializer.getExtension().getResponseStatus();
            return this.statusReturnCode;
        }
        catch (InvalidArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidArgumentException(e);
        }
    }

    public TxReadWriteSetInfo getChaincodeActionResponseReadWriteSetInfo() throws InvalidArgumentException {
        if (this.isInvalid()) {
            throw new InvalidArgumentException("Proposal response is invalid.");
        }
        try {
            ProposalResponsePayloadDeserializer proposalResponsePayloadDeserializer = this.getProposalResponsePayloadDeserializer();
            Rwset.TxReadWriteSet txReadWriteSet = proposalResponsePayloadDeserializer.getExtension().getResults();
            return txReadWriteSet != null ? new TxReadWriteSetInfo(txReadWriteSet) : null;
        }
        catch (Exception e) {
            throw new InvalidArgumentException(e);
        }
    }
}

