/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.hyperledger.fabric.sdk.HFClient;
import org.hyperledger.fabric.sdk.ProposalResponse;
import org.hyperledger.fabric.sdk.exception.InvalidArgumentException;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.security.CryptoSuite;

public class SDKUtils {
    private static final Log logger = LogFactory.getLog(SDKUtils.class);
    private static final boolean IS_DEBUG_LEVEL = logger.isDebugEnabled();
    public static CryptoSuite suite = null;

    private SDKUtils() {
    }

    public static byte[] calculateBlockHash(HFClient client, long blockNumber, byte[] previousHash, byte[] dataHash) throws IOException, InvalidArgumentException {
        if (previousHash == null) {
            throw new InvalidArgumentException("previousHash parameter is null.");
        }
        if (dataHash == null) {
            throw new InvalidArgumentException("dataHash parameter is null.");
        }
        if (null == client) {
            throw new InvalidArgumentException("client parameter is null.");
        }
        CryptoSuite cryptoSuite = client.getCryptoSuite();
        if (null == cryptoSuite) {
            throw new InvalidArgumentException("Client crypto suite has not  been set.");
        }
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        DERSequenceGenerator seq = new DERSequenceGenerator((OutputStream)s);
        seq.addObject((ASN1Encodable)new ASN1Integer(blockNumber));
        seq.addObject((ASN1Encodable)new DEROctetString(previousHash));
        seq.addObject((ASN1Encodable)new DEROctetString(dataHash));
        seq.close();
        return cryptoSuite.hash(s.toByteArray());
    }

    public static Collection<Set<ProposalResponse>> getProposalConsistencySets(Collection<ProposalResponse> proposalResponses) throws InvalidArgumentException {
        return SDKUtils.getProposalConsistencySets(proposalResponses, new HashSet<ProposalResponse>());
    }

    /*
     * WARNING - void declaration
     */
    public static Collection<Set<ProposalResponse>> getProposalConsistencySets(Collection<? extends ProposalResponse> proposalResponses, Set<ProposalResponse> invalid) throws InvalidArgumentException {
        if (proposalResponses == null) {
            throw new InvalidArgumentException("proposalResponses collection is null");
        }
        if (proposalResponses.isEmpty()) {
            throw new InvalidArgumentException("proposalResponses collection is empty");
        }
        if (null == invalid) {
            throw new InvalidArgumentException("invalid set is null.");
        }
        HashMap<ByteString, Set> ret = new HashMap<ByteString, Set>();
        for (ProposalResponse proposalResponse : proposalResponses) {
            if (proposalResponse.isInvalid()) {
                invalid.add(proposalResponse);
                continue;
            }
            ByteString payloadBytes = proposalResponse.getPayloadBytes();
            if (payloadBytes == null) {
                throw new InvalidArgumentException(String.format("proposalResponse.getPayloadBytes() was null from peer: %s.", proposalResponse.getPeer()));
            }
            if (payloadBytes.isEmpty()) {
                throw new InvalidArgumentException(String.format("proposalResponse.getPayloadBytes() was empty from peer: %s.", proposalResponse.getPeer()));
            }
            Set set = ret.computeIfAbsent(payloadBytes, k -> new HashSet());
            set.add(proposalResponse);
        }
        if (IS_DEBUG_LEVEL && ret.size() > 1) {
            StringBuilder sb = new StringBuilder(1000);
            boolean bl = false;
            String sep = "";
            for (Map.Entry entry : ret.entrySet()) {
                void var4_6;
                ByteString bytes = (ByteString)entry.getKey();
                Set presp = (Set)entry.getValue();
                sb.append(sep).append("Consistency set: ").append((int)(++var4_6)).append(" bytes size: ").append(bytes.size()).append(" bytes: ").append(Utils.toHexString(bytes.toByteArray())).append(" [");
                String psep = "";
                for (ProposalResponse proposalResponse : presp) {
                    sb.append(psep).append(proposalResponse.getPeer());
                    psep = ", ";
                }
                sb.append("]");
                sep = ", ";
            }
            logger.debug((Object)sb.toString());
        }
        return ret.values();
    }
}

