/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.protos.discovery.Protocol;
import org.hyperledger.fabric.protos.gossip.Message;
import org.hyperledger.fabric.protos.msp.Identities;
import org.hyperledger.fabric.protos.msp.MspConfigPackage;
import org.hyperledger.fabric.sdk.Channel;
import org.hyperledger.fabric.sdk.Peer;
import org.hyperledger.fabric.sdk.exception.InvalidProtocolBufferRuntimeException;
import org.hyperledger.fabric.sdk.exception.ServiceDiscoveryException;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.helper.DiagnosticFileDumper;
import org.hyperledger.fabric.sdk.helper.Utils;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

public class ServiceDiscovery {
    private static final Log logger = LogFactory.getLog(ServiceDiscovery.class);
    private static final boolean DEBUG = logger.isDebugEnabled();
    private static final Config config = Config.getConfig();
    private static final boolean IS_TRACE_LEVEL = logger.isTraceEnabled();
    private static final DiagnosticFileDumper diagnosticFileDumper = IS_TRACE_LEVEL ? config.getDiagnosticFileDumper() : null;
    private static final int SERVICE_DISCOVERY_WAITTIME = config.getServiceDiscoveryWaitTime();
    private static final Random random = new Random();
    private final Collection<Peer> serviceDiscoveryPeers;
    private final Channel channel;
    private final TransactionContext transactionContext;
    private final String channelName;
    private volatile Map<String, SDChaindcode> chaindcodeMap = new HashMap<String, SDChaindcode>();
    private static final boolean asLocalhost = config.discoverAsLocalhost();
    private volatile SDNetwork sdNetwork = null;
    private final Set<ByteString> certs = ConcurrentHashMap.newKeySet();
    static final EndorsementSelector ENDORSEMENT_SELECTION_LEAST_REQUIRED_BLOCKHEIGHT;
    public static final EndorsementSelector DEFAULT_ENDORSEMENT_SELECTION;
    public static final EndorsementSelector ENDORSEMENT_SELECTION_RANDOM;
    private ScheduledFuture<?> seviceDiscovery = null;
    private static final int SERVICE_DISCOVER_FREQ_SECONDS;

    ServiceDiscovery(Channel channel, Collection<Peer> serviceDiscoveryPeers, TransactionContext transactionContext) {
        this.serviceDiscoveryPeers = serviceDiscoveryPeers;
        this.channel = channel;
        this.channelName = channel.getName();
        this.transactionContext = transactionContext.retryTransactionSameContext();
    }

    SDChaindcode discoverEndorserEndpoint(TransactionContext transactionContext, String name) throws ServiceDiscoveryException {
        SDChaindcode sdChaindcode;
        Map<String, SDChaindcode> lchaindcodeMap = this.chaindcodeMap;
        if (lchaindcodeMap != null && null != (sdChaindcode = lchaindcodeMap.get(name))) {
            return sdChaindcode;
        }
        Channel.ServiceDiscoveryChaincodeCalls serviceDiscoveryChaincodeCalls = new Channel.ServiceDiscoveryChaincodeCalls(name);
        LinkedList<Channel.ServiceDiscoveryChaincodeCalls> cc = new LinkedList<Channel.ServiceDiscoveryChaincodeCalls>();
        cc.add(serviceDiscoveryChaincodeCalls);
        LinkedList<List<Channel.ServiceDiscoveryChaincodeCalls>> ccl = new LinkedList<List<Channel.ServiceDiscoveryChaincodeCalls>>();
        ccl.add(cc);
        Map<String, SDChaindcode> dchaindcodeMap = this.discoverEndorserEndpoints(transactionContext, ccl);
        SDChaindcode sdChaindcode2 = dchaindcodeMap.get(name);
        if (null == sdChaindcode2) {
            throw new ServiceDiscoveryException(String.format("Failed to find any endorsers for chaincode %s. See logs for details", name));
        }
        return sdChaindcode2;
    }

    Collection<String> getDiscoveredChaincodeNames() {
        SDNetwork lsdNetwork = this.fullNetworkDiscovery(false);
        if (null == lsdNetwork) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(lsdNetwork.getChaincodesNames());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SDNetwork networkDiscovery(TransactionContext ltransactionContext, boolean force) {
        logger.trace((Object)String.format("Network discovery force: %b", force));
        ArrayList<Peer> speers = new ArrayList<Peer>(this.serviceDiscoveryPeers);
        Collections.shuffle(speers);
        SDNetwork ret = this.sdNetwork;
        if (!force && null != ret && ret.discoveryTime + (long)(SERVICE_DISCOVER_FREQ_SECONDS * 1000) > System.currentTimeMillis()) {
            return ret;
        }
        ret = null;
        for (Peer serviceDiscoveryPeer : speers) {
            try {
                Object discoveredAlready;
                URI serviceDiscoveryPeerURI = URI.create(serviceDiscoveryPeer.getUrl());
                boolean isTLS = serviceDiscoveryPeerURI.getScheme().equals("grpcs");
                logger.trace((Object)String.format("Service discovery peer %s using TLS: %b", serviceDiscoveryPeerURI.toString(), isTLS));
                SDNetwork lsdNetwork = new SDNetwork();
                byte[] clientTLSCertificateDigest = serviceDiscoveryPeer.getClientTLSCertificateDigest();
                logger.info((Object)String.format("Channel %s doing discovery with peer: %s", this.channelName, serviceDiscoveryPeer.toString()));
                if (null == clientTLSCertificateDigest) {
                    throw new RuntimeException(String.format("Channel %s, peer %s requires mutual tls for service discovery.", this.channelName, serviceDiscoveryPeer));
                }
                ByteString clientIdent = ltransactionContext.getIdentity().toByteString();
                ByteString tlshash = ByteString.copyFrom((byte[])clientTLSCertificateDigest);
                Protocol.AuthInfo authentication = Protocol.AuthInfo.newBuilder().setClientIdentity(clientIdent).setClientTlsCertHash(tlshash).build();
                ArrayList<Protocol.Query> fq = new ArrayList<Protocol.Query>(2);
                fq.add(Protocol.Query.newBuilder().setChannel(this.channelName).setConfigQuery(Protocol.ConfigQuery.newBuilder().build()).build());
                fq.add(Protocol.Query.newBuilder().setChannel(this.channelName).setPeerQuery(Protocol.PeerMembershipQuery.newBuilder().build()).build());
                Protocol.Request request = Protocol.Request.newBuilder().addAllQueries(fq).setAuthentication(authentication).build();
                ByteString payloadBytes = request.toByteString();
                ByteString signatureBytes = ltransactionContext.signByteStrings(payloadBytes);
                Protocol.SignedRequest sr = Protocol.SignedRequest.newBuilder().setPayload(payloadBytes).setSignature(signatureBytes).build();
                if (IS_TRACE_LEVEL && null != diagnosticFileDumper) {
                    logger.trace((Object)String.format("Service discovery channel %s %s service chaincode query sent %s", this.channelName, serviceDiscoveryPeer, diagnosticFileDumper.createDiagnosticProtobufFile(sr.toByteArray())));
                }
                Protocol.Response response = serviceDiscoveryPeer.sendDiscoveryRequestAsync(sr).get(SERVICE_DISCOVERY_WAITTIME, TimeUnit.MILLISECONDS);
                if (IS_TRACE_LEVEL && null != diagnosticFileDumper) {
                    logger.trace((Object)String.format("Service discovery channel %s %s service discovery returned %s", this.channelName, serviceDiscoveryPeer, diagnosticFileDumper.createDiagnosticProtobufFile(response.toByteArray())));
                }
                serviceDiscoveryPeer.hasConnected();
                List<Protocol.QueryResult> resultsList = response.getResultsList();
                Protocol.QueryResult queryResult = resultsList.get(0);
                if (queryResult.getResultCase().getNumber() == 1) {
                    logger.warn((Object)String.format("Channel %s peer: %s error during service discovery %s", this.channelName, serviceDiscoveryPeer.toString(), queryResult.getError().getContent()));
                    continue;
                }
                Protocol.QueryResult queryResult2 = resultsList.get(1);
                if (queryResult2.getResultCase().getNumber() == 1) {
                    logger.warn((Object)String.format("Channel %s peer %s service discovery error %s", this.channelName, serviceDiscoveryPeer.toString(), queryResult2.getError().getContent()));
                    continue;
                }
                Protocol.ConfigResult configResult = queryResult.getConfigResult();
                Map<String, MspConfigPackage.FabricMSPConfig> msps = configResult.getMspsMap();
                HashSet<ByteString> cbbs = new HashSet<ByteString>(msps.size() * 4);
                for (Map.Entry<String, MspConfigPackage.FabricMSPConfig> entry : msps.entrySet()) {
                    MspConfigPackage.FabricMSPConfig value = entry.getValue();
                    String mspid = value.getName();
                    cbbs.addAll(value.getRootCertsList());
                    cbbs.addAll(value.getIntermediateCertsList());
                    value.getTlsRootCertsList().forEach(bytes -> lsdNetwork.addTlsCert(mspid, bytes.toByteArray()));
                    value.getTlsIntermediateCertsList().forEach(bytes -> lsdNetwork.addTlsIntermCert(mspid, bytes.toByteArray()));
                }
                LinkedList<byte[]> toaddCerts = new LinkedList<byte[]>();
                Set<ByteString> set = this.certs;
                synchronized (set) {
                    cbbs.forEach(bytes -> {
                        if (this.certs.add((ByteString)bytes)) {
                            toaddCerts.add(bytes.toByteArray());
                        }
                    });
                }
                if (!toaddCerts.isEmpty()) {
                    this.channel.client.getCryptoSuite().loadCACertificatesAsBytes(toaddCerts);
                }
                HashMap<String, SDOrderer> hashMap = new HashMap<String, SDOrderer>();
                Map<String, Protocol.Endpoints> orderersMap = configResult.getOrderersMap();
                for (Map.Entry entry : orderersMap.entrySet()) {
                    String mspid = (String)entry.getKey();
                    Protocol.Endpoints value = (Protocol.Endpoints)entry.getValue();
                    for (Protocol.Endpoint l : value.getEndpointList()) {
                        logger.trace((Object)String.format("Channel: %s peer: %s discovered orderer MSPID: %s, endpoint: %s:%s", this.channelName, serviceDiscoveryPeer, mspid, l.getHost(), l.getPort()));
                        String host = asLocalhost ? "localhost" : l.getHost();
                        String endpoint = (host + ":" + l.getPort()).trim().toLowerCase();
                        discoveredAlready = (SDOrderer)hashMap.get(endpoint);
                        if (discoveredAlready != null) {
                            if (!mspid.equals(((SDOrderer)discoveredAlready).getMspid())) {
                                logger.error((Object)String.format("Service discovery in channel: %s, peer: %s found Orderer endpoint: %s with two mspids: '%s', '%s'", this.channelName, serviceDiscoveryPeer, endpoint, mspid, ((SDOrderer)discoveredAlready).getMspid()));
                                continue;
                            }
                            logger.debug((Object)String.format("Service discovery in channel: %s, peer: %s found Orderer endpoint: %s mspid: %s discovered twice", this.channelName, serviceDiscoveryPeer, endpoint, mspid));
                            continue;
                        }
                        Properties properties = new Properties();
                        if (asLocalhost) {
                            properties.put("hostnameOverride", l.getHost());
                        }
                        SDOrderer sdOrderer = new SDOrderer(mspid, endpoint, lsdNetwork.getTlsCerts(mspid), lsdNetwork.getTlsIntermediateCerts(mspid), properties, isTLS);
                        hashMap.put(sdOrderer.getEndPoint(), sdOrderer);
                    }
                }
                lsdNetwork.ordererEndpoints = hashMap;
                Protocol.PeerMembershipResult membership = queryResult2.getMembers();
                lsdNetwork.endorsers = new HashMap<String, SDEndorser>();
                for (Map.Entry<String, Protocol.Peers> peers : membership.getPeersByOrgMap().entrySet()) {
                    String mspId = peers.getKey();
                    Protocol.Peers peer = peers.getValue();
                    for (Protocol.Peer pp : peer.getPeersList()) {
                        SDEndorser ppp = new SDEndorser(pp, lsdNetwork.getTlsCerts(mspId), lsdNetwork.getTlsIntermediateCerts(mspId), asLocalhost, isTLS);
                        discoveredAlready = lsdNetwork.endorsers.get(ppp.getEndpoint());
                        if (null != discoveredAlready) {
                            if (!mspId.equals(((SDEndorser)discoveredAlready).getMspid())) {
                                logger.error((Object)String.format("Service discovery in channel: %s, peer: %s,  found endorser endpoint: %s with two mspids: '%s', '%s'", this.channelName, serviceDiscoveryPeer, ppp.getEndpoint(), mspId, ((SDEndorser)discoveredAlready).getMspid()));
                                continue;
                            }
                            logger.debug((Object)String.format("Service discovery in channel %s peer: %s found Endorser endpoint: %s mspid: %s discovered twice", this.channelName, serviceDiscoveryPeer, ppp.getEndpoint(), mspId));
                            continue;
                        }
                        logger.trace((Object)String.format("Channel %s peer: %s discovered peer mspid group: %s, endpoint: %s, mspid: %s", this.channelName, serviceDiscoveryPeer, mspId, ppp.getEndpoint(), ppp.getMspid()));
                        lsdNetwork.endorsers.put(ppp.getEndpoint(), ppp);
                    }
                }
                lsdNetwork.discoveryTime = System.currentTimeMillis();
                this.sdNetwork = lsdNetwork;
                ret = lsdNetwork;
                break;
            }
            catch (Exception e) {
                logger.warn((Object)String.format("Channel %s peer %s service discovery error %s", this.channelName, serviceDiscoveryPeer, e.getMessage()));
            }
        }
        logger.debug((Object)String.format("Channel %s service discovery completed: %b", this.channelName, ret != null));
        return ret;
    }

    Map<String, SDChaindcode> discoverEndorserEndpoints(TransactionContext transactionContext, List<List<Channel.ServiceDiscoveryChaincodeCalls>> chaincodeNames) throws ServiceDiscoveryException {
        if (null == chaincodeNames) {
            logger.warn((Object)"Discover of chaincode names was null.");
            return Collections.emptyMap();
        }
        if (chaincodeNames.isEmpty()) {
            logger.warn((Object)"Discover of chaincode names was empty.");
            return Collections.emptyMap();
        }
        if (DEBUG) {
            StringBuilder cns = new StringBuilder(1000);
            String sep = "";
            cns.append("[");
            for (List<Channel.ServiceDiscoveryChaincodeCalls> s : chaincodeNames) {
                Channel.ServiceDiscoveryChaincodeCalls n = s.get(0);
                cns.append(sep).append(n.write(s.subList(1, s.size())));
                sep = ", ";
            }
            cns.append("]");
            logger.debug((Object)String.format("Channel %s doing discovery for chaincodes: %s", this.channelName, cns.toString()));
        }
        ArrayList<Peer> speers = new ArrayList<Peer>(this.serviceDiscoveryPeers);
        Collections.shuffle(speers);
        HashMap<String, SDChaindcode> ret = new HashMap<String, SDChaindcode>();
        SDNetwork sdNetwork = this.networkDiscovery(transactionContext, false);
        ServiceDiscoveryException serviceDiscoveryException = null;
        for (Peer serviceDiscoveryPeer : speers) {
            serviceDiscoveryException = null;
            try {
                URI serviceDiscoveryPeerURI = URI.create(serviceDiscoveryPeer.getUrl());
                boolean isTLS = serviceDiscoveryPeerURI.getScheme().equals("grpcs");
                logger.trace((Object)String.format("Service discovery peer %s using TLS: %b", serviceDiscoveryPeerURI.toString(), isTLS));
                logger.debug((Object)String.format("Channel %s doing discovery for chaincodes on peer: %s", this.channelName, serviceDiscoveryPeer.toString()));
                TransactionContext ltransactionContext = transactionContext.retryTransactionSameContext();
                byte[] clientTLSCertificateDigest = serviceDiscoveryPeer.getClientTLSCertificateDigest();
                if (null == clientTLSCertificateDigest) {
                    logger.warn((Object)String.format("Channel %s peer %s requires mutual tls for service discovery.", this.channelName, serviceDiscoveryPeer.toString()));
                    continue;
                }
                ByteString clientIdent = ltransactionContext.getIdentity().toByteString();
                ByteString tlshash = ByteString.copyFrom((byte[])clientTLSCertificateDigest);
                Protocol.AuthInfo authentication = Protocol.AuthInfo.newBuilder().setClientIdentity(clientIdent).setClientTlsCertHash(tlshash).build();
                ArrayList<Protocol.Query> fq = new ArrayList<Protocol.Query>(chaincodeNames.size());
                for (List<Channel.ServiceDiscoveryChaincodeCalls> chaincodeName : chaincodeNames) {
                    if (ret.containsKey(chaincodeName.get(0).getName())) continue;
                    LinkedList chaincodeCalls = new LinkedList();
                    chaincodeName.forEach(serviceDiscoveryChaincodeCalls -> chaincodeCalls.add(serviceDiscoveryChaincodeCalls.build()));
                    ArrayList<Protocol.ChaincodeInterest> cinn = new ArrayList<Protocol.ChaincodeInterest>(1);
                    chaincodeName.forEach(Channel.ServiceDiscoveryChaincodeCalls::build);
                    Protocol.ChaincodeInterest cci = Protocol.ChaincodeInterest.newBuilder().addAllChaincodes(chaincodeCalls).build();
                    cinn.add(cci);
                    Protocol.ChaincodeQuery chaincodeQuery = Protocol.ChaincodeQuery.newBuilder().addAllInterests(cinn).build();
                    fq.add(Protocol.Query.newBuilder().setChannel(this.channelName).setCcQuery(chaincodeQuery).build());
                }
                if (fq.size() == 0) break;
                Protocol.Request request = Protocol.Request.newBuilder().addAllQueries(fq).setAuthentication(authentication).build();
                ByteString payloadBytes = request.toByteString();
                ByteString signatureBytes = ltransactionContext.signByteStrings(payloadBytes);
                Protocol.SignedRequest sr = Protocol.SignedRequest.newBuilder().setPayload(payloadBytes).setSignature(signatureBytes).build();
                if (IS_TRACE_LEVEL && null != diagnosticFileDumper) {
                    logger.trace((Object)String.format("Service discovery channel %s %s service chaincode query sent %s", this.channelName, serviceDiscoveryPeer, diagnosticFileDumper.createDiagnosticProtobufFile(sr.toByteArray())));
                }
                logger.debug((Object)String.format("Channel %s peer %s sending chaincode query request", this.channelName, serviceDiscoveryPeer.toString()));
                Protocol.Response response = serviceDiscoveryPeer.sendDiscoveryRequestAsync(sr).get(SERVICE_DISCOVERY_WAITTIME, TimeUnit.MILLISECONDS);
                if (IS_TRACE_LEVEL && null != diagnosticFileDumper) {
                    logger.trace((Object)String.format("Service discovery channel %s %s service chaincode query returned %s", this.channelName, serviceDiscoveryPeer, diagnosticFileDumper.createDiagnosticProtobufFile(response.toByteArray())));
                }
                logger.debug((Object)String.format("Channel %s peer %s completed chaincode query request", this.channelName, serviceDiscoveryPeer.toString()));
                serviceDiscoveryPeer.hasConnected();
                for (Protocol.QueryResult queryResult : response.getResultsList()) {
                    ServiceDiscoveryException discoveryException;
                    if (queryResult.getResultCase().getNumber() == 1) {
                        discoveryException = new ServiceDiscoveryException(String.format("Error %s", queryResult.getError().getContent()));
                        logger.error((Object)discoveryException.getMessage());
                        continue;
                    }
                    if (queryResult.getResultCase().getNumber() != 3) {
                        discoveryException = new ServiceDiscoveryException(String.format("Error expected chaincode endorsement query but got %s : ", queryResult.getResultCase().toString()));
                        logger.error((Object)discoveryException.getMessage());
                        continue;
                    }
                    Protocol.ChaincodeQueryResult ccQueryRes = queryResult.getCcQueryRes();
                    if (ccQueryRes.getContentList().isEmpty()) {
                        throw new ServiceDiscoveryException(String.format("Error %s", queryResult.getError().getContent()));
                    }
                    for (Protocol.EndorsementDescriptor es : ccQueryRes.getContentList()) {
                        String chaincode = es.getChaincode();
                        LinkedList<SDLayout> layouts = new LinkedList<SDLayout>();
                        for (Protocol.Layout layout : es.getLayoutsList()) {
                            SDLayout sdLayout = null;
                            Map<String, Integer> quantitiesByGroupMap = layout.getQuantitiesByGroupMap();
                            for (Map.Entry<String, Integer> qmap : quantitiesByGroupMap.entrySet()) {
                                Protocol.Peers peers;
                                String key = qmap.getKey();
                                int quantity = qmap.getValue();
                                if (quantity < 1 || (peers = es.getEndorsersByGroupsMap().get(key)) == null || peers.getPeersCount() == 0) continue;
                                LinkedList<SDEndorser> sdEndorsers = new LinkedList<SDEndorser>();
                                for (Protocol.Peer pp : peers.getPeersList()) {
                                    SDEndorser ppp = new SDEndorser(pp, null, null, asLocalhost, isTLS);
                                    String endPoint = ppp.getEndpoint();
                                    SDEndorser nppp = sdNetwork.getEndorserByEndpoint(endPoint);
                                    if (null == nppp) {
                                        sdNetwork = this.networkDiscovery(transactionContext, true);
                                        if (null == sdNetwork) {
                                            throw new ServiceDiscoveryException("Failed to discover network resources.");
                                        }
                                        nppp = sdNetwork.getEndorserByEndpoint(ppp.getEndpoint());
                                        if (null == nppp) {
                                            throw new ServiceDiscoveryException(String.format("Failed to discover peer endpoint information %s for chaincode %s ", endPoint, chaincode));
                                        }
                                    }
                                    sdEndorsers.add(nppp);
                                }
                                if (sdLayout == null) {
                                    sdLayout = new SDLayout();
                                    layouts.add(sdLayout);
                                }
                                sdLayout.addGroup(key, quantity, sdEndorsers);
                            }
                        }
                        if (layouts.isEmpty()) {
                            logger.warn((Object)String.format("Channel %s chaincode %s discovered no layouts!", this.channelName, chaincode));
                            continue;
                        }
                        if (DEBUG) {
                            StringBuilder sb = new StringBuilder(1000);
                            sb.append("Channel ").append(this.channelName).append(" found ").append(layouts.size()).append(" layouts for chaincode: ").append(es.getChaincode());
                            sb.append(", layouts: [");
                            String sep = "";
                            for (SDLayout layout : layouts) {
                                sb.append(sep).append(layout);
                                sep = ", ";
                            }
                            sb.append("]");
                            logger.debug((Object)sb.toString());
                        }
                        ret.put(es.getChaincode(), new SDChaindcode(es.getChaincode(), layouts));
                    }
                }
                if (ret.size() != chaincodeNames.size()) continue;
                break;
            }
            catch (ServiceDiscoveryException e) {
                logger.warn((Object)String.format("Service discovery error on peer %s. Error: %s", serviceDiscoveryPeer.toString(), e.getMessage()));
                serviceDiscoveryException = e;
            }
            catch (Exception e) {
                logger.warn((Object)String.format("Service discovery error on peer %s. Error: %s", serviceDiscoveryPeer.toString(), e.getMessage()));
                serviceDiscoveryException = new ServiceDiscoveryException(e);
            }
        }
        if (null != serviceDiscoveryException) {
            throw serviceDiscoveryException;
        }
        if (ret.size() != chaincodeNames.size()) {
            logger.warn((Object)String.format("Channel %s failed to find all layouts for chaincodes. Expected: %d and found: %d", this.channelName, chaincodeNames.size(), ret.size()));
        }
        return ret;
    }

    private static List<SDEndorser> topNbyHeight(int required, List<SDEndorser> endorsers) {
        ArrayList<SDEndorser> ret = new ArrayList<SDEndorser>(endorsers);
        ret.sort(Comparator.comparingLong(SDEndorser::getLedgerHeight));
        return ret.subList(Math.max(ret.size() - required, 0), ret.size());
    }

    void run() {
        if (this.channel.isShutdown() || SERVICE_DISCOVER_FREQ_SECONDS < 1) {
            return;
        }
        if (this.seviceDiscovery == null) {
            this.seviceDiscovery = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }).scheduleAtFixedRate(() -> {
                logger.debug((Object)String.format("Channel %s starting service rediscovery after %d seconds.", this.channelName, SERVICE_DISCOVER_FREQ_SECONDS));
                this.fullNetworkDiscovery(true);
            }, SERVICE_DISCOVER_FREQ_SECONDS, SERVICE_DISCOVER_FREQ_SECONDS, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SDNetwork fullNetworkDiscovery(boolean force) {
        if (this.channel.isShutdown()) {
            return null;
        }
        logger.trace((Object)String.format("Full network discovery force: %b", force));
        try {
            SDNetwork osdNetwork = this.sdNetwork;
            SDNetwork lsdNetwork = this.networkDiscovery(this.transactionContext.retryTransactionSameContext(), force);
            if (this.channel.isShutdown() || null == lsdNetwork) {
                SDNetwork sDNetwork = null;
                return sDNetwork;
            }
            if (osdNetwork != lsdNetwork) {
                Set<String> chaincodesNames = lsdNetwork.getChaincodesNames();
                LinkedList<List<Channel.ServiceDiscoveryChaincodeCalls>> lcc = new LinkedList<List<Channel.ServiceDiscoveryChaincodeCalls>>();
                chaincodesNames.forEach(s -> {
                    LinkedList<Channel.ServiceDiscoveryChaincodeCalls> lc = new LinkedList<Channel.ServiceDiscoveryChaincodeCalls>();
                    lc.add(new Channel.ServiceDiscoveryChaincodeCalls((String)s));
                    lcc.add(lc);
                });
                this.chaindcodeMap = this.discoverEndorserEndpoints(this.transactionContext.retryTransactionSameContext(), lcc);
                if (this.channel.isShutdown()) {
                    SDNetwork sDNetwork = null;
                    return sDNetwork;
                }
                this.channel.sdUpdate(lsdNetwork);
            }
            SDNetwork sDNetwork = lsdNetwork;
            return sDNetwork;
        }
        catch (Exception e) {
            logger.warn((Object)("Service discovery got error:" + e.getMessage()), (Throwable)e);
        }
        finally {
            logger.trace((Object)"Full network rediscovery completed.");
        }
        return null;
    }

    void shutdown() {
        logger.trace((Object)"Service discovery shutdown.");
        try {
            ScheduledFuture<?> lseviceDiscovery = this.seviceDiscovery;
            this.seviceDiscovery = null;
            if (null != lseviceDiscovery) {
                lseviceDiscovery.cancel(true);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    static {
        DEFAULT_ENDORSEMENT_SELECTION = ENDORSEMENT_SELECTION_LEAST_REQUIRED_BLOCKHEIGHT = sdChaindcode -> {
            List<SDLayout> layouts = sdChaindcode.getLayouts();
            SDLayout pickedLayout = null;
            HashMap<SDLayout, Set> layoutEndorsers = new HashMap<SDLayout, Set>();
            for (SDLayout sdLayout : layouts) {
                class LGroup {
                    int stillRequred;
                    final Set endorsers = new HashSet();

                    LGroup(SDLayout.SDGroup group) {
                        this.endorsers.addAll(group.getEndorsers());
                        this.stillRequred = group.getStillRequired();
                    }

                    boolean endorsed(Set<SDEndorser> endorsed) {
                        for (SDEndorser sdEndorser : endorsed) {
                            if (!this.endorsers.contains(sdEndorser)) continue;
                            this.endorsers.remove(sdEndorser);
                            this.stillRequred = Math.max(0, this.stillRequred - 1);
                        }
                        return this.stillRequred > 0;
                    }
                }
                Object sdEndorsers;
                Object lgroup;
                HashSet remainingGroups = new HashSet();
                for (SDLayout.SDGroup sDGroup : sdLayout.getSDLGroups()) {
                    remainingGroups.add(new LGroup(sDGroup));
                }
                HashSet<SDEndorser> hashSet = new HashSet<SDEndorser>();
                Iterator iterator = remainingGroups.iterator();
                while (iterator.hasNext()) {
                    lgroup = (LGroup)iterator.next();
                    if (((LGroup)lgroup).stillRequred != ((LGroup)lgroup).endorsers.size()) continue;
                    hashSet.addAll(((LGroup)lgroup).endorsers);
                }
                if (hashSet.size() > 0) {
                    HashSet<LGroup> hashSet2 = new HashSet<LGroup>(remainingGroups.size());
                    lgroup = remainingGroups.iterator();
                    while (lgroup.hasNext()) {
                        LGroup lGroup = (LGroup)lgroup.next();
                        if (lGroup.endorsed(hashSet)) continue;
                        hashSet2.add(lGroup);
                    }
                    remainingGroups.removeAll(hashSet2);
                    sdEndorsers = layoutEndorsers.computeIfAbsent(sdLayout, k -> new HashSet());
                    sdEndorsers.addAll(hashSet);
                }
                if (remainingGroups.isEmpty()) continue;
                do {
                    Object sd22;
                    HashMap<SDEndorser, Integer> hashMap = new HashMap<SDEndorser, Integer>();
                    sdEndorsers = remainingGroups.iterator();
                    while (sdEndorsers.hasNext()) {
                        LGroup group = (LGroup)sdEndorsers.next();
                        for (SDEndorser sDEndorser : group.endorsers) {
                            Integer count = (Integer)hashMap.get(sDEndorser);
                            if (count == null) {
                                hashMap.put(sDEndorser, 1);
                                continue;
                            }
                            count = count + 1;
                            hashMap.put(sDEndorser, count);
                        }
                    }
                    HashSet<Object> theMost = new HashSet<Object>();
                    int maxMatch = 0;
                    for (Map.Entry entry : hashMap.entrySet()) {
                        int count = (Integer)entry.getValue();
                        SDEndorser sdEndorser = (SDEndorser)entry.getKey();
                        if (count > maxMatch) {
                            theMost.clear();
                            theMost.add(sdEndorser);
                            maxMatch = count;
                            continue;
                        }
                        if (count != maxMatch) continue;
                        theMost.add(sdEndorser);
                    }
                    HashSet<SDEndorser> theVeryMost = new HashSet<SDEndorser>(1);
                    long l = 0L;
                    for (Object sd22 : theMost) {
                        if (((SDEndorser)sd22).getLedgerHeight() <= l) continue;
                        l = ((SDEndorser)sd22).getLedgerHeight();
                        theVeryMost.clear();
                        theVeryMost.add((SDEndorser)sd22);
                    }
                    HashSet<LGroup> remove2 = new HashSet<LGroup>(remainingGroups.size());
                    sd22 = remainingGroups.iterator();
                    while (sd22.hasNext()) {
                        LGroup lGroup = (LGroup)sd22.next();
                        if (lGroup.endorsed(theVeryMost)) continue;
                        remove2.add(lGroup);
                    }
                    Set sdEndorsers2 = layoutEndorsers.computeIfAbsent(sdLayout, k -> new HashSet());
                    sdEndorsers2.addAll(theVeryMost);
                    remainingGroups.removeAll(remove2);
                } while (!remainingGroups.isEmpty());
            }
            int min = Integer.MAX_VALUE;
            HashSet<SDLayout> theLeast = new HashSet<SDLayout>();
            for (Map.Entry entry : layoutEndorsers.entrySet()) {
                SDLayout sDLayout = (SDLayout)entry.getKey();
                Integer count = ((Set)entry.getValue()).size();
                if (count < min) {
                    theLeast.clear();
                    theLeast.add(sDLayout);
                    min = count;
                    continue;
                }
                if (count != min) continue;
                theLeast.add(sDLayout);
            }
            if (theLeast.size() == 1) {
                pickedLayout = (SDLayout)theLeast.iterator().next();
            } else {
                long max = 0L;
                for (SDLayout sdLayout : theLeast) {
                    int height = 0;
                    for (SDEndorser sDEndorser : (Set)layoutEndorsers.get(sdLayout)) {
                        height = (int)((long)height + sDEndorser.getLedgerHeight());
                    }
                    if ((long)height <= max) continue;
                    max = height;
                    pickedLayout = sdLayout;
                }
            }
            SDEndorserState sdEndorserState = new SDEndorserState();
            sdEndorserState.setPickedEndorsers((Collection)layoutEndorsers.get(pickedLayout));
            sdEndorserState.setPickedLayout(pickedLayout);
            return sdEndorserState;
        };
        ENDORSEMENT_SELECTION_RANDOM = sdChaindcode -> {
            List<SDLayout> layouts = sdChaindcode.getLayouts();
            SDLayout pickedLayout = layouts.get(0);
            if (layouts.size() > 1) {
                pickedLayout = layouts.get(random.nextInt(layouts.size()));
            }
            HashMap retMap = new HashMap();
            for (SDLayout.SDGroup group : pickedLayout.getSDLGroups()) {
                ArrayList<SDEndorser> endorsers = new ArrayList<SDEndorser>(group.getEndorsers());
                int required = group.getStillRequired();
                Collections.shuffle(endorsers);
                List sdEndorsers = endorsers.subList(0, required);
                sdEndorsers.forEach(sdEndorser -> retMap.putIfAbsent(sdEndorser.getEndpoint(), sdEndorser));
            }
            SDEndorserState sdEndorserState = new SDEndorserState();
            sdEndorserState.setPickedEndorsers(retMap.values());
            sdEndorserState.setPickedLayout(pickedLayout);
            return sdEndorserState;
        };
        SERVICE_DISCOVER_FREQ_SECONDS = config.getServiceDiscoveryFreqSeconds();
    }

    public static interface EndorsementSelector {
        public static final EndorsementSelector ENDORSEMENT_SELECTION_RANDOM = ENDORSEMENT_SELECTION_RANDOM;
        public static final EndorsementSelector ENDORSEMENT_SELECTION_LEAST_REQUIRED_BLOCKHEIGHT = ENDORSEMENT_SELECTION_LEAST_REQUIRED_BLOCKHEIGHT;

        public SDEndorserState endorserSelector(SDChaindcode var1);
    }

    public static class SDEndorser {
        private List<Message.Chaincode> chaincodesList;
        private String endPoint = null;
        private String name = null;
        private String mspid;
        private long ledgerHeight = -1L;
        private final Collection<byte[]> tlsCerts;
        private final Collection<byte[]> tlsIntermediateCerts;
        private final boolean asLocalhost;
        private final boolean tls;

        SDEndorser() {
            this.tlsCerts = null;
            this.tlsIntermediateCerts = null;
            this.asLocalhost = false;
            this.tls = false;
        }

        SDEndorser(Protocol.Peer peerRet, Collection<byte[]> tlsCerts, Collection<byte[]> tlsIntermediateCerts, boolean asLocalhost, boolean tls) {
            this.tlsCerts = tlsCerts;
            this.tlsIntermediateCerts = tlsIntermediateCerts;
            this.asLocalhost = asLocalhost;
            this.tls = tls;
            this.parseEndpoint(peerRet);
            this.parseLedgerHeight(peerRet);
            this.parseIdentity(peerRet);
        }

        Collection<byte[]> getTLSCerts() {
            return this.tlsCerts;
        }

        Collection<byte[]> getTLSIntermediateCerts() {
            return this.tlsIntermediateCerts;
        }

        public String getName() {
            return this.name;
        }

        public String getEndpoint() {
            return this.endPoint;
        }

        public long getLedgerHeight() {
            return this.ledgerHeight;
        }

        private void parseIdentity(Protocol.Peer peerRet) {
            try {
                Identities.SerializedIdentity serializedIdentity = Identities.SerializedIdentity.parseFrom(peerRet.getIdentity());
                this.mspid = serializedIdentity.getMspid();
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
        }

        private String parseEndpoint(Protocol.Peer peerRet) throws InvalidProtocolBufferRuntimeException {
            if (null == this.endPoint) {
                try {
                    Message.Envelope membershipInfo = peerRet.getMembershipInfo();
                    ByteString membershipInfoPayloadBytes = membershipInfo.getPayload();
                    Message.GossipMessage gossipMessageMemberInfo = Message.GossipMessage.parseFrom(membershipInfoPayloadBytes);
                    if (Message.GossipMessage.ContentCase.ALIVE_MSG.getNumber() != gossipMessageMemberInfo.getContentCase().getNumber()) {
                        throw new RuntimeException(String.format("Error %s", "bad"));
                    }
                    Message.AliveMessage aliveMsg = gossipMessageMemberInfo.getAliveMsg();
                    this.name = aliveMsg.getMembership().getEndpoint();
                    if (this.name != null) {
                        this.endPoint = this.asLocalhost ? "localhost" + this.name.substring(this.name.lastIndexOf(58)) : this.name.toLowerCase().trim();
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw new InvalidProtocolBufferRuntimeException(e);
                }
            }
            return this.endPoint;
        }

        private long parseLedgerHeight(Protocol.Peer peerRet) throws InvalidProtocolBufferRuntimeException {
            if (-1L == this.ledgerHeight) {
                try {
                    Message.Envelope stateInfo = peerRet.getStateInfo();
                    Message.GossipMessage stateInfoGossipMessage = Message.GossipMessage.parseFrom(stateInfo.getPayload());
                    Message.GossipMessage.ContentCase contentCase = stateInfoGossipMessage.getContentCase();
                    if (contentCase.getNumber() != Message.GossipMessage.ContentCase.STATE_INFO.getNumber()) {
                        throw new RuntimeException("" + contentCase.getNumber());
                    }
                    Message.StateInfo stateInfo1 = stateInfoGossipMessage.getStateInfo();
                    this.ledgerHeight = stateInfo1.getProperties().getLedgerHeight();
                    this.chaincodesList = stateInfo1.getProperties().getChaincodesList();
                }
                catch (InvalidProtocolBufferException e) {
                    throw new InvalidProtocolBufferRuntimeException(e);
                }
            }
            return this.ledgerHeight;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SDEndorser)) {
                return false;
            }
            SDEndorser other = (SDEndorser)obj;
            return Objects.equals(this.mspid, other.getMspid()) && Objects.equals(this.endPoint, other.getEndpoint());
        }

        public int hashCode() {
            return Objects.hash(this.mspid, this.endPoint);
        }

        Set<String> getChaincodeNames() {
            if (this.chaincodesList == null) {
                return Collections.emptySet();
            }
            HashSet<String> ret = new HashSet<String>(this.chaincodesList.size());
            this.chaincodesList.forEach(chaincode -> ret.add(chaincode.getName()));
            return ret;
        }

        public String getMspid() {
            return this.mspid;
        }

        public boolean isTLS() {
            return this.tls;
        }

        public String toString() {
            return "SDEndorser-" + this.mspid + "-" + this.endPoint;
        }
    }

    public static class SDEndorserState {
        private Collection<SDEndorser> sdEndorsers = new ArrayList<SDEndorser>();
        private SDLayout pickedLayout;

        public void setPickedEndorsers(Collection<SDEndorser> sdEndorsers) {
            this.sdEndorsers = sdEndorsers;
        }

        Collection<SDEndorser> getSdEndorsers() {
            return this.sdEndorsers;
        }

        public void setPickedLayout(SDLayout pickedLayout) {
            this.pickedLayout = pickedLayout;
        }

        public SDLayout getPickedLayout() {
            return this.pickedLayout;
        }
    }

    public static class SDLayout {
        final List<SDGroup> groups = new LinkedList<SDGroup>();

        SDLayout() {
        }

        SDLayout(SDLayout sdLayout) {
            for (SDGroup group : sdLayout.groups) {
                new SDGroup(group);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(1000);
            sb.append("SDLayout: {");
            if (!this.groups.isEmpty()) {
                sb.append("groups: [");
                String sep2 = "";
                for (SDGroup group : this.groups) {
                    sb.append(sep2).append(group.toString());
                    sep2 = ", ";
                }
                sb.append("]");
            } else {
                sb.append(", groups: []");
            }
            sb.append("}");
            return sb.toString();
        }

        boolean ignoreList(Collection<String> names) {
            boolean ret = true;
            HashSet<String> bnames = new HashSet<String>(names);
            for (SDGroup group : this.groups) {
                if (group.ignoreList(bnames)) continue;
                ret = false;
            }
            return ret;
        }

        boolean ignoreListSDEndorser(Collection<SDEndorser> names) {
            boolean ret = true;
            HashSet<SDEndorser> bnames = new HashSet<SDEndorser>(names);
            for (SDGroup group : this.groups) {
                if (group.ignoreListSDEndorser(bnames)) continue;
                ret = false;
            }
            return ret;
        }

        boolean endorsedList(Collection<SDEndorser> sdEndorsers) {
            int endorsementMeet = 0;
            for (SDGroup group : this.groups) {
                if (!group.endorsedList(sdEndorsers)) continue;
                ++endorsementMeet;
            }
            return endorsementMeet >= this.groups.size();
        }

        Collection<SDEndorser> meetsEndorsmentPolicy(Set<SDEndorser> endpoints) {
            HashSet<SDEndorser> ret = new HashSet<SDEndorser>();
            for (SDGroup group : this.groups) {
                Collection<SDEndorser> sdEndorsers = group.meetsEndorsmentPolicy(endpoints, null);
                if (null == sdEndorsers) {
                    return null;
                }
                ret.addAll(sdEndorsers);
            }
            return ret;
        }

        public Collection<SDGroup> getSDLGroups() {
            return new ArrayList<SDGroup>(this.groups);
        }

        void addGroup(String key, int required, List<SDEndorser> endorsers) {
            new SDGroup(key, required, endorsers);
        }

        public class SDGroup {
            final int required;
            final List<SDEndorser> endorsers = new LinkedList<SDEndorser>();
            private final String name;
            private int endorsed = 0;

            SDGroup(String name, int required, List<SDEndorser> endorsers) {
                SDLayout.this.groups.add(this);
                this.name = name;
                this.required = required;
                this.endorsers.addAll(endorsers);
            }

            SDGroup(SDGroup group) {
                SDLayout.this.groups.add(this);
                this.name = group.name;
                this.required = group.required;
                this.endorsers.addAll(group.endorsers);
                this.endorsed = 0;
            }

            public int getStillRequired() {
                return this.required - this.endorsed;
            }

            public String getName() {
                return this.name;
            }

            public int getRequired() {
                return this.required;
            }

            public Collection<SDEndorser> getEndorsers() {
                return new ArrayList<SDEndorser>(this.endorsers);
            }

            boolean ignoreList(Collection<String> names) {
                HashSet<String> bnames = new HashSet<String>(names);
                this.endorsers.removeIf(endorser -> bnames.contains(endorser.getEndpoint()));
                return this.endorsers.size() >= this.required;
            }

            boolean ignoreListSDEndorser(Collection<SDEndorser> sdEndorsers) {
                HashSet<SDEndorser> bnames = new HashSet<SDEndorser>(sdEndorsers);
                this.endorsers.removeIf(bnames::contains);
                return this.endorsers.size() >= this.required;
            }

            boolean endorsedList(Collection<SDEndorser> sdEndorsers) {
                if (this.endorsed >= this.required) {
                    return true;
                }
                if (!sdEndorsers.isEmpty()) {
                    HashSet enames = new HashSet(sdEndorsers.size());
                    sdEndorsers.forEach(sdEndorser -> enames.add(sdEndorser.getEndpoint()));
                    this.endorsers.removeIf(endorser -> {
                        if (enames.contains(endorser.getEndpoint())) {
                            this.endorsed = Math.min(this.required, this.endorsed++);
                            return true;
                        }
                        return false;
                    });
                }
                return this.endorsed >= this.required;
            }

            public String toString() {
                StringBuilder sb = new StringBuilder(512);
                sb.append("SDGroup: { name: ").append(this.name).append(", required: ").append(this.required);
                if (!this.endorsers.isEmpty()) {
                    sb.append(", endorsers: [");
                    String sep2 = "";
                    for (SDEndorser sdEndorser : this.endorsers) {
                        sb.append(sep2).append(sdEndorser.toString());
                        sep2 = ", ";
                    }
                    sb.append("]");
                } else {
                    sb.append(", endorsers: []");
                }
                sb.append("}");
                return sb.toString();
            }

            Collection<SDEndorser> meetsEndorsmentPolicy(Set<SDEndorser> allEndorsed, Collection<SDEndorser> requiredYet) {
                HashSet<SDEndorser> ret = new HashSet<SDEndorser>(this.endorsers.size());
                for (SDEndorser hasBeenEndorsed : allEndorsed) {
                    for (SDEndorser sdEndorser : this.endorsers) {
                        if (!hasBeenEndorsed.equals(sdEndorser)) continue;
                        ret.add(sdEndorser);
                        if (ret.size() < this.required) continue;
                        return ret;
                    }
                }
                if (null != requiredYet) {
                    for (SDEndorser sdEndorser : this.endorsers) {
                        if (allEndorsed.contains(sdEndorser)) continue;
                        requiredYet.add(sdEndorser);
                    }
                }
                return null;
            }
        }
    }

    public static class SDChaindcode {
        final String name;
        final List<SDLayout> layouts;

        SDChaindcode(SDChaindcode sdChaindcode) {
            this.name = sdChaindcode.name;
            this.layouts = new LinkedList<SDLayout>();
            sdChaindcode.layouts.forEach(sdLayout -> this.layouts.add(new SDLayout((SDLayout)sdLayout)));
        }

        SDChaindcode(String name, List<SDLayout> layouts) {
            this.name = name;
            this.layouts = layouts;
        }

        public List<SDLayout> getLayouts() {
            return Collections.unmodifiableList(this.layouts);
        }

        int ignoreList(Collection<String> names) {
            if (names != null && !names.isEmpty()) {
                this.layouts.removeIf(sdLayout -> !sdLayout.ignoreList(names));
            }
            return this.layouts.size();
        }

        int ignoreListSDEndorser(Collection<SDEndorser> sdEndorsers) {
            if (sdEndorsers != null && !sdEndorsers.isEmpty()) {
                this.layouts.removeIf(sdLayout -> !sdLayout.ignoreListSDEndorser(sdEndorsers));
            }
            return this.layouts.size();
        }

        boolean endorsedList(Collection<SDEndorser> sdEndorsers) {
            boolean ret = false;
            for (SDLayout sdLayout : this.layouts) {
                if (!sdLayout.endorsedList(sdEndorsers)) continue;
                ret = true;
            }
            return ret;
        }

        Collection<SDEndorser> meetsEndorsmentPolicy(Set<SDEndorser> endpoints) {
            Collection<SDEndorser> ret = null;
            for (SDLayout sdLayout : this.layouts) {
                Collection<SDEndorser> needed = sdLayout.meetsEndorsmentPolicy(endpoints);
                if (needed == null || ret != null && ret.size() <= needed.size()) continue;
                ret = needed;
            }
            return ret;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(1000);
            sb.append("SDChaindcode(name: ").append(this.name);
            if (null != this.layouts && !this.layouts.isEmpty()) {
                sb.append(", layouts: [");
                String sep = "";
                for (SDLayout sdLayout : this.layouts) {
                    sb.append(sep).append(sdLayout + "");
                    sep = " ,";
                }
                sb.append("]");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    public static class SDOrderer {
        private final String mspid;
        private final Collection<byte[]> tlsCerts;
        private final Collection<byte[]> tlsIntermediateCerts;
        private final String endPoint;
        private final Properties properties;
        private final boolean tls;

        SDOrderer(String mspid, String endPoint, Collection<byte[]> tlsCerts, Collection<byte[]> tlsIntermediateCerts, Properties properties, boolean tls) {
            this.mspid = mspid;
            this.endPoint = endPoint;
            this.tlsCerts = tlsCerts;
            this.tlsIntermediateCerts = tlsIntermediateCerts;
            this.properties = properties;
            this.tls = tls;
        }

        public Collection<byte[]> getTlsIntermediateCerts() {
            return this.tlsIntermediateCerts;
        }

        public String getEndPoint() {
            return this.endPoint;
        }

        public String getMspid() {
            return this.mspid;
        }

        public Collection<byte[]> getTlsCerts() {
            return this.tlsCerts;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public boolean isTLS() {
            return this.tls;
        }
    }

    class SDNetwork {
        final Map<String, List<byte[]>> tlsCerts = new HashMap<String, List<byte[]>>();
        final Map<String, List<byte[]>> tlsIntermCerts = new HashMap<String, List<byte[]>>();
        long discoveryTime;
        Map<String, SDEndorser> endorsers = Collections.emptyMap();
        Map<String, SDOrderer> ordererEndpoints = Collections.emptyMap();
        Set<String> chaincodeNames = null;

        SDNetwork() {
        }

        void addTlsCert(String mspid, byte[] cert) {
            if (IS_TRACE_LEVEL) {
                logger.trace((Object)String.format("Channel %s service discovery MSPID %s adding TLSCert %s", ServiceDiscovery.this.channelName, mspid, Utils.toHexString(cert)));
            }
            this.tlsCerts.computeIfAbsent(mspid, k -> new LinkedList()).add(cert);
        }

        void addTlsIntermCert(String mspid, byte[] cert) {
            if (IS_TRACE_LEVEL) {
                logger.trace((Object)String.format("Channel %s service discovery MSPID %s adding intermediate TLSCert %s", ServiceDiscovery.this.channelName, mspid, Utils.toHexString(cert)));
            }
            this.tlsIntermCerts.computeIfAbsent(mspid, k -> new LinkedList()).add(cert);
        }

        SDEndorser getEndorserByEndpoint(String endpoint) {
            return this.endorsers.get(endpoint);
        }

        public Collection<SDEndorser> getEndorsers() {
            return Collections.unmodifiableCollection(this.endorsers.values());
        }

        Set<String> getOrdererEndpoints() {
            return Collections.unmodifiableSet(this.ordererEndpoints.keySet());
        }

        Collection<SDOrderer> getSDOrderers() {
            return this.ordererEndpoints.values();
        }

        Set<String> getPeerEndpoints() {
            return Collections.unmodifiableSet(this.endorsers.keySet());
        }

        Set<String> getChaincodesNames() {
            if (null == this.chaincodeNames) {
                if (null == this.endorsers) {
                    this.chaincodeNames = Collections.emptySet();
                    return this.chaincodeNames;
                }
                HashSet<String> ret = new HashSet<String>();
                this.endorsers.values().forEach(sdEndorser -> {
                    if (null != ((SDEndorser)sdEndorser).chaincodesList) {
                        ((SDEndorser)sdEndorser).chaincodesList.forEach(chaincode -> ret.add(chaincode.getName()));
                    }
                });
                this.chaincodeNames = ret;
            }
            return this.chaincodeNames;
        }

        Collection<byte[]> getTlsCerts(String mspid) {
            Collection bytes = this.tlsCerts.get(mspid);
            if (null == bytes) {
                logger.debug((Object)String.format("Channel %s no tls ca certs for mspid: %s", ServiceDiscovery.this.channelName, mspid));
                return Collections.emptyList();
            }
            if (bytes.isEmpty()) {
                logger.debug((Object)String.format("Channel %s no tls ca certs for mspid: %s", ServiceDiscovery.this.channelName, mspid));
            }
            return Collections.unmodifiableCollection(bytes);
        }

        Collection<byte[]> getTlsIntermediateCerts(String mspid) {
            Collection bytes = this.tlsIntermCerts.get(mspid);
            if (null == bytes) {
                logger.debug((Object)String.format("Channel %s no tls intermediary ca certs for mspid: %s", ServiceDiscovery.this.channelName, mspid));
                return Collections.emptyList();
            }
            if (bytes.isEmpty()) {
                logger.debug((Object)String.format("Channel %s no tls intermediary ca certs for mspid: %s", ServiceDiscovery.this.channelName, mspid));
            }
            return Collections.unmodifiableCollection(bytes);
        }
    }
}

