/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.ref.WeakReference;
import org.hyperledger.fabric.protos.peer.TransactionPackage;
import org.hyperledger.fabric.sdk.ChaincodeActionPayloadDeserializer;
import org.hyperledger.fabric.sdk.exception.InvalidProtocolBufferRuntimeException;

class TransactionActionDeserializer {
    private final ByteString byteString;
    private WeakReference<TransactionPackage.TransactionAction> transactionAction;
    private WeakReference<ChaincodeActionPayloadDeserializer> chaincodeActionPayloadDeserializer;

    TransactionActionDeserializer(ByteString byteString) {
        this.byteString = byteString;
    }

    TransactionActionDeserializer(TransactionPackage.TransactionAction transactionAction) {
        this.byteString = transactionAction.toByteString();
        this.transactionAction = new WeakReference<TransactionPackage.TransactionAction>(transactionAction);
    }

    TransactionPackage.TransactionAction getTransactionAction() {
        TransactionPackage.TransactionAction ret;
        TransactionPackage.TransactionAction transactionAction = ret = this.transactionAction != null ? (TransactionPackage.TransactionAction)this.transactionAction.get() : null;
        if (null == ret) {
            try {
                ret = TransactionPackage.TransactionAction.parseFrom(this.byteString);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
            this.transactionAction = new WeakReference<TransactionPackage.TransactionAction>(ret);
        }
        return ret;
    }

    ChaincodeActionPayloadDeserializer getPayload() {
        ChaincodeActionPayloadDeserializer ret;
        ChaincodeActionPayloadDeserializer chaincodeActionPayloadDeserializer = ret = this.chaincodeActionPayloadDeserializer != null ? (ChaincodeActionPayloadDeserializer)this.chaincodeActionPayloadDeserializer.get() : null;
        if (null == ret) {
            ret = new ChaincodeActionPayloadDeserializer(this.getTransactionAction().getPayload());
            this.chaincodeActionPayloadDeserializer = new WeakReference<ChaincodeActionPayloadDeserializer>(ret);
        }
        return ret;
    }
}

