/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.hyperledger.fabric.protos.peer.TransactionPackage;
import org.hyperledger.fabric.sdk.TransactionActionDeserializer;
import org.hyperledger.fabric.sdk.exception.InvalidProtocolBufferRuntimeException;

class TransactionDeserializer {
    private final ByteString byteString;
    private WeakReference<TransactionPackage.Transaction> transaction;
    private final Map<Integer, WeakReference<TransactionActionDeserializer>> transactionActions = Collections.synchronizedMap(new WeakHashMap());

    TransactionDeserializer(ByteString byteString) {
        this.byteString = byteString;
    }

    TransactionPackage.Transaction getTransaction() {
        TransactionPackage.Transaction ret;
        TransactionPackage.Transaction transaction = ret = this.transaction != null ? (TransactionPackage.Transaction)this.transaction.get() : null;
        if (null == ret) {
            try {
                ret = TransactionPackage.Transaction.parseFrom(this.byteString);
            }
            catch (InvalidProtocolBufferException e) {
                throw new InvalidProtocolBufferRuntimeException(e);
            }
            this.transaction = new WeakReference<TransactionPackage.Transaction>(ret);
        }
        return ret;
    }

    int getActionsCount() {
        return this.getTransaction().getActionsCount();
    }

    TransactionActionDeserializer getTransactionAction(int index) {
        TransactionActionDeserializer ret;
        TransactionPackage.Transaction transaction = this.getTransaction();
        if (index >= this.getActionsCount()) {
            return null;
        }
        WeakReference<TransactionActionDeserializer> envelopeWeakReference = this.transactionActions.get(index);
        if (null != envelopeWeakReference && null != (ret = (TransactionActionDeserializer)envelopeWeakReference.get())) {
            return ret;
        }
        TransactionActionDeserializer transactionActionDeserialize = new TransactionActionDeserializer(transaction.getActions(index));
        this.transactionActions.put(index, new WeakReference<TransactionActionDeserializer>(transactionActionDeserialize));
        return transactionActionDeserialize;
    }

    Iterable<TransactionActionDeserializer> getTransactionActions() {
        return new TransactionActionIterable();
    }

    class TransactionActionIterable
    implements Iterable<TransactionActionDeserializer> {
        TransactionActionIterable() {
        }

        @Override
        public Iterator<TransactionActionDeserializer> iterator() {
            return new TransactionActionIterator();
        }
    }

    class TransactionActionIterator
    implements Iterator<TransactionActionDeserializer> {
        int ci = 0;
        final int max;

        TransactionActionIterator() {
            this.max = TransactionDeserializer.this.getActionsCount();
        }

        @Override
        public boolean hasNext() {
            return this.ci < this.max;
        }

        @Override
        public TransactionActionDeserializer next() {
            return TransactionDeserializer.this.getTransactionAction(this.ci++);
        }
    }
}

