/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hyperledger.fabric.protos.peer.Chaincode;
import org.hyperledger.fabric.sdk.ChaincodeCollectionConfiguration;
import org.hyperledger.fabric.sdk.ChaincodeEndorsementPolicy;
import org.hyperledger.fabric.sdk.ChaincodeID;
import org.hyperledger.fabric.sdk.User;
import org.hyperledger.fabric.sdk.helper.Config;
import org.hyperledger.fabric.sdk.transaction.TransactionContext;

public class TransactionRequest {
    protected boolean init = false;
    private User userContext;
    private final Config config = Config.getConfig();
    protected String chaincodePath;
    protected String chaincodeName;
    protected String chaincodeVersion;
    private ChaincodeID chaincodeID;
    protected String fcn;
    protected ArrayList<String> args;
    protected ArrayList<byte[]> argBytes;
    protected Type chaincodeLanguage = Type.GO_LANG;
    private ChaincodeEndorsementPolicy endorsementPolicy = null;
    protected long proposalWaitTime = this.config.getProposalWaitTime();
    protected Map<String, byte[]> transientMap;
    protected ChaincodeCollectionConfiguration chaincodeCollectionConfiguration = null;
    private TransactionContext transactionContext;

    public void setChaincodeName(String chaincodeName) {
        this.chaincodeName = chaincodeName;
    }

    User getUserContext() {
        return this.userContext;
    }

    public void setUserContext(User userContext) {
        User.userContextCheck(userContext);
        this.userContext = userContext;
        this.transactionContext = null;
    }

    public Optional<TransactionContext> getTransactionContext() {
        return Optional.ofNullable(this.transactionContext);
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.userContext = transactionContext.getUser();
        this.transactionContext = transactionContext;
    }

    public Map<String, byte[]> getTransientMap() {
        return this.transientMap;
    }

    public boolean noChannelID() {
        return false;
    }

    public boolean doVerify() {
        return true;
    }

    public String getChaincodePath() {
        return null == this.chaincodePath ? "" : this.chaincodePath;
    }

    public String getChaincodeName() {
        return this.chaincodeName;
    }

    public TransactionRequest setChaincodeVersion(String chaincodeVersion) {
        this.chaincodeVersion = chaincodeVersion;
        return this;
    }

    public String getChaincodeVersion() {
        return this.chaincodeVersion;
    }

    public ChaincodeID getChaincodeID() {
        return this.chaincodeID;
    }

    public void setChaincodeID(ChaincodeID chaincodeID) {
        if (this.chaincodeName != null) {
            throw new IllegalArgumentException("Chaincode name has already been set.");
        }
        if (this.chaincodeVersion != null) {
            throw new IllegalArgumentException("Chaincode version has already been set.");
        }
        if (this.chaincodePath != null) {
            throw new IllegalArgumentException("Chaincode path has already been set.");
        }
        this.chaincodeID = chaincodeID;
        this.chaincodeName = chaincodeID.getName();
        this.chaincodePath = chaincodeID.getPath();
        this.chaincodeVersion = chaincodeID.getVersion();
    }

    public String getFcn() {
        return this.fcn;
    }

    public TransactionRequest setFcn(String fcn) {
        this.fcn = fcn;
        return this;
    }

    public ArrayList<String> getArgs() {
        return this.args;
    }

    public TransactionRequest setArgs(String ... args) {
        this.args = new ArrayList<String>(Arrays.asList(args));
        return this;
    }

    public ArrayList<byte[]> getArgBytes() {
        return this.argBytes;
    }

    public TransactionRequest setArgBytes(byte[][] args) {
        this.argBytes = new ArrayList(Arrays.asList(args));
        return this;
    }

    public TransactionRequest setArgs(ArrayList<String> args) {
        this.args = args;
        return this;
    }

    public TransactionRequest setArgs(byte[] ... args) {
        ArrayList argBytes = new ArrayList(args.length);
        argBytes.addAll(Arrays.asList(args));
        this.argBytes = argBytes;
        return this;
    }

    public Chaincode.ChaincodeID getFabricChaincodeID() {
        ChaincodeID chaincodeID = this.getChaincodeID();
        Chaincode.ChaincodeID fabricChaincodeID = null;
        if (null == chaincodeID) {
            Chaincode.ChaincodeID.Builder builder = Chaincode.ChaincodeID.newBuilder().setName(this.getChaincodeName());
            if (this.getChaincodeVersion() != null) {
                builder.setVersion(this.getChaincodeVersion());
            }
            if (this.getChaincodePath() != null) {
                builder.setPath(this.getChaincodePath());
            }
            fabricChaincodeID = builder.build();
        } else {
            fabricChaincodeID = chaincodeID.getFabricChaincodeID();
        }
        return fabricChaincodeID;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public boolean isInit() {
        return this.init;
    }

    public Type getChaincodeLanguage() {
        return this.chaincodeLanguage;
    }

    public void setChaincodeLanguage(Type chaincodeLanguage) {
        this.chaincodeLanguage = chaincodeLanguage;
    }

    public void setChaincodeEndorsementPolicy(ChaincodeEndorsementPolicy policy) {
        this.endorsementPolicy = policy;
    }

    public ChaincodeEndorsementPolicy getChaincodeEndorsementPolicy() {
        return this.endorsementPolicy;
    }

    public ChaincodeCollectionConfiguration getChaincodeCollectionConfiguration() {
        return this.chaincodeCollectionConfiguration;
    }

    public void setChaincodeCollectionConfiguration(ChaincodeCollectionConfiguration chaincodeCollectionConfiguration) {
        this.chaincodeCollectionConfiguration = chaincodeCollectionConfiguration;
    }

    public long getProposalWaitTime() {
        return this.proposalWaitTime;
    }

    public void setProposalWaitTime(long proposalWaitTime) {
        this.proposalWaitTime = proposalWaitTime;
    }

    protected TransactionRequest(User userContext) {
        User.userContextCheck(userContext);
        this.userContext = userContext;
    }

    public static enum Type {
        JAVA,
        GO_LANG,
        NODE;

        private static final Map<Type, String> cpv;
        private static final Map<String, Type> cpvr;

        public String toPackageName() {
            String ret = cpv.get((Object)this);
            if (null == ret) {
                ret = "golang";
            }
            return ret;
        }

        public static Type fromPackageName(String name) {
            Type ret = cpvr.get(name);
            return ret;
        }

        static {
            cpv = new HashMap<Type, String>(4);
            cpvr = new HashMap<String, Type>(4);
            cpv.put(JAVA, "java");
            cpv.put(GO_LANG, "golang");
            cpv.put(NODE, "node");
            cpvr.put("java", JAVA);
            cpvr.put("golang", GO_LANG);
            cpvr.put("node", NODE);
        }
    }
}

