/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Iterator;
import org.hyperledger.fabric.protos.ledger.rwset.Rwset;
import org.hyperledger.fabric.protos.ledger.rwset.kvrwset.KvRwset;

public class TxReadWriteSetInfo {
    private final Rwset.TxReadWriteSet txReadWriteSet;

    public TxReadWriteSetInfo(Rwset.TxReadWriteSet txReadWriteSet) {
        this.txReadWriteSet = txReadWriteSet;
    }

    public int getNsRwsetCount() {
        return this.txReadWriteSet.getNsRwsetCount();
    }

    public NsRwsetInfo getNsRwsetInfo(int index) {
        return new NsRwsetInfo(this.txReadWriteSet.getNsRwset(index));
    }

    public Iterable<NsRwsetInfo> getNsRwsetInfos() {
        return new NsRwsetInfoIterable();
    }

    public class NsRwsetInfoIterable
    implements Iterable<NsRwsetInfo> {
        @Override
        public Iterator<NsRwsetInfo> iterator() {
            return new NsRwsetInfoIterator();
        }
    }

    public class NsRwsetInfoIterator
    implements Iterator<NsRwsetInfo> {
        int ci = 0;
        final int max;

        NsRwsetInfoIterator() {
            this.max = TxReadWriteSetInfo.this.getNsRwsetCount();
        }

        @Override
        public boolean hasNext() {
            return this.ci < this.max;
        }

        @Override
        public NsRwsetInfo next() {
            return TxReadWriteSetInfo.this.getNsRwsetInfo(this.ci++);
        }
    }

    public static class NsRwsetInfo {
        private final Rwset.NsReadWriteSet nsReadWriteSet;

        NsRwsetInfo(Rwset.NsReadWriteSet nsReadWriteSet) {
            this.nsReadWriteSet = nsReadWriteSet;
        }

        public KvRwset.KVRWSet getRwset() throws InvalidProtocolBufferException {
            return KvRwset.KVRWSet.parseFrom(this.nsReadWriteSet.getRwset());
        }

        public String getNamespace() {
            return this.nsReadWriteSet.getNamespace();
        }
    }
}

